/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.ClientPrms;
import hydra.HydraVector;
import hydra.MasterController;
import hydra.TestConfig;
import splitBrain.SBUtil;
import splitBrain.SelectionTest;
import util.TestException;
import util.TestHelperPrms;

public class CoordSelectionTest
extends SelectionTest {
    public static synchronized void HydraTask_initializeLocator() {
        if (testInstance == null) {
            testInstance = new CoordSelectionTest();
            testInstance.initializeInstance();
        }
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new CoordSelectionTest();
            testInstance.initializeRegion("clientRegion");
            testInstance.initializeInstance();
        }
    }

    public static void HydraTask_serialCoordSelectionTest() {
        testInstance.serialSelectionTest();
    }

    public static void HydraTask_concCoordSelectionTest() {
        testInstance.concSelectionTest("locator");
    }

    public static void HydraTask_busyClient() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, 15L);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            CoordSelectionTest.testInstance.aRegion.put((Object)"key", (Object)"value");
            MasterController.sleepForMs(200);
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    @Override
    protected Object[] waitForChange(DistributedMember member, int msToSleep) {
        return SBUtil.waitForCoordChange(member, msToSleep);
    }

    @Override
    protected int getNumToStop() {
        int numLocators = this.getNumLocators();
        return numLocators - 1;
    }

    @Override
    protected void serialVerifyAfterStop(DistributedMember currentCoord, int totalNumStopped) {
        if (currentCoord == null) {
            throw new TestException("Expected a new coordinator, but it is " + currentCoord);
        }
    }

    @Override
    protected DistributedMember getCurrentMember() {
        return SBUtil.getCoordinator();
    }

    @Override
    protected int getNumMembersOfInterest() {
        return this.getNumLocators();
    }

    protected int getNumLocators() {
        int num = 0;
        HydraVector aVec = TestConfig.tab().vecAt(ClientPrms.names);
        for (int i = 0; i < aVec.size(); ++i) {
            String clientName = (String)aVec.get(i);
            if (!clientName.startsWith("locator")) continue;
            ++num;
        }
        return num;
    }
}

