/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import cq.CQTest;
import cq.CQUtilBB;
import hydra.BridgeHelper;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.util.List;
import splitBrain.ControllerBB;
import splitBrain.MembershipNotifierHook;
import splitBrain.SBUtil;
import util.MethodCoordinator;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class FDCQTest
extends CQTest {
    protected Region fdRegion = null;

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new FDCQTest();
            testInstance.initializeInstance();
            FDCQTest.testInstance.aRegion = testInstance.initializeRegion("clientRegion");
            ((FDCQTest)FDCQTest.testInstance).fdRegion = testInstance.initializeRegion("fdRegionClient");
            if (FDCQTest.testInstance.isBridgeConfiguration) {
                FDCQTest.testInstance.isBridgeClient = true;
                CQTest.registerInterest(FDCQTest.testInstance.aRegion);
                if (CQsOn) {
                    testInstance.initializeQueryService();
                    FDCQTest.testInstance.queryMap = testInstance.generateQueries(FDCQTest.testInstance.queryDepth);
                    testInstance.initializeCQs();
                } else {
                    Log.getLogWriter().info("Not creating CQs because CQUtilPrms.CQsOn is " + CQsOn);
                }
            }
        }
        FDCQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new FDCQTest();
            testInstance.initializeInstance();
            FDCQTest.testInstance.aRegion = testInstance.initializeRegion("serverRegion");
            ((FDCQTest)FDCQTest.testInstance).fdRegion = testInstance.initializeRegion("fdRegionServer");
            BridgeHelper.startBridgeServer("bridge");
            FDCQTest.testInstance.isBridgeClient = false;
            Log.getLogWriter().info("Installing MembershipNotifierHook");
            SBUtil.addMembershipHook(new MembershipNotifierHook());
        }
        FDCQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    @Override
    protected void HAController() {
        int vmid;
        int i;
        FDCQTest.logExecutionNumber();
        concVerifyCoordinator = new MethodCoordinator(CQTest.class.getName(), "concVerify");
        this.checkForLastIteration();
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.ExceptionCounter);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.ConcurrentLeader);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.Reinitialized);
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "bridge");
        List vmList = (List)tmpArr[0];
        this.disconnected = true;
        for (i = 0; i < vmList.size(); ++i) {
            vmid = ((ClientVmInfo)vmList.get(i)).getVmid();
            ControllerBB.enableSlowListener(vmid);
            ControllerBB.enablePlayDead(vmid);
        }
        Log.getLogWriter().info("Calling put to cause a forced disconnect on " + vmList);
        this.fdRegion.put((Object)new Long(System.currentTimeMillis()), (Object)"");
        Log.getLogWriter().info("Done calling put to cause a forced disconnect on " + vmList);
        ControllerBB.checkForError();
        for (i = 0; i < vmList.size(); ++i) {
            ControllerBB.checkForError();
            vmid = ((ClientVmInfo)vmList.get(i)).getVmid();
            ControllerBB.signalReadyForInit(vmid);
        }
        for (i = 0; i < vmList.size(); ++i) {
            ControllerBB.checkForError();
            vmid = ((ClientVmInfo)vmList.get(i)).getVmid();
            ControllerBB.waitForInitialization(vmid);
        }
        ControllerBB.checkForError();
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.SnapshotWritten);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.FinishedVerify);
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.Pausing);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.Pausing", CQUtilBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.SyncUp);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        concVerifyCoordinator.executeOnce(this, new Object[0]);
        if (!concVerifyCoordinator.methodWasExecuted()) {
            throw new TestException("Test problem: concVerify did not execute");
        }
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.FinishedVerify);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.FinishedVerify", CQUtilBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.Pausing);
        for (i = 0; i < vmList.size(); ++i) {
            vmid = ((ClientVmInfo)vmList.get(i)).getVmid();
            ControllerBB.reset(vmid);
        }
        this.disconnected = false;
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.SyncUp);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.SyncUp", CQUtilBB.SyncUp, this.numThreadsInClients, true, -1L, 1000L);
        long counter = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.ExecutionNumber));
        }
    }

    @Override
    protected void handleException(Exception anExcept) {
        if (anExcept instanceof DistributedSystemDisconnectedException && !ControllerBB.isSlowListenerEnabled()) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
        Log.getLogWriter().info("Caught " + anExcept + "; expected, continuing test");
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.ExceptionCounter);
    }
}

