/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.MembershipTestHook;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.management.ManagementException;
import cq.CQUtil;
import cq.CQUtilPrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import splitBrain.CrashEventMemberInfo;
import splitBrain.SBUtil;
import splitBrain.SplitBrainBB;
import splitBrain.SplitBrainPrms;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationsClient;
import util.TestException;
import util.TestHelper;

public class NetworkPartitionTest
extends OperationsClient {
    protected static boolean forcedDisconnect = false;
    protected static NetworkPartitionTest testInstance;
    static Region aRegion;
    static DistributedSystem oldSystem;
    static String losingSideHost;
    static boolean enableNetworkHelper;
    static boolean survivingSideGiiClient;
    static final String SNAPSHOT_KEY = "regionSnapshot";

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new NetworkPartitionTest();
            testInstance.initializeOperationsClient();
            testInstance.initializePrms();
            testInstance.initializeBridgeServer();
        }
    }

    protected void initializeBridgeServer() {
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            SplitBrainBB.addExpectForcedDisconnect(RemoteTestModule.getMyVmid());
        }
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfig);
            if (this.requiresPersistence(rd)) {
                String diskStoreConfig = ConfigPrms.getDiskStoreConfig();
                DiskStoreHelper.createDiskStore(diskStoreConfig);
                factory.setDiskStoreName(diskStoreConfig);
            }
            aRegion = RegionHelper.createRegion(rd.getRegionName(), factory);
            CacheServer server = BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
            this.createGatewayHub();
        }
        if (SBUtil.isLeadMember()) {
            Log.getLogWriter().info("This VM is currently the LeadMember");
        }
        DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            SplitBrainBB.addMember(dm, false);
        } else {
            SplitBrainBB.addMember(dm, true);
        }
    }

    public static String getXmlFileName() {
        int vmID = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        return "vm_" + vmID + "_" + clientName + ".xml";
    }

    public static synchronized void HydraTask_initializeBridgeClient() {
        if (testInstance == null) {
            testInstance = new NetworkPartitionTest();
            testInstance.initializeOperationsClient();
            testInstance.initializePrms();
            testInstance.initializeBridgeClient();
        }
    }

    protected void initializeBridgeClient() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionHelper.createRegion(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            aRegion = RegionHelper.getRegion(rd.getRegionName());
        }
        if (TestConfig.tab().booleanAt(CQUtilPrms.useCQ, false)) {
            CQUtil.initialize();
            CQUtil.initializeCQService();
            CQUtil.registerCQ(aRegion);
        } else {
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Registered interest in ALL_KEYS");
        }
    }

    public static synchronized void HydraTask_connectToDS() {
        DistributedSystemHelper.connect();
    }

    public static synchronized void HydraTask_initialize() {
        NetworkPartitionTest.initializeInstance(false);
    }

    public static synchronized void HydraTask_initializeFromXML() {
        NetworkPartitionTest.initializeInstance(true);
    }

    private static synchronized void initializeInstance(boolean usingXML) {
        if (testInstance == null) {
            testInstance = new NetworkPartitionTest();
            testInstance.initializeOperationsClient();
            testInstance.initializePrms();
            try {
                if (usingXML) {
                    testInstance.initializeFromXML();
                } else {
                    testInstance.initialize();
                }
            }
            catch (ManagementException me) {
                NetworkPartitionTest.checkForForcedDisconnect((Exception)((Object)me));
            }
            catch (CancelException cce) {
                NetworkPartitionTest.checkForForcedDisconnect((Exception)((Object)cce));
            }
            catch (SystemConnectException sce) {
                NetworkPartitionTest.checkForForcedDisconnect((Exception)((Object)sce));
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize threw Exception " + e + ", forcedDisconnect = " + forcedDisconnect);
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_addExpectForcedDisconnectClient() {
        if (losingSideHost == null) {
            NetworkPartitionTest.setLosingSideHost();
        }
        Log.getLogWriter().info("my host = " + RemoteTestModule.getMyHost() + " and the expected losing side is " + losingSideHost);
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            SplitBrainBB.addExpectForcedDisconnect(RemoteTestModule.getMyVmid());
        }
    }

    private void generateCacheXml() {
        String xmlFileName = NetworkPartitionTest.getXmlFileName();
        File f = new File(xmlFileName);
        if (f.exists()) {
            try {
                f.delete();
            }
            catch (SecurityException e) {
                throw new TestException("unable to delete XML file", e);
            }
        }
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), null, ConfigPrms.getRegionConfig(), null, ConfigPrms.getBridgeConfig(), ConfigPrms.getPoolConfig(), ConfigPrms.getDiskStoreConfig(), null, NetworkPartitionTest.getXmlFileName());
    }

    protected void initialize() {
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            SplitBrainBB.addExpectForcedDisconnect(RemoteTestModule.getMyVmid());
        }
        if (CacheHelper.getCache() == null) {
            try {
                CacheHelper.createCache(ConfigPrms.getCacheConfig());
            }
            catch (ManagementException me) {
                if (me.getCause() instanceof RegionDestroyedException) {
                    throw me;
                }
            }
            catch (SystemConnectException sce) {
                throw sce;
            }
            if (SBUtil.isLeadMember()) {
                Log.getLogWriter().info("This VM is currently the LeadMember");
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfig);
            DataPolicy dataPolicy = SplitBrainPrms.getGiiDataPolicy();
            if (dataPolicy != null) {
                factory.setDataPolicy(dataPolicy);
            }
            if (this.requiresPersistence(rd)) {
                String diskStoreConfig = ConfigPrms.getDiskStoreConfig();
                DiskStoreHelper.createDiskStore(diskStoreConfig);
                factory.setDiskStoreName(diskStoreConfig);
            }
            String regionName = rd.getRegionName();
            aRegion = RegionHelper.createRegion(regionName, factory);
            this.createGatewayHub();
            this.performInitialChecks(regionName);
        }
    }

    protected void initializeFromXML() {
        if (CacheHelper.getCache() == null) {
            try {
                String xmlFileName = NetworkPartitionTest.getXmlFileName();
                this.generateCacheXml();
                CacheHelper.createCacheFromXml(xmlFileName);
            }
            catch (ManagementException me) {
                if (me.getCause() instanceof RegionDestroyedException) {
                    throw me;
                }
            }
            catch (SystemConnectException sce) {
                throw sce;
            }
            if (SBUtil.isLeadMember()) {
                Log.getLogWriter().info("This VM is currently the LeadMember");
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionName = rd.getRegionName();
            aRegion = RegionHelper.getRegion(regionName);
            this.performInitialChecks(regionName);
        }
    }

    private void performInitialChecks(String regionName) {
        DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            SplitBrainBB.addMember(dm, false);
        } else {
            SplitBrainBB.addMember(dm, true);
            survivingSideGiiClient = TestConfig.tasktab().booleanAt(SplitBrainPrms.isGiiClient, TestConfig.tab().booleanAt(SplitBrainPrms.isGiiClient, false));
            Log.getLogWriter().info("survivingSideGiiClient = " + survivingSideGiiClient);
        }
        if (survivingSideGiiClient) {
            boolean expectEmptyRegion = TestConfig.tasktab().booleanAt(SplitBrainPrms.expectEmptyRegion, TestConfig.tab().booleanAt(SplitBrainPrms.expectEmptyRegion, false));
            int regionSize = aRegion.keySet().size();
            Log.getLogWriter().info("Region " + regionName + " has regionSize = " + regionSize);
            long maxKeys = SplitBrainBB.getBB().getSharedCounters().read(SplitBrainBB.loadClientRegionSize);
            if (expectEmptyRegion) {
                if (regionSize != 0 && (long)regionSize != maxKeys) {
                    throw new TestException("Expected an empty region or a complete gii (forcedDisconnect during getFromOne), but found " + regionSize + " of " + maxKeys + " entries in region.");
                }
            } else if (regionSize <= 0 || (long)regionSize > maxKeys) {
                throw new TestException("Expected a partial image, but found " + regionSize + " of " + maxKeys + " entries in region.");
            }
        }
    }

    protected void reconnected() {
        aRegion = CacheHelper.getCache().getRegion(aRegion.getFullPath());
    }

    public static void HydraTask_createSnapshot() {
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            Log.getLogWriter().info("Not creating region snapshot; this is the losing side");
        } else {
            Log.getLogWriter().info("Creating region snapshot for region " + aRegion.getFullPath());
            HashMap regionSnapshot = new HashMap();
            for (Object key : aRegion.keySet()) {
                Object value = aRegion.get(key);
                if (value instanceof BaseValueHolder) {
                    value = ((BaseValueHolder)value).myValue;
                }
                regionSnapshot.put(key, value);
            }
            Log.getLogWriter().info("Writing region snapshot of size " + regionSnapshot.size() + " to blackboard: " + regionSnapshot);
            SplitBrainBB.getBB().getSharedMap().put(SNAPSHOT_KEY, regionSnapshot);
        }
    }

    protected boolean requiresPersistence(RegionDescription rd) {
        return rd.getDataPolicy().withPersistence() || rd.getEvictionAttributes() != null && rd.getEvictionAttributes().getAction().isOverflowToDisk();
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    protected void initializePrms() {
        enableNetworkHelper = TestConfig.tab().booleanAt(SplitBrainPrms.enableNetworkHelper, true);
        Log.getLogWriter().info("NetworkHelper commands are " + (enableNetworkHelper ? "" : " not ") + "enabled");
        NetworkPartitionTest.setLosingSideHost();
    }

    private static void setLosingSideHost() {
        String losingPartition = TestConfig.tab().stringAt(SplitBrainPrms.losingPartition);
        if (!losingPartition.equalsIgnoreCase("host1") && !losingPartition.equalsIgnoreCase("host2")) {
            throw new HydraConfigException("losingPartition must specified as host1 or host2, configured as " + losingPartition);
        }
        losingSideHost = TestConfig.getInstance().getHostDescription(losingPartition).getHostName();
        SplitBrainBB.putLosingSideHost(losingSideHost);
        Log.getLogWriter().info("Partition on " + losingPartition + " running on " + losingSideHost + " is not expected to survive the network Partition");
    }

    public static void startGatewayHubTask() {
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        testInstance.startGatewayHub(gatewayConfig);
    }

    private void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    public static synchronized void HydraTask_createGatewaySenderIds() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static synchronized void HydraTask_initWanComponents() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createAndStartGatewaySenders(senderConfig);
    }

    public static void HydraTask_loadRegion() {
        testInstance.loadRegion();
    }

    protected void loadRegion() {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int maxKeysToCreate = TestConfig.tab().intAt(SplitBrainPrms.maxKeys);
        do {
            if (NameFactory.getPositiveNameCounter() >= (long)maxKeysToCreate) {
                String reason = "In loadRegion, maxKeysToCreate = " + maxKeysToCreate + ", regionSize is " + aRegion.size();
                SplitBrainBB.getBB().getSharedCounters().add(SplitBrainBB.loadClientRegionSize, aRegion.size());
                throw new StopSchedulingTaskOnClientOrder(reason);
            }
            this.addEntry(aRegion);
        } while (System.currentTimeMillis() - startTime < limit);
    }

    public static void HydraTask_doEntryOperations() {
        try {
            testInstance.doEntryOperations();
        }
        catch (CancelException cce) {
            NetworkPartitionTest.checkForForcedDisconnect((Exception)((Object)cce));
        }
        catch (TransactionDataNodeHasDepartedException e) {
            Log.getLogWriter().info("doEntryOperations threw Exception " + (Object)((Object)e) + ", forcedDisconnect = " + forcedDisconnect);
        }
        catch (TransactionDataRebalancedException e) {
            Log.getLogWriter().info("doEntryOperations threw Exception " + (Object)((Object)e) + ", forcedDisconnect = " + forcedDisconnect);
            throw new TestException("doEntryOperations caught Exception " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            Log.getLogWriter().info("doEntryOperations threw Exception " + e + ", forcedDisconnect = " + forcedDisconnect);
            throw new TestException("doEntryOperations caught Exception " + TestHelper.getStackTrace(e));
        }
    }

    protected void doEntryOperations() {
        if (oldSystem == null) {
            oldSystem = DistributedSystemHelper.getDistributedSystem();
        }
        super.doEntryOperations(aRegion);
    }

    protected boolean waitForReconnect() {
        if (oldSystem.isReconnecting()) {
            try {
                return oldSystem.waitUntilReconnected(4L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        DistributedSystem sys = DistributedSystemHelper.getDistributedSystem();
        return sys != null && sys != oldSystem;
    }

    public static void closeCacheAndDisconnectFromDS() {
        CacheHelper.closeCache();
        DistributedSystemHelper.disconnect();
        testInstance = null;
    }

    public static void setForcedDisconnect() {
        forcedDisconnect = true;
    }

    private static void checkForForcedDisconnect(Exception e) {
        GemFireException gfe;
        Throwable rootCause;
        Log.getLogWriter().info("checkForForcedDisconnect processed Exception " + e);
        String errStr = e.toString();
        boolean causedByForcedDisconnect = errStr.indexOf("com.gemstone.gemfire.ForcedDisconnectException") >= 0;
        boolean rootCauseIsFD = false;
        if (e instanceof GemFireException && (rootCause = (gfe = (GemFireException)e).getRootCause()) instanceof ForcedDisconnectException) {
            rootCauseIsFD = true;
        }
        Log.getLogWriter().info("forcedDisconnct = " + forcedDisconnect + " causedByForcedDisconnect = " + causedByForcedDisconnect + " rootCauseIsFD = " + rootCauseIsFD);
        if (!(forcedDisconnect || causedByForcedDisconnect || rootCauseIsFD)) {
            throw new TestException("doEntryOperations caught Exception " + TestHelper.getStackTrace(e));
        }
        if (!RemoteTestModule.getMyHost().equals(losingSideHost)) {
            throw new TestException("doEntryOperations caught Exception " + e + " for vm " + SBUtil.getMyUniqueName() + " which should have survived the NetworkPartition");
        }
        SplitBrainBB.addDisconnectedClient(RemoteTestModule.getMyVmid());
    }

    public static synchronized void HydraCloseTask_checkForRegionDestroyedForcedDisconnects() {
        MasterController.sleepForMs(30000);
        if (forcedDisconnect) {
            SplitBrainBB.addDisconnectedClient(RemoteTestModule.getMyVmid());
        }
    }

    public static synchronized void HydraEndTask_verifyLosingPartition() {
        Set disconnectedClients = SplitBrainBB.getForcedDisconnectList();
        Set expectedDisconnectList = SplitBrainBB.getExpectForcedDisconnects();
        StringBuffer aStr = new StringBuffer();
        if (!disconnectedClients.equals(expectedDisconnectList)) {
            aStr.append("Expected forcedDisconnects in clientVms [ " + expectedDisconnectList + " ] but the following clientVms had forcedDisconnects [" + disconnectedClients + "]\n");
        } else {
            Log.getLogWriter().info("All expected clientVms in losing partition were forcefully disconnected [ " + disconnectedClients + " ].  No other vms were forcibly disconnected\n");
        }
        Set memberList = SplitBrainBB.getMembers();
        for (CrashEventMemberInfo m : memberList) {
            try {
                m.validate();
            }
            catch (TestException te) {
                aStr.append(te);
            }
        }
        try {
            TestHelper.checkForEventError(SplitBrainBB.getBB());
        }
        catch (TestException te) {
            aStr.append("Listener encountered exceptions, first Exception = \n" + te);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    public static void HydraTask_verifyRegion() {
        int size = aRegion.size();
        Log.getLogWriter().info(aRegion.getFullPath() + " is size " + size);
        if (aRegion.size() == 0) {
            throw new TestException("Expected region size to be > 0, but it is " + size);
        }
        NetworkPartitionTest.verifyFromSnapshot(aRegion, (Map)SplitBrainBB.getBB().getSharedMap().get(SNAPSHOT_KEY));
    }

    public static void HydraTask_addAdminFailureListener() {
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            MembershipManagerHelper.addTestHook((DistributedSystem)DistributedSystemHelper.getDistributedSystem(), (MembershipTestHook)new MembershipTestHook(){

                public void beforeMembershipFailure(String reason, Throwable cause) {
                }

                public void afterMembershipFailure(String reason, Throwable cause) {
                    SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.adminForcedDisconnects);
                }
            });
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.expectedAdminForcedDisconnects);
        }
    }

    public static void HydraTask_verifyAdminFailures() {
        String losingPartition = TestConfig.tab().stringAt(SplitBrainPrms.losingPartition);
        if (losingPartition.equalsIgnoreCase("host1") || losingPartition.equalsIgnoreCase("host2")) {
            long actual;
            SharedCounters sc;
            long expected;
            losingSideHost = TestConfig.getInstance().getHostDescription(losingPartition).getHostName();
            if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost) && (expected = (sc = SplitBrainBB.getBB().getSharedCounters()).read(SplitBrainBB.expectedAdminForcedDisconnects)) != (actual = sc.read(SplitBrainBB.adminForcedDisconnects))) {
                throw new TestException("Expected " + expected + " admin forced-disconnects but found " + actual);
            }
        }
    }

    public static synchronized void HydraEndTask_waitForReconnect() {
        boolean reconnected;
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost) && (reconnected = testInstance.waitForReconnect())) {
            SplitBrainBB.addReconnectedClient(RemoteTestModule.getMyVmid());
        }
    }

    public static synchronized void HydraEndTask_verifyReconnect() {
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
            Set expectedDisconnectList = SplitBrainBB.getExpectForcedDisconnects();
            Set reconnectedClients = SplitBrainBB.getReconnectedList();
            StringBuffer aStr = new StringBuffer();
            if (!expectedDisconnectList.equals(reconnectedClients)) {
                aStr.append("Expected all clients to reconnect but only these did: " + reconnectedClients + ".   expected list is " + expectedDisconnectList + "\n");
            }
            if (aStr.length() > 0) {
                throw new TestException(aStr.toString());
            }
            testInstance.reconnected();
        }
    }

    private static void verifyFromSnapshot(Region aRegion, Map expectedMap) {
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + " against snapshot of size " + expectedMap.size());
        StringBuffer aStr = new StringBuffer();
        int regionSize = aRegion.size();
        int expectedSize = expectedMap.size();
        if (regionSize != expectedSize) {
            aStr.append(aRegion.getFullPath() + " size is " + regionSize + " but expected it to be " + expectedSize + "\n");
        }
        HashSet expectedKeys = new HashSet(expectedMap.keySet());
        HashSet actualKeys = new HashSet(aRegion.keySet());
        HashSet missingKeys = new HashSet(expectedKeys);
        missingKeys.removeAll(actualKeys);
        HashSet extraKeys = new HashSet(actualKeys);
        extraKeys.removeAll(expectedKeys);
        if (missingKeys.size() > 0) {
            aStr.append("The following " + missingKeys.size() + " expected keys were missing from " + aRegion.getFullPath() + ": " + missingKeys + "\n");
        }
        if (extraKeys.size() > 0) {
            aStr.append("The following " + extraKeys.size() + " extra keys were found in " + aRegion.getFullPath() + ": " + extraKeys + "\n");
        }
        for (Object key : aRegion.keySet()) {
            Object value = aRegion.get(key);
            if (expectedMap.containsKey(key)) {
                Object expectedValue = expectedMap.get(key);
                if (value instanceof BaseValueHolder) {
                    value = ((BaseValueHolder)value).myValue;
                }
                if (value == null) {
                    if (expectedValue == null) continue;
                    aStr.append("For key " + key + " expectedValue is " + TestHelper.toString(expectedValue) + " but value in region is " + TestHelper.toString(value) + "\n");
                    continue;
                }
                if (value.equals(expectedValue)) continue;
                aStr.append("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + " but it is " + TestHelper.toString(value) + "\n");
                continue;
            }
            aStr.append("Key " + key + " does not exist in " + aRegion.getFullPath() + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + expectedMap.size() + " entries in " + aRegion.getFullPath());
    }

    public static void createLocatorTask() {
        try {
            SBUtil.createLocatorTask();
        }
        catch (HydraRuntimeException e) {
            Log.getLogWriter().info("NetworkPartitionTest caught " + (Object)((Object)e) + " indicating locator is already created");
        }
    }

    public static void startAndConnectLocatorTask() {
        try {
            SBUtil.startAndConnectLocatorTask();
        }
        catch (HydraRuntimeException e) {
            Log.getLogWriter().info("NetworkPartitionTest caught " + (Object)((Object)e) + " indicating locator is already started");
        }
    }

    static {
        losingSideHost = null;
        enableNetworkHelper = true;
        survivingSideGiiClient = false;
    }
}

