/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireException;
import hydra.BridgeHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.blackboard.SharedLock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import splitBrain.SplitBrainBB;
import util.BaseValueHolder;
import util.MethodCoordinator;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;

public class PRNetDownTest
extends ParRegTest {
    protected static String CONCURRENT_LEADER_THREADID = "ConcurrentLeaderThreadId";

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new PRNetDownTest();
            testInstance.initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            PRNetDownTest.testInstance.isBridgeClient = false;
            PRNetDownTest.testInstance.isDataStore = PRNetDownTest.getIsDataStore();
        }
        PRNetDownTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new PRNetDownTest();
            testInstance.initializeRegion("clientRegion");
            testInstance.initializeInstance();
            if (PRNetDownTest.testInstance.isBridgeConfiguration) {
                PRNetDownTest.testInstance.isBridgeClient = true;
                ParRegUtil.registerInterest(PRNetDownTest.testInstance.aRegion);
            }
            PRNetDownTest.testInstance.isDataStore = PRNetDownTest.getIsDataStore();
        }
        PRNetDownTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void HydraTask_doConcOpsAndVerify() {
        ((PRNetDownTest)testInstance).doConcOpsAndVerify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConcOpsAndVerify() {
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ReadyToBegin);
        if (counter == 1L) {
            PRNetDownTest.logExecutionNumber();
        }
        registerInterestCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "registerInterest");
        concVerifyCoordinator = new MethodCoordinator(ParRegTest.class.getName(), "concVerify");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ConcurrentLeader);
        this.numThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreadsInClients = " + this.numThreadsInClients);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.ReadyToBegin", ParRegBB.ReadyToBegin, this.numThreadsInClients, true, -1L, 1000L);
        this.checkForLastIteration();
        Log.getLogWriter().info("Zeroing ShapshotWritten");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.SnapshotWritten);
        try {
            this.doEntryOperations(this.aRegion);
        }
        catch (Exception e) {
            boolean rootCauseIsFD = false;
            if (e instanceof GemFireException) {
                GemFireException gfe = (GemFireException)e;
                Throwable rootCause = gfe.getRootCause();
                if (rootCause instanceof ForcedDisconnectException) {
                    rootCauseIsFD = true;
                }
            }
            throw new TestException("doEntryOperations caught unexpected Exception " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Zeroing FinishedVerify");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.FinishedVerify);
        ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
        TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.Pausing", ParRegBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing ReadyToBegin");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.ReadyToBegin);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
            if (this.isBridgeClient && this.bridgeOrderingWorkaround.equalsIgnoreCase("registerInterest")) {
                registerInterestCoordinator.executeOnce(this, new Object[0]);
                if (!registerInterestCoordinator.methodWasExecuted()) {
                    throw new TestException("Test problem: RegisterInterest did not execute");
                }
            }
        }
        try {
            concVerifyCoordinator.executeOnce(this, new Object[0]);
            if (!concVerifyCoordinator.methodWasExecuted()) {
                throw new TestException("Test problem: concVerify did not execute");
            }
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.FinishedVerify);
            TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.FinishedVerify", ParRegBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        }
        finally {
            Integer tid = (Integer)SplitBrainBB.getBB().getSharedMap().get(CONCURRENT_LEADER_THREADID);
            if (tid.intValue() == RemoteTestModule.getCurrentThread().getThreadId()) {
                SharedLock criticalCodeSection = SplitBrainBB.getBB().getSharedLock();
                criticalCodeSection.unlock();
                Log.getLogWriter().fine("PRNetDown released the SharedLock!");
            }
        }
        Log.getLogWriter().info("Zeroing Pausing");
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.Pausing);
        counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
    }

    @Override
    protected void concVerify() {
        boolean leader = false;
        boolean isSurvivingSide = true;
        if (RemoteTestModule.getMyHost().equalsIgnoreCase(SplitBrainBB.getLosingSideHost())) {
            isSurvivingSide = false;
        }
        if (isSurvivingSide || this.isBridgeClient) {
            boolean bl = leader = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ConcurrentLeader) == 1L;
        }
        if (leader) {
            int tid = RemoteTestModule.getCurrentThread().getThreadId();
            SplitBrainBB.getBB().getSharedMap().put(CONCURRENT_LEADER_THREADID, new Integer(tid));
            Log.getLogWriter().info("In concVerify, this thread is the concurrent leader");
            SharedLock criticalCodeSection = SplitBrainBB.getBB().getSharedLock();
            criticalCodeSection.lock();
            Log.getLogWriter().fine("PRNetDown obtained the SharedLock!");
            this.regionSnapshot = new HashMap();
            this.destroyedKeys = new HashSet();
            Log.getLogWriter().info("This thread is the concurrentLeader, creating region snapshot...");
            Set keySet = this.aRegion.keySet();
            for (Object key : keySet) {
                Object value = null;
                if (this.aRegion.containsValueForKey(key)) {
                    value = this.aRegion.get(key);
                }
                if (value instanceof BaseValueHolder) {
                    this.regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                    continue;
                }
                this.regionSnapshot.put(key, value);
            }
            Log.getLogWriter().info("Done creating region snapshot with " + this.regionSnapshot.size() + " entries; " + this.regionSnapshot);
            ParRegBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
            Log.getLogWriter().info("Done creating destroyed keys with " + this.destroyedKeys.size() + " keys");
            ParRegBB.getBB().getSharedMap().put("DestroyedKeys", this.destroyedKeys);
            long snapshotWritten = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        } else {
            Log.getLogWriter().info("In concVerify, this thread is waiting for the concurrent leader to write the snapshot");
            TestHelper.waitForCounter(ParRegBB.getBB(), "ParRegBB.SnapshotWritten", ParRegBB.SnapshotWritten, 1L, true, -1L, 2000L);
            try {
                this.verifyFromSnapshot();
            }
            catch (Exception e) {
                boolean rootCauseIsFD = false;
                if (e instanceof GemFireException) {
                    GemFireException gfe = (GemFireException)e;
                    Throwable rootCause = gfe.getRootCause();
                    if (rootCause instanceof ForcedDisconnectException) {
                        rootCauseIsFD = true;
                    }
                }
                throw new TestException("verifyFromSnapshot threw unexpected Exception " + TestHelper.getStackTrace(e));
            }
        }
    }
}

