/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionMembershipListener;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import java.util.ArrayList;
import java.util.List;
import splitBrain.ControllerBB;
import splitBrain.ListenerBB;
import util.AbstractListener;
import util.TestHelper;

public class RegMembershipListener
extends AbstractListener
implements RegionMembershipListener {
    public static List eventsReceivedInThisVM = new ArrayList();

    public synchronized void afterRemoteRegionCrash(RegionEvent event) {
        try {
            this.doAfterRemoteRegionCrash(event);
        }
        catch (Exception e) {
            String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            ControllerBB.getBB().getSharedMap().put("Error", errStr);
        }
    }

    protected void doAfterRemoteRegionCrash(RegionEvent event) {
        String errStr;
        String eventStr = this.logCall("afterRemoteRegionCrash", (CacheEvent)event);
        ListenerBB.getBB().getSharedCounters().increment(ListenerBB.numAfterRemoteRegionCrashEvents);
        int thisPid = ProcessMgr.getProcessId();
        if (event.getDistributedMember().getProcessId() == thisPid) {
            String errStr2 = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + "; event should not refer to member " + event.getDistributedMember();
            Log.getLogWriter().info(errStr2);
            ControllerBB.getBB().getSharedMap().put("Error", errStr2);
        }
        if (eventsReceivedInThisVM == null) {
            eventsReceivedInThisVM.add(event);
        } else {
            for (int i = 0; i < eventsReceivedInThisVM.size(); ++i) {
                RegionEvent priorEvent = (RegionEvent)eventsReceivedInThisVM.get(i);
                if (priorEvent.getDistributedMember().getProcessId() != event.getDistributedMember().getProcessId() || !priorEvent.getRegion().getFullPath().equals(event.getRegion().getFullPath())) continue;
                errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + "; event " + eventStr + " refers to the same pid and region name as prior event " + priorEvent;
                Log.getLogWriter().info(errStr);
                ControllerBB.getBB().getSharedMap().put("Error", errStr);
            }
        }
        int eventPid = event.getDistributedMember().getProcessId();
        int vmId = ControllerBB.getVmIdForPid(eventPid);
        if (!ControllerBB.isPlayDeadEnabled(vmId) && !ControllerBB.isAlertEnabled(vmId)) {
            errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + "; event " + eventStr + " was unexpected because this vm was not targeted for a forced disconnect";
            Log.getLogWriter().info(errStr);
            ControllerBB.getBB().getSharedMap().put("Error", errStr);
        }
    }

    public void afterRemoteRegionCreate(RegionEvent event) {
        this.logCall("afterRemoteRegionCreate", (CacheEvent)event);
        ListenerBB.getBB().getSharedCounters().increment(ListenerBB.numAfterRemoteRegionCreateEvents);
    }

    public void afterRemoteRegionDeparture(RegionEvent event) {
        this.logCall("afterRemoteRegionDeparture", (CacheEvent)event);
        ListenerBB.getBB().getSharedCounters().increment(ListenerBB.numAfterRemoteRegionDepartureEvents);
    }

    public void close() {
        Log.getLogWriter().info("Invoked " + this.getClass().getName() + ": close");
    }

    public void initialMembers(Region aRegion, DistributedMember[] initialMembers) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": initialMembers with: ");
        for (int i = 0; i < initialMembers.length; ++i) {
            aStr.append(initialMembers[i] + " ");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public void afterCreate(EntryEvent event) {
    }

    public void afterUpdate(EntryEvent event) {
    }

    public void afterInvalidate(EntryEvent event) {
    }

    public void afterDestroy(EntryEvent event) {
    }

    public void afterRegionClear(RegionEvent event) {
    }

    public void afterRegionCreate(RegionEvent event) {
    }

    public void afterRegionDestroy(RegionEvent event) {
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void afterRegionLive(RegionEvent event) {
    }
}

