/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedSystemHelper;
import hydra.GemFirePrms;
import hydra.HydraRuntimeException;
import hydra.HydraSubthread;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import splitBrain.SBUtil;
import splitBrain.SplitBrainBB;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public abstract class SelectionTest {
    protected static SelectionTest testInstance = null;
    protected static final String VmIDStr = "VmId_";
    protected Region aRegion;
    protected long changeLimitMS;

    protected abstract Object[] waitForChange(DistributedMember var1, int var2);

    protected abstract int getNumMembersOfInterest();

    protected abstract int getNumToStop();

    protected abstract void serialVerifyAfterStop(DistributedMember var1, int var2);

    protected abstract DistributedMember getCurrentMember();

    public static synchronized void HydraTask_logMembers() {
        Log.getLogWriter().info("Current lead member is " + SBUtil.getLeadMember());
        Log.getLogWriter().info("Current coordinator is " + SBUtil.getCoordinator());
    }

    protected void initializeRegion(String regDescriptName) {
        block2: {
            CacheHelper.createCache("cache1");
            String key = VmIDStr + RemoteTestModule.getMyVmid();
            String xmlFile = key + ".xml";
            try {
                CacheHelper.generateCacheXmlFile("cache1", regDescriptName, xmlFile);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block2;
                throw e;
            }
        }
        this.aRegion = RegionHelper.createRegion(regDescriptName);
    }

    protected void initializeInstance() {
        String aStr = DistributedSystemHelper.getDistributedSystem().getProperties().getProperty("member-timeout");
        int memberTimeout = Integer.valueOf(aStr);
        int limit = memberTimeout * 3 + 20000;
        this.changeLimitMS = limit;
        Log.getLogWriter().info("changeLimitMS is " + this.changeLimitMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialSelectionTest() {
        int i;
        long exeNum = SplitBrainBB.getBB().getSharedCounters().incrementAndRead(SplitBrainBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        int numToStop = this.getNumToStop();
        Log.getLogWriter().info("numToStop is " + numToStop);
        DistributedMember member = this.getCurrentMember();
        for (int i2 = 1; i2 <= numToStop; ++i2) {
            Log.getLogWriter().info("Member is " + member);
            if (member == null) {
                throw new TestException("Unexpected: member is " + member);
            }
            String host = member.getHost();
            int pid = member.getProcessId();
            ClientVmInfo targetVm = SBUtil.getClientVmInfo(host, pid);
            try {
                String stopMode = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                Log.getLogWriter().info("Test is stopping " + member + " with " + stopMode);
                ClientVmMgr.stop("Stopping member " + member + " with " + stopMode, ClientVmMgr.toStopMode(stopMode), -31, targetVm);
                member = this.waitForChangeWithTimeout(member);
                this.serialVerifyAfterStop(member, i2);
                continue;
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done stopping members");
        Log.getLogWriter().info("Restarting all stopped members.");
        ArrayList<HydraSubthread> threadList = new ArrayList<HydraSubthread>();
        final StringBuffer errStr = new StringBuffer();
        for (i = 1; i <= numToStop; ++i) {
            HydraSubthread startThread = new HydraSubthread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ClientVmMgr.start("Restarting a random member");
                    }
                    catch (Exception e) {
                        StringBuffer stringBuffer = errStr;
                        synchronized (stringBuffer) {
                            errStr.append(TestHelper.getStackTrace(e));
                        }
                    }
                }
            });
            startThread.start();
            threadList.add(startThread);
        }
        for (i = 0; i < threadList.size(); ++i) {
            Thread aThread = (Thread)threadList.get(i);
            try {
                aThread.join();
                continue;
            }
            catch (InterruptedException e) {
                StringBuffer stringBuffer = errStr;
                synchronized (stringBuffer) {
                    errStr.append(TestHelper.getStackTrace(e));
                    continue;
                }
            }
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("All members have restarted");
        member = this.getCurrentMember();
    }

    protected void concSelectionTest(String matchStr) {
        long exeNum = SplitBrainBB.getBB().getSharedCounters().incrementAndRead(SplitBrainBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        DistributedMember member = this.getCurrentMember();
        Log.getLogWriter().info("The current member for this test is " + member);
        int numToStop = this.getNumToStop();
        int randInt = TestConfig.tab().getRandGen().nextInt(1, numToStop);
        Object[] objArr = StopStartVMs.getOtherVMs(randInt, matchStr);
        List clientVmInfoList = (List)objArr[0];
        List stopModeList = (List)objArr[1];
        StopStartVMs.stopStartVMs(clientVmInfoList, stopModeList);
        Log.getLogWriter().info("Done restarting members");
        DistributedMember newMember = this.getCurrentMember();
    }

    protected DistributedMember waitForChangeWithTimeout(DistributedMember member) {
        Object[] tmpArr = this.waitForChange(member, 0);
        long duration = (Long)tmpArr[0];
        DistributedMember newMember = (DistributedMember)tmpArr[1];
        if (duration > this.changeLimitMS) {
            int memberTimeout = TestConfig.tab().intAt(GemFirePrms.memberTimeout);
            throw new TestException("It took " + duration + " ms to detect a member change " + "(member-timeout is " + memberTimeout + ")");
        }
        return newMember;
    }

    protected void verifyMemberExists(DistributedMember member) {
        if (member != null) {
            int pid = member.getProcessId();
            String host = member.getHost();
            boolean exists = ProcessMgr.processExists(host, pid);
            if (!exists) {
                throw new TestException("Member " + member + " is a process that does not exist");
            }
        }
    }
}

