/*
 * Decompiled with CFR 0.152.
 */
package sustainability;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import roles.RolesPrms;
import sustainability.SustainabilityBB;
import util.CacheUtil;

public class SustainabilityTest {
    static final String rr1 = "rolePlayer";
    static final String rr2 = "RoleB";
    static final String[] requiredRoles = new String[]{"rolePlayer"};
    static final String regionName = "MyRegion";
    static final String regionNameA = "regionA";
    static final String regionNameB = "regionB";
    static final String regionNameC = "regionC";
    static final String regionNameD = "regionD";
    static final String regionNameE = "regionE";
    static final String regionNameF = "regionF";
    static final String regionNameG = "regionG";
    static final String xmlFileName = "RoleReconnect-cache.xml";
    static final String key = "MyKey";
    static final String value = "MyValue";
    static final String roleA = "rolePlayerA";
    static final String roleB = "rolePlayerB";
    static final String roleC = "rolePlayerC";
    static final String roleD = "rolePlayerD";
    static final String roleE = "rolePlayerE";
    static final String roleF = "rolePlayerF";
    static final String roleG = "rolePlayerG";
    static final String[] roleRequiredRegionA = new String[]{"rolePlayerA"};
    static final String[] roleRequiredRegionB = new String[]{"rolePlayerB"};
    static final String[] roleRequiredRegionC = new String[]{"rolePlayerC"};
    static final String[] roleRequiredRegionD = new String[]{"rolePlayerD"};
    static final String[] roleRequiredRegionE = new String[]{"rolePlayerE"};
    static final String[] roleRequiredRegionF = new String[]{"rolePlayerF"};
    static final String[] roleRequiredRegionG = new String[]{"rolePlayerG"};
    static final String xmlFileNameRequireAB = "RequiresRoleAB-cache.xml";

    public static void generateXml() throws TimeoutException, CacheWriterException, CacheExistsException, RegionExistsException, IOException {
        Cache cache = CacheUtil.createCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        File file = new File(xmlFileName);
        Region region = CacheUtil.createRegion(regionName, attr);
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
            pw.close();
        }
        catch (IOException ex) {
            Log.getLogWriter().info("IOException during cache.xml generation to " + file + " : " + ex);
            throw ex;
        }
    }

    public static void generateXmlWithMultiRequiredRoles() throws Exception {
        Cache cache = CacheUtil.createCache();
        MembershipAttributes ra = new MembershipAttributes(roleRequiredRegionA, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region regionA = CacheUtil.createRegion(regionNameA, attr);
        ra = new MembershipAttributes(roleRequiredRegionB, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionB = CacheUtil.createRegion(regionNameB, attr);
        ra = new MembershipAttributes(roleRequiredRegionC, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionC = CacheUtil.createRegion(regionNameC, attr);
        ra = new MembershipAttributes(roleRequiredRegionD, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionD = CacheUtil.createRegion(regionNameD, attr);
        ra = new MembershipAttributes(roleRequiredRegionE, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionE = CacheUtil.createRegion(regionNameE, attr);
        ra = new MembershipAttributes(roleRequiredRegionF, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionF = CacheUtil.createRegion(regionNameF, attr);
        ra = new MembershipAttributes(roleRequiredRegionG, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionG = CacheUtil.createRegion(regionNameG, attr);
        SustainabilityTest.generateXml(cache);
    }

    public static void generateXml(Cache cache) throws Exception {
        File file = new File(xmlFileName);
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
            pw.close();
        }
        catch (IOException ex) {
            Log.getLogWriter().info("IOException during cache.xml generation to " + file + " : " + ex);
            throw ex;
        }
    }

    public static void generateABRegionRequiredXml() throws Exception {
        Cache cache = CacheUtil.createCache();
        MembershipAttributes ra = new MembershipAttributes(roleRequiredRegionA, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region regionA = CacheUtil.createRegion(regionNameA, attr);
        ra = new MembershipAttributes(roleRequiredRegionB, LossAction.RECONNECT, ResumptionAction.NONE);
        fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        attr = fac.createRegionAttributes();
        Region regionB = CacheUtil.createRegion(regionNameB, attr);
        File file = new File(xmlFileNameRequireAB);
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
            pw.close();
        }
        catch (IOException ex) {
            Log.getLogWriter().info("IOException during cache.xml generation to " + file + " : " + ex);
            throw ex;
        }
    }

    public static void createRolePlayerVm() throws TimeoutException, CacheWriterException, CacheExistsException, RegionExistsException {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionName, attr);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        region.put((Object)key, (Object)value);
    }

    public static void createSingleRegionRequiresRoleAB() throws Exception {
        Cache cache = CacheUtil.createCache();
        String[] requiredRoles = new String[]{"relePlayerA", roleB};
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameA, attr);
        SustainabilityTest.generateXml(cache);
    }

    public static void createSelfRolePlayingVm() throws Exception {
        Cache cache = CacheUtil.createCache();
        String[] requiredRoles = new String[]{roleA};
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameA, attr);
        SustainabilityTest.generateXml(cache);
    }

    public static void createRolePlayerAVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameA, attr);
    }

    public static void createRolePlayerBVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameB, attr);
    }

    public static void createRolePlayerCVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameC, attr);
    }

    public static void createRolePlayerDVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameD, attr);
    }

    public static void createRolePlayerEVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameE, attr);
    }

    public static void createRolePlayerFVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameF, attr);
    }

    public static void createRolePlayerGVm() {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameG, attr);
    }

    public static void createCacheAndRegionsWithRoleLoss() throws Exception {
        Cache cache = CacheUtil.createCache(xmlFileName);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            Region myRegion = cache.getRegion(regionName);
            throw new Exception("The cache should have thrown CancelException");
        }
        catch (CancelException ignor) {
            Log.getLogWriter().info("Got the expected CancelException exception ", (Throwable)ignor);
            return;
        }
    }

    public static void createCacheAndRegionsWithBackUp() throws Exception {
        Cache cache = CacheUtil.createCache(xmlFileName);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Region myRegion = cache.getRegion(regionName);
        Set entrySet = myRegion.entrySet();
        Region.Entry keyValue2 = null;
        for (Region.Entry keyValue2 : entrySet) {
            if (((String)keyValue2.getKey()).compareTo(key) != 0) {
                throw new Exception("The key doesnt match the orignal key : " + keyValue2.getKey() + " Orignal Key : " + key);
            }
            if (((String)keyValue2.getValue()).compareTo(value) == 0) continue;
            throw new Exception("The value doesnt match the orignal value for the key : " + keyValue2.getValue() + " Orignal Key : " + value);
        }
    }

    public static void createCacheRequiresABFromXML() throws Exception {
        Cache cache = CacheUtil.createCache(xmlFileNameRequireAB);
        int attempts = 0;
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (attempts < 5) {
            try {
                cache = CacheFactory.getAnyInstance();
                ++attempts;
                Region myRegion = cache.getRegion(regionNameA);
                Log.getLogWriter().info("Region : regionA created properly : " + myRegion);
                myRegion = cache.getRegion(regionNameB);
                Log.getLogWriter().info("Region : regionB created properly : " + myRegion);
                break;
            }
            catch (CancelException ignor) {
                ++attempts;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (attempts != 5) continue;
                throw new Exception("Treid reconnect : " + attempts + " times but failed to reconnect properly because of a role player member loss.");
            }
        }
        Log.getLogWriter().info("TOOK : " + attempts + "  ATTEMPTS TO RECONNECT AND CACHE : " + cache);
    }

    public static void validateCacheCreation() throws Exception {
        int attempts = 0;
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (attempts < 5) {
            try {
                Cache cache = CacheFactory.getAnyInstance();
                ++attempts;
                Region myRegion = cache.getRegion(regionNameA);
                SustainabilityTest.validateRegion(myRegion);
                Log.getLogWriter().info("Region : regionA validated properly : " + myRegion);
                myRegion = cache.getRegion(regionNameB);
                SustainabilityTest.validateRegion(myRegion);
                Log.getLogWriter().info("Region : regionB validated properly : " + myRegion);
                break;
            }
            catch (CancelException ignor) {
                ++attempts;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (attempts != 5) continue;
                throw new Exception("Tried reconnect : " + attempts + " times but failed to reconnect properly because of a role player member loss.");
            }
        }
    }

    public static void createMultiRegionRequireRoles() {
        Cache cache = CacheUtil.createCache(xmlFileName);
        Region region = cache.getRegion(regionNameA);
    }

    public static void validateSelfRolePlayerClient() throws Exception {
        Cache cache = CacheUtil.getCache();
        Region myRegion = cache.getRegion(regionNameA);
        SustainabilityTest.validateRegion(myRegion);
    }

    public static void checkGetInitialImageStats() throws Exception {
        Cache aCache = null;
        long time = System.currentTimeMillis();
        while (aCache == null) {
            try {
                aCache = CacheFactory.getAnyInstance();
            }
            catch (CancelException ignor) {
                if (System.currentTimeMillis() - time > 240000L) {
                    throw new Exception("Waited 3 mins for the system to reconnect porperly");
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException ignor) {
            // empty catch block
        }
        if (((GemFireCacheImpl)aCache).isClosed()) {
            Log.getLogWriter().severe("obtained closing cache from CacheFactory");
        }
        CachePerfStats stats = ((GemFireCacheImpl)aCache).getCachePerfStats();
        Log.getLogWriter().info("THE INITIMAGE STAT : " + stats.getGetInitialImageKeysReceived());
        Log.getLogWriter().info("THE Number of Regions :" + stats.getRegions());
        if (stats.getRegions() != 7) {
            throw new Exception("There should be 7 regions defined after reconnect");
        }
        Set regions = aCache.rootRegions();
        for (Region r : regions) {
            Set s = r.entrySet();
            if (s.size() != 20000) {
                throw new Exception("There should be 20000 keys but found : " + s.size() + " in region : " + r);
            }
            Log.getLogWriter().info("Region : " + r + " contains : " + s.size() + " keys and value pairs");
        }
    }

    private static void validateRegion(Region myRegion) throws Exception {
        boolean i = false;
        HashMap regionKeyValue = (HashMap)SustainabilityBB.getBB().getSharedMap().get(myRegion.getName());
        Set entrySet = myRegion.entrySet();
        Iterator it = entrySet.iterator();
        Log.getLogWriter().info("Checking integrity for : " + myRegion.getName());
        if (entrySet.size() != regionKeyValue.size()) {
            throw new Exception("There should be : " + regionKeyValue.size() + " key-value pairs but found : " + entrySet.size());
        }
        Log.getLogWriter().info("ENTRY KEY SIZE : " + entrySet.size() + " and the hashmap : " + regionKeyValue.size());
        Region.Entry keyValue = null;
        while (it.hasNext()) {
            keyValue = (Region.Entry)it.next();
            String value = (String)regionKeyValue.get(keyValue.getKey());
            if (value == null) {
                throw new RuntimeException("No key-value pair for the : " + keyValue.getKey() + " in KeyValue HashMap but the key is present in the local region");
            }
            if (value.compareTo((String)keyValue.getValue()) == 0) continue;
            throw new RuntimeException("The value for the key : " + keyValue.getKey() + " from entry set :" + keyValue.getKey() + " does not match the value from the hashmap : " + value);
        }
    }

    public static void putRegionA() throws Exception {
        String key = "myKey";
        String value = "myValue";
        HashMap<String, String> regionKeyValue = new HashMap<String, String>();
        Cache cache = null;
        while (cache == null) {
            try {
                cache = CacheFactory.getAnyInstance();
            }
            catch (CancelException ignor) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Region myRegion = cache.getRegion(regionNameA);
        for (int i = 0; i < 10; ++i) {
            myRegion.put((Object)(key + i), (Object)(value + i));
            regionKeyValue.put(key + i, value + i);
        }
        SharedMap smap = SustainabilityBB.getBB().getSharedMap();
        smap.put(myRegion.getName(), regionKeyValue);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void putRegionB() throws Exception {
        String key = "myKey";
        String value = "myValue";
        HashMap<String, String> regionKeyValue = new HashMap<String, String>();
        Cache cache = null;
        while (cache == null) {
            try {
                cache = CacheFactory.getAnyInstance();
            }
            catch (CancelException ignor) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Region myRegion = null;
        while (myRegion == null) {
            myRegion = cache.getRegion(regionNameB);
        }
        for (int i = 0; i < 10; ++i) {
            myRegion.put((Object)(key + i), (Object)(value + i));
            regionKeyValue.put(key + i, value + i);
        }
        SharedMap smap = SustainabilityBB.getBB().getSharedMap();
        smap.put(myRegion.getName(), regionKeyValue);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void putKeysValuesRegionA() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameA, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValuesRegionB() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameB, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValuesRegionC() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameC, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValuesRegionD() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameD, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValuesRegionE() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameE, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValuesRegionF() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameF, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValuesRegionG() throws Exception {
        Cache cache = CacheUtil.createCache();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.createRegionAttributes();
        Region region = CacheUtil.createRegion(regionNameG, attr);
        SustainabilityTest.putKeysValues(region);
    }

    public static void putKeysValues(Region theRegion) throws Exception {
        String key = "Key";
        String value = "Value";
        for (int i = 0; i < 20000; ++i) {
            theRegion.put((Object)(key + i), (Object)(value + i));
        }
    }

    public static void stopOtherClients() throws ClientVmNotFoundException {
        HydraVector clientsToStop = TestConfig.tab().vecAt(RolesPrms.clientsToStop);
        for (int i = 0; i < clientsToStop.size(); ++i) {
            String stopMode = TestConfig.tab().stringAt(RolesPrms.stopMode, "MEAN_KILL");
            String startMode = TestConfig.tab().stringAt(RolesPrms.startMode, "ON_DEMAND");
            Long key = RolesPrms.clientsToStop;
            String clientToStop = (String)clientsToStop.elementAt(i);
            Log.getLogWriter().info("STOPPING THE CLIENT : " + clientToStop);
            ClientVmInfo info = ClientVmMgr.stop("stop client", ClientVmMgr.toStopMode(stopMode), ClientVmMgr.toStartMode(startMode), new ClientVmInfo(null, clientToStop, null));
            Log.getLogWriter().info("stopped client" + info);
        }
    }

    public static void stopAndRestartRandomRolePlayingClients() throws ClientVmNotFoundException, Exception {
        HydraVector clientsToStop = TestConfig.tab().vecAt(RolesPrms.clientsToStop);
        int numClients = clientsToStop.size();
        Random rand = new Random();
        int randClientNum = rand.nextInt(numClients);
        String clientToStopAndRestart = (String)clientsToStop.elementAt(randClientNum);
        Log.getLogWriter().info("STOPPING AND STARTING CLIENT : " + clientToStopAndRestart);
        SustainabilityTest.stopClient(clientToStopAndRestart);
        long time = System.currentTimeMillis();
        MasterController.sleepForMs(1000);
        SustainabilityTest.startClient(clientToStopAndRestart);
        Log.getLogWriter().info("TIME TAKE TO RESTART THE CLIENT : " + (System.currentTimeMillis() - time));
        MasterController.sleepForMs(60000);
    }

    public static void stopClient(String theClient) throws ClientVmNotFoundException {
        String stopMode = TestConfig.tab().stringAt(RolesPrms.stopMode, "MEAN_KILL");
        String startMode = TestConfig.tab().stringAt(RolesPrms.startMode, "ON_DEMAND");
        Long key = RolesPrms.clientsToStop;
        ClientVmInfo info = ClientVmMgr.stop("stop client", ClientVmMgr.toStopMode(stopMode), ClientVmMgr.toStartMode(startMode), new ClientVmInfo(null, theClient, null));
        Log.getLogWriter().info("STOPED : " + info);
    }

    public static void startClient(String theClient) {
        try {
            ClientVmInfo info = ClientVmMgr.start("start client", new ClientVmInfo(null, theClient, null));
            Log.getLogWriter().info("RESTARTED CLIENT  : " + info);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Could not start client!");
        }
    }

    public static void printRegions() throws Exception {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        Set roots = cache.rootRegions();
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            Log.getLogWriter().info("ROOT XXXX : " + it.next());
        }
    }

    public static void stopClient() throws ClientVmNotFoundException {
        String stopMode = TestConfig.tab().stringAt(RolesPrms.stopMode, "MEAN_KILL");
        String startMode = TestConfig.tab().stringAt(RolesPrms.startMode, "ON_DEMAND");
        Long key = RolesPrms.clientsToStop;
        String clientToStop = TestConfig.tasktab().stringAt(key, TestConfig.tab().stringAt(key));
        ClientVmInfo info = ClientVmMgr.stop("stop client", ClientVmMgr.toStopMode(stopMode), ClientVmMgr.toStartMode(startMode), new ClientVmInfo(null, clientToStop, null));
        Log.getLogWriter().info("stopped client" + info);
    }

    public static void startClient() throws ClientVmNotFoundException {
        try {
            ClientVmInfo info = ClientVmMgr.start("start client");
            Log.getLogWriter().info("RESTARTED CLIENT : " + info);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Could not start client!");
        }
    }

    public static void doSomeThing() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

