/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import swarm.DUnitTestMethodDetail;
import swarm.MethodRunSummary;
import swarm.Swarm;

public class DUnitRun
implements Comparable<DUnitRun> {
    private final int id;
    private final String userName;
    private final String path;
    private final int sites;
    private final String revision;
    private final String branch;
    private final String osName;
    private final String osVersion;
    private final String javaVersion;
    private final String javaVmVersion;
    private final String javaVmVendor;
    private final Date time;
    private List<DUnitTestMethodDetail> passAndFail = null;
    private List<DUnitTestMethodDetail> fails = null;
    private List<DUnitTestMethodDetail> passes = null;
    private List<MethodRunSummary> passSummaries = null;

    @Override
    public int compareTo(DUnitRun du) {
        return this.getTime().compareTo(du.getTime());
    }

    public DUnitRun(int id, String userName, String path, int sites, String revision, String branch, String osName, String osVersion, String javaVersion, String javaVmVersion, String javaVmVendor, Date time) {
        this.id = id;
        this.userName = userName;
        this.path = path;
        this.sites = sites;
        this.revision = revision;
        this.branch = branch;
        this.osName = osName;
        this.osVersion = osVersion;
        this.javaVersion = javaVersion;
        this.javaVmVersion = javaVmVersion;
        this.javaVmVendor = javaVmVendor;
        this.time = time;
    }

    public int getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPath() {
        return this.path;
    }

    public int getSites() {
        return this.sites;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getShortBranch() {
        return this.branch.replaceAll("gemfire/", "").replaceAll("branches/", "");
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVmVersion() {
        return this.javaVmVersion;
    }

    public String getJavaVmVendor() {
        return this.javaVmVendor;
    }

    public String getShortJavaVmVendor() {
        return this.javaVmVendor.replaceAll(" Microsystems Inc.", "");
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeString() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        return sdf.format(this.getTime());
    }

    public List<DUnitTestMethodDetail> getPassesAndFails() throws SQLException {
        if (this.passAndFail == null) {
            this.passAndFail = new ArrayList<DUnitTestMethodDetail>();
            this.passAndFail.addAll(this.fails);
            this.passAndFail.addAll(this.passes);
            Collections.sort(this.passAndFail);
            Collections.reverse(this.passAndFail);
        }
        return this.passAndFail;
    }

    public List<DUnitTestMethodDetail> getFails() throws SQLException {
        if (this.fails == null) {
            this.fails = Swarm.getFailedForRun(this.getId());
            Collections.sort(this.fails);
            Collections.reverse(this.fails);
        }
        return this.fails;
    }

    public List<DUnitTestMethodDetail> getPasses() throws SQLException {
        if (this.passes == null) {
            this.passes = Swarm.getPassedForRun(this.getId());
            Collections.sort(this.passes);
            Collections.reverse(this.passes);
        }
        return this.passes;
    }

    public List<MethodRunSummary> getPassSummaries() throws SQLException {
        if (this.passSummaries == null) {
            this.passSummaries = Swarm.getPassSummariesForRun(this.getId());
            Collections.sort(this.passSummaries);
            Collections.reverse(this.passSummaries);
        }
        return this.passSummaries;
    }

    public int getPassCount() throws SQLException {
        return this.getPasses().size();
    }

    public int getFailCount() throws SQLException {
        return this.getFails().size();
    }

    public String toString() {
        return "DUnitRun@" + System.identityHashCode(this) + ":" + ("id:" + this.id) + (" userName:" + this.userName) + (" path:" + this.path) + (" sites:" + this.sites) + (" revision:" + this.revision) + (" branch:" + this.branch) + (" osName:" + this.osName) + (" osVersion:" + this.osVersion) + (" javaVersion:" + this.javaVersion) + (" javaVmVersion:" + this.javaVmVendor) + (" javaVmVendor:" + this.javaVmVendor) + (" time:" + this.time);
    }

    public String getVerboseHtml() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("<div class=\"dunitMethodResult\" id=\"run").append(this.getId()).append("\">");
        sb.append("<div class=\"leftResult\">");
        sb.append("<div class=\"timestamp\">").append(this.getTimeString()).append("</div>");
        sb.append("<div class=\"runInfo\"><label>user:</label> <a href=\"/shh/user/").append(this.getUserName()).append("\">").append(this.getUserName()).append("</a> <label>dunit run:</label> <a href=\"/shh/run/").append(this.getId()).append("\">#").append(this.getId()).append("</a></div>");
        sb.append("<div class=\"runInfo\"><label>branch:</label> ").append(this.getShortBranch()).append(" <label>rev:</label> ").append(this.getRevision()).append("</div>");
        sb.append("<div class=\"runInfo\"><label>os:</label> ").append(this.getOsName()).append(" <label>jdk:</label> ").append(this.getShortJavaVmVendor()).append(": ").append(this.getJavaVersion()).append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"rightResult\">");
        sb.append("<div class=\"");
        if (this.getFailCount() > 0) {
            sb.append("statusfail");
        } else {
            sb.append("statuspass");
        }
        sb.append("\"><a href=\"/shh/run/").append(this.getId()).append("\">Failures: ").append(this.getFailCount()).append(" Passes: ").append(this.getPassCount()).append("</a></div>");
        sb.append("");
        sb.append("<div style=\"padding:10px;\">");
        if (this.getFailCount() == 0) {
            sb.append("<a href=\"/shh/run/").append(this.getId()).append("\">No failures - Click for details</a>");
        } else {
            sb.append("<div style=\"text-align:left;\"><strong>Failures:</strong></div>");
            sb.append("<div class=\"errorText\" style=\"padding-left:10px;\">");
            for (int i = 0; i < this.getFails().size(); ++i) {
                DUnitTestMethodDetail fail = this.getFails().get(i);
                if (i == 3 && i != this.getFails().size() - 1 && this.getFails().size() > 3) {
                    sb.append("<div id=\"showMore").append(this.getId()).append("\"><a style=\"font-weight:bold;\" href=\"#\" onclick=\"document.getElementById('moreFails").append(this.getId()).append("').style.display='block';document.getElementById('showMore").append(this.getId()).append("').style.display='none';return false;\">Click to see ").append(this.getFailCount() - 3).append(" more failures...</a></div>");
                    sb.append("<div style=\"display:none;\" id=\"moreFails").append(this.getId()).append("\">");
                }
                sb.append("<div style=\"border-bottom:1px dashed #776045;padding-bottom:3px;\"><a href=\"/shh/result/").append(fail.getId()).append("\" title=\"").append(fail.getError()).append("\">").append(fail.getMethodInfo().getClassInfo().getVeryShortName()).append(" : <strong>").append(fail.getMethodInfo().getName()).append("()</strong></a></div>");
                if (i == 3 || i != this.getFails().size() - 1 || this.getFails().size() <= 3) continue;
                sb.append("</div>");
            }
            sb.append("</div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"fs\"></div>");
        sb.append("</div>");
        return sb.toString();
    }
}

