/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import swarm.DUnitMethodInfo;
import swarm.DUnitRun;
import swarm.Swarm;

public class DUnitTestMethodDetail
implements Comparable<DUnitTestMethodDetail> {
    private final int id;
    private final int methodId;
    private final String status;
    private final String error;
    private final int runId;
    private final Date time;
    private final long tookMs;
    private final int hashCode;

    public boolean equals(Object o) {
        if (!(o instanceof DUnitTestMethodDetail)) {
            return false;
        }
        return ((DUnitTestMethodDetail)o).getId() == this.getId();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(DUnitTestMethodDetail o1) {
        return this.getTime().compareTo(o1.getTime());
    }

    public DUnitTestMethodDetail(int id, int methodId, String status, String error, int runId, Date time, long tookMs) {
        this.id = id;
        this.methodId = methodId;
        this.status = status;
        this.error = error;
        this.runId = runId;
        this.time = time;
        this.tookMs = tookMs;
        this.hashCode = new Integer(id).hashCode();
    }

    public long getTookMs() {
        return this.tookMs;
    }

    public boolean isFail() {
        return this.error != null;
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeString() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        return sdf.format(this.getTime());
    }

    public int getRunId() {
        return this.runId;
    }

    public DUnitRun getRun() {
        try {
            return Swarm.getDUnitRun(this.getRunId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public DUnitMethodInfo getMethodInfo() {
        try {
            return Swarm.getDUnitMethodInfo(this.getMethodId());
        }
        catch (SQLException se) {
            se.printStackTrace();
            return null;
        }
    }
}

