/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import swarm.BaseEnv;
import swarm.DUnitClassInfo;
import swarm.DUnitMethodInfo;
import swarm.DUnitRun;
import swarm.DUnitTestMethodDetail;
import swarm.Database;
import swarm.FilterCriterion;
import swarm.RuntimeEnv;
import swarm.Swarm;

public class SwarmServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        String path = request.getContextPath();
        String path3 = request.getPathTranslated();
        String path4 = request.getQueryString();
        System.out.println("pathInfo:" + pathInfo + " cpath:" + path + " tpath:" + path3 + " qs:" + path4);
        if (pathInfo == null) {
            SwarmServlet.showDUnitRuns(request, response);
        } else {
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if (pathInfo.startsWith("run/")) {
                pathInfo = pathInfo.substring(4);
                int runId = Integer.parseInt(pathInfo);
                SwarmServlet.showDUnitRun(runId, request, response);
            } else if (pathInfo.startsWith("result/")) {
                pathInfo = pathInfo.substring(7);
                int methodId = Integer.parseInt(pathInfo);
                SwarmServlet.showDUnitMethodDetail(methodId, request, response);
            } else if (pathInfo.startsWith("method/")) {
                pathInfo = pathInfo.substring(7);
                int methodId = Integer.parseInt(pathInfo);
                SwarmServlet.showDUnitMethodInfo(methodId, request, response);
            } else if (pathInfo.startsWith("class/")) {
                pathInfo = pathInfo.substring(6);
                int methodId = Integer.parseInt(pathInfo);
                SwarmServlet.showDUnitClassInfo(methodId, request, response);
            } else if (pathInfo.startsWith("runs")) {
                SwarmServlet.showDUnitRuns(request, response);
            } else if (pathInfo.startsWith("classes")) {
                SwarmServlet.showDUnitClasses(request, response);
            } else if (pathInfo.startsWith("search")) {
                String query = request.getParameter("query");
                SwarmServlet.showSearchResults(query, request, response);
            } else {
                response.sendRedirect("/shh/runs");
            }
        }
    }

    public static void showSearchResults(String query, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            List<DUnitTestMethodDetail> details = Swarm.queryFailures(query);
            request.setAttribute("query", (Object)query);
            request.setAttribute("failures", details);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/query_results.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDUnitRun(int runId, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DUnitRun run = Swarm.getDUnitRun(runId);
            request.setAttribute("run", (Object)run);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/dunit_run.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDUnitMethodDetail(int methodId, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DUnitTestMethodDetail mutmd = Swarm.getDUnitTestMethodDetail(methodId);
            int runId = mutmd.getRunId();
            DUnitRun run = Swarm.getDUnitRun(runId);
            List<DUnitTestMethodDetail> classResults = Swarm.getDetailsForClassAndRun(mutmd.getMethodInfo().getClassId(), run.getId());
            Collections.sort(classResults);
            Collections.reverse(classResults);
            classResults.remove(mutmd);
            request.setAttribute("classResults", classResults);
            request.setAttribute("method", (Object)mutmd);
            request.setAttribute("run", (Object)run);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/dunit_method_result.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDUnitMethodInfo(int methodId, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DUnitMethodInfo minfo = Swarm.getDUnitMethodInfo(methodId);
            DUnitClassInfo cinfo = minfo.getClassInfo();
            List<DUnitTestMethodDetail> passes = Swarm.getPassedDetailsForMethod(methodId);
            List<DUnitTestMethodDetail> fails = Swarm.getFailedDetailsForMethod(methodId);
            int passCount = passes.size();
            int failCount = fails.size();
            int totalCount = failCount + passCount;
            request.setAttribute("passCount", (Object)passCount);
            request.setAttribute("failCount", (Object)failCount);
            request.setAttribute("totalCount", (Object)totalCount);
            Collections.sort(passes);
            Collections.sort(fails);
            Collections.reverse(passes);
            Collections.reverse(fails);
            request.setAttribute("passes", passes);
            request.setAttribute("fails", fails);
            ArrayList<DUnitTestMethodDetail> both = new ArrayList<DUnitTestMethodDetail>(passes);
            both.addAll(fails);
            Collections.sort(both);
            Collections.reverse(both);
            request.setAttribute("both", both);
            request.setAttribute("minfo", (Object)minfo);
            request.setAttribute("cinfo", (Object)cinfo);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/dunit_method_info.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDUnitClassInfo(int classId, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DUnitClassInfo cinfo = Swarm.getDUnitClassInfo(classId);
            List<DUnitMethodInfo> minfos = Swarm.getDUnitMethodInfosForClass(classId);
            System.out.println("!!!!!!!!!!!!!minfos:" + minfos.size());
            request.setAttribute("cinfo", (Object)cinfo);
            request.setAttribute("minfos", minfos);
            List<DUnitTestMethodDetail> passes = Swarm.getPassedDetailsForClass(classId);
            List<DUnitTestMethodDetail> fails = Swarm.getFailedDetailsForClass(classId);
            int passCount = passes.size();
            int failCount = fails.size();
            int totalCount = failCount + passCount;
            System.out.println("pc:" + passCount + " fc:" + failCount);
            request.setAttribute("passCount", (Object)passCount);
            request.setAttribute("failCount", (Object)failCount);
            request.setAttribute("totalCount", (Object)totalCount);
            Collections.sort(passes);
            Collections.sort(fails);
            Collections.reverse(passes);
            Collections.reverse(fails);
            request.setAttribute("passes", passes);
            request.setAttribute("fails", fails);
            ArrayList<DUnitTestMethodDetail> both = new ArrayList<DUnitTestMethodDetail>(passes);
            both.addAll(fails);
            Collections.sort(both);
            Collections.reverse(both);
            request.setAttribute("both", both);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/dunit_class_info.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDashboard(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ResultSet rs = Database.executeQuery("SELECT user_name FROM \"USER\"", true);
            ArrayList<String> users = new ArrayList<String>();
            while (rs.next()) {
                String s = rs.getString(1);
                users.add(s);
            }
            System.out.println("users:" + users);
            request.setAttribute("users", users);
            request.setAttribute("base_envs", SwarmServlet.getBaseEnvs("gregp"));
            request.setAttribute("runtime_envs", SwarmServlet.getRuntimeEnvs("gregp"));
            List<DUnitClassInfo> ducis = Swarm.getAllDUnitClasses();
            request.setAttribute("ducis", ducis);
            DUnitRun latestRun = Swarm.getLatestDUnitRun("gregp");
            request.setAttribute("latestRun", (Object)latestRun);
            System.out.println("LatestRun:" + latestRun);
            FilterCriterion fc = SwarmServlet.buildFilterCriterion(request);
            request.setAttribute("os_name", request.getAttribute("os_name"));
            List<DUnitRun> druns = Swarm.getAllDUnitRuns(fc);
            request.setAttribute("druns", druns);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/swarm.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDUnitClasses(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            List<DUnitClassInfo> ducis = Swarm.getAllDUnitClasses();
            request.setAttribute("ducis", ducis);
            int duciCount = ducis.size();
            request.setAttribute("classCount", (Object)duciCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.getRequestDispatcher("/dunit_classes.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showDUnitRuns(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            request.setAttribute("users", SwarmServlet.getUserList());
            request.setAttribute("branches", SwarmServlet.getBranchList());
            FilterCriterion fc = SwarmServlet.buildFilterCriterion(request);
            request.getSession().setAttribute("os_name", (Object)request.getParameter("os_name"));
            request.getSession().setAttribute("java_version", (Object)request.getParameter("java_version"));
            request.getSession().setAttribute("branch", (Object)request.getParameter("branch"));
            request.getSession().setAttribute("user", (Object)request.getParameter("user"));
            List<DUnitRun> druns = Swarm.getAllDUnitRuns(fc);
            Collections.sort(druns);
            Collections.reverse(druns);
            List<DUnitRun> last10 = druns;
            if (druns.size() > 10) {
                last10 = druns.subList(0, 10);
            }
            request.setAttribute("last10", last10);
            request.setAttribute("druns", druns);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        request.getRequestDispatcher("/runs.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public static List<BaseEnv> getBaseEnvs(String user) throws SQLException {
        PreparedStatement ps = Database.prepareStatement("SELECT id,name,checkoutPath,outputPath from \"BASE_ENV\" WHERE user_name=?");
        ps.setString(1, user);
        ResultSet rs = ps.executeQuery();
        ArrayList<BaseEnv> base_envs = new ArrayList<BaseEnv>();
        while (rs.next()) {
            BaseEnv be = new BaseEnv(rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(1));
            base_envs.add(be);
        }
        return base_envs;
    }

    public static List<RuntimeEnv> getRuntimeEnvs(String user) throws SQLException {
        PreparedStatement ps = Database.prepareStatement("SELECT name,user_name,build_properties,targets,buildPath,resultPath from \"RUNTIME_ENV\" WHERE user_name=?");
        ps.setString(1, user);
        ResultSet rs = ps.executeQuery();
        ArrayList<RuntimeEnv> run_envs = new ArrayList<RuntimeEnv>();
        while (rs.next()) {
            RuntimeEnv re = new RuntimeEnv(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6));
            run_envs.add(re);
        }
        return run_envs;
    }

    private static FilterCriterion buildFilterCriterion(HttpServletRequest request) {
        FilterCriterion fc = new FilterCriterion();
        fc.setUserName(request.getParameter("user"));
        fc.setOsName(request.getParameter("os_name"));
        fc.setJavaVersion(request.getParameter("java_version"));
        fc.setBranch(request.getParameter("branch"));
        return fc;
    }

    private static List<String> getUserList() {
        return SwarmServlet.getOneColumn("SELECT distinct user_name FROM dunit_run");
    }

    private static List<String> getBranchList() {
        return SwarmServlet.getOneColumn("select distinct branch from dunit_run");
    }

    private static List<String> getOneColumn(String sql) {
        ArrayList<String> list = null;
        try {
            ResultSet rs = Database.executeQuery(sql, false);
            list = new ArrayList<String>();
            while (rs.next()) {
                String s = rs.getString(1);
                list.add(s);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

