/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import hydra.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import swarm.DUnitClassInfo;
import swarm.DUnitMethodInfo;
import swarm.DUnitRun;
import swarm.Swarm;
import swarm.TestType;
import swarm.UnitTestObserver;
import swarm.bb.SwarmBB;

public class UnitTestObserverImpl
implements UnitTestObserver {
    private static DUnitRun dunitRun = null;
    private static boolean dunitRecordResults = Boolean.getBoolean("dunitRecordResults");
    private long startTime;
    private String testInProgress = null;
    String lastPassClass = null;
    String lastFailClass = null;
    String lastFailMethod = null;
    Throwable lastThrowable = null;
    private static Pattern methodpattern = Pattern.compile("(.*\\w+)\\(.*\\)");
    private static Pattern classpattern = Pattern.compile(".*\\w+\\((.*)\\)");

    @Override
    public void incCurrentTestCount() {
        SwarmBB.incCurrentTestCount();
    }

    @Override
    public void testTypeDetected(TestType t) {
        SwarmBB.setTestType(t);
    }

    @Override
    public void totalTestCountDetected(int count) {
        SwarmBB.setTotalTestCount(count);
    }

    public long getCurrentTestCount() {
        return SwarmBB.getCurrentTestCount();
    }

    public long getTotalTestCount() {
        return SwarmBB.getTotalTestCount();
    }

    public void startTest(Test test) {
        this.startTime = System.currentTimeMillis();
        String s = "zzzzzSTART " + test;
        Log.getLogWriter().info(s);
        this.testInProgress = test.toString();
    }

    public void endTest(Test test) {
        if (!dunitRecordResults) {
            Log.getLogWriter().info("Not recording results");
            return;
        }
        long delta = System.currentTimeMillis() - this.startTime;
        String s = "zzzzzEND " + test + " (took " + delta + "ms)";
        Log.getLogWriter().info(s);
        this.testInProgress = null;
        String className = UnitTestObserverImpl.getClassName(test);
        String methodName = UnitTestObserverImpl.getMethodName(test);
        if (className.equals(this.lastFailClass)) {
            if (methodName.equals(this.lastFailMethod)) {
                this.recordFail(className, methodName, delta);
            } else {
                this.lastFailMethod = null;
                this.lastThrowable = null;
                this.recordPass(className, methodName, delta);
            }
            return;
        }
        if (this.lastPassClass == null) {
            this.lastPassClass = className;
            this.lastFailMethod = null;
            this.lastFailClass = null;
            this.recordPass(className, methodName, delta);
        } else if (!this.lastPassClass.equals(className)) {
            this.lastPassClass = className;
            this.lastFailMethod = null;
            this.lastFailClass = null;
            this.recordPass(className, methodName, delta);
        } else {
            this.recordPass(className, methodName, delta);
        }
    }

    public void recordPass(String className, String methodName, long tookMs) {
        try {
            DUnitRun du = UnitTestObserverImpl.getDUnitRun();
            DUnitClassInfo duci = Swarm.getOrCreateDUnitClassInfo(className);
            DUnitMethodInfo dumi = Swarm.getOrCreateDUnitMethodInfo(methodName, duci.getId());
            Swarm.recordPass(du, dumi, tookMs);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
    }

    public void recordFail(String className, String methodName, long tookMs) {
        try {
            DUnitRun du = UnitTestObserverImpl.getDUnitRun();
            DUnitClassInfo duci = Swarm.getOrCreateDUnitClassInfo(className);
            DUnitMethodInfo dumi = Swarm.getOrCreateDUnitMethodInfo(methodName, duci.getId());
            Swarm.recordFailure(du, dumi, this.lastThrowable, tookMs);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
    }

    public void addError(Test test, Throwable t) {
        StringBuffer sb = new StringBuffer();
        sb.append(test.toString());
        sb.append("\n");
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        sb.append(sw.toString());
        Log.getLogWriter().severe("zzzzzERROR IN " + test, t);
        this.lastFailClass = UnitTestObserverImpl.getClassName(test);
        this.lastFailMethod = UnitTestObserverImpl.getMethodName(test);
        this.lastThrowable = t;
    }

    public void addFailure(Test test, AssertionFailedError t) {
        StringBuffer sb = new StringBuffer();
        sb.append(test.toString());
        sb.append("\n");
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        sb.append(sw.toString());
        Log.getLogWriter().severe("zzzzzFAILURE IN " + test, (Throwable)t);
        this.lastFailClass = UnitTestObserverImpl.getClassName(test);
        this.lastFailMethod = UnitTestObserverImpl.getMethodName(test);
        this.lastThrowable = t;
    }

    protected static String getClassName(Test test) {
        String desc = test.toString();
        Matcher matcher = classpattern.matcher(desc);
        String className = matcher.matches() ? matcher.group(1) : desc;
        return className;
    }

    protected static String getMethodName(Test test) {
        String desc = test.toString();
        Matcher matcher = methodpattern.matcher(desc);
        String className = matcher.matches() ? matcher.group(1) : desc;
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DUnitRun getDUnitRun() {
        if (dunitRun != null) {
            System.out.println("BBB dunitRun not null returning");
            return dunitRun;
        }
        try {
            SwarmBB.getBB().getSharedLock().lock();
            Integer runId = (Integer)SwarmBB.getBB().getSharedMap().get(SwarmBB.RUN_ID);
            System.out.println("BBB runID=" + runId);
            if (runId != null) {
                dunitRun = Swarm.getDUnitRun(runId);
                System.out.println("BBB lookedUp RUN:" + dunitRun);
            } else {
                dunitRun = Swarm.generateNewDUnitRun();
                System.out.println("BBB GENNED UP A RUN:" + dunitRun + " mapping to id:" + dunitRun.getId());
                SwarmBB.getBB().getSharedMap().put(SwarmBB.RUN_ID, dunitRun.getId());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            SwarmBB.getBB().getSharedLock().unlock();
        }
        return dunitRun;
    }
}

