/*
 * Decompiled with CFR 0.152.
 */
package target;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import hydra.Log;
import target.TargetBB;

public class PutAllCacheWriter
extends CacheWriterAdapter {
    private static long numCreates = 0L;
    private long delayInBetweenPutsMS = 0L;
    private boolean useBlackBoard = false;

    public PutAllCacheWriter(long putDelay, boolean useBlackBoard) {
        this.delayInBetweenPutsMS = putDelay;
        this.useBlackBoard = useBlackBoard;
        TargetBB.getBB().getSharedMap().put("numCreates", new Integer(0));
    }

    public PutAllCacheWriter(long putDelay) {
        this.delayInBetweenPutsMS = putDelay;
    }

    public void beforeCreate(EntryEvent event) throws CacheWriterException {
        Log.getLogWriter().info("Number of creates " + ++numCreates);
        if (this.useBlackBoard) {
            TargetBB.getBB().getSharedMap().put("numCreates", new Integer((int)numCreates));
        }
        try {
            Thread.sleep(this.delayInBetweenPutsMS);
        }
        catch (Exception e) {
            Log.getLogWriter().info("beforeCreate : " + e.getMessage());
        }
    }

    public long getNumCreates() {
        return numCreates;
    }

    public void setDelay(long delay) {
        this.delayInBetweenPutsMS = delay;
    }

    public void useBlackBoard(boolean useBlackBoard) {
        this.useBlackBoard = useBlackBoard;
    }
}

