/*
 * Decompiled with CFR 0.152.
 */
package target;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.HashMap;
import java.util.Map;
import target.PutAllCacheWriter;
import target.PutAllThread;
import target.TargetBB;
import target.TargetPrms;
import util.TestException;

public class TargetTest {
    public static Cache cache = null;
    public static Region region = null;
    private static Map<Integer, Byte[]> dataMap = null;
    private static final int defaultEntriesCount = 100;
    private static final int defaultByteArraySize = 100;
    private static final int defaultDelayInBetweenPuts = 1000;
    private static final int defaultEntriesThresholdPercent = 10;
    public static final String REGION_NAME = "testRegion";
    private static int entriesThreshold = 0;
    private static int numEntries = 0;
    private static int delayInBetweenPutsMS = 0;
    private static TargetTest testInstance = null;

    private TargetTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TargetTest getTestInstance() {
        if (testInstance != null) return testInstance;
        Class<TargetTest> clazz = TargetTest.class;
        synchronized (TargetTest.class) {
            if (testInstance != null) return testInstance;
            testInstance = new TargetTest();
            // ** MonitorExit[var0] (shouldn't be in output)
            return testInstance;
        }
    }

    public static synchronized void InitBridgeServer() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Region serverRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        delayInBetweenPutsMS = TestConfig.tab().intAt(TargetPrms.delayInBetweenPutsMS, 1000);
        PutAllCacheWriter cacheWriter = new PutAllCacheWriter(delayInBetweenPutsMS, true);
        serverRegion.getAttributesMutator().setCacheWriter((CacheWriter)cacheWriter);
    }

    public static void InitEdgeClient() {
        cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Log.getLogWriter().info("initEdgeClient() : Cache created");
        Region clientRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        clientRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        int delay = TestConfig.tab().intAt(TargetPrms.delayInBetweenPutsMS, 1000);
        PutAllCacheWriter cacheWriter = new PutAllCacheWriter(delay, true);
        clientRegion.getAttributesMutator().setCacheWriter((CacheWriter)cacheWriter);
        TargetBB.getBB();
        TargetBB.getBB().getSharedMap().put("regionSize", new Integer(-1));
    }

    public static void TaskTargetClientServer() {
        Log.getLogWriter().info("In the TaskTargetClientServer");
        TargetTest.getTestInstance().startPutAllAndCloseCache(false);
    }

    public static void loadDataMap() {
        numEntries = TestConfig.tab().intAt(TargetPrms.numMapEntries, 100);
        int byteArraySize = TestConfig.tab().intAt(TargetPrms.byteArraySize, 100);
        int thresholdPercent = TestConfig.tab().intAt(TargetPrms.entriesThresholdPercent, 10);
        double e = thresholdPercent * numEntries / 100;
        entriesThreshold = (int)e;
        Log.getLogWriter().info("Number of entries           : " + numEntries);
        Log.getLogWriter().info("Size of the byte array      : " + byteArraySize);
        Log.getLogWriter().info("Threshold number of entries : " + entriesThreshold);
        dataMap = new HashMap<Integer, Byte[]>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            Byte[] largeObj = new Byte[byteArraySize];
            dataMap.put(new Integer(i), largeObj);
        }
        Log.getLogWriter().info("Large data map created");
    }

    public static synchronized void InitTargetP2PTest() {
        if (CacheHelper.getCache() == null) {
            Log.getLogWriter().info("Creating cache");
            cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            Log.getLogWriter().info("Cache created");
            region = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
            Log.getLogWriter().info("Region created");
            TargetTest.loadDataMap();
        }
        Log.getLogWriter().info("Hydra Task initialized");
    }

    public static void TaskTargetP2P() {
        Log.getLogWriter().info("In the TaskTargetP2P()");
        TargetTest.getTestInstance().startPutAllAndCloseCache(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startPutAllAndCloseCache(boolean isP2P) {
        Region region = RegionHelper.getRegion(REGION_NAME);
        TargetTest.loadDataMap();
        PutAllThread t = new PutAllThread(region, dataMap);
        if (isP2P) {
            delayInBetweenPutsMS = TestConfig.tab().intAt(TargetPrms.delayInBetweenPutsMS, 1000);
            PutAllCacheWriter cacheWriter = new PutAllCacheWriter(delayInBetweenPutsMS);
            region.getAttributesMutator().setCacheWriter((CacheWriter)cacheWriter);
            t.start();
            while (cacheWriter.getNumCreates() < (long)entriesThreshold) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Exception  : " + e.getMessage());
                }
            }
        } else {
            t.start();
            int numEntries = 0;
            while (numEntries < entriesThreshold) {
                Integer creates = (Integer)TargetBB.getBB().getSharedMap().get("numCreates");
                numEntries = creates;
                Log.getLogWriter().info("Number of entries : " + numEntries);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Exception  : " + e.getMessage());
                }
            }
        }
        long cacheCloseDuration = 0L;
        Log.getLogWriter().info("The cache is being closed");
        long cacheCloseStartTime = System.currentTimeMillis();
        cache.close();
        long cacheCloseEndTime = System.currentTimeMillis();
        Log.getLogWriter().info("The cache is closed");
        try {
            t.join();
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            Log.getLogWriter().info(e.getMessage());
        }
        if (isP2P) {
            if (t.isDisconnected()) {
                Log.getLogWriter().info("The test passed as the ongoing Region.putAll(map) was terminated due to a Cache.close() and CacheClosedException was rightly thrown");
                return;
            }
            Log.getLogWriter().info("The test failed as the Region.putAll(map) did not terminate due to a Cache.close()");
            throw new TestException("Unexpected behavior : The test failed as the ongoing Region.putAll(map) did not terminate due to a Cache.close()");
        }
        cacheCloseDuration = cacheCloseEndTime - cacheCloseStartTime;
        delayInBetweenPutsMS = TestConfig.tab().intAt(TargetPrms.delayInBetweenPutsMS, 1000);
        int putAllTime = (numEntries - entriesThreshold) * delayInBetweenPutsMS;
        if (cacheCloseDuration > (long)putAllTime) {
            Log.getLogWriter().info("The Cache close took really long time to return");
            Log.getLogWriter().info("Cache close duration : " + cacheCloseDuration + " (milliseconds)");
            Log.getLogWriter().info("The duration of putAll() after Cache.close() : " + putAllTime);
            throw new TestException("Cache.close() does not return immediately");
        }
        int putsInClient = (Integer)TargetBB.getBB().getSharedMap().get("clientNumPuts");
        int putsInServer = (Integer)TargetBB.getBB().getSharedMap().get("numCreates");
        Log.getLogWriter().info("Number of puts in the client : " + putsInClient);
        Log.getLogWriter().info("Number of puts by the server : " + putsInServer);
    }

    public static void PutRegionSizeOnBB() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            Log.getLogWriter().info("Not the right VM");
        } else {
            Region aRegion = RegionHelper.getRegion(REGION_NAME);
            int regionSize = aRegion.size();
            Log.getLogWriter().info("PutRegionSizeonBB()- Region size : " + aRegion.size());
            TargetBB.getBB().getSharedMap().put("regionSize", new Integer(regionSize));
        }
    }

    public static void VerifyRegionSize() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            Log.getLogWriter().info("Not the right VM");
        } else {
            int regionSizeFromBB;
            Region aRegion = RegionHelper.getRegion(REGION_NAME);
            int regionSize = aRegion.size();
            if (regionSize != (regionSizeFromBB = ((Integer)TargetBB.getBB().getSharedMap().get("regionSize")).intValue())) {
                new TestException("Region sizes do not match, inconsistent putAll() ");
            }
        }
    }
}

