/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.internal.cache.Token;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import tx.CollectionInfo;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import tx.TxUtil;
import util.BaseValueHolder;
import util.CacheUtil;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class CollectionsTest {
    protected static CollectionsTest collectionsTest;
    RandomValues randomValues = null;
    int modValInitializer = 0;
    long executionNumber = 0L;
    private static final int ONE_MORE = 0;
    private static final int ONE_LESS = 1;
    private static final int EQUAL = 2;

    public static void HydraTask_initialize() {
        Log.getLogWriter().info("In HydraTask_initialize");
        if (collectionsTest == null) {
            collectionsTest = new CollectionsTest();
            collectionsTest.initialize();
        }
    }

    public void initialize() {
        this.randomValues = new RandomValues();
    }

    public static void HydraTask_doTransactions() {
        Log.getLogWriter().info("In HydraTask_doTransactions");
        HydraVector operations = TestConfig.tab().vecAt(TxPrms.operations);
        collectionsTest.doTransactions(operations);
    }

    private void doTransactions(Vector operations) {
        long TIME_LIMIT_MS = 60000L;
        long taskStartTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - taskStartTime < 60000L) {
            Log.getLogWriter().info("doTransactions: EXECUTION NUMBER = " + ++this.executionNumber);
            Operation op = this.getOperation(operations);
            Region aRegion = CacheUtil.getCache().getRegion(op.getRegionName());
            CollectionInfo originalData = new CollectionInfo(aRegion, op);
            Log.getLogWriter().info("Original Collections  = \n" + originalData.toString());
            TxUtil.txUtilInstance.clearDestroyedRegions();
            TxHelper.begin();
            this.executeOperation(op);
            CollectionInfo txData = new CollectionInfo(aRegion, op);
            Log.getLogWriter().info("Transaction Collections = \n" + txData.toString());
            this.validateInTx(op, originalData, txData);
            try {
                TxHelper.commit();
            }
            catch (ConflictException e) {
                throw new TestException("Unexpected ConflictException " + TestHelper.getStackTrace(e));
            }
            this.validateAfterCommit(op, originalData, txData);
            TxUtil.txUtilInstance.createAllDestroyedRegions(true);
        }
    }

    private Operation getOperation(Vector operations) {
        Operation op = null;
        String operation = (String)operations.get(TestConfig.tab().getRandGen().nextInt(0, operations.size() - 1));
        int attempts = 0;
        while (op == null) {
            Region aRegion;
            if (operation.equalsIgnoreCase("entry-create")) {
                op = this.getCreateEntryOp(TxUtil.txUtilInstance.getRandomRegion(true));
            } else if (operation.equalsIgnoreCase("entry-update")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getUpdateEntryOp(aRegion, TxUtil.txUtilInstance.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-destroy")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getDestroyEntryOp(false, aRegion, TxUtil.txUtilInstance.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-localDestroy")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getDestroyEntryOp(true, aRegion, TxUtil.txUtilInstance.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-inval")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getInvalEntryOp(false, aRegion, TxUtil.txUtilInstance.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-localInval")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getInvalEntryOp(true, aRegion, TxUtil.txUtilInstance.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-getWithNewKey")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getGetEntryWithNewKeyOp(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithExistingKey")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getGetEntryWithExistingKeyOp(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithPreviousKey")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getGetEntryWithPreviousKeyOp(aRegion);
            } else if (operation.equalsIgnoreCase("region-create")) {
                op = this.getCreateRegionOp();
            } else if (operation.equalsIgnoreCase("region-destroy")) {
                op = this.getDestroyRegionOp(false, TxUtil.txUtilInstance.getRandomRegion(false));
            } else if (operation.equalsIgnoreCase("region-localDestroy")) {
                op = this.getDestroyRegionOp(true, TxUtil.txUtilInstance.getRandomRegion(false));
            } else if (operation.equalsIgnoreCase("region-inval")) {
                aRegion = TxUtil.txUtilInstance.getRandomRegion(true);
                op = this.getInvalRegionOp(false, TxUtil.txUtilInstance.getRandomRegion(false));
            } else if (operation.equalsIgnoreCase("region-localInval")) {
                op = this.getInvalRegionOp(true, TxUtil.txUtilInstance.getRandomRegion(false));
            } else {
                throw new TestException("Unknown operation " + operation);
            }
            if (++attempts <= 20) continue;
            throw new TestException("Could not execute an operation in 20 attempts (perhaps no keys exist).  Check client vm logs for details");
        }
        Log.getLogWriter().info("getOperation() returning " + op.toString());
        return op;
    }

    public Operation getCreateEntryOp(Region aRegion) {
        String key = NameFactory.getNextPositiveObjectName();
        ValueHolder vh = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer++));
        return new Operation(aRegion.getFullPath(), key, "entry-create", null, vh);
    }

    public Operation getUpdateEntryOp(Region aRegion, Object key) {
        if (key == null) {
            TxUtil.txUtilInstance.createEntries(aRegion);
            return null;
        }
        BaseValueHolder vh = null;
        Object oldValue = this.getValueInVM(aRegion, key);
        vh = oldValue instanceof BaseValueHolder ? (BaseValueHolder)oldValue : new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
        vh = (BaseValueHolder)CopyHelper.copy((Object)vh);
        vh.modVal = new Integer(vh.modVal + 1);
        return new Operation(aRegion.getFullPath(), key, "entry-update", oldValue, vh);
    }

    public Operation getDestroyEntryOp(boolean isLocalDestroy, Region aRegion, Object key) {
        if (key == null) {
            TxUtil.txUtilInstance.createEntries(aRegion);
            return null;
        }
        Object oldValue = this.getValueInVM(aRegion, key);
        if (isLocalDestroy) {
            return new Operation(aRegion.getFullPath(), key, "entry-localDestroy", oldValue, null);
        }
        return new Operation(aRegion.getFullPath(), key, "entry-destroy", oldValue, null);
    }

    public Operation getInvalEntryOp(boolean isLocalInval, Region aRegion, Object key) {
        if (key == null) {
            TxUtil.txUtilInstance.createEntries(aRegion);
            return null;
        }
        Object oldValue = this.getValueInVM(aRegion, key);
        if (isLocalInval) {
            return new Operation(aRegion.getFullPath(), key, "entry-localInval", oldValue, null);
        }
        return new Operation(aRegion.getFullPath(), key, "entry-inval", oldValue, null);
    }

    public Operation getGetEntryWithExistingKeyOp(Region aRegion) {
        Object key = TxUtil.txUtilInstance.getRandomKey(aRegion);
        if (key == null) {
            TxUtil.txUtilInstance.createEntries(aRegion);
            return null;
        }
        Object oldValue = this.getValueInVM(aRegion, key);
        return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, null);
    }

    public Operation getGetEntryWithPreviousKeyOp(Region aRegion) {
        long keysUsed = NameFactory.getPositiveNameCounter();
        String key = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
        Object oldValue = this.getValueInVM(aRegion, key);
        return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, null);
    }

    public Operation getGetEntryWithNewKeyOp(Region aRegion) {
        String key = NameFactory.getNextPositiveObjectName();
        Object oldValue = this.getValueInVM(aRegion, key);
        return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, null);
    }

    public Operation getInvalRegionOp(boolean isLocalInval, Region aRegion) {
        if (isLocalInval) {
            return new Operation(aRegion.getFullPath(), null, "region-localInval", null, null);
        }
        return new Operation(aRegion.getFullPath(), null, "region-inval", null, null);
    }

    public Operation getDestroyRegionOp(boolean isLocalDestroy, Region aRegion) {
        if (aRegion == null) {
            throw new TestException("No regions left to destroy\n" + TestHelper.getStackTrace());
        }
        if (isLocalDestroy) {
            return new Operation(aRegion.getFullPath(), null, "region-localDestroy", null, null);
        }
        return new Operation(aRegion.getFullPath(), null, "region-destroy", null, null);
    }

    public Operation getCreateRegionOp() {
        ArrayList list = (ArrayList)TxBB.getBB().getSharedMap().get(TxBB.DestroyedRegionsKey);
        if (list.size() > 0) {
            int index = TestConfig.tab().getRandGen().nextInt(0, list.size() - 1);
            String regionPath = (String)list.get(index);
            return new Operation(regionPath, null, "region-create", null, null);
        }
        return null;
    }

    public Operation executeOperation(Operation operation) {
        Operation op;
        String opName = operation.getOpName();
        if (opName.equalsIgnoreCase("entry-create")) {
            op = this.executeCreateEntry(operation);
        } else if (opName.equalsIgnoreCase("entry-update")) {
            op = this.executeUpdateEntry(operation);
        } else if (opName.equalsIgnoreCase("entry-destroy")) {
            op = this.executeDestroyEntry(operation);
        } else if (opName.equalsIgnoreCase("entry-localDestroy")) {
            op = this.executeDestroyEntry(operation);
        } else if (opName.equalsIgnoreCase("entry-inval")) {
            op = this.executeInvalEntry(operation);
        } else if (opName.equalsIgnoreCase("entry-localInval")) {
            op = this.executeInvalEntry(operation);
        } else if (opName.equalsIgnoreCase("entry-getWithNewKey")) {
            op = this.executeGetEntryWithNewKey(operation);
        } else if (opName.equalsIgnoreCase("entry-getWithExistingKey")) {
            op = this.executeGetEntryWithExistingKey(operation);
        } else if (opName.equalsIgnoreCase("entry-getWithPreviousKey")) {
            op = this.executeGetEntryWithPreviousKey(operation);
        } else if (opName.equalsIgnoreCase("region-create")) {
            op = this.executeCreateRegion(operation);
        } else if (opName.equalsIgnoreCase("region-destroy")) {
            op = this.executeDestroyRegion(operation);
        } else if (opName.equalsIgnoreCase("region-localDestroy")) {
            op = this.executeDestroyRegion(operation);
        } else if (opName.equalsIgnoreCase("region-inval")) {
            op = this.executeInvalRegion(operation);
        } else if (opName.equalsIgnoreCase("region-localInval")) {
            op = this.executeInvalRegion(operation);
        } else {
            throw new TestException("Unknown operation " + operation);
        }
        return op;
    }

    public Operation executeCreateEntry(Operation op) {
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        Object vh = op.getNewValue();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            Log.getLogWriter().info("createEntry: putting key " + key + ", object " + vh.toString() + " in region " + regionName);
            aRegion.put((Object)key, vh);
            Log.getLogWriter().info("createEntry: done putting key " + key + ", object " + vh.toString() + " in region " + regionName);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeUpdateEntry(Operation op) {
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        Object vh = op.getNewValue();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (key == null) {
            Log.getLogWriter().info("Could not update a key in " + regionName + " because no keys are available");
            return null;
        }
        try {
            Log.getLogWriter().info("updateEntry: Putting new value " + vh + " for key " + key + " in region " + regionName);
            aRegion.put((Object)key, vh);
            Log.getLogWriter().info("updateEntry: Done putting new value " + vh + " for key " + key + " in region " + regionName);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeDestroyEntry(Operation op) {
        String regionName = op.getRegionName();
        Object key = op.getKey();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (key == null) {
            Log.getLogWriter().info("Could not destroy an entry in " + regionName + " because no keys are available");
            return null;
        }
        try {
            if (op.isLocalOperation()) {
                Log.getLogWriter().info("destroyEntry: locally destroying key " + key + " in region " + regionName);
                aRegion.localDestroy(key);
                Log.getLogWriter().info("destroyEntry: done locally destroying key " + key + " in region " + regionName);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " in region " + regionName);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key + " in region " + regionName);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeInvalEntry(Operation op) {
        String regionName = op.getRegionName();
        Object key = op.getKey();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (key == null) {
            Log.getLogWriter().info("Could not invalidate an entry in " + regionName + " because no keys are available");
            return null;
        }
        try {
            if (op.isLocalOperation()) {
                Log.getLogWriter().info("invalEntry: locally invalidating key " + key + " in region " + regionName);
                aRegion.localInvalidate(key);
                Log.getLogWriter().info("invalEntry: done locally invalidating key " + key + " in region " + regionName);
            } else {
                Log.getLogWriter().info("invalEntry: invalidating key " + key + " in region " + regionName);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalEntry: done invalidating key " + key + " in region " + regionName);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newValue = this.getValueInVM(aRegion, key);
        op.setNewValue(newValue);
        return op;
    }

    public Operation executeGetEntryWithExistingKey(Operation op) {
        String regionName = op.getRegionName();
        Object key = op.getKey();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (key == null) {
            Log.getLogWriter().info("Could not get with an existing key " + regionName + " because no keys are available");
            return null;
        }
        try {
            Log.getLogWriter().info("getEntryWithExistingKey: getting value for key " + key + " in region " + regionName);
            Object newValue = aRegion.get(key);
            Log.getLogWriter().info("getEntryWithExistingKey: got value for key " + key + ": " + newValue + " in region " + regionName);
            op.setNewValue(newValue);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeGetEntryWithPreviousKey(Operation op) {
        String regionName = op.getRegionName();
        Object key = op.getKey();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntryWithPreviousKey: getting value for key " + key + " in region " + regionName);
            Object newValue = aRegion.get(key);
            Log.getLogWriter().info("getEntryWithPreviousKey: got value for key " + key + ": " + newValue + " in region " + regionName);
            op.setNewValue(newValue);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeGetEntryWithNewKey(Operation op) {
        String regionName = op.getRegionName();
        Object key = op.getKey();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            Log.getLogWriter().info("getEntryWithNewKey: getting value for key " + key + " in region " + regionName);
            Object newValue = aRegion.get(key);
            Log.getLogWriter().info("getEntryWithNewKey: got value for key " + key + ": " + newValue + " in region " + regionName);
            op.setNewValue(newValue);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeInvalRegion(Operation op) {
        String regionName = op.getRegionName();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            if (op.isLocalOperation()) {
                Log.getLogWriter().info("invalRegion: locally invalidating region " + regionName);
                aRegion.localInvalidateRegion();
                Log.getLogWriter().info("invalRegion: done locally invalidating region " + aRegion.getFullPath());
            } else {
                Log.getLogWriter().info("invalRegion: invalidating region " + regionName);
                aRegion.invalidateRegion();
                Log.getLogWriter().info("invalRegion: done invalidating region " + regionName);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    public Operation executeDestroyRegion(Operation op) {
        String regionName = op.getRegionName();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (aRegion == null) {
            throw new TestException("No regions left to destroy\n" + TestHelper.getStackTrace());
        }
        try {
            TxUtil.txUtilInstance.recordDestroyedRegion(aRegion);
            if (op.isLocalOperation()) {
                Log.getLogWriter().info("destroyRegion: locally destroying region " + regionName);
                aRegion.localDestroyRegion();
                Log.getLogWriter().info("destroyRegion: done locally destroying region " + regionName);
            } else {
                Log.getLogWriter().info("destroyRegion: destroying region " + regionName);
                aRegion.destroyRegion();
                Log.getLogWriter().info("destroyRegion: done destroying region " + regionName);
            }
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return op;
    }

    private void validateInTx(Operation op, CollectionInfo originalData, CollectionInfo txData) {
        Log.getLogWriter().info("validateInTx: op = " + op.toString());
        String opName = op.getOpName();
        Object key = op.getKey();
        Object oldValue = op.getOldValue();
        Object newValue = op.getNewValue();
        String regionName = op.getRegionName();
        this.verifyCollectionsNotAccessible(originalData, op, false);
        Log.getLogWriter().info("validateInTx:  Region collections and iterators obtained outside of transaction properly threw IllegalStateException when accessed within Tx, continuing test");
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (TxPrms.isPartitionedRegion()) {
            return;
        }
        if (opName.equalsIgnoreCase("entry-create")) {
            this.verifyKeys(txData, key, true);
            this.verifyValues(txData, newValue, true);
            this.verifyEntries(txData, key, newValue, true);
            if (!txData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from TxData, txData entry = (key=" + txData.entry.getKey() + ", value = " + txData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("entry-update")) {
            this.verifyKeys(txData, key, true);
            this.verifyValues(txData, newValue, true);
            this.verifyEntries(txData, key, newValue, true);
            if (op.isPreviouslyInvalid()) {
                if (originalData.entry.getValue() != null) {
                    throw new TestException("validateInTransaction failure: originalData.entry.getValue() should be null, but is " + originalData.entry.getValue());
                }
            } else if (originalData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value matches getEntry object from originalData, but shouldn't: originalData entry = (key=" + originalData.entry.getKey() + ", value = " + originalData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
            if (!txData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from TxData, txData entry = (key=" + txData.entry.getKey() + ", value = " + txData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("entry-destroy") || opName.equalsIgnoreCase("entry-localDestroy")) {
            this.verifyKeys(txData, key, false);
            this.verifyValues(txData, newValue, false);
            this.verifyEntries(txData, key, newValue, false);
            if (aRegion.getEntry(key) != null) {
                throw new TestException("validateInTransaction failure: getEntry() should be null (entryDestroyed), but is " + aRegion.getEntry(key));
            }
            if (txData.entry != null) {
                throw new TestException("validateInTransaction failure: txData.entry should show isDestroyed()");
            }
        } else if (opName.equalsIgnoreCase("entry-inval") || opName.equalsIgnoreCase("entry-localInval")) {
            Object regionEntry;
            Object txEntry;
            this.verifyKeys(txData, key, true);
            this.verifyValues(txData, null, false);
            this.verifyEntries(txData, key, null, true);
            if (op.isPreviouslyInvalid()) {
                if (originalData.entry.getValue() != null) {
                    throw new TestException("validateInTransaction failure: entry (" + key + ") previously invalidated, but originalData.entry.getValue() != null, instead found " + originalData.entry.getValue());
                }
            } else if (aRegion.getEntry(key).getValue() != null) {
                throw new TestException("validateInTransaction failure: expected Region.getEntry(key).getValue() == null (after invalidate), but found " + aRegion.getEntry(key).getValue());
            }
            if ((txEntry = txData.entry.getValue()) != (regionEntry = aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from TxData, txData entry = (key=" + txData.entry.getKey() + ", value = " + txEntry + " vs region.getEntry(key).getValue() = " + regionEntry);
            }
        } else if (opName.equalsIgnoreCase("entry-getWithNewKey")) {
            this.verifyKeys(txData, key, true);
            this.verifyValues(txData, newValue, true);
            this.verifyEntries(txData, key, newValue, true);
            if (!txData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: entry for key " + key + " from txData was not updated with newly loaded value");
            }
        } else if (opName.equalsIgnoreCase("entry-getWithExistingKey")) {
            this.verifyKeys(txData, key, true);
            this.verifyValues(txData, newValue, true);
            this.verifyEntries(txData, key, newValue, true);
            if (op.isPreviouslyInvalid()) {
                if (originalData.entry.getValue() != null) {
                    throw new TestException("validateInTransaction failure: previously invalidated entry, originalData.entry.getValue() should be null, but is " + originalData.entry.getValue());
                }
            } else if (!originalData.entry.getValue().equals(oldValue)) {
                throw new TestException("validateInTransaction failure: after getWithExistingKey, expected originalData.entry.getValue() == oldValue, but found originalData = " + originalData.entry.getValue() + " with oldValue = " + oldValue);
            }
        } else if (opName.equalsIgnoreCase("entry-getWithPreviousKey")) {
            this.verifyKeys(txData, key, true);
            this.verifyValues(txData, newValue, true);
            this.verifyEntries(txData, key, newValue, true);
            if (!txData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from TxData, txData entry = (key=" + txData.entry.getKey() + ", value = " + txData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("region-create")) {
            this.checkRegionData(originalData, txData, op, 0);
        } else if (opName.equalsIgnoreCase("region-destroy")) {
            this.checkRegionData(originalData, txData, op, 1);
        } else if (opName.equalsIgnoreCase("region-localDestroy")) {
            this.checkRegionData(originalData, txData, op, 1);
        } else if (opName.equalsIgnoreCase("region-inval")) {
            this.checkRegionData(originalData, txData, op, 2);
        } else if (opName.equalsIgnoreCase("region-localInval")) {
            this.checkRegionData(originalData, txData, op, 2);
        } else {
            throw new TestException("Unknown operation " + op);
        }
        Log.getLogWriter().info("validateInTx: data and collection behavior validation successful");
    }

    private void validateAfterCommit(Operation op, CollectionInfo originalData, CollectionInfo txData) {
        Log.getLogWriter().info("validateAfterCommit, op = " + op.toString());
        String opName = op.getOpName();
        Object key = op.getKey();
        Object oldValue = op.getOldValue();
        Object newValue = op.getNewValue();
        String regionName = op.getRegionName();
        this.verifyCollectionsNotAccessible(txData, op, true);
        if (!op.isEntryOperation()) {
            this.verifySubregionsSetAccessible(txData);
        }
        Log.getLogWriter().info("validateAfterCommit:  Region collections and iterators obtained within transaction properly threw IllegalStateException when accessed after commit, continuing test");
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
            return;
        }
        if (opName.equalsIgnoreCase("entry-create")) {
            this.verifyKeys(originalData, key, true);
            this.verifyValues(originalData, newValue, true);
            this.verifyEntries(originalData, key, newValue, true);
        } else if (opName.equalsIgnoreCase("entry-update")) {
            this.verifyKeys(originalData, key, true);
            this.verifyValues(originalData, newValue, true);
            this.verifyEntries(originalData, key, newValue, true);
            if (!originalData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from originalData, originalData entry = (key=" + originalData.entry.getKey() + ", value = " + originalData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("entry-destroy") || opName.equalsIgnoreCase("entry-localDestroy")) {
            this.verifyKeys(originalData, key, false);
            this.verifyValues(originalData, oldValue, false);
            this.verifyEntries(originalData, key, oldValue, false);
            if (aRegion.getEntry(key) != null) {
                throw new TestException("validateInTransaction failure: getEntry() should be null (entryDestroyed), but is " + aRegion.getEntry(key));
            }
        } else if (opName.equalsIgnoreCase("entry-inval") || opName.equalsIgnoreCase("entry-localInval")) {
            this.verifyKeys(originalData, key, true);
            this.verifyValues(originalData, newValue, true);
            this.verifyEntries(originalData, key, newValue, true);
            if (originalData.entry.getValue() != null) {
                throw new TestException("validateInTransaction failure: region.getEntry() value matches getEntry object from originalData, but shouldn't: originalData entry = (key=" + originalData.entry.getKey() + ", value = " + originalData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("entry-getWithNewKey")) {
            this.verifyKeys(originalData, key, true);
            this.verifyValues(originalData, newValue, true);
            this.verifyEntries(originalData, key, newValue, true);
        } else if (opName.equalsIgnoreCase("entry-getWithExistingKey")) {
            this.verifyKeys(originalData, key, true);
            this.verifyValues(originalData, newValue, true);
            this.verifyEntries(originalData, key, newValue, true);
            if (!originalData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from originalData, originalData entry = (key=" + originalData.entry.getKey() + ", value = " + originalData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("entry-getWithPreviousKey")) {
            this.verifyKeys(originalData, key, true);
            this.verifyValues(originalData, newValue, true);
            this.verifyEntries(originalData, key, newValue, true);
            if (originalData.entry != null && !originalData.entry.getValue().equals(aRegion.getEntry(key).getValue())) {
                throw new TestException("validateInTransaction failure: region.getEntry() value doesn't match getEntry value from originalData, originalData entry = (key=" + originalData.entry.getKey() + ", value = " + originalData.entry.getValue() + " vs region.getEntry(key).getValue() = " + aRegion.getEntry(key).getValue() + ")");
            }
        } else if (opName.equalsIgnoreCase("region-create")) {
            boolean found = false;
            for (Region oRegion : originalData.subRegions) {
                if (!oRegion.getFullPath().equals(op.getRegionName())) continue;
                found = true;
            }
            if (!found) {
                throw new TestException("validateAfterCommit validation failure: did NOT find regionName " + op.getRegionName() + " as expected after op = " + op.toString());
            }
        } else if (opName.equalsIgnoreCase("region-destroy") || opName.equalsIgnoreCase("region-localDestroy")) {
            for (Region oRegion : originalData.subRegions) {
                if (!oRegion.getFullPath().equals(op.getRegionName())) continue;
                throw new TestException("checkRegionData validationfailure: found regionName " + op.getRegionName() + ": not expected after op = " + op.toString());
            }
        } else if (opName.equalsIgnoreCase("region-inval") || opName.equalsIgnoreCase("region-localInval")) {
            boolean found = false;
            for (Region oRegion : originalData.subRegions) {
                if (!oRegion.getFullPath().equals(op.getRegionName())) continue;
                found = true;
                Collection values = oRegion.values();
                for (Object o : values) {
                    if (o == null) continue;
                    throw new TestException("validateAfterCommit validation failure: found non-null value " + o + " in invalidated region " + oRegion.getFullPath());
                }
            }
            if (!found) {
                throw new TestException("validateAfterCommit validationfailure: did NOT find regionName " + op.getRegionName() + " as expected after op = " + op.toString());
            }
        } else {
            throw new TestException("Unknown operation " + op);
        }
        Log.getLogWriter().info("validateAfterCommit: data and collection behavior validation successful");
    }

    private void checkRegionData(CollectionInfo originalData, CollectionInfo txData, Operation op, int expected) {
        if (!originalData.parentRegionName.equals(txData.parentRegionName)) {
            throw new TestException("checkRegionData validation failure: original & txdata have different parentRegionNames, originalData = " + originalData.parentRegionName + " txData = " + txData.parentRegionName);
        }
        int diff = originalData.subRegions.size() - txData.subRegions.size();
        if (diff != 0) {
            throw new TestException("checkRegionData validation failure: region operations are immediate and affect both committed & transactional state.  Region,subregions() should return the same number of subRegions for both original & txData");
        }
        switch (expected) {
            case 0: 
            case 2: {
                boolean found = false;
                for (Region aRegion : originalData.subRegions) {
                    if (!aRegion.getFullPath().equals(op.getRegionName())) continue;
                    found = true;
                }
                if (!found) {
                    throw new TestException("checkRegionData validationfailure: did NOT find regionName " + op.getRegionName() + " in originalData " + originalData.subRegions.toString() + " as expected after op = " + op.toString());
                }
                found = false;
                for (Region aRegion : txData.subRegions) {
                    if (!aRegion.getFullPath().equals(op.getRegionName())) continue;
                    found = true;
                }
                if (found) break;
                throw new TestException("checkRegionData validationfailure: did NOT find regionName " + op.getRegionName() + " in txData " + txData.subRegions.toString() + " as expected after op = " + op.toString());
            }
            case 1: {
                for (Region aRegion : originalData.subRegions) {
                    if (!aRegion.getFullPath().equals(op.getRegionName())) continue;
                    throw new TestException("checkRegionData validationfailure: found regionName " + op.getRegionName() + ": not expected after op = " + op.toString());
                }
                for (Region aRegion : txData.subRegions) {
                    if (!aRegion.getFullPath().equals(op.getRegionName())) continue;
                    throw new TestException("checkRegionData validationfailure: found regionName " + op.getRegionName() + ": not expected after op = " + op.toString());
                }
                break;
            }
        }
    }

    private void verifyKeys(CollectionInfo data, Object key, boolean expected) {
        boolean found = false;
        Iterator it = data.keys.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(key)) continue;
            found = true;
        }
        if (found != expected) {
            throw new TestException("CollectionValidation failure: verifyKeys: key found = " + found + " expected = " + expected);
        }
    }

    private void verifyValues(CollectionInfo data, Object value, boolean expected) {
        if (expected && (value.toString().equals("INVALID") || value.toString().equals("LOCAL_INVALID"))) {
            return;
        }
        boolean found = false;
        Iterator it = data.values.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(value)) continue;
            found = true;
        }
        if (found != expected) {
            throw new TestException("CollectionValidation failure: verifyValues: value found = " + found + " expected = " + expected);
        }
    }

    private void verifyEntries(CollectionInfo data, Object key, Object value, boolean expected) {
        boolean found = false;
        Region.Entry theEntry = null;
        for (Region.Entry entry : data.entries) {
            Object entryKey = entry.getKey();
            if (!entryKey.equals(key)) continue;
            found = true;
            theEntry = entry;
            break;
        }
        if (found != expected) {
            throw new TestException("CollectionValidation failure: verifyEntries: value found = " + found + " expected = " + expected);
        }
        if (value != null && (value.toString().equals("INVALID") || value.toString().equals("LOCAL_INVALID"))) {
            value = null;
        }
        boolean correctValues = false;
        Object entryValue = null;
        if (found) {
            entryValue = theEntry.getValue();
            if (entryValue == null) {
                if (value == null) {
                    correctValues = true;
                }
            } else if (entryValue.equals(value)) {
                correctValues = true;
            }
            if (!correctValues) {
                throw new TestException("CollectionValidation failure: verifyEntries: value found = " + entryValue + " expected = " + value);
            }
        }
    }

    public Operation executeCreateRegion(Operation op) {
        String regionName = op.getRegionName();
        Object[] tmp = this.createRegionWithPath(regionName);
        return op;
    }

    public Object[] createRegionWithPath(String regionName) {
        boolean regionCreated = false;
        Cache theCache = CacheUtil.getCache();
        StringTokenizer st = new StringTokenizer(regionName, "/", false);
        String currentRegionName = st.nextToken();
        Region aRegion = theCache.getRegion(currentRegionName);
        RegionAttributes attr = aRegion.getAttributes();
        Region previousRegion = aRegion;
        while (st.hasMoreTokens()) {
            currentRegionName = st.nextToken();
            aRegion = theCache.getRegion(previousRegion.getFullPath() + "/" + currentRegionName);
            if (aRegion == null) {
                try {
                    aRegion = previousRegion.createSubregion(currentRegionName, attr);
                    Log.getLogWriter().info("Created region " + aRegion.getFullPath());
                    regionCreated = true;
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (RegionExistsException e) {
                    throw new TestException("Test error; unexpected " + TestHelper.getStackTrace(e));
                }
            }
            previousRegion = aRegion;
        }
        return new Object[]{aRegion, new Boolean(regionCreated)};
    }

    private void verifyCollectionsNotAccessible(CollectionInfo cInfo, Operation op, boolean afterCommit) {
        boolean beforeCommit;
        boolean exceptionThrown = false;
        boolean bl = beforeCommit = !afterCommit;
        if (!op.isEntryOperation()) {
            return;
        }
        this.attemptOperationsOnSet(cInfo.keys, "keySet");
        this.attemptOperationsOnSet(cInfo.entries, "entrySet");
        this.attemptOperationsOnSet(cInfo.values, "values");
    }

    private void verifyIteratorNotAccessible(Iterator iterator, String description) {
        boolean exceptionThrown = false;
        try {
            if (iterator.hasNext()) {
                Object e = iterator.next();
            }
        }
        catch (IllegalStateException e) {
            exceptionThrown = true;
            Log.getLogWriter().fine("verifyIteratorNotAccessible caught expected Exception " + e + " with " + description + ".hasNext(), continuing test");
        }
        if (!exceptionThrown) {
            throw new TestException("invoking " + description + ".hasNext() did not result in expected IllegalStateException being thrown " + TestHelper.getStackTrace());
        }
    }

    private void verifySubregionsSetAccessible(CollectionInfo cInfo) {
        try {
            cInfo.subRegions.size();
            cInfo.subRegions.isEmpty();
            cInfo.subRegions.toArray();
            cInfo.subRegions.iterator();
        }
        catch (Exception e) {
            throw new TestException("access of subregions outside of tx resulted in Exception " + e + " being thrown " + TestHelper.getStackTrace());
        }
        Log.getLogWriter().fine("verifySubregionsSetAccessible successfully executed size(), isEmpty(), toArray() and iterator() on collection");
    }

    private void attemptOperationsOnSet(Collection aSet, String description) {
        String[] methods = new String[]{"size", "iterator", "isEmpty", "toArray"};
        Class[] params = new Class[]{};
        Object[] args = new Object[]{};
        for (int i = 0; i < methods.length; ++i) {
            Method theMethod;
            Class<?> theClass;
            boolean exceptionThrown = false;
            try {
                theClass = Class.forName(aSet.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            try {
                theMethod = theClass.getMethod(methods[i], params);
            }
            catch (NoSuchMethodException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            try {
                theMethod.setAccessible(true);
                Log.getLogWriter().fine("invoking " + theClass.getName() + "." + theMethod.getName() + " on " + description);
                theMethod.invoke((Object)aSet, args);
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalArgumentException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof IllegalStateException) {
                    String errStr = targetException.toString();
                    if (errStr.indexOf("Region collection") >= 0) {
                        Log.getLogWriter().fine("attemptOperationsOnSet caught expected Exception " + targetException + " with " + description + "." + methods[i] + ", continuing test");
                        exceptionThrown = true;
                    }
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (exceptionThrown) continue;
            throw new TestException("invoking " + methods[i] + " did not result in expected IllegalStateException being thrown " + TestHelper.getStackTrace());
        }
    }

    public Object getValueInVM(Region aRegion, Object key) {
        Object value = null;
        Region.Entry entry = aRegion.getEntry(key);
        if (entry != null && (value = entry.getValue()) == null) {
            value = Token.INVALID;
        }
        return value;
    }
}

