/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.Token;
import hydra.Log;
import java.util.HashMap;
import java.util.Map;
import tx.Operation;
import util.BaseValueHolder;
import util.CacheUtil;
import util.TestException;

public class EntryValidator {
    private static Map visible = null;
    private static Map notVisible = null;
    public static final Integer DONT_CARE = new Integer(-1);
    public static final Integer OLDVAL = new Integer(0);
    public static final Integer NEWVAL = new Integer(1);
    private String regionName = null;
    private String key = null;
    private Operation op = null;
    private boolean keyExists;
    private boolean hasValue;
    private Object cacheValue;

    public EntryValidator(Operation op) {
        this.op = op;
    }

    public EntryValidator(boolean keyExists, boolean hasValue, Object cacheValue) {
        this.keyExists = keyExists;
        this.hasValue = hasValue;
        this.cacheValue = cacheValue;
    }

    public EntryValidator(Operation op, String regionName, String key, boolean keyExists, boolean hasValue, Object cacheValue) {
        this.op = op;
        this.regionName = regionName;
        this.key = key;
        this.keyExists = keyExists;
        this.hasValue = hasValue;
        this.cacheValue = cacheValue;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setKeyExists(boolean b) {
        this.keyExists = b;
    }

    public void setHasValue(boolean b) {
        this.hasValue = b;
    }

    public void setCacheValue(Object value) {
        this.cacheValue = value;
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation op) {
        this.op = op;
    }

    public static EntryValidator getExpected(Operation op, boolean isVisible) {
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        String opName = op.getOpName();
        Object oldVal = op.getOldValue();
        Object newVal = op.getNewValue();
        Log.getLogWriter().info("EntryValidator.getExpected(" + op.toString() + " isVisible = " + isVisible + ")");
        Map aMap = isVisible ? visible : notVisible;
        EntryValidator template = (EntryValidator)aMap.get(opName);
        EntryValidator expected = new EntryValidator(op);
        expected.setRegionName(regionName);
        expected.setKey(key);
        expected.keyExists = template.keyExists;
        expected.hasValue = template.hasValue;
        expected.cacheValue = template.cacheValue;
        if (expected.cacheValue != DONT_CARE) {
            if (expected.cacheValue == OLDVAL) {
                expected.setCacheValue(oldVal);
            } else if (expected.cacheValue == NEWVAL) {
                expected.setCacheValue(newVal);
            } else {
                throw new TestException("EntryValidator: invalid value <" + expected.cacheValue + "> given for cacheValue");
            }
        }
        if (expected.cacheValue == null || expected.cacheValue.toString().equals("INVALID") || expected.cacheValue.toString().equals("LOCAL_INVALID")) {
            expected.hasValue = false;
        }
        Log.getLogWriter().info("getExpected returns " + expected.toString());
        return expected;
    }

    public static EntryValidator getActual(Operation op) {
        boolean hasValue;
        boolean keyExists;
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        String opName = op.getOpName();
        Object oldVal = op.getOldValue();
        Object newVal = op.getNewValue();
        Log.getLogWriter().info("EntryValidator.getActual(" + op.toString() + ")");
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        Object actualValue = DONT_CARE;
        if (aRegion != null) {
            keyExists = aRegion.containsKey((Object)key);
            hasValue = aRegion.containsValueForKey((Object)key);
            actualValue = null;
            Region.Entry entry = aRegion.getEntry((Object)key);
            if (entry != null && (actualValue = entry.getValue()) == null) {
                actualValue = Token.INVALID;
            }
            if (actualValue instanceof BaseValueHolder) {
                actualValue = ((BaseValueHolder)actualValue).modVal;
            } else {
                Log.getLogWriter().info("WARNING: actual value retrieved from cache is not a ValueHolder, is " + actualValue);
            }
            if (actualValue != null && (actualValue.toString().equals("INVALID") || actualValue.toString().equals("LOCAL_INVALID"))) {
                hasValue = false;
            }
        } else {
            keyExists = false;
            hasValue = false;
            actualValue = null;
        }
        EntryValidator actualValues = new EntryValidator(op, regionName, key, keyExists, hasValue, actualValue);
        Log.getLogWriter().info("EntryValidator.getActual returning = " + actualValues.toString());
        return actualValues;
    }

    public void compare(EntryValidator vc) {
        if (this.keyExists != vc.keyExists) {
            if (!vc.keyExists && vc.getOperation().getOpName().equalsIgnoreCase("entry-getWithPreviousKey")) {
                return;
            }
            throw new TestException("EntryValidator comparison failure: expected " + this.toString() + " but actualValues = " + vc.toString());
        }
        if (!this.getInvalidatedEntry() && this.hasValue != vc.hasValue) {
            throw new TestException("EntryValidator comparison failure: expected " + this.toString() + " but actualValues = " + vc.toString());
        }
        if (this.cacheValue != DONT_CARE && (this.cacheValue != null ? !this.cacheValue.equals(vc.cacheValue) : vc.cacheValue != null)) {
            throw new TestException("EntryValidator comparison failure: expected " + this.toString() + " but actualValues = " + vc.toString());
        }
    }

    private boolean getInvalidatedEntry() {
        Object oldVal;
        if (this.op.getOpName().toLowerCase().startsWith("entry-get") && (oldVal = this.op.getOldValue()) != null && oldVal.toString().equals("INVALID")) {
            Log.getLogWriter().info("FOUND GET ON INVALIDATED ENTRY");
            return true;
        }
        return false;
    }

    public String toString() {
        String aStr = "op: " + this.op + " regionName: " + this.regionName + " key:" + this.key + ", keyExists: " + this.keyExists + ", hasValue: " + this.hasValue + ", cacheValue: " + this.cacheValue;
        return aStr;
    }

    static {
        visible = new HashMap();
        visible.put("entry-create", new EntryValidator(true, true, NEWVAL));
        visible.put("entry-update", new EntryValidator(true, true, NEWVAL));
        visible.put("entry-destroy", new EntryValidator(false, false, NEWVAL));
        visible.put("entry-localDestroy", new EntryValidator(false, false, NEWVAL));
        visible.put("entry-inval", new EntryValidator(true, false, NEWVAL));
        visible.put("entry-localInval", new EntryValidator(true, false, NEWVAL));
        visible.put("entry-getWithNewKey", new EntryValidator(true, true, NEWVAL));
        visible.put("entry-getWithExistingKey", new EntryValidator(true, true, NEWVAL));
        visible.put("entry-getWithPreviousKey", new EntryValidator(true, true, NEWVAL));
        notVisible = new HashMap();
        notVisible.put("entry-create", new EntryValidator(false, false, OLDVAL));
        notVisible.put("entry-update", new EntryValidator(true, true, OLDVAL));
        notVisible.put("entry-destroy", new EntryValidator(true, true, OLDVAL));
        notVisible.put("entry-localDestroy", new EntryValidator(true, true, OLDVAL));
        notVisible.put("entry-inval", new EntryValidator(true, true, OLDVAL));
        notVisible.put("entry-localInval", new EntryValidator(true, true, OLDVAL));
        notVisible.put("entry-getWithNewKey", new EntryValidator(false, false, OLDVAL));
        notVisible.put("entry-getWithExistingKey", new EntryValidator(true, true, OLDVAL));
        notVisible.put("entry-getWithPreviousKey", new EntryValidator(true, true, OLDVAL));
    }
}

