/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import tx.TxBB;
import util.AbstractWriter;
import util.TestException;
import util.TestHelper;
import util.WriterCountersBB;

public class MixedRegionWriter
extends AbstractWriter
implements CacheWriter,
Declarable {
    public void beforeCreate(EntryEvent event) {
        this.logCall("beforeCreate", (CacheEvent)event);
        if (this.processingTx()) {
            this.incrementBeforeCreateCounters(event, WriterCountersBB.getBB());
        }
        this.checkVM(event);
        this.checkCallback((CacheEvent)event, "Create event originated in pid ");
    }

    public void beforeDestroy(EntryEvent event) {
        this.logCall("beforeDestroy", (CacheEvent)event);
        if (this.processingTx()) {
            this.incrementBeforeDestroyCounters(event, WriterCountersBB.getBB());
        }
        this.checkVM(event);
        this.checkCallback((CacheEvent)event, "Destroy event originated in pid ");
    }

    public void beforeUpdate(EntryEvent event) {
        this.logCall("beforeUpdate", (CacheEvent)event);
        if (this.processingTx()) {
            this.incrementBeforeUpdateCounters(event, WriterCountersBB.getBB());
        }
        this.checkVM(event);
        this.checkCallback((CacheEvent)event, "Update event originated in pid ");
    }

    public void beforeRegionDestroy(RegionEvent event) {
        this.logCall("beforeRegionDestroy", (CacheEvent)event);
        this.checkCallback((CacheEvent)event, "Region destroy event originated in pid ");
        this.checkVM();
        if (!event.getOperation().equals("cache-close")) {
            Region region = event.getRegion();
            try {
                region.size();
            }
            catch (Exception e) {
                this.throwException("MixedRegionWriter: beforeRegionDestroy() caught " + e + " during beforeRegionDestroy");
            }
        }
    }

    public void beforeRegionClear(RegionEvent event) {
        this.logCall("beforeRegionClear", (CacheEvent)event);
        Region region = event.getRegion();
        try {
            region.size();
        }
        catch (Exception e) {
            this.throwException("MixedRegionWriter: beforeRegionClear() caught " + e + " during beforeRegionClear");
        }
    }

    public void close() {
        this.logCall("close", null);
    }

    protected void checkVM(EntryEvent event) {
        Region region = event.getRegion();
        if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            DistributedMember eventDM;
            Object key = event.getKey();
            DistributedMember thisDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (!thisDM.equals(eventDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, (Object)key))) {
                this.throwException("TxWriter invoked in " + thisDM + " which is not the primary for entry " + region + " " + key + ".  " + eventDM + " is the primary for this entry");
            }
            return;
        }
        this.checkVM();
    }

    protected void checkVM() {
        int myPID = ProcessMgr.getProcessId();
        if (this.whereIWasRegistered != myPID) {
            String errStr = "Expected cacheWriter to be invoked in VM " + this.whereIWasRegistered + ", but it was invoked in " + myPID + ": " + this.toString() + "; see system.log for call stack";
            SharedMap aMap = TxBB.getBB().getSharedMap();
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
    }

    protected void checkCallback(CacheEvent event, String expectedCallbackPrefix) {
        if (event.getOperation().isLoad()) {
            return;
        }
        String callbackObj = (String)event.getCallbackArgument();
        if (callbackObj != null && !callbackObj.startsWith(expectedCallbackPrefix)) {
            String errStr = "Expected " + expectedCallbackPrefix + ", but callback object is " + TestHelper.toString(callbackObj);
            SharedMap aMap = TxBB.getBB().getSharedMap();
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
    }

    private boolean processingTx() {
        boolean rc = true;
        if (TxBB.getBB().getSharedCounters().read(TxBB.PROCESS_EVENTS) == 0L) {
            rc = false;
        }
        return rc;
    }

    protected void throwException(String errStr) {
        SharedMap aMap = TxBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

