/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.GsRandom;
import hydra.RegionHelper;
import hydra.TestConfig;
import tx.TxBB;
import tx.TxPrms;
import tx.TxUtil;
import tx.TxUtilKeyRange;
import util.BaseValueHolder;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.TxHelper;

public class NoConflictTest {
    public static NoConflictTest testInstance = null;
    static final String REGION_NAME = "NoConflictRegion";

    public static synchronized void HydraTask_initializeConcTest() {
        if (testInstance == null) {
            testInstance = new NoConflictTest();
            testInstance.initialize();
            TxUtil.txUtilInstance = new TxUtilKeyRange();
        }
        testInstance.initEachThread();
    }

    protected void initialize() {
        Cache aCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        CacheUtil.setCache(aCache);
        Region aRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
    }

    protected void initEachThread() {
        TxUtil.txUtilInstance.initialize();
        Region aRegion = CacheUtil.getCache().getRegion(REGION_NAME);
        int lowerKeyIndex = (Integer)((TxUtilKeyRange)TxUtil.txUtilInstance).lowerKeyRange.get();
        int upperKeyIndex = (Integer)((TxUtilKeyRange)TxUtil.txUtilInstance).upperKeyRange.get();
        for (int i = lowerKeyIndex; i <= upperKeyIndex; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, i);
            BaseValueHolder value = (BaseValueHolder)TxUtil.txUtilInstance.getNewValue(key);
            TxUtil.txUtilInstance.putEntry(aRegion, key, value, "entry-create");
        }
    }

    public static void HydraTask_concNoConflictTest() {
        testInstance.concNoConflictTest();
    }

    public void concNoConflictTest() {
        GsRandom rand = TestConfig.tab().getRandGen();
        int tasksInTxPercentage = TxPrms.getTasksInTxPercentage();
        if (rand.nextInt(1, 100) <= tasksInTxPercentage) {
            TxHelper.begin();
        } else {
            TxBB.inc(TxBB.NOT_IN_TRANS);
        }
        TxUtil.doOperations();
        if (TxHelper.exists()) {
            int commitPercentage = TxPrms.getCommitPercentage();
            if (rand.nextInt(1, 100) <= commitPercentage) {
                TxHelper.commitExpectSuccess();
                TxBB.inc(TxBB.TX_SUCCESS);
            } else {
                TxHelper.rollback();
                TxBB.inc(TxBB.TX_ROLLBACK);
            }
        }
    }
}

