/*
 * Decompiled with CFR 0.152.
 */
package tx;

import hydra.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tx.Operation;
import tx.TxBB;
import tx.TxUtil;

public class OpList
implements Serializable {
    private List opList = new ArrayList();

    public Object set(int index, Operation op) {
        Object returnObj = this.opList.get(index);
        this.opList.set(index, op);
        return returnObj;
    }

    public void addAll(OpList toBeAdded) {
        if (toBeAdded == null) {
            return;
        }
        for (int i = 0; i < toBeAdded.numOps(); ++i) {
            this.add(toBeAdded.getOperation(i));
        }
    }

    public void add(Operation anOp) {
        if (!this.opList.contains(anOp)) {
            this.opList.add(anOp);
        }
    }

    public void addAll(OpList toBeAdded, boolean allowDuplicates) {
        if (toBeAdded == null) {
            return;
        }
        for (int i = 0; i < toBeAdded.numOps(); ++i) {
            if (allowDuplicates) {
                this.opList.add(toBeAdded.getOperation(i));
                continue;
            }
            this.add(toBeAdded.getOperation(i));
        }
    }

    public void remove(int index) {
        this.opList.remove(index);
    }

    public boolean contains(Operation anOp) {
        return this.opList.contains(anOp);
    }

    public int numOps() {
        return this.opList.size();
    }

    public Operation getOperation(int i) {
        return (Operation)this.opList.get(i);
    }

    public OpList getOps(String opName) {
        OpList resultList = new OpList();
        for (int i = 0; i < this.opList.size(); ++i) {
            Operation op = (Operation)this.opList.get(i);
            if (!op.getOpName().equals(opName)) continue;
            resultList.add(op);
        }
        return resultList;
    }

    public OpList getOpsForRegion(String regionName) {
        OpList resultList = new OpList();
        for (int i = 0; i < this.opList.size(); ++i) {
            Operation op = (Operation)this.opList.get(i);
            if (!op.getRegionName().equals(regionName)) continue;
            resultList.add(op);
        }
        return resultList;
    }

    public OpList getOpsForKey(String key) {
        OpList resultList = new OpList();
        for (int i = 0; i < this.opList.size(); ++i) {
            Operation op = (Operation)this.opList.get(i);
            if (!op.getKey().equals(key)) continue;
            resultList.add(op);
        }
        return resultList;
    }

    public OpList getOpsForRegionAndKey(String regionName, Object key) {
        OpList resultList = new OpList();
        for (int i = 0; i < this.opList.size(); ++i) {
            boolean keyMatches;
            boolean regionMatches;
            Operation op = (Operation)this.opList.get(i);
            boolean bl = regionName == null ? op.getRegionName() == null : (regionMatches = regionName.equals(op.getRegionName()));
            boolean bl2 = key == null ? op.getKey() == null : (keyMatches = key.equals(op.getKey()));
            if (!regionMatches || !keyMatches) continue;
            resultList.add(op);
        }
        return resultList;
    }

    public OpList getOpsAffectedBy(Operation operation) {
        OpList resultList = new OpList();
        for (int i = 0; i < this.opList.size(); ++i) {
            Operation op = (Operation)this.opList.get(i);
            if (!op.affectedBy(operation)) continue;
            resultList.add(op);
        }
        return resultList;
    }

    public boolean containsOpName(String opName) {
        for (int i = 0; i < this.opList.size(); ++i) {
            Operation op = (Operation)this.opList.get(i);
            if (!op.getOpName().equals(opName)) continue;
            return true;
        }
        return false;
    }

    public OpList collapse() {
        return this.collapse(TxBB.TXACTION_NONE);
    }

    public OpList collapse(String txAction) {
        OpList entryOps = this.getEntryOps();
        OpList regionOps = this.getRegionOps();
        entryOps = this.getEntriesWithUniqueKeys(entryOps, txAction);
        entryOps = this.getEntriesNotAffectedByRegionDestroy(regionOps, entryOps);
        entryOps = this.getEntriesNotAffectedByRegionInvalidates(regionOps, entryOps);
        regionOps = this.getValidRegionOps(regionOps);
        regionOps = this.getVerifiableRegionOps(regionOps, this.getEntryOps());
        OpList collapsedOps = new OpList();
        collapsedOps.addAll(entryOps);
        collapsedOps.addAll(regionOps);
        Log.getLogWriter().info("COLLAPSED OPS: " + collapsedOps.toString());
        return collapsedOps;
    }

    public OpList collapseForEvents(String txAction) {
        OpList entryOps = this.getEntryOps();
        OpList regionOps = this.getRegionOps();
        entryOps = this.getEntriesWithUniqueKeys(entryOps, txAction);
        if (!TxUtil.inTxVm()) {
            entryOps = this.getEntriesNotAffectedByRegionDestroy(regionOps, entryOps);
        }
        OpList collapsedOps = new OpList();
        collapsedOps.addAll(entryOps);
        Log.getLogWriter().info("COLLAPSED EVENT OPS: " + collapsedOps.toString());
        return collapsedOps;
    }

    public OpList getEntryOps() {
        OpList entryOps = new OpList();
        for (int i = 0; i < this.numOps(); ++i) {
            Operation op = this.getOperation(i);
            if (!op.isEntryOperation()) continue;
            entryOps.add(op);
        }
        Log.getLogWriter().fine("COLLAPSE: entryOps = " + entryOps.toString());
        return entryOps;
    }

    private OpList getRegionOps() {
        OpList regionOps = new OpList();
        for (int i = 0; i < this.numOps(); ++i) {
            Operation op = this.getOperation(i);
            if (!op.isRegionOperation()) continue;
            regionOps.add(op);
        }
        Log.getLogWriter().fine("COLLAPSE: regionOps = " + regionOps.toString());
        return regionOps;
    }

    private boolean updatedInvalidatedEntry(Operation firstOp, Operation secondOp) {
        boolean rc = false;
        if (firstOp.isEntryInvalidate() && (secondOp.isEntryGet() || secondOp.isEntryUpdate())) {
            rc = true;
        }
        return rc;
    }

    private boolean invalidatedExistingEntry(Operation firstOp, Operation secondOp) {
        boolean rc = false;
        if (secondOp.isEntryInvalidate() && firstOp.getOldValue() != null) {
            rc = true;
        }
        return rc;
    }

    public OpList handleDoubleInvalidates(OpList entryOps) {
        OpList newList = new OpList();
        for (int i = 0; i < entryOps.numOps(); ++i) {
            Operation op = entryOps.getOperation(i);
            boolean intermediateOp = false;
            for (int j = i + 1; j < entryOps.numOps(); ++j) {
                Operation tmpOp = entryOps.getOperation(j);
                if (!op.entryOpAffectedBy(tmpOp) || !op.isEntryInvalidate()) continue;
                if (tmpOp.isEntryInvalidate()) {
                    if (intermediateOp) continue;
                    entryOps.remove(j);
                    --j;
                    continue;
                }
                intermediateOp = true;
            }
            newList.add(op);
        }
        Log.getLogWriter().fine("handleDoubleInvalidates = " + newList.toString());
        return newList;
    }

    public OpList removeNoOpGets(OpList entryOps) {
        OpList newList = new OpList();
        for (int i = 0; i < entryOps.numOps(); ++i) {
            Operation op = entryOps.getOperation(i);
            if (op.isGetOperation()) {
                Object oldVal = op.getOldValue();
                Object newVal = op.getNewValue();
                if (oldVal != null && newVal != null && oldVal.equals(newVal)) continue;
            }
            newList.add(op);
        }
        Log.getLogWriter().fine("removeNoOpGets = " + newList.toString());
        return newList;
    }

    public OpList getEntriesWithUniqueKeys(OpList entryOps) {
        return this.getEntriesWithUniqueKeys(entryOps, TxBB.TXACTION_NONE);
    }

    public OpList getEntriesWithUniqueKeys(OpList entryOps, String txAction) {
        entryOps = this.removeNoOpGets(entryOps);
        entryOps = this.handleDoubleInvalidates(entryOps);
        boolean isTxVmProxy = false;
        String txClientName = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_VM_CLIENTNAME);
        if (txClientName != null) {
            String mapKey = TxBB.DataPolicyPrefix + txClientName;
            String dataPolicy = (String)TxBB.getBB().getSharedMap().get(mapKey);
            if (dataPolicy != null && dataPolicy.equals("empty")) {
                isTxVmProxy = true;
            }
        }
        Log.getLogWriter().info("getEntriesWithUniqueKeys: txAction = " + txAction + " isTxVmProxy = " + isTxVmProxy);
        OpList newList = new OpList();
        for (int i = 0; i < entryOps.numOps(); ++i) {
            Operation op = entryOps.getOperation(i);
            for (int j = i + 1; j < entryOps.numOps(); ++j) {
                Operation tmpOp = entryOps.getOperation(j);
                if (!op.entryOpAffectedBy(tmpOp)) continue;
                boolean keepOp = false;
                boolean keepTmpOp = true;
                if ((op.isEntryCreate() || op.isEntryGet() && op.getOldValue() == null) && tmpOp.isEntryDestroy() && (!TxUtil.inTxVm() || !isTxVmProxy)) {
                    keepTmpOp = false;
                }
                if (!keepTmpOp) {
                    entryOps.remove(j);
                    --j;
                }
                if (keepOp) continue;
                if (keepTmpOp) {
                    if (!(tmpOp.isEntryDestroy() || this.updatedInvalidatedEntry(op, tmpOp) || this.invalidatedExistingEntry(op, tmpOp) || op.isEntryDestroy())) {
                        tmpOp.setOpName(op.getOpName());
                    }
                    tmpOp.setOldValue(op.getOldValue());
                    entryOps.set(j, tmpOp);
                }
                op = null;
                break;
            }
            if (op == null) continue;
            newList.add(op);
        }
        Log.getLogWriter().fine("ENTRY OPS WITH UNIQUE KEYS = " + newList.toString());
        return newList;
    }

    private OpList getVerifiableRegionOps(OpList regionOps, OpList entryOps) {
        OpList newList = new OpList();
        for (int i = 0; i < regionOps.numOps(); ++i) {
            Operation regionOp = regionOps.getOperation(i);
            if (regionOp.isRegionDestroy()) {
                newList.add(regionOp);
                continue;
            }
            boolean verifiable = true;
            for (int j = 0; j < entryOps.numOps(); ++j) {
                Operation entryOp = entryOps.getOperation(j);
                Log.getLogWriter().fine("(ValidRegionOps) RegionOp = " + regionOp.toString() + " Looking at entryOp = " + entryOp.toString());
                if (!entryOp.getRegionName().startsWith(regionOp.getRegionName())) continue;
                Log.getLogWriter().fine("(ValidRegionOps) entryOp affected by RegionOp (based on regionName)");
                if (regionOp.isRegionInvalidate() && entryOp.isEntryInvalidate()) {
                    Log.getLogWriter().fine("(ValidRegionOps) verifiable = true");
                    verifiable = true;
                    continue;
                }
                Log.getLogWriter().fine("(ValidRegionOps) verifiable = false");
                verifiable = false;
                break;
            }
            if (!verifiable) continue;
            Log.getLogWriter().fine("(VaildRegionOps) adding regionOp " + regionOp.toString() + " to list of verifiable region operations");
            newList.add(regionOp);
        }
        Log.getLogWriter().fine("VERIFIABLE REGION OPS " + newList.toString());
        return newList;
    }

    private OpList getEntriesNotAffectedByRegionDestroy(OpList regionOps, OpList entryOps) {
        for (int i = 0; i < regionOps.numOps(); ++i) {
            Operation regionOp = regionOps.getOperation(i);
            if (!regionOp.isRegionDestroy()) {
                Log.getLogWriter().finer("(AffectedByRegionDestroy) Ignoring RegionOp = " + regionOp.toString());
                continue;
            }
            Log.getLogWriter().finer("(AffectedByRegionDestroy) RegionDestroyOp = " + regionOp.toString());
            for (int j = 0; j < entryOps.numOps(); ++j) {
                Operation entryOp = entryOps.getOperation(j);
                Log.getLogWriter().finer("(AffectedByRegionDestroy) Looking at entryOp = " + entryOp.toString());
                if (!entryOp.getRegionName().startsWith(regionOp.getRegionName())) continue;
                Log.getLogWriter().finer("(AffectedByRegionDestroy) Removing entryOp = " + entryOp.toString());
                entryOps.remove(j);
                --j;
            }
        }
        Log.getLogWriter().fine("ENTRY OPS NOT AFFECTED BY REGION DESTROY " + entryOps.toString());
        return entryOps;
    }

    private OpList getEntriesNotAffectedByRegionInvalidates(OpList regionOps, OpList entryOps) {
        for (int i = 0; i < regionOps.numOps(); ++i) {
            Operation regionOp = regionOps.getOperation(i);
            if (!regionOp.isRegionInvalidate()) {
                Log.getLogWriter().finer("(AffectedByRegionInval) Ignoring regionOp = " + regionOp.toString());
                continue;
            }
            Log.getLogWriter().finer("(AffectedByRegionInval) RegionOp = " + regionOp.toString());
            for (int j = 0; j < entryOps.numOps(); ++j) {
                Operation entryOp = entryOps.getOperation(j);
                Log.getLogWriter().finer("(AffectedByRegionInval) Looking at entryOp = " + entryOp.toString());
                if (!entryOp.getRegionName().startsWith(regionOp.getRegionName())) continue;
                Log.getLogWriter().finer("(AffectedByRegionInval) Removing entryOp = " + entryOp.toString());
                entryOps.remove(j);
                --j;
            }
        }
        Log.getLogWriter().fine("ENTRY OPS NOT AFFECTED BY REGION INVALIDATE " + entryOps.toString());
        return entryOps;
    }

    private OpList getValidRegionOps(OpList regionOps) {
        OpList newList = new OpList();
        for (int i = 0; i < regionOps.numOps(); ++i) {
            Operation op = regionOps.getOperation(i);
            for (int j = 0; j < regionOps.numOps(); ++j) {
                if (i == j) continue;
                Operation tmpOp = regionOps.getOperation(j);
                if (!op.getRegionName().startsWith(tmpOp.getRegionName())) continue;
                op = null;
                break;
            }
            if (op == null) continue;
            newList.add(op);
        }
        return newList;
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        if (this.opList.size() == 0) {
            aStr.append("OpList is empty");
        } else {
            aStr.append("OpList containing " + this.opList.size() + " operations:");
        }
        for (int i = 0; i < this.opList.size(); ++i) {
            aStr.append("\n" + this.opList.get(i).toString());
        }
        return aStr.toString();
    }
}

