/*
 * Decompiled with CFR 0.152.
 */
package tx;

import hydra.Log;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import util.TestException;

public class Operation
implements Serializable {
    public static final String ENTRY_CREATE = "entry-create";
    public static final String ENTRY_UPDATE = "entry-update";
    public static final String ENTRY_PUTALL = "putAll";
    public static final String ENTRY_DESTROY = "entry-destroy";
    public static final String ENTRY_LOCAL_DESTROY = "entry-localDestroy";
    public static final String ENTRY_INVAL = "entry-inval";
    public static final String ENTRY_LOCAL_INVAL = "entry-localInval";
    public static final String ENTRY_GET_NEW_KEY = "entry-getWithNewKey";
    public static final String ENTRY_GET_EXIST_KEY = "entry-getWithExistingKey";
    public static final String ENTRY_GET_PREV_KEY = "entry-getWithPreviousKey";
    public static final String ENTRY_GET_ENTRY_EXIST_KEY = "entry-getEntryWithExistingKey";
    public static final String ENTRY_GETALL = "getAll";
    public static final String ENTRY_CONTAINS_KEY = "entry-containsKey";
    public static final String ENTRY_CONTAINS_VALUE_FOR_KEY = "entry-containsValueForKey";
    public static final String ENTRY_CONTAINS_VALUE = "entry-containsValue";
    public static final String ENTRY_REMOVE = "entry-remove";
    public static final String REGION_CREATE = "region-create";
    public static final String REGION_DESTROY = "region-destroy";
    public static final String REGION_LOCAL_DESTROY = "region-localDestroy";
    public static final String REGION_INVAL = "region-inval";
    public static final String REGION_LOCAL_INVAL = "region-localInval";
    public static final String REGION_KEYS = "region-keys";
    public static final String REGION_KEY_SET = "region-keySet";
    public static final String REGION_VALUES = "region-values";
    public static final String REGION_ENTRIES = "region-entries";
    public static final String REGION_ENTRY_SET = "region-entrySet";
    public static final String CACHE_CLOSE = "cache-close";
    public static List repeatableReadOps = Arrays.asList("entry-getWithExistingKey", "entry-getEntryWithExistingKey", "entry-containsKey", "entry-containsValueForKey", "entry-containsValue", "entry-create", "entry-inval", "entry-destroy", "entry-remove", "region-keys", "region-keySet", "region-values", "region-entries", "region-entrySet");
    public static List nonrepeatableReadOps = Arrays.asList("region-keys", "region-keySet", "region-values", "region-entries", "region-entrySet");
    public static List clientRepeatableReadOps = Arrays.asList("entry-getWithExistingKey", "entry-getEntryWithExistingKey", "entry-containsKey", "entry-containsValueForKey", "entry-containsValue", "entry-create", "entry-inval", "entry-destroy", "entry-remove", "region-keys", "region-keySet", "region-values", "region-entries", "region-entrySet");
    private List opList = Arrays.asList("entry-create", "entry-update", "entry-destroy", "entry-inval", "entry-getWithNewKey", "entry-getWithExistingKey", "entry-getWithPreviousKey", "entry-getEntryWithExistingKey", "entry-containsKey", "entry-containsValueForKey", "entry-containsValue", "entry-remove", "putAll", "region-create", "region-destroy", "region-localDestroy", "region-inval", "region-localInval", "region-keys", "region-keySet", "region-values", "region-entries", "region-entrySet", "cache-close");
    private String regionName = null;
    private Object key = null;
    private String opName = null;
    private Object oldValue = null;
    private Object newValue = null;
    private boolean repeatableRead = false;

    public Operation(String regionName, Object key, String opName, Object oldValue, Object newValue) {
        if (!this.opList.contains(opName)) {
            throw new TestException("Unknown opName " + opName);
        }
        this.regionName = regionName;
        this.key = key;
        this.opName = opName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Object getKey() {
        return this.key;
    }

    public String getOpName() {
        return this.opName;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public void setRepeatableRead(boolean abool) {
        this.repeatableRead = abool;
    }

    public boolean usesSameRegionAndKey(Operation anOp) {
        if (this.key == null && this.regionName == null) {
            return anOp.getRegionName() == null && anOp.getKey() == null;
        }
        if (this.key == null) {
            return this.regionName.equals(anOp.getRegionName()) && anOp.getKey() == null;
        }
        if (this.regionName == null) {
            return anOp.getRegionName() == null && this.key.equals(anOp.getKey());
        }
        return this.regionName.equals(anOp.getRegionName()) && this.key.equals(anOp.getKey());
    }

    public boolean usesSameRegion(Operation anOp) {
        if (this.regionName == null) {
            return anOp.getRegionName() == null;
        }
        return this.regionName.equals(anOp.getRegionName());
    }

    public boolean isRepeatableRead() {
        return this.repeatableRead;
    }

    public boolean isRegionSetOperation() {
        return this.opName.equals(REGION_KEYS) || this.opName.equals(REGION_KEY_SET) || this.opName.equals(REGION_VALUES) || this.opName.equals(REGION_ENTRIES) || this.opName.equals(REGION_ENTRY_SET);
    }

    public boolean isWriteOperation() {
        return this.isInvalidate() || this.isEntryDestroy() || this.isEntryUpdate() || this.isEntryCreate() || this.isGetWithLoad();
    }

    public boolean isGetOperation() {
        return this.opName.toLowerCase().indexOf("-get") > 0;
    }

    public boolean isGetWithLoad() {
        boolean loaderInvoked = false;
        if (this.isGetOperation()) {
            loaderInvoked = (this.getOldValue() == null || this.isPreviouslyInvalid()) && this.getNewValue() != null;
        }
        return loaderInvoked;
    }

    public boolean isRegionOperation() {
        return this.opName.toLowerCase().startsWith("region");
    }

    public boolean isEntryOperation() {
        return this.opName.toLowerCase().startsWith("entry");
    }

    public boolean isInvalidate() {
        return this.opName.toLowerCase().indexOf("inval") > 0;
    }

    public boolean isPreviouslyInvalid() {
        if (this.oldValue == null) {
            return false;
        }
        String oldValueStr = this.oldValue.toString();
        return oldValueStr.equals("LOCAL_INVALID") || oldValueStr.equals("INVALID");
    }

    public boolean isLocalOperation() {
        return this.opName.toLowerCase().indexOf("local") > 0;
    }

    public boolean isRegionCreate() {
        return this.isRegionOperation() && this.opName.toLowerCase().indexOf("create") > 0;
    }

    public boolean isRegionDestroy() {
        return this.isRegionOperation() && this.opName.toLowerCase().indexOf("destroy") > 0;
    }

    public boolean isRegionInvalidate() {
        return this.isRegionOperation() && this.opName.toLowerCase().indexOf("inval") > 0;
    }

    public boolean isEntryUpdate() {
        return this.isEntryOperation() && this.opName.toLowerCase().indexOf("update") > 0;
    }

    public boolean isEntryInvalidate() {
        return this.isEntryOperation() && this.opName.toLowerCase().indexOf("inval") > 0;
    }

    public boolean isEntryCreate() {
        return this.isEntryOperation() && this.opName.toLowerCase().indexOf("create") > 0;
    }

    public boolean isEntryDestroy() {
        return this.isEntryOperation() && this.opName.toLowerCase().indexOf("destroy") > 0;
    }

    public boolean isDoubleInvalidate() {
        if (this.isInvalidate()) {
            if (this.oldValue == null) {
                return false;
            }
            String oldValueStr = this.oldValue.toString();
            if (oldValueStr.equals("LOCAL_INVALID") || oldValueStr.equals("INVALID")) {
                return true;
            }
        }
        return false;
    }

    public boolean isEntryGet() {
        return this.isEntryOperation() && this.opName.toLowerCase().indexOf("get") > 0;
    }

    public boolean equalsEventOp(Object anObj) {
        if (anObj instanceof Operation) {
            Operation op = (Operation)anObj;
            boolean result = (this.regionName == null ? op.getRegionName() == null : this.regionName.equals(op.getRegionName())) && (this.key == null ? op.getKey() == null : this.key.equals(op.getKey())) && (this.opName == null ? op.getOpName() == null : this.opName.equals(op.getOpName())) && (this.oldValue == null || this.oldValue.toString().equals("INVALID") ? op.getOldValue() == null : this.oldValue.equals(op.getOldValue())) && (this.newValue == null || this.newValue.toString().equals("INVALID") ? op.getNewValue() == null : this.newValue.equals(op.getNewValue()));
            return result;
        }
        return false;
    }

    public boolean equals(Object anObj) {
        if (anObj instanceof Operation) {
            Operation op = (Operation)anObj;
            boolean result = (this.regionName == null ? op.getRegionName() == null : this.regionName.equals(op.getRegionName())) && (this.key == null ? op.getKey() == null : this.key.equals(op.getKey())) && (this.opName == null ? op.getOpName() == null : this.opName.equals(op.getOpName())) && (this.oldValue == null ? op.getOldValue() == null : this.oldValue.equals(op.getOldValue())) && (this.newValue == null ? op.getNewValue() == null : this.newValue.equals(op.getNewValue()));
            return result;
        }
        return false;
    }

    public String toString() {
        String aStr = "Operation " + this.opName + " on " + this.regionName;
        if (this.key != null) {
            aStr = aStr + ":" + this.key;
        }
        aStr = aStr + ", old value = " + this.oldValue + ", new value = " + this.newValue;
        aStr = aStr + " repeatableRead: " + this.repeatableRead;
        return aStr;
    }

    public boolean entryOpAffectedBy(Operation op) {
        if (this.isEntryOperation() && op.isEntryOperation() && this.regionName.equals(op.getRegionName()) && this.key.equals(op.getKey())) {
            Log.getLogWriter().fine("Operation.affectedBy(): entryOperations on same key " + this.toString() + " " + op.toString());
            return true;
        }
        return false;
    }

    public boolean affectedBy(Operation op) {
        if (this.isEntryOperation() && op.isEntryOperation() && this.regionName.equals(op.getRegionName()) && this.key.equals(op.getKey())) {
            Log.getLogWriter().fine("Operation.affectedBy(): entryOperations on same key " + this.toString() + " " + op.toString());
            return true;
        }
        if (op.isRegionOperation() && this.regionName.startsWith(op.getRegionName())) {
            Log.getLogWriter().fine("Operation.affectedBy(): entry or region Operation affected by regionOperation " + this.toString() + " " + op.toString());
            return true;
        }
        if (this.isRegionOperation() && op.isEntryOperation() && op.getRegionName().startsWith(this.regionName)) {
            Log.getLogWriter().fine("Operation.affectedBy: regionOperation affected by entryOperation" + this.toString() + " " + op.toString());
            return true;
        }
        return false;
    }
}

