/*
 * Decompiled with CFR 0.152.
 */
package tx;

import hydra.Log;
import hydra.ProcessMgr;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import tx.OpList;
import tx.TxPrms;
import util.TestException;

public class TxBB
extends Blackboard {
    static String BB_NAME = "Tx_Blackboard";
    static String BB_TYPE = "RMI";
    private static TxBB bbInstance = null;
    public static int RoundRobinNumber;
    public static int ExecutionNumber;
    public static int TX_NUMBER;
    public static int PROCESS_EVENTS;
    public static int TX_IN_PROGRESS;
    public static int TX_READY_FOR_VALIDATION;
    public static int TX_COMPLETED;
    public static int TX_SUCCESS;
    public static int TX_FAILURE;
    public static int TX_ROLLBACK;
    public static int NOT_IN_TRANS;
    public static int NUM_EXPECTED_FAILED_COMMIT;
    public static int NUM_EXPECTED_ROLLBACK;
    public static int UniqueKeyCounter;
    public static int nextRepeatableRead;
    public static String TxWriterAction;
    public static String COMPLETION_ACTION;
    public static String TXACTION_COMMIT;
    public static String TXACTION_ROLLBACK;
    public static String TXACTION_ABORT;
    public static String TXACTION_NONE;
    public static String RoundRobinStartThread;
    public static String OpListKey;
    public static String OpListKey2;
    public static String CommitStatusKey;
    public static String DestroyedRegionsKey;
    public static String FirstInRoundCommitStatus;
    public static String SecondInRoundCommitStatus;
    public static String TX_OPLIST_KEY;
    public static String TX_VM_PID;
    public static String TX_VM_CLIENTNAME;
    public static String NON_TX_OPLIST;
    public static String LocalListenerOpListPrefix;
    public static String RemoteListenerOpListPrefix;
    public static String UpdateStrategy;
    public static String CommitStateTrigger;
    public static String RegConfigForPIDBaseKey;
    public static String RegConfigForPIDKey;
    public static String RepeatableRead;
    public static String DataPolicyPrefix;
    public static final String keySet = "keySet_";
    public static final String delegate = "DelegateVmInfo";
    public static final String nonDelegateServer = "NonDelegateServerVmInfo";
    public static final String timeToStop = "timeToStop";
    public static final String afterCommitProcessed = "afterCommitProcessed";
    public static final String VMOTION_TRIGGERED = "vMotionTriggerred";
    public static final String VMOTION_TRIGGERED_TIME = "vMotionTriggerredTime";
    public static int LOCAL_CREATE;
    public static int LOCAL_CREATE_ISLOAD;
    public static int LOCAL_UPDATE;
    public static int LOCAL_UPDATE_ISLOAD;
    public static int LOCAL_DESTROY;
    public static int LOCAL_INVALIDATE;
    public static int LOCAL_LOCAL_DESTROY;
    public static int LOCAL_LOCAL_INVALIDATE;
    public static int REMOTE_CREATE;
    public static int REMOTE_CREATE_ISLOAD;
    public static int REMOTE_UPDATE;
    public static int REMOTE_UPDATE_ISLOAD;
    public static int REMOTE_DESTROY;
    public static int REMOTE_INVALIDATE;
    public static int REMOTE_LOCAL_DESTROY;
    public static int REMOTE_LOCAL_INVALIDATE;
    public static int CONFLATED_CREATE_DESTROY;
    public static int CREATE_IN_DESTROYED_REGION;
    public static int CREATE_IN_DESTROYED_REGION_ISLOAD;

    public static String getUpdateStrategy() {
        String strategy = (String)TxBB.getBB().getSharedMap().get(UpdateStrategy);
        if (strategy == null) {
            strategy = TxPrms.getUpdateStrategy();
            TxBB.getBB().getSharedMap().put(UpdateStrategy, strategy);
            Log.getLogWriter().info("Update strategy is " + strategy);
        }
        return strategy;
    }

    public static void putOpList(OpList opList) {
        String key = OpListKey + Thread.currentThread().getName();
        TxBB.getBB().getSharedMap().put(key, opList);
        Log.getLogWriter().info("TxBB put into shared map key " + key + ", value " + opList);
    }

    public static OpList getOpList() {
        String key = OpListKey + Thread.currentThread().getName();
        OpList opList = (OpList)TxBB.getBB().getSharedMap().get(key);
        Log.getLogWriter().info("TxBB read from shared map key " + key + ", value " + opList);
        return opList;
    }

    public static String getOpListKey() {
        return OpListKey + Thread.currentThread().getName();
    }

    public static void recordCommitStatus(boolean expectCommitStatus) {
        String key = CommitStatusKey + Thread.currentThread().getName();
        TxBB.getBB().getSharedMap().put(key, new Boolean(expectCommitStatus));
        Log.getLogWriter().info("Written to TxBB: " + key + ", " + expectCommitStatus);
    }

    public static boolean getCommitStatus() {
        String key = CommitStatusKey + Thread.currentThread().getName();
        Object result = TxBB.getBB().getSharedMap().get(key);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new TestException("Unknown value " + result + " for TxBB sharedMap key " + key);
    }

    public static void inc(int whichCounter) {
        TxBB.getBB().getSharedCounters().increment(whichCounter);
    }

    public void zeroEventCounters() {
        SharedCounters sc = this.getSharedCounters();
        sc.zero(LOCAL_CREATE);
        sc.zero(LOCAL_CREATE_ISLOAD);
        sc.zero(LOCAL_UPDATE);
        sc.zero(LOCAL_UPDATE_ISLOAD);
        sc.zero(LOCAL_DESTROY);
        sc.zero(LOCAL_INVALIDATE);
        sc.zero(LOCAL_LOCAL_DESTROY);
        sc.zero(LOCAL_LOCAL_INVALIDATE);
        sc.zero(CONFLATED_CREATE_DESTROY);
        sc.zero(CREATE_IN_DESTROYED_REGION);
        sc.zero(CREATE_IN_DESTROYED_REGION_ISLOAD);
        sc.zero(REMOTE_CREATE);
        sc.zero(REMOTE_CREATE_ISLOAD);
        sc.zero(REMOTE_UPDATE);
        sc.zero(REMOTE_UPDATE_ISLOAD);
        sc.zero(REMOTE_DESTROY);
        sc.zero(REMOTE_INVALIDATE);
        sc.zero(REMOTE_LOCAL_DESTROY);
        sc.zero(REMOTE_LOCAL_INVALIDATE);
        sc.zero(TX_SUCCESS);
        sc.zero(TX_FAILURE);
        sc.zero(TX_ROLLBACK);
        sc.zero(NUM_EXPECTED_FAILED_COMMIT);
        sc.zero(NUM_EXPECTED_ROLLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TxBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<TxBB> clazz = TxBB.class;
        synchronized (TxBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new TxBB(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public TxBB() {
    }

    public TxBB(String name, String type) {
        super(name, type, TxBB.class);
    }

    static {
        TxWriterAction = "TxWriterAction";
        COMPLETION_ACTION = "CompletionAction";
        TXACTION_COMMIT = "commit";
        TXACTION_ROLLBACK = "rollback";
        TXACTION_ABORT = "abort";
        TXACTION_NONE = "none";
        RoundRobinStartThread = "RoundRobinStartThread";
        OpListKey = "OpList_";
        OpListKey2 = "OpList2_";
        CommitStatusKey = "CommitStatus_";
        DestroyedRegionsKey = "DestroyedRegions";
        FirstInRoundCommitStatus = "FirstInRoundCommitStatus";
        SecondInRoundCommitStatus = "SecondInRoundCommitStatus";
        TX_OPLIST_KEY = "txOpListKey";
        TX_VM_PID = "txVmPid";
        TX_VM_CLIENTNAME = "txVmClientName";
        NON_TX_OPLIST = "nonTxOpList";
        LocalListenerOpListPrefix = "LocalListenerOpList_";
        RemoteListenerOpListPrefix = "RemoteListenerOpList_";
        UpdateStrategy = "UpdateStrategy";
        CommitStateTrigger = "CommitStateTrigger";
        RegConfigForPIDBaseKey = "RegionsForPID_";
        RegConfigForPIDKey = RegConfigForPIDBaseKey + ProcessMgr.getProcessId();
        RepeatableRead = "RepeatableRead";
        DataPolicyPrefix = "DATAPOLICY_";
    }
}

