/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.TestConfig;
import util.TestException;

public class TxPrms
extends BasePrms {
    public static Long excludeRegionName;
    public static Long txListener;
    public static Long txWriter;
    public static Long operations;
    public static Long isPartitionedRegion;
    public static Long executeNonTxOperations;
    public static Long checkEventCounters;
    public static Long checkTxEventOrder;
    public static Long numOps;
    public static Long tasksInTxPercentage;
    public static Long commitPercentage;
    public static Long regionOpPercentage;
    public static Long maxKeys;
    public static Long numRootRegions;
    public static Long numSubRegions;
    public static Long regionDepth;
    public static Long updateStrategy;
    public static final String USE_COPY_HELPER = "useCopyHelper";
    public static final String USE_COPY_ON_READ = "useCopyOnRead";
    public static Long commitStateTrigger;
    public static final int CommitState_afterReservation = 0;
    public static final int CommitState_afterConflictCheck = 1;
    public static final int CommitState_beforeSend = 2;
    public static final int CommitState_duringIndividualSend = 3;
    public static final int CommitState_afterIndividualSend = 4;
    public static final int CommitState_duringIndividualCommit = 5;
    public static final int CommitState_afterIndividualCommit = 6;
    public static final int CommitState_afterApplyChanges = 7;
    public static final int CommitState_afterReleaseLocalLocks = 8;
    public static final int CommitState_afterSend = 9;
    public static final int CommitState_afterSendCommit = 10;
    public static final int CommitState_afterSendRollback = 11;
    static final String AFTER_RESERVATION = "afterReservation";
    static final String AFTER_CONFLICT_CHECK = "afterConflictCheck";
    static final String BEFORE_SEND = "beforeSend";
    static final String AFTER_APPLY_CHANGES = "afterApplyChanges";
    static final String AFTER_RELEASE_LOCAL_LOCKS = "afterReleaseLocalLocks";
    static final String DURING_INDIVIDUAL_SEND = "duringIndividualSend";
    static final String AFTER_INDIVIDUAL_SEND = "afterIndividualSend";
    static final String DURING_INDIVIDUAL_COMMIT = "duringIndividualCommit";
    static final String AFTER_INDIVIDUAL_COMMIT = "afterIndividualCommit";
    static final String AFTER_SEND = "afterSend";
    static final String AFTER_SEND_COMMIT = "afterSendCommit";
    static final String AFTER_SEND_ROLLBACK = "afterSendRollback";
    public static Long killRemoteTxVm;
    public static Long viewDataPolicies;

    public static TransactionListener getTxListener() {
        Long key = txListener;
        String val = TxPrms.tasktab().stringAt(key, TxPrms.tab().stringAt(key, null));
        try {
            return (TransactionListener)TxPrms.instantiate(key, val);
        }
        catch (ClassCastException e) {
            throw new HydraConfigException("Illegal value for " + TxPrms.nameForKey(key) + ": " + val + " does not implement TransactionListener", e);
        }
    }

    public static TransactionWriter getTxWriter() {
        Long key = txWriter;
        String val = TxPrms.tasktab().stringAt(key, TxPrms.tab().stringAt(key, null));
        try {
            return (TransactionWriter)TxPrms.instantiate(key, val);
        }
        catch (ClassCastException e) {
            throw new HydraConfigException("Illegal value for " + TxPrms.nameForKey(key) + ": " + val + " does not implement TransactionWriter", e);
        }
    }

    public static boolean isPartitionedRegion() {
        Long key = isPartitionedRegion;
        return TxPrms.tasktab().booleanAt(key, TxPrms.tab().booleanAt(key, false));
    }

    public static boolean getExecuteNonTxOperations() {
        Long key = executeNonTxOperations;
        return TxPrms.tasktab().booleanAt(key, TxPrms.tab().booleanAt(key, false));
    }

    public static boolean checkEventCounters() {
        Long key = checkEventCounters;
        return TxPrms.tasktab().booleanAt(key, TxPrms.tab().booleanAt(key, false));
    }

    public static boolean checkTxEventOrder() {
        Long key = checkTxEventOrder;
        return TxPrms.tasktab().booleanAt(key, TxPrms.tab().booleanAt(key, true));
    }

    public static int getTasksInTxPercentage() {
        Long key = tasksInTxPercentage;
        int val = TxPrms.tasktab().intAt(key, TxPrms.tab().intAt(key, 100));
        if (val < 0 || val > 100) {
            throw new HydraConfigException("Illegal value for " + TxPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static int getCommitPercentage() {
        Long key = commitPercentage;
        int val = TxPrms.tasktab().intAt(key, TxPrms.tab().intAt(key, 100));
        if (val < 0 || val > 100) {
            throw new HydraConfigException("Illegal value for " + TxPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static int getRegionOpPercentage() {
        Long key = regionOpPercentage;
        int val = TxPrms.tasktab().intAt(key, TxPrms.tab().intAt(key, 100));
        if (val < 0 || val > 100) {
            throw new HydraConfigException("Illegal value for " + TxPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static String getUpdateStrategy() {
        String strategy = TestConfig.tab().stringAt(updateStrategy);
        if (!strategy.equalsIgnoreCase(USE_COPY_HELPER) && !strategy.equalsIgnoreCase(USE_COPY_ON_READ)) {
            throw new TestException("Unknown TxPrms.updateStrategy " + strategy);
        }
        return strategy;
    }

    public static int getCommitStateTrigger(String commitStatePrm) {
        int commitStateTrigger = -1;
        if (commitStatePrm.equalsIgnoreCase(AFTER_RESERVATION)) {
            commitStateTrigger = 0;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_CONFLICT_CHECK)) {
            commitStateTrigger = 1;
        } else if (commitStatePrm.equalsIgnoreCase(BEFORE_SEND)) {
            commitStateTrigger = 2;
        } else if (commitStatePrm.equalsIgnoreCase(DURING_INDIVIDUAL_SEND)) {
            commitStateTrigger = 3;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_INDIVIDUAL_SEND)) {
            commitStateTrigger = 4;
        } else if (commitStatePrm.equalsIgnoreCase(DURING_INDIVIDUAL_COMMIT)) {
            commitStateTrigger = 5;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_INDIVIDUAL_COMMIT)) {
            commitStateTrigger = 6;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_APPLY_CHANGES)) {
            commitStateTrigger = 7;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_RELEASE_LOCAL_LOCKS)) {
            commitStateTrigger = 8;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_SEND)) {
            commitStateTrigger = 9;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_SEND_COMMIT)) {
            commitStateTrigger = 10;
        } else if (commitStatePrm.equalsIgnoreCase(AFTER_SEND_ROLLBACK)) {
            commitStateTrigger = 11;
        } else {
            throw new TestException("Unknown TxPrms.commitStateTrigger " + commitStateTrigger);
        }
        return commitStateTrigger;
    }

    public static String toStringForCommitStateTrigger(int commitStateTrigger) {
        String s = null;
        switch (commitStateTrigger) {
            case 0: {
                s = AFTER_RESERVATION;
                break;
            }
            case 1: {
                s = AFTER_CONFLICT_CHECK;
                break;
            }
            case 2: {
                s = BEFORE_SEND;
                break;
            }
            case 3: {
                s = DURING_INDIVIDUAL_SEND;
                break;
            }
            case 4: {
                s = AFTER_INDIVIDUAL_SEND;
                break;
            }
            case 5: {
                s = DURING_INDIVIDUAL_COMMIT;
                break;
            }
            case 6: {
                s = AFTER_INDIVIDUAL_COMMIT;
                break;
            }
            case 7: {
                s = AFTER_APPLY_CHANGES;
                break;
            }
            case 8: {
                s = AFTER_RELEASE_LOCAL_LOCKS;
                break;
            }
            case 9: {
                s = AFTER_SEND;
                break;
            }
            case 10: {
                s = AFTER_SEND_COMMIT;
                break;
            }
            case 11: {
                s = AFTER_SEND_ROLLBACK;
                break;
            }
            default: {
                s = "Invalid commitStateTrigger (" + commitStateTrigger + ")";
            }
        }
        return s;
    }

    public static boolean killRemoteTxVm() {
        Long key = killRemoteTxVm;
        boolean val = TxPrms.tab().booleanAt(key, false);
        return val;
    }

    private static Object instantiate(Long key, String classname) {
        if (classname == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(classname);
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new HydraConfigException("Illegal value for " + TxPrms.nameForKey(key) + ": cannot instantiate " + classname, e);
        }
    }

    static {
        BasePrms.setValues(TxPrms.class);
    }
}

