/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.TransactionWriterException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.TransactionObserver;
import com.gemstone.gemfire.internal.cache.TransactionObserverAdapter;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import parReg.tx.SetupRemoteTestCallbacks;
import tx.CollectionsTest;
import tx.EntryValidator;
import tx.OpList;
import tx.Operation;
import tx.RegionValidator;
import tx.TxBB;
import tx.TxPrms;
import tx.TxViewUtil;
import util.CacheUtil;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TxEventCountersBB;
import util.TxHelper;
import util.TxWriterCountersBB;
import util.WriterCountersBB;

public class ViewTest {
    protected static ViewTest viewTest;
    protected boolean isSerialExecution;
    protected GsRandom rng;
    protected boolean txInProgress = false;
    protected Integer myVmPid;
    protected boolean isScopeLocal = false;
    protected boolean isBridgeClient = false;
    protected boolean isProxy;
    protected InterestPolicy interestPolicy;
    protected boolean initializeTxInfo = true;
    protected boolean checkEventCounters;
    public static Object killSyncObject;
    protected TXStateInterface txContext = null;
    static final int LOCAL_EVENTS = 0;
    static final int REMOTE_EVENTS = 1;

    public static void HydraTask_initialize() {
        Log.getLogWriter().info("In HydraTask_initialize");
        if (viewTest == null) {
            viewTest = new ViewTest();
            viewTest.initialize();
        }
        TxBB.getBB().getSharedMap().put("afterCommitProcessed", new Boolean(false));
    }

    public void initialize() {
        RegionAttributes ratts;
        this.rng = TestConfig.tab().getRandGen();
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        if (this.isSerialExecution) {
            Log.getLogWriter().info("ViewTest is running in SERIAL_EXECUTION mode");
        }
        this.myVmPid = new Integer(RemoteTestModule.getMyPid());
        Set root = CacheUtil.getCache().rootRegions();
        Iterator it = root.iterator();
        if (it.hasNext()) {
            Region aRegion = (Region)it.next();
            ratts = aRegion.getAttributes();
            boolean bl = this.isBridgeClient = ratts.getPoolName() != null;
            if (!this.isBridgeClient) {
                this.isScopeLocal = ratts.getScope() == Scope.LOCAL;
            }
        } else {
            throw new TestException("no regions found at initialization -- cannot setup test without established forest of regions!");
        }
        this.isProxy = ratts.getDataPolicy().isEmpty();
        this.checkEventCounters = TxPrms.checkEventCounters();
        Log.getLogWriter().info("isScopeLocal = " + this.isScopeLocal + ", isProxy = " + this.isProxy + ", myVmPid = " + this.myVmPid + ", checkEventCounters = " + this.checkEventCounters);
        TxBB.getBB().getSharedMap().put("timeToStop", new Boolean(false));
    }

    private void initializeTxInfo() {
        Integer txVmPid = new Integer(RemoteTestModule.getMyPid());
        TxBB.getBB().getSharedMap().put(TxBB.TX_VM_PID, txVmPid);
        Log.getLogWriter().info("Putting txVmPid into BB at " + TxBB.TX_VM_PID + " with value = " + txVmPid);
        String myClientName = RemoteTestModule.getMyClientName();
        TxBB.getBB().getSharedMap().put(TxBB.TX_VM_CLIENTNAME, myClientName);
        Log.getLogWriter().info("Putting clientVmName of txVm into BB at " + TxBB.TX_VM_CLIENTNAME + " with value " + myClientName);
        TxBB.getBB().getSharedMap().put(TxBB.TxWriterAction, TxBB.TXACTION_NONE);
        this.initializeTxInfo = false;
    }

    public static void HydraTask_executeTx() {
        TestHelper.checkForEventError(TxBB.getBB());
        viewTest.executeTx();
    }

    protected void executeTx() {
        if (this.initializeTxInfo) {
            this.initializeTxInfo();
        }
        if (this.txInProgress) {
            TxHelper.internalResume(this.txContext);
            this.finishTx();
        } else {
            this.beginTx();
            this.txContext = TxHelper.internalSuspend();
        }
        this.txInProgress = !this.txInProgress;
    }

    protected void beginTx() {
        long txNum = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.TX_NUMBER);
        Log.getLogWriter().info("In beginTx() for TX_NUMBER = " + txNum);
        MasterController.sleepForMs(10000);
        TxBB.getBB().getSharedCounters().increment(TxBB.PROCESS_EVENTS);
        Log.getLogWriter().fine("Clearing BB NON_TX_OPLIST");
        TxBB.getBB().getSharedMap().remove(TxBB.NON_TX_OPLIST);
        Log.getLogWriter().info("Removing CacheListener operation lists from BB");
        TxBB.getBB().getSharedMap().remove(TxBB.LocalListenerOpListPrefix + (txNum - 1L));
        TxBB.getBB().getSharedMap().remove(TxBB.RemoteListenerOpListPrefix + (txNum - 1L));
        TxViewUtil.txUtilInstance.clearDestroyedRegions();
        TxViewUtil.txUtilInstance.suspendResume = true;
        this.checkAndClearEventCounters();
        TxHelper.begin();
        boolean allowGetOperations = !this.isProxy;
        OpList opList = TxViewUtil.doOperations(allowGetOperations);
        TxBB.putOpList(opList);
        String commitStatePrm = TestConfig.tab().stringAt(TxPrms.commitStateTrigger, null);
        if (commitStatePrm != null) {
            this.setupCommitTestCallbacks(commitStatePrm);
        }
        TxBB.getBB().getSharedMap().put(TxBB.TX_OPLIST_KEY, TxBB.getOpListKey());
        Log.getLogWriter().info("validating tx state");
        this.validateTxOps(true);
        this.setExpectedEventCounts();
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        sc.zero(TxBB.TX_COMPLETED);
        sc.increment(TxBB.TX_READY_FOR_VALIDATION);
    }

    protected void finishTx() {
        int n = this.rng.nextInt(1, 100);
        int commitPercentage = TxPrms.getCommitPercentage();
        boolean failedCommit = false;
        boolean txAborted = false;
        boolean isCausedByTransactionWriterException = false;
        boolean isCausedByHA = false;
        if (n <= commitPercentage) {
            try {
                TxHelper.commit();
            }
            catch (ConflictException e) {
                failedCommit = true;
                Log.getLogWriter().info("finishTx() caught " + e.toString());
                Throwable causedBy = e.getCause();
                if (causedBy instanceof TransactionWriterException) {
                    isCausedByTransactionWriterException = true;
                } else {
                    Log.getLogWriter().info("causedBy is not a TransactionWriterException, but is " + causedBy, causedBy);
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                failedCommit = true;
                Log.getLogWriter().info("finishTx() caught " + e.toString());
                String errStr = e.toString();
                isCausedByHA = errStr.indexOf("PartitionResponse got memberDeparted event") >= 0;
            }
            catch (TransactionInDoubtException e) {
                failedCommit = true;
                Log.getLogWriter().info("finishTx() caught " + e.toString());
                String errStr = e.toString();
                boolean bl = isCausedByHA = errStr.indexOf("ReplyException: Failed to deliver message to members") >= 0 || errStr.indexOf("memberDeparted") >= 0;
            }
            if (failedCommit && !isCausedByTransactionWriterException && !TxBB.getBB().getSharedMap().get(TxBB.TxWriterAction).equals(TxBB.TXACTION_NONE)) {
                throw new TestException("Invoked TransactionWriter after conflict detected " + TestHelper.getStackTrace());
            }
            if (TxBB.getBB().getSharedMap().get(TxBB.TxWriterAction).equals(TxBB.TXACTION_ABORT)) {
                txAborted = true;
            }
            if (!(!txAborted || failedCommit && isCausedByTransactionWriterException)) {
                throw new TestException("TransactionWriter threw TransactionWriterException (to abort tx), but caller did not process ConflictException Caused by TransactionWriterException " + TestHelper.getStackTrace());
            }
            if (failedCommit && isCausedByTransactionWriterException && !txAborted) {
                throw new TestException("Missed expected TX ABORT " + TestHelper.getStackTrace());
            }
            if (failedCommit) {
                TxBB.inc(TxBB.NUM_EXPECTED_FAILED_COMMIT);
                if (txAborted) {
                    TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_ABORT);
                } else {
                    TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_ROLLBACK);
                }
                boolean isVisible = false;
                if (isCausedByHA) {
                    MasterController.sleepForMs(3000);
                    isVisible = this.updatesVisible();
                }
                this.validateCommittedState(isVisible);
            } else {
                TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_COMMIT);
                this.validateCommittedState(true);
            }
        } else {
            TxBB.inc(TxBB.NUM_EXPECTED_ROLLBACK);
            try {
                TxHelper.rollback();
            }
            catch (TransactionDataNodeHasDepartedException e) {
                Log.getLogWriter().info("finishTx() caught " + e.toString() + " on rollback");
            }
            TxBB.getBB().getSharedMap().put(TxBB.COMPLETION_ACTION, TxBB.TXACTION_ROLLBACK);
            this.validateCommittedState(false);
        }
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        sc.zero(TxBB.TX_READY_FOR_VALIDATION);
        sc.increment(TxBB.TX_COMPLETED);
        TxBB.getBB().getSharedMap().put("timeToStop", new Boolean(true));
    }

    protected void verifyCallbackInvocation(int numVmsWithTxListener) {
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        boolean hasEntryOps = false;
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Operation op = txOpList.getOperation(i);
            if (!op.isEntryOperation()) continue;
            hasEntryOps = true;
        }
        if (!hasEntryOps) {
            Log.getLogWriter().info("OpList does not contain any entry operations, only the local TxListener will be invoked.  Setting numVmsWithTxListener to 1");
            numVmsWithTxListener = 1;
        }
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        long expectedFailedCommits = sc.read(TxBB.NUM_EXPECTED_FAILED_COMMIT) * (long)numVmsWithTxListener;
        long expectedRollbacks = sc.read(TxBB.NUM_EXPECTED_ROLLBACK) * (long)numVmsWithTxListener;
        long actualFailedCommits = sc.read(TxBB.TX_FAILURE);
        long actualRollbacks = sc.read(TxBB.TX_ROLLBACK);
        StringBuffer aStr = new StringBuffer();
        if (actualFailedCommits != expectedFailedCommits) {
            aStr.append("Expected " + expectedFailedCommits + " afterFailedCommit() listener invocations, but found " + actualFailedCommits);
        }
        if (actualRollbacks != expectedRollbacks) {
            aStr.append("Expected " + expectedRollbacks + " afterRollback() listener invocations, but found " + actualRollbacks);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString() + " " + TestHelper.getStackTrace());
        }
    }

    protected void validateCommittedState(boolean txCommitted) {
        if (this.isProxy) {
            return;
        }
        if (txCommitted) {
            Log.getLogWriter().info("TX COMPLETED: validating tx committed");
            this.validateCombinedOpsAfterCommit();
        } else {
            Log.getLogWriter().info("TX COMPLETED: validating tx rollback");
            this.validateCombinedOpsAfterRollback();
        }
    }

    protected void validateCombinedOpsAfterCommit() {
        int j;
        int i;
        OpList nonTxOpList = (OpList)TxBB.getBB().getSharedMap().get(TxBB.NON_TX_OPLIST);
        if (nonTxOpList != null) {
            for (int i2 = 0; i2 < nonTxOpList.numOps(); ++i2) {
                Operation nonTxOp = nonTxOpList.getOperation(i2);
                if (!nonTxOp.isDoubleInvalidate()) continue;
                Log.getLogWriter().info("removing double invalidate from nonTxList " + nonTxOp.toString());
                nonTxOpList.remove(i2);
            }
        }
        if (nonTxOpList == null) {
            this.validateTxOps(true, TxBB.TXACTION_COMMIT);
            return;
        }
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        OpList fullList = new OpList();
        for (i = 0; i < nonTxOpList.numOps(); ++i) {
            Operation nonTxOp = nonTxOpList.getOperation(i);
            for (j = 0; j < txOpList.numOps(); ++j) {
                Operation txOp = txOpList.getOperation(j);
                if (txOp.isEntryGet() || !nonTxOp.affectedBy(txOp)) continue;
                if (txOp.isEntryDestroy()) {
                    nonTxOp = null;
                    break;
                }
                nonTxOp.setNewValue(txOp.getNewValue());
            }
            if (nonTxOp == null) continue;
            fullList.add(nonTxOp);
        }
        for (i = 0; i < txOpList.numOps(); ++i) {
            Operation txOp = txOpList.getOperation(i);
            for (j = 0; j < nonTxOpList.numOps(); ++j) {
                Operation nonTxOp = nonTxOpList.getOperation(j);
                if (!txOp.affectedBy(nonTxOp) || txOp.isEntryDestroy()) continue;
                txOp = null;
                break;
            }
            if (txOp == null) continue;
            fullList.add(txOp);
        }
        Log.getLogWriter().fine("COMBINED NON-TX & TX OPS = " + fullList);
        this.validateState(fullList, true);
    }

    protected void validateCombinedOpsAfterRollback() {
        OpList nonTxOpList = (OpList)TxBB.getBB().getSharedMap().get(TxBB.NON_TX_OPLIST);
        if (nonTxOpList == null) {
            this.validateTxOps(false, TxBB.TXACTION_ROLLBACK);
            return;
        }
        this.validateNonTxOps();
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        OpList shortList = new OpList();
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Operation txOp = txOpList.getOperation(i);
            for (int j = 0; j < nonTxOpList.numOps(); ++j) {
                Operation nonTxOp = nonTxOpList.getOperation(j);
                if (!txOp.affectedBy(nonTxOp)) continue;
                txOp = null;
                break;
            }
            if (txOp == null) continue;
            shortList.add(txOp);
        }
        Log.getLogWriter().fine("TXOPS NOT AFFECTED BY NON-TX OPS = " + shortList);
        this.validateState(shortList, false);
    }

    public static void HydraTask_checkCommittedState() {
        Log.getLogWriter().info("HydraTask_checkCommittedState(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        MasterController.sleepForMs(1000);
        viewTest.checkCommittedState();
        if (TxBB.getBB().getSharedCounters().read(TxBB.TX_COMPLETED) == 1L) {
            TxBB.getBB().getSharedCounters().zero(TxBB.PROCESS_EVENTS);
            TxViewUtil.txUtilInstance.createDestroyedRegionsFromBB(true);
        }
    }

    protected void checkCommittedState() {
        if (this.isProxy) {
            Log.getLogWriter().info("Cannot validate state with DataPolicy.EMPTY, no local storage/state, returning ...");
            return;
        }
        if (TxBB.getBB().getSharedCounters().read(TxBB.TX_READY_FOR_VALIDATION) == 1L) {
            boolean executeNonTxOperations = TxPrms.getExecuteNonTxOperations();
            Log.getLogWriter().info("TxPrms.getExecuteNonTxOperations() = " + executeNonTxOperations);
            if (executeNonTxOperations) {
                Log.getLogWriter().info("executing non-tx operations");
                OpList opList = TxViewUtil.doOperations();
                TxBB.getBB().getSharedMap().put(TxBB.NON_TX_OPLIST, opList);
                Log.getLogWriter().info("non-tx operations written to BB " + opList.toString());
            } else {
                Log.getLogWriter().info("check view, TX in progress, we should only see committed state");
            }
            if (!this.validateNonTxOps()) {
                this.validateTxOps(false);
            }
            return;
        }
        if (TxBB.getBB().getSharedCounters().read(TxBB.TX_COMPLETED) == 1L) {
            String txAction = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION);
            if (txAction.equals(TxBB.TXACTION_COMMIT)) {
                Log.getLogWriter().info("validate tx committed");
                this.validateCombinedOpsAfterCommit();
            } else {
                Log.getLogWriter().info("validate tx rollback");
                this.validateCombinedOpsAfterRollback();
            }
            return;
        }
        Log.getLogWriter().info("checkCommittedState: no tx state to verify, returning");
    }

    protected void validateAllStates(boolean isTxVisible) {
        this.validateNonTxOps();
        this.validateTxOps(isTxVisible);
    }

    protected boolean validateNonTxOps() {
        boolean nonTxOpsVerified = false;
        OpList nonTxOpList = (OpList)TxBB.getBB().getSharedMap().get(TxBB.NON_TX_OPLIST);
        if (nonTxOpList != null) {
            Log.getLogWriter().info("validateAllStates() - verifying state with nonTxOpList");
            this.validateState(nonTxOpList, true);
            nonTxOpsVerified = true;
        }
        return nonTxOpsVerified;
    }

    protected boolean validateTxOps(boolean isTxVisible) {
        return this.validateTxOps(isTxVisible, TxBB.TXACTION_NONE);
    }

    protected boolean validateTxOps(boolean isTxVisible, String txAction) {
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        Log.getLogWriter().info("validateAllStates() - verifying state with txOpList");
        this.validateState(txOpList, isTxVisible, txAction);
        return true;
    }

    protected void validateState(OpList opList, boolean isVisible) {
        this.validateState(opList, isVisible, TxBB.TXACTION_NONE);
    }

    protected void validateState(OpList opList, boolean isVisible, String txAction) {
        if (this.isProxy) {
            return;
        }
        opList = opList.collapse(txAction);
        for (int i = 0; i < opList.numOps(); ++i) {
            Operation op = opList.getOperation(i);
            if (op.isLocalOperation() && !TxViewUtil.inTxVm()) {
                Log.getLogWriter().fine("validateState() - isVisible forced to false");
                isVisible = false;
            }
            if (op.isEntryOperation()) {
                EntryValidator expectedValues = EntryValidator.getExpected(op, isVisible);
                if (this.isScopeLocal && !TxViewUtil.inTxVm()) {
                    if (NameFactory.getCounterForName(op.getKey()) > (long)(TestConfig.tab().intAt(TxPrms.maxKeys) - 1)) {
                        Log.getLogWriter().fine("override expected values -- scope is local and key " + op.getKey() + " is only visible in txVm");
                        expectedValues.setKeyExists(false);
                        expectedValues.setHasValue(false);
                        expectedValues.setCacheValue(EntryValidator.DONT_CARE);
                    } else {
                        expectedValues.setKeyExists(true);
                        expectedValues.setHasValue(true);
                        expectedValues.setCacheValue(EntryValidator.DONT_CARE);
                    }
                }
                EntryValidator actualValues = EntryValidator.getActual(op);
                expectedValues.compare(actualValues);
                continue;
            }
            if (op.isRegionOperation()) {
                boolean regionOpsVisible = true;
                if (!TxViewUtil.inTxVm() && (this.isScopeLocal || op.isLocalOperation())) {
                    regionOpsVisible = false;
                }
                RegionValidator expectedValues = RegionValidator.getExpected(op, regionOpsVisible);
                RegionValidator actualValues = RegionValidator.getActual(op);
                expectedValues.compare(actualValues);
                continue;
            }
            if (op.getOpName().equalsIgnoreCase("cache-close")) {
                this.validateCacheClosed(isVisible);
                continue;
            }
            throw new TestException("Unknown operation " + op);
        }
    }

    protected void validateCacheClosed(boolean isVisible) {
        Log.getLogWriter().info("Entering validateCacheClosed");
        boolean cacheClosed = CacheUtil.getCache().isClosed();
        if (isVisible != cacheClosed) {
            throw new TestException("Validation failure in cacheClosed");
        }
    }

    protected void adjustOldValue(Operation op, OpList opList) {
        Log.getLogWriter().info("adjustOldValue received op = " + op.toString());
        for (int j = 0; j < opList.numOps(); ++j) {
            String updatedOldVal;
            Operation tmpOp = opList.getOperation(j);
            if (!tmpOp.isRegionOperation() || !op.getRegionName().startsWith(tmpOp.getRegionName())) continue;
            if (tmpOp.isLocalOperation()) {
                if (!TxViewUtil.inTxVm()) continue;
                updatedOldVal = null;
                if (tmpOp.getOpName().endsWith("inval")) {
                    updatedOldVal = new String("LOCAL_INVALID");
                }
                op.setOldValue(updatedOldVal);
                continue;
            }
            updatedOldVal = null;
            if (tmpOp.getOpName().endsWith("inval")) {
                updatedOldVal = new String("INVALID");
            }
            op.setOldValue(updatedOldVal);
        }
        Log.getLogWriter().info("adjustOldValue returns op = " + op.toString());
    }

    private void setExpectedEventCounts() {
        if (!this.checkEventCounters) {
            return;
        }
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        TxBB.getBB().zeroEventCounters();
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        this.incrementEventCounters(txOpList, 0);
        this.incrementEventCounters(txOpList.getEntriesWithUniqueKeys(txOpList.getEntryOps()), 1);
    }

    private boolean updatedInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        int i = 0;
        for (i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
        }
        ++i;
        while (i < txOpList.numOps()) {
            tmpOp = txOpList.getOperation(i);
            if (tmpOp.isEntryUpdate() && tmpOp.usesSameRegionAndKey(op)) {
                Log.getLogWriter().info("updatedInThisTx returning TRUE + updateOperation = " + tmpOp.toString() + " occurred after get/loadOp = " + op.toString());
                rc = true;
                break;
            }
            ++i;
        }
        return rc;
    }

    private boolean invalidatedInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        for (int i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            if (!tmpOp.isEntryInvalidate() || !tmpOp.usesSameRegionAndKey(op)) continue;
            Log.getLogWriter().info("invalidatedInThisTx returning TRUE + invalidateOperation = " + tmpOp.toString() + " occurred before op = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    private boolean createdInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        for (int i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            if (!tmpOp.isEntryCreate() || !tmpOp.usesSameRegionAndKey(op)) continue;
            Log.getLogWriter().info("createdInThisTx returning TRUE, createOperation = " + tmpOp.toString() + " occurred prior to destroyOp = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    private boolean destroyedBeforeLoadInThisTx(Operation op) {
        Operation tmpOp;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        for (int i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            if (!tmpOp.isEntryDestroy() || !tmpOp.usesSameRegionAndKey(op)) continue;
            Log.getLogWriter().info("destroyedBeforeLoad returning TRUE + destroyOperation = " + tmpOp.toString() + " occurred prior to getOperation = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    private boolean destroyedInThisTx(Operation op) {
        Operation tmpOp;
        int i;
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        String regionName = op.getRegionName();
        String key = (String)op.getKey();
        Log.getLogWriter().fine("Searching for original (create) operation in OpList, op = " + op.toString());
        for (i = 0; i < txOpList.numOps() && !op.equals(tmpOp = txOpList.getOperation(i)); ++i) {
            Log.getLogWriter().fine("operation " + tmpOp.toString() + " does not match createOp = " + op.toString());
        }
        Log.getLogWriter().fine("Found original operation in opList " + op.toString());
        Log.getLogWriter().fine("Searching for an entry-destroy on same region/key as createOp  " + op.toString());
        ++i;
        while (i < txOpList.numOps()) {
            tmpOp = txOpList.getOperation(i);
            if (tmpOp.isEntryDestroy() && tmpOp.usesSameRegionAndKey(op)) {
                Log.getLogWriter().info("destroyedInThisTx returning TRUE + destroyOperation = " + tmpOp.toString() + " occurred prior to createOp = " + op.toString());
                rc = true;
                break;
            }
            Log.getLogWriter().fine("Operation " + tmpOp.toString() + " does not match createOp = " + op.toString());
            ++i;
        }
        return rc;
    }

    private boolean hostRegionDestroyedInThisTx(Operation op) {
        boolean rc = false;
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        int i = 0;
        for (i = 0; i < txOpList.numOps(); ++i) {
            Operation tmpOp = txOpList.getOperation(i);
            if (!tmpOp.isRegionDestroy() || !op.getRegionName().startsWith(tmpOp.getRegionName())) continue;
            Log.getLogWriter().info("hostRegionDestroyedInThisTx found regionDestroy = " + tmpOp.toString() + " op = " + op.toString());
            rc = true;
            break;
        }
        return rc;
    }

    public void incrementEventCounters(OpList txOpList, int counterType) {
        String counterTypeName = counterType == 0 ? "LOCAL" : "REMOTE";
        Log.getLogWriter().fine("In incrementEventCounters, counterType = " + counterTypeName);
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Operation op = txOpList.getOperation(i);
            String opName = op.getOpName();
            boolean isLoad = false;
            if (op.isEntryGet()) {
                if (op.isPreviouslyInvalid() || this.invalidatedInThisTx(op)) {
                    opName = "entry-update";
                    isLoad = true;
                } else if (this.destroyedBeforeLoadInThisTx(op)) {
                    opName = counterType == 0 ? "entry-create" : "entry-update";
                } else if (op.getOldValue() == null) {
                    opName = "entry-create";
                    isLoad = true;
                    if (counterType == 1 && this.updatedInThisTx(op)) {
                        isLoad = false;
                    }
                }
            }
            SharedCounters sc = TxBB.getBB().getSharedCounters();
            if (opName.equalsIgnoreCase("entry-create")) {
                if (counterType == 1) {
                    if (this.hostRegionDestroyedInThisTx(op)) {
                        sc.increment(isLoad ? TxBB.CREATE_IN_DESTROYED_REGION_ISLOAD : TxBB.CREATE_IN_DESTROYED_REGION);
                        continue;
                    }
                    sc.increment(isLoad ? TxBB.REMOTE_CREATE_ISLOAD : TxBB.REMOTE_CREATE);
                    continue;
                }
                if (this.destroyedInThisTx(op)) {
                    sc.increment(TxBB.CONFLATED_CREATE_DESTROY);
                }
                sc.increment(isLoad ? TxBB.LOCAL_CREATE_ISLOAD : TxBB.LOCAL_CREATE);
                continue;
            }
            if (opName.equalsIgnoreCase("entry-update")) {
                if (isLoad) {
                    sc.increment(counterType == 1 ? TxBB.REMOTE_UPDATE_ISLOAD : TxBB.LOCAL_UPDATE_ISLOAD);
                    continue;
                }
                sc.increment(counterType == 1 ? TxBB.REMOTE_UPDATE : TxBB.LOCAL_UPDATE);
                continue;
            }
            if (opName.equalsIgnoreCase("entry-destroy")) {
                if (counterType == 1) {
                    if (this.createdInThisTx(op)) continue;
                    sc.increment(TxBB.REMOTE_DESTROY);
                    continue;
                }
                sc.increment(TxBB.LOCAL_DESTROY);
                continue;
            }
            if (opName.equalsIgnoreCase("entry-localDestroy")) {
                if (counterType != 0) continue;
                sc.increment(TxBB.LOCAL_LOCAL_DESTROY);
                continue;
            }
            if (opName.equalsIgnoreCase("entry-inval")) {
                if (op.isDoubleInvalidate()) continue;
                sc.increment(counterType == 1 ? TxBB.REMOTE_INVALIDATE : TxBB.LOCAL_INVALIDATE);
                continue;
            }
            if (!opName.equalsIgnoreCase("entry-localInval") || op.isDoubleInvalidate()) continue;
            sc.increment(counterType == 1 ? TxBB.REMOTE_LOCAL_INVALIDATE : TxBB.LOCAL_LOCAL_INVALIDATE);
        }
        TxBB.getBB().printSharedCounters();
    }

    private void checkAndClearEventCounters() {
        if (!this.checkEventCounters) {
            return;
        }
        this.checkWriterCounters();
        this.checkEventCounters();
        this.checkTxEventCounters(TxEventCountersBB.getBB());
        this.checkTxEventCounters(TxWriterCountersBB.getBB());
        EventCountersBB.getBB().zeroAllCounters();
        WriterCountersBB.getBB().zeroAllCounters();
        TxEventCountersBB.getBB().zeroAllCounters();
        TxWriterCountersBB.getBB().zeroAllCounters();
        TxBB.getBB().getSharedMap().put(TxBB.TxWriterAction, TxBB.TXACTION_NONE);
    }

    protected void checkWriterCounters() {
        SharedCounters counters = TxBB.getBB().getSharedCounters();
        long localCreate = counters.read(TxBB.LOCAL_CREATE);
        long localCreateIsLoad = counters.read(TxBB.LOCAL_CREATE_ISLOAD);
        long localUpdate = counters.read(TxBB.LOCAL_UPDATE);
        long localUpdateIsLoad = counters.read(TxBB.LOCAL_UPDATE_ISLOAD);
        long localDestroy = counters.read(TxBB.LOCAL_DESTROY);
        long localInval = counters.read(TxBB.LOCAL_INVALIDATE);
        long localLocalDestroy = counters.read(TxBB.LOCAL_LOCAL_DESTROY);
        long localLocalInval = counters.read(TxBB.LOCAL_LOCAL_INVALIDATE);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numBeforeCreateEvents_isDist", localCreate + localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotExp", localCreate + localCreateIsLoad));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", localCreate + localCreateIsLoad));
            al.add(new ExpCounterValue("numBeforeCreateEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeCreateEvents_isNotRemote", localCreate + localCreateIsLoad));
        }
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLoad", localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLoad", localCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLocalLoad", localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLocalLoad", localCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetLoad", localCreate + localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetSearch", localCreate + localCreateIsLoad));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isDist", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotExp", localDestroy));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", localDestroy));
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotRemote", localDestroy));
        }
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLoad", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLocalLoad", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetLoad", localDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetSearch", localDestroy));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isDist", localUpdate + localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotExp", localUpdate + localUpdateIsLoad));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", localUpdate + localUpdateIsLoad));
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", 0L));
            al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotRemote", localUpdate + localUpdateIsLoad));
        }
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLoad", localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLoad", localUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLocalLoad", localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLocalLoad", localUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetLoad", localUpdate + localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetSearch", localUpdate + localUpdateIsLoad));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotRemote", 0L));
        WriterCountersBB.getBB().checkEventCounters(al);
    }

    protected void checkEventCounters() {
        SharedCounters counters = TxBB.getBB().getSharedCounters();
        long remoteCreate = counters.read(TxBB.REMOTE_CREATE);
        long remoteCreateIsLoad = counters.read(TxBB.REMOTE_CREATE_ISLOAD);
        long remoteUpdate = counters.read(TxBB.REMOTE_UPDATE);
        long remoteUpdateIsLoad = counters.read(TxBB.REMOTE_UPDATE_ISLOAD);
        long remoteDestroy = counters.read(TxBB.REMOTE_DESTROY);
        long remoteInval = counters.read(TxBB.REMOTE_INVALIDATE);
        long remoteLocalDestroy = counters.read(TxBB.REMOTE_LOCAL_DESTROY);
        long remoteLocalInval = counters.read(TxBB.REMOTE_LOCAL_INVALIDATE);
        long numConflatedCreateDestroy = counters.read(TxBB.CONFLATED_CREATE_DESTROY);
        if (!this.isProxy) {
            numConflatedCreateDestroy = 0L;
        }
        long numClose = 0L;
        String endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION);
        if (endResult == null) {
            return;
        }
        int numVmsWithList = TestHelper.getNumVMs();
        if (this.isProxy) {
            numVmsWithList = TestHelper.getNumVMs() - 1;
        }
        Log.getLogWriter().info("num VMs with listener installed: " + numVmsWithList);
        if (!endResult.equals(TxBB.TXACTION_COMMIT)) {
            remoteCreate = 0L;
            remoteCreateIsLoad = 0L;
            remoteUpdate = 0L;
            remoteUpdateIsLoad = 0L;
            remoteDestroy = 0L;
            remoteInval = 0L;
            remoteLocalDestroy = 0L;
            remoteLocalInval = 0L;
            numConflatedCreateDestroy = 0L;
        }
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        if (this.isProxy) {
            al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
            al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", (remoteCreate + remoteCreateIsLoad) * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", remoteCreate + remoteCreateIsLoad));
        }
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", remoteCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", remoteCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", remoteCreateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", remoteCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", (remoteCreate + remoteCreateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        if (this.isProxy) {
            al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", remoteDestroy * (long)numVmsWithList));
            al.add(new ExpCounterValue("numAfterDestroyEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", remoteDestroy * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numAfterDestroyEvents_isNotRemote", remoteDestroy + numConflatedCreateDestroy));
        }
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", remoteDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", remoteInval * (long)numVmsWithList));
        if (this.isProxy) {
            al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", remoteInval * (long)numVmsWithList));
            al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", remoteInval * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotRemote", remoteInval));
        }
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", remoteInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        if (this.isProxy) {
            al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
            al.add(new ExpCounterValue("numAfterUpdateEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", remoteUpdateIsLoad * (long)numVmsWithList));
            al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", remoteUpdate * (long)numVmsWithList));
        }
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", remoteUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", remoteUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", (remoteUpdate + remoteUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numClose", numClose, false));
        EventCountersBB.getBB().checkEventCounters(al);
    }

    protected void checkTxEventCounters(Blackboard bb) {
        String endResult;
        SharedCounters counters = TxBB.getBB().getSharedCounters();
        long numCreate = counters.read(TxBB.REMOTE_CREATE);
        long numCreateIsLoad = counters.read(TxBB.REMOTE_CREATE_ISLOAD);
        long numUpdate = counters.read(TxBB.REMOTE_UPDATE);
        long numUpdateIsLoad = counters.read(TxBB.REMOTE_UPDATE_ISLOAD);
        long numDestroy = counters.read(TxBB.REMOTE_DESTROY);
        long numInval = counters.read(TxBB.REMOTE_INVALIDATE);
        long numLocalDestroy = counters.read(TxBB.REMOTE_LOCAL_DESTROY);
        long numLocalInval = counters.read(TxBB.REMOTE_LOCAL_INVALIDATE);
        long numConflatedCreateDestroy = counters.read(TxBB.CONFLATED_CREATE_DESTROY);
        long numCreateInDestroyedRegion = counters.read(TxBB.CREATE_IN_DESTROYED_REGION);
        long numCreateInDestroyedRegion_isLoad = counters.read(TxBB.CREATE_IN_DESTROYED_REGION_ISLOAD);
        int numVmsWithList = TestHelper.getNumVMs();
        if (this.isBridgeClient) {
            numVmsWithList = BridgeHelper.getEndpoints().size();
        } else if (this.isProxy) {
            numVmsWithList = TestHelper.getNumVMs() - 1;
        }
        if (bb.equals(TxWriterCountersBB.getBB())) {
            numVmsWithList = 1;
        }
        if ((endResult = (String)TxBB.getBB().getSharedMap().get(TxBB.COMPLETION_ACTION)) == null) {
            return;
        }
        if (!endResult.equals(TxBB.TXACTION_COMMIT)) {
            if (bb.equals(TxWriterCountersBB.getBB())) {
                if (endResult.equals(TxBB.TXACTION_ROLLBACK)) {
                    numCreate = 0L;
                    numCreateIsLoad = 0L;
                    numUpdate = 0L;
                    numUpdateIsLoad = 0L;
                    numDestroy = 0L;
                    numInval = 0L;
                    numLocalDestroy = 0L;
                    numLocalInval = 0L;
                    numConflatedCreateDestroy = 0L;
                    numCreateInDestroyedRegion = 0L;
                    numCreateInDestroyedRegion_isLoad = 0L;
                }
            } else {
                numVmsWithList = 1;
                Log.getLogWriter().info("Commit failed or was rolled back, remote TxListeners will not be included in counts, numVmsWithList = " + numVmsWithList);
                if (!this.isProxy) {
                    numConflatedCreateDestroy = 0L;
                }
            }
        }
        Log.getLogWriter().info("num VMs with listener installed: " + numVmsWithList);
        if (bb.equals(TxEventCountersBB.getBB())) {
            this.verifyCallbackInvocation(numVmsWithList);
        }
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numCreateTxEvents_isDist", (numCreate + numCreateIsLoad) * (long)numVmsWithList + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotExp", (numCreate + numCreateIsLoad) * (long)numVmsWithList + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numCreateTxEvents_isRemote", (numCreate + numCreateIsLoad) * (long)numVmsWithList));
            al.add(new ExpCounterValue("numCreateTxEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numCreateTxEvents_isRemote", (numCreate + numCreateIsLoad) * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numCreateTxEvents_isNotRemote", numCreate + numCreateIsLoad + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        }
        al.add(new ExpCounterValue("numCreateTxEvents_isLoad", numCreateIsLoad * (long)numVmsWithList + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLoad", numCreate * (long)numVmsWithList + numCreateInDestroyedRegion));
        al.add(new ExpCounterValue("numCreateTxEvents_isLocalLoad", numCreateIsLoad * (long)numVmsWithList + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotLocalLoad", numCreate * (long)numVmsWithList + numCreateInDestroyedRegion));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetLoad", (numCreate + numCreateIsLoad) * (long)numVmsWithList + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numCreateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numCreateTxEvents_isNotNetSearch", (numCreate + numCreateIsLoad) * (long)numVmsWithList + numCreateInDestroyedRegion + numCreateInDestroyedRegion_isLoad));
        al.add(new ExpCounterValue("numDestroyTxEvents_isDist", numDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotExp", numDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numDestroyTxEvents_isRemote", numDestroy * (long)numVmsWithList));
            al.add(new ExpCounterValue("numDestroyTxEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numDestroyTxEvents_isRemote", numDestroy * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numDestroyTxEvents_isNotRemote", numDestroy + numConflatedCreateDestroy));
        }
        al.add(new ExpCounterValue("numDestroyTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLoad", numDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotLocalLoad", numDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetLoad", numDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numDestroyTxEvents_isNotNetSearch", numDestroy * (long)numVmsWithList + numConflatedCreateDestroy));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isDist", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotExp", numInval * (long)numVmsWithList));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numInvalidateTxEvents_isRemote", numInval * (long)numVmsWithList));
            al.add(new ExpCounterValue("numInvalidateTxEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numInvalidateTxEvents_isRemote", numInval * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numInvalidateTxEvents_isNotRemote", numInval));
        }
        al.add(new ExpCounterValue("numInvalidateTxEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotLocalLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotNetLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numInvalidateTxEvents_isNotNetSearch", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isDist", (numUpdate + numUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isExp", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotExp", (numUpdate + numUpdateIsLoad) * (long)numVmsWithList));
        if (this.isBridgeClient || this.isProxy) {
            al.add(new ExpCounterValue("numUpdateTxEvents_isRemote", (numUpdate + numUpdateIsLoad) * (long)numVmsWithList));
            al.add(new ExpCounterValue("numUpdateTxEvents_isNotRemote", 0L));
        } else {
            al.add(new ExpCounterValue("numUpdateTxEvents_isRemote", (numUpdate + numUpdateIsLoad) * (long)(numVmsWithList - 1)));
            al.add(new ExpCounterValue("numUpdateTxEvents_isNotRemote", numUpdate + numUpdateIsLoad));
        }
        al.add(new ExpCounterValue("numUpdateTxEvents_isLoad", numUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isLocalLoad", numUpdateIsLoad * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotLocalLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetLoad", (numUpdate + numUpdateIsLoad) * (long)numVmsWithList));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numUpdateTxEvents_isNotNetSearch", (numUpdate + numUpdateIsLoad) * (long)numVmsWithList));
        if (bb instanceof TxEventCountersBB) {
            ((TxEventCountersBB)bb).checkEventCounters(al);
        } else {
            ((TxWriterCountersBB)bb).checkEventCounters(al);
        }
    }

    public void setupCommitTestCallbacks(String commitStatePrm) {
        if (this.isProxy && TxPrms.killRemoteTxVm()) {
            this.setupRemoteCallbacks(commitStatePrm);
        } else {
            TXStateInterface txState = TxHelper.getTxState();
            int commitStateTrigger = TxPrms.getCommitStateTrigger(commitStatePrm);
            TxBB.getBB().getSharedMap().put(TxBB.CommitStateTrigger, new Integer(commitStateTrigger));
            Log.getLogWriter().info("TxPrms.commitStateTrigger = " + commitStatePrm + "(" + commitStateTrigger + ")");
            switch (commitStateTrigger) {
                case 0: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 1: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 2: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void beforeSend(TXStateProxy tx, boolean rollback) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 3: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 4: {
                    throw new TestException("TODO: Not valid with new model; remove");
                }
                case 5: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void duringIndividualCommit(TXStateProxy tx, Object callbackArg) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 6: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterIndividualCommit(TXStateProxy tx, Object callbackArg) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 7: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterApplyChanges(TXStateProxy tx) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 8: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterReleaseLocalLocks(TXStateProxy tx) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 9: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterSend(TXStateProxy tx, boolean rollback) {
                            CommitTestCallback.run();
                        }
                    });
                    break;
                }
                case 10: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterSend(TXStateProxy tx, boolean rollback) {
                            if (!rollback) {
                                CommitTestCallback.run();
                            }
                        }
                    });
                    break;
                }
                case 11: {
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public void afterSend(TXStateProxy tx, boolean rollback) {
                            if (rollback) {
                                CommitTestCallback.run();
                            }
                        }
                    });
                    break;
                }
                default: {
                    throw new TestException("Unexpected commitStateTrigger " + TxPrms.toStringForCommitStateTrigger(commitStateTrigger));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killCommittor() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killCommittor ...");
        Object object = killSyncObject;
        synchronized (object) {
            try {
                killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killCommittor interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        int stopMode = -21;
        String commitStatePrm = TestConfig.tab().stringAt(TxPrms.commitStateTrigger, null);
        if (commitStatePrm != null && TxPrms.getCommitStateTrigger(commitStatePrm) == 6) {
            stopMode = -20;
        }
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing comittor", stopMode, -32);
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_waitForDist() {
        MasterController.sleepForMs(60000);
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        if (timeToStop.equals(Boolean.TRUE)) {
            Object object = killSyncObject;
            synchronized (object) {
                Log.getLogWriter().info("waitForDist signalling killCommittor to stop waiting, commit completed");
                killSyncObject.notify();
            }
        }
    }

    public static void HydraCloseTask_verifyResourcesReleased() {
        Log.getLogWriter().info("HydraCloseTask_verifyResourcesReleased(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        viewTest.verifyResourcesReleased();
    }

    protected void verifyResourcesReleased() {
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList opList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        OpList txOpList = opList.collapse();
        Log.getLogWriter().info("Entered verifyResourcesReleased, reusing operations from " + txOpList.toString());
        boolean isVisible = this.updatesVisible();
        CollectionsTest validator = new CollectionsTest();
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Operation op = txOpList.getOperation(i);
            Log.getLogWriter().info("Executing operation " + op);
            TxHelper.begin();
            if (isVisible) {
                if (op.isEntryDestroy()) {
                    op.setOpName("entry-create");
                } else if (op.isEntryInvalidate()) {
                    op.setOpName("entry-update");
                } else {
                    op.setOpName("entry-update");
                }
                op.setNewValue(new Integer(0));
            }
            validator.executeOperation(op);
            try {
                TxHelper.commit();
                continue;
            }
            catch (ConflictException e) {
                throw new TestException("Unexpected ConflictException " + TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraCloseTask_validateTxConsistency() {
        Log.getLogWriter().info("HydraCloseTask_validateTxConsistency(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        viewTest.validateTxConsistency();
    }

    protected void validateTxConsistency() {
        Log.getLogWriter().info("Entered validateTxConsistency(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        try {
            this.validateTxOps(this.updatesVisible());
        }
        catch (TestException e) {
            Log.getLogWriter().info("Listing current values of each entry involved in the commit");
            String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
            OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
            for (int i = 0; i < txOpList.numOps(); ++i) {
                Operation op = txOpList.getOperation(i);
                String regionName = op.getRegionName();
                Region aRegion = CacheUtil.getCache().getRegion(regionName);
                String key = (String)op.getKey();
                Log.getLogWriter().info("Operation(" + i + ") = " + op.toString());
                Log.getLogWriter().info("Current value of <" + regionName + "><" + key + "> = <" + ViewTest.getValueInVM(aRegion, key) + ">");
            }
            throw e;
        }
    }

    protected boolean updatesVisible() {
        boolean isVisible = false;
        Integer mapValue = (Integer)TxBB.getBB().getSharedMap().get(TxBB.CommitStateTrigger);
        int commitStateTrigger = mapValue;
        Boolean listenerProcessedCommit = (Boolean)TxBB.getBB().getSharedMap().get("afterCommitProcessed");
        if (commitStateTrigger == 9 || commitStateTrigger == 8 || commitStateTrigger == 6 || listenerProcessedCommit.booleanValue()) {
            isVisible = true;
        }
        Log.getLogWriter().info("updatesVisible(" + TxPrms.toStringForCommitStateTrigger(commitStateTrigger) + ") returning " + isVisible);
        return isVisible;
    }

    public static Object getValueInVM(Region aRegion, Object key) {
        Object value = null;
        Region.Entry entry = aRegion.getEntry(key);
        if (entry != null && (value = entry.getValue()) == null) {
            value = Token.INVALID;
        }
        return value;
    }

    private void setupRemoteCallbacks(String commitStatePrm) {
        TXStateInterface txState = TxHelper.getTxState();
        TransactionId txId = TxHelper.getTransactionId();
        Set targetDMs = txState.getProxy().getFinishMessageRecipientsForTest();
        Log.getLogWriter().info("Invoking setupRemoteTestCallbacks with " + txId + " and trigger " + commitStatePrm + " on " + targetDMs);
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        SetupRemoteTestCallbacks f = new SetupRemoteTestCallbacks();
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add(txId);
        aList.add(commitStatePrm);
        Execution e = FunctionService.onMembers((Set)targetDMs).withArgs(aList);
        Log.getLogWriter().info("executing " + f.getId() + " on members " + targetDMs);
        ResultCollector rc = e.execute((Function)f);
        Log.getLogWriter().info("executed " + f.getId());
        Object result = rc.getResult();
    }

    static {
        killSyncObject = new Object();
    }

    static final class CommitTestCallback {
        CommitTestCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void run() {
            Object object = killSyncObject;
            synchronized (object) {
                Log.getLogWriter().info("product invoked CommitTestCallback, killSyncObject.notify() ...");
                killSyncObject.notify();
            }
            MasterController.sleepForMs(30000);
        }
    }
}

