/*
 * Decompiled with CFR 0.152.
 */
package tx.capCon;

import hydra.ClientDescription;
import hydra.Log;
import hydra.TestConfig;
import tx.TxUtil;
import tx.capCon.NoConflictTest;
import util.CacheUtil;
import util.TestException;

public class LRUNoConflictTest
extends NoConflictTest {
    protected int maximumEntries = -1;
    protected int highestAllowableEntries = -1;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            TxUtil.txUtilInstance = new TxUtil();
            testInstance = new LRUNoConflictTest();
            testInstance.initialize();
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.maximumEntries = CacheUtil.getRegion("capConRegion").getAttributes().getEvictionAttributes().getMaximum();
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        int numThreads = cd.getVmThreads();
        this.highestAllowableEntries = this.maximumEntries + numThreads + 2;
        Log.getLogWriter().info("Setting limits: numThreads = " + numThreads + " maximumEntries = " + this.maximumEntries + ", highestAllowableEntries = " + this.highestAllowableEntries);
    }

    @Override
    protected void verifyCapacity() {
        int numKeys = this.aRegion.keys().size();
        Log.getLogWriter().info("In verifyNumKeys, numKeys is " + numKeys);
        if (numKeys > this.highestAllowableEntries) {
            throw new TestException("Expected num keys to be <= " + this.highestAllowableEntries + ", but num keys for " + this.aRegion.getFullPath() + " is " + numKeys + ", " + this.toString());
        }
    }

    @Override
    protected void fill() {
        Log.getLogWriter().info("Filling with " + this.maximumEntries + " entries...");
        for (int i = 1; i <= this.maximumEntries; ++i) {
            TxUtil.txUtilInstance.createEntry(this.aRegion, false);
            this.verifyCapacity();
        }
    }
}

