/*
 * Decompiled with CFR 0.152.
 */
package useCase13Scenarios;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.Log;
import hydra.MasterController;
import hydra.StopSchedulingOrder;
import hydra.blackboard.SharedCounters;
import java.util.List;
import useCase13Scenarios.UseCase13BB;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class UseCase13Client
extends CachePerfClient {
    public static void putDataTask() {
        UseCase13Client c = new UseCase13Client();
        c.initialize(3);
        c.putData();
    }

    private void putData() {
        CachePerfClient.putDataTask();
        SharedCounters sc = UseCase13BB.getBB().getSharedCounters();
        sc.setIfLarger(UseCase13BB.numOperationsCompleted, this.count);
        Log.getLogWriter().info("putData: numOperationsCompleted = " + sc.read(UseCase13BB.numOperationsCompleted));
    }

    public static void closeCacheTask() {
        UseCase13Client c = new UseCase13Client();
        c.initHydraThreadLocals();
        c.closeCache();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeCache() {
        super.closeCache();
    }

    public static void killDuringDiskRecovery() throws ClientVmNotFoundException {
        UseCase13Client c = new UseCase13Client();
        c.initHydraThreadLocals();
        c._killDuringDiskRecovery();
        c.updateHydraThreadLocals();
    }

    private void _killDuringDiskRecovery() throws ClientVmNotFoundException {
        UseCase13Client.log().info("killDuringDiskRecovery: waiting for DiskStoreStatistics(disk).recoveriesInProgress");
        while (TestHelper.getStat_getRecoveriesInProgress("disk") == 0) {
            UseCase13Client.log().fine("monitorDiskRecovery: waiting for recoveriesInProgress > 0 ...");
            MasterController.sleepForMs(100);
        }
        UseCase13Client.log().info("diskRecovery is IN PROGRESS");
        List targetVMs = StopStartVMs.getAllVMs();
        ClientVmInfo info = (ClientVmInfo)targetVMs.get(0);
        ClientVmMgr.stopAsync("disk recovery is in progress", -21, -32, info);
    }

    public static void killAfterMinOps() throws ClientVmNotFoundException {
        UseCase13Client c = new UseCase13Client();
        c.initHydraThreadLocals();
        c._killAfterMinOps();
        c.updateHydraThreadLocals();
    }

    private void _killAfterMinOps() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killAfterMinOps ...");
        int minimumNumOpsBeforeKill = CachePerfPrms.getMaxKeys() * 3;
        try {
            TestHelper.waitForCounter(UseCase13BB.getBB(), "UseCase13BB.numOperationsCompleted", UseCase13BB.numOperationsCompleted, minimumNumOpsBeforeKill, false, 60000L, 2000L);
        }
        catch (TestException e) {
            return;
        }
        List targetVMs = StopStartVMs.getAllVMs();
        ClientVmInfo info = (ClientVmInfo)targetVMs.get(0);
        ClientVmMgr.stopAsync("minimum number of ops (" + minimumNumOpsBeforeKill + ") have completed", -21, -32, info);
        throw new StopSchedulingOrder("Killed " + info.toString());
    }
}

