/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.TransactionEvent;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import java.util.Collection;
import java.util.List;
import util.TestHelper;

public abstract class AbstractWriter {
    public final String CntrName_BeforeCreate_isDist = "numBeforeCreateEvents_isDist";
    public final String CntrName_BeforeCreate_isNotDist = "numBeforeCreateEvents_isNotDist";
    public final String CntrName_BeforeCreate_isExp = "numBeforeCreateEvents_isExp";
    public final String CntrName_BeforeCreate_isNotExp = "numBeforeCreateEvents_isNotExp";
    public final String CntrName_BeforeCreate_isRemote = "numBeforeCreateEvents_isRemote";
    public final String CntrName_BeforeCreate_isNotRemote = "numBeforeCreateEvents_isNotRemote";
    public final String CntrName_BeforeCreate_isLoad = "numBeforeCreateEvents_isLoad";
    public final String CntrName_BeforeCreate_isNotLoad = "numBeforeCreateEvents_isNotLoad";
    public final String CntrName_BeforeCreate_isLocalLoad = "numBeforeCreateEvents_isLocalLoad";
    public final String CntrName_BeforeCreate_isNotLocalLoad = "numBeforeCreateEvents_isNotLocalLoad";
    public final String CntrName_BeforeCreate_isNetLoad = "numBeforeCreateEvents_isNetLoad";
    public final String CntrName_BeforeCreate_isNotNetLoad = "numBeforeCreateEvents_isNotNetLoad";
    public final String CntrName_BeforeCreate_isNetSearch = "numBeforeCreateEvents_isNetSearch";
    public final String CntrName_BeforeCreate_isNotNetSearch = "numBeforeCreateEvents_isNotNetSearch";
    public final String CntrName_BeforeDestroy_isDist = "numBeforeDestroyEvents_isDist";
    public final String CntrName_BeforeDestroy_isNotDist = "numBeforeDestroyEvents_isNotDist";
    public final String CntrName_BeforeDestroy_isExp = "numBeforeDestroyEvents_isExp";
    public final String CntrName_BeforeDestroy_isNotExp = "numBeforeDestroyEvents_isNotExp";
    public final String CntrName_BeforeDestroy_isRemote = "numBeforeDestroyEvents_isRemote";
    public final String CntrName_BeforeDestroy_isNotRemote = "numBeforeDestroyEvents_isNotRemote";
    public final String CntrName_BeforeDestroy_isLoad = "numBeforeDestroyEvents_isLoad";
    public final String CntrName_BeforeDestroy_isNotLoad = "numBeforeDestroyEvents_isNotLoad";
    public final String CntrName_BeforeDestroy_isLocalLoad = "numBeforeDestroyEvents_isLocalLoad";
    public final String CntrName_BeforeDestroy_isNotLocalLoad = "numBeforeDestroyEvents_isNotLocalLoad";
    public final String CntrName_BeforeDestroy_isNetLoad = "numBeforeDestroyEvents_isNetLoad";
    public final String CntrName_BeforeDestroy_isNotNetLoad = "numBeforeDestroyEvents_isNotNetLoad";
    public final String CntrName_BeforeDestroy_isNetSearch = "numBeforeDestroyEvents_isNetSearch";
    public final String CntrName_BeforeDestroy_isNotNetSearch = "numBeforeDestroyEvents_isNotNetSearch";
    public final String CntrName_BeforeUpdate_isDist = "numBeforeUpdateEvents_isDist";
    public final String CntrName_BeforeUpdate_isNotDist = "numBeforeUpdateEvents_isNotDist";
    public final String CntrName_BeforeUpdate_isExp = "numBeforeUpdateEvents_isExp";
    public final String CntrName_BeforeUpdate_isNotExp = "numBeforeUpdateEvents_isNotExp";
    public final String CntrName_BeforeUpdate_isRemote = "numBeforeUpdateEvents_isRemote";
    public final String CntrName_BeforeUpdate_isNotRemote = "numBeforeUpdateEvents_isNotRemote";
    public final String CntrName_BeforeUpdate_isLoad = "numBeforeUpdateEvents_isLoad";
    public final String CntrName_BeforeUpdate_isNotLoad = "numBeforeUpdateEvents_isNotLoad";
    public final String CntrName_BeforeUpdate_isLocalLoad = "numBeforeUpdateEvents_isLocalLoad";
    public final String CntrName_BeforeUpdate_isNotLocalLoad = "numBeforeUpdateEvents_isNotLocalLoad";
    public final String CntrName_BeforeUpdate_isNetLoad = "numBeforeUpdateEvents_isNetLoad";
    public final String CntrName_BeforeUpdate_isNotNetLoad = "numBeforeUpdateEvents_isNotNetLoad";
    public final String CntrName_BeforeUpdate_isNetSearch = "numBeforeUpdateEvents_isNetSearch";
    public final String CntrName_BeforeUpdate_isNotNetSearch = "numBeforeUpdateEvents_isNotNetSearch";
    public final String CntrName_BeforeRegionDestroy_isDist = "numBeforeRegionDestroyEvents_isDist";
    public final String CntrName_BeforeRegionDestroy_isNotDist = "numBeforeRegionDestroyEvents_isNotDist";
    public final String CntrName_BeforeRegionDestroy_isExp = "numBeforeRegionDestroyEvents_isExp";
    public final String CntrName_BeforeRegionDestroy_isNotExp = "numBeforeRegionDestroyEvents_isNotExp";
    public final String CntrName_BeforeRegionDestroy_isRemote = "numBeforeRegionDestroyEvents_isRemote";
    public final String CntrName_BeforeRegionDestroy_isNotRemote = "numBeforeRegionDestroyEvents_isNotRemote";
    public final String CntrName_BeforeRegionClear_isDist = "numBeforeRegionClearEvents_isDist";
    public final String CntrName_BeforeRegionClear_isNotDist = "numBeforeRegionClearEvents_isNotDist";
    public final String CntrName_BeforeRegionClear_isExp = "numBeforeRegionClearEvents_isExp";
    public final String CntrName_BeforeRegionClear_isNotExp = "numBeforeRegionClearEvents_isNotExp";
    public final String CntrName_BeforeRegionClear_isRemote = "numBeforeRegionClearEvents_isRemote";
    public final String CntrName_BeforeRegionClear_isNotRemote = "numBeforeRegionClearEvents_isNotRemote";
    public int whereIWasRegistered = ProcessMgr.getProcessId();

    public String toString(String methodName, CacheEvent event) {
        StringBuffer aStr = new StringBuffer();
        String clientName = RemoteTestModule.getMyClientName();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + clientName + "\n");
        aStr.append("   whereIWasRegistered: " + this.whereIWasRegistered + "\n");
        if (event == null) {
            return aStr.toString();
        }
        if (event instanceof EntryEvent) {
            EntryEvent eEvent = (EntryEvent)event;
            aStr.append("   event.getKey(): " + eEvent.getKey() + "\n");
            aStr.append("   event.getOldValue(): " + this.getOldValueStr(eEvent) + "\n");
            aStr.append("   event.getNewValue(): " + this.getNewValueStr(eEvent) + "\n");
            aStr.append("   event.isLoad(): " + eEvent.isLoad() + "\n");
            aStr.append("   event.isLocalLoad(): " + eEvent.isLocalLoad() + "\n");
            aStr.append("   event.isNetLoad(): " + eEvent.isNetLoad() + "\n");
            aStr.append("   event.isNetSearch(): " + eEvent.isNetSearch() + "\n");
        }
        if (event instanceof RegionEvent) {
            RegionEvent rEvent = (RegionEvent)event;
            aStr.append("   event.isReinitializing(): " + rEvent.isReinitializing() + "\n");
        }
        aStr.append("   event.getMemberId(): " + event.getDistributedMember().toString() + "\n");
        aStr.append("   event.getCallbackArgument(): " + TestHelper.toString(event.getCallbackArgument()) + "\n");
        aStr.append("   event.getRegion(): " + TestHelper.regionToString(event.getRegion(), false) + "\n");
        aStr.append("   event.isDistributed(): " + event.isDistributed() + "\n");
        aStr.append("   event.isExpiration(): " + event.isExpiration() + "\n");
        aStr.append("   event.isOriginRemote(): " + event.isOriginRemote() + "\n");
        Operation op = event.getOperation();
        aStr.append("   Operation: " + op.toString() + "\n");
        if (op.isEntry()) {
            aStr.append("   Operation.isLoad(): " + op.isLoad() + "\n");
            aStr.append("   Operation.isLocalLoad(): " + op.isLocalLoad() + "\n");
            aStr.append("   Operation.isNetLoad(): " + op.isNetLoad() + "\n");
            aStr.append("   Operation.isNetSearch(): " + op.isNetSearch() + "\n");
        }
        aStr.append("   Operation.isDistributed(): " + op.isDistributed() + "\n");
        aStr.append("   Operation.isExpiration(): " + op.isExpiration() + "\n");
        return aStr.toString();
    }

    public String getOldValueStr(EntryEvent eEvent) {
        return TestHelper.toString(eEvent.getOldValue());
    }

    public String getNewValueStr(EntryEvent eEvent) {
        return TestHelper.toString(eEvent.getNewValue());
    }

    public String toString(String methodName, TransactionEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + RemoteTestModule.getMyClientName() + "\n");
        aStr.append("   whereIWasRegistered: " + this.whereIWasRegistered + "\n");
        if (event == null) {
            return aStr.toString();
        }
        aStr.append("   event.getTransactionId(): " + event.getTransactionId() + "\n");
        List txEvents = event.getEvents();
        aStr.append("TxEvent contains " + txEvents.size() + " entry events\n");
        aStr.append(this.getEntryEvents(txEvents));
        return aStr.toString();
    }

    private String getEntryEvents(Collection txEvents) {
        StringBuffer aStr = new StringBuffer();
        for (EntryEvent eEvent : txEvents) {
            aStr.append(this.toString(eEvent.getOperation().toString(), (CacheEvent)eEvent));
            aStr.append("\n");
        }
        return aStr.toString();
    }

    public String logTxEvent(String methodName, TransactionEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    public String logCall(String methodName, CacheEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    public void incrementBeforeCreateCounters(EntryEvent event, Blackboard bb) {
        SharedCounters counters = bb.getSharedCounters();
        if (event.isDistributed()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isDist"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotDist"));
        }
        if (event.isExpiration()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isExp"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotExp"));
        }
        if (event.isOriginRemote()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isRemote"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotRemote"));
        }
        if (event.isLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotLoad"));
        }
        if (event.isLocalLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isLocalLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotLocalLoad"));
        }
        if (event.isNetLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNetLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotNetLoad"));
        }
        if (event.isNetSearch()) {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNetSearch"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeCreateEvents_isNotNetSearch"));
        }
    }

    public void incrementBeforeDestroyCounters(EntryEvent event, Blackboard bb) {
        SharedCounters counters = bb.getSharedCounters();
        if (event.isDistributed()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isDist"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotDist"));
        }
        if (event.isExpiration()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isExp"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotExp"));
        }
        if (event.isOriginRemote()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isRemote"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotRemote"));
        }
        if (event.isLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotLoad"));
        }
        if (event.isLocalLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isLocalLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotLocalLoad"));
        }
        if (event.isNetLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNetLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotNetLoad"));
        }
        if (event.isNetSearch()) {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNetSearch"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeDestroyEvents_isNotNetSearch"));
        }
    }

    public void incrementBeforeUpdateCounters(EntryEvent event, Blackboard bb) {
        SharedCounters counters = bb.getSharedCounters();
        if (event.isDistributed()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isDist"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotDist"));
        }
        if (event.isExpiration()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isExp"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotExp"));
        }
        if (event.isOriginRemote()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isRemote"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotRemote"));
        }
        if (event.isLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotLoad"));
        }
        if (event.isLocalLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isLocalLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotLocalLoad"));
        }
        if (event.isNetLoad()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNetLoad"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotNetLoad"));
        }
        if (event.isNetSearch()) {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNetSearch"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeUpdateEvents_isNotNetSearch"));
        }
    }

    public void incrementBeforeRegionDestroyCounters(RegionEvent event, Blackboard bb) {
        SharedCounters counters = bb.getSharedCounters();
        if (event.isDistributed()) {
            counters.increment(bb.getSharedCounter("numBeforeRegionDestroyEvents_isDist"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeRegionDestroyEvents_isNotDist"));
        }
        if (event.isExpiration()) {
            counters.increment(bb.getSharedCounter("numBeforeRegionDestroyEvents_isExp"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeRegionDestroyEvents_isNotExp"));
        }
        if (event.isOriginRemote()) {
            counters.increment(bb.getSharedCounter("numBeforeRegionDestroyEvents_isRemote"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeRegionDestroyEvents_isNotRemote"));
        }
    }

    public void incrementBeforeRegionClearCounters(RegionEvent event, Blackboard bb) {
        SharedCounters counters = bb.getSharedCounters();
        if (event.isDistributed()) {
            counters.increment(bb.getSharedCounter("numBeforeRegionClearEvents_isDist"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeRegionClearEvents_isNotDist"));
        }
        if (event.isExpiration()) {
            counters.increment(bb.getSharedCounter("numBeforeRegionClearEvents_isExp"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeRegionClearEvents_isNotExp"));
        }
        if (event.isOriginRemote()) {
            counters.increment(bb.getSharedCounter("numBeforeRegionClearEvents_isRemote"));
        } else {
            counters.increment(bb.getSharedCounter("numBeforeRegionClearEvents_isNotRemote"));
        }
    }
}

