/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.OperationCancelledException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import util.TestHelper;

public class AlertLogListener
implements AlertListener {
    public void alert(Alert alert) {
        String alertStr = this.getAlertString(alert);
        Log.getLogWriter().info(alertStr);
    }

    protected String getAlertString(Alert alert) {
        int myPID = ProcessMgr.getProcessId();
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + " in client with vmID " + RemoteTestModule.getMyVmid() + ", pid " + myPID + "\n");
        aStr.append("   alert.getConnectionName(): " + alert.getConnectionName() + "\n");
        aStr.append("   alert.getDate(): " + alert.getDate() + "\n");
        aStr.append("   alert.getLevel(): " + alert.getLevel() + "\n");
        aStr.append("   alert.getMessage(): " + alert.getMessage() + "\n");
        aStr.append("   alert.getSourceId(): " + alert.getSourceId() + "\n");
        try {
            aStr.append("   alert.getSystemMember(): " + alert.getSystemMember());
        }
        catch (OperationCancelledException e) {
            String errStr = "Bug 39657; Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
        }
        return aStr.toString();
    }
}

