/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.control.ResourceManager;
import hydra.Log;
import util.CacheUtil;
import util.Definition;
import util.TestException;

public class CacheDefinition
extends Definition {
    private Boolean copyOnRead = null;
    private Integer lockTimeout = null;
    private Integer lockLease = null;
    private Integer searchTimeout = null;
    private Float evictionHeapPercentage = null;
    private Float criticalHeapPercentage = null;
    private static final String COPY_ON_READ_TOKEN = "copyOnRead";
    private static final String LOCK_TIMEOUT_TOKEN = "lockTimeout";
    private static final String LOCK_LEASE_TOKEN = "lockLease";
    private static final String SEARCH_TIMEOUT_TOKEN = "searchTimeout";
    private static final String EVICTION_HEAP_TOKEN = "evictionHeapPercentage";
    private static final String CRITICAL_HEAP_TOKEN = "criticalHeapPercentage";

    private CacheDefinition() {
    }

    @Override
    protected void initializeWithSpec(String cacheSpecStr) {
        String token;
        this.tokenArr = cacheSpecStr.split(ATTR_DELIM);
        this.specName = token = this.getNextToken();
        token = this.getNextToken();
        while (token != null) {
            if (token.equalsIgnoreCase(COPY_ON_READ_TOKEN)) {
                this.getTokenEquals();
                this.copyOnRead = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(LOCK_TIMEOUT_TOKEN)) {
                this.getTokenEquals();
                this.lockTimeout = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(LOCK_LEASE_TOKEN)) {
                this.getTokenEquals();
                this.lockLease = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(SEARCH_TIMEOUT_TOKEN)) {
                this.getTokenEquals();
                this.searchTimeout = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(EVICTION_HEAP_TOKEN)) {
                this.getTokenEquals();
                this.evictionHeapPercentage = this.getTokenFloat();
            } else if (token.equalsIgnoreCase(CRITICAL_HEAP_TOKEN)) {
                this.getTokenEquals();
                this.criticalHeapPercentage = this.getTokenFloat();
            } else {
                throw new TestException("Unknown keyword " + token);
            }
            token = this.getNextToken();
        }
    }

    @Override
    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append("CacheDefinition with name " + this.specName + "\n");
        aStr.append("   copyOnRead: " + this.copyOnRead + "\n");
        aStr.append("   lockTimeout: " + this.lockTimeout + "\n");
        aStr.append("   lockLease: " + this.lockLease + "\n");
        aStr.append("   searchTimeout: " + this.searchTimeout + "\n");
        aStr.append("   evictionHeapPercentage: " + this.evictionHeapPercentage + "\n");
        aStr.append("   criticalHeapPercentage: " + this.criticalHeapPercentage + "\n");
        return aStr.toString();
    }

    public Cache createCache(String xmlFile) {
        ResourceManager rm;
        Cache theCache = CacheUtil.getCache();
        if (theCache != null) {
            throw new TestException("Cache has already been created");
        }
        theCache = CacheUtil.createCache(xmlFile);
        if (this.copyOnRead != null) {
            theCache.setCopyOnRead(this.copyOnRead.booleanValue());
        }
        if (this.lockTimeout != null) {
            theCache.setLockTimeout(this.lockTimeout.intValue());
        }
        if (this.lockLease != null) {
            theCache.setLockLease(this.lockLease.intValue());
        }
        if (this.searchTimeout != null) {
            theCache.setSearchTimeout(this.searchTimeout.intValue());
        }
        if (this.evictionHeapPercentage != null) {
            rm = theCache.getResourceManager();
            rm.setEvictionHeapPercentage(this.evictionHeapPercentage.floatValue());
        }
        if (this.criticalHeapPercentage != null) {
            rm = theCache.getResourceManager();
            rm.setCriticalHeapPercentage(this.criticalHeapPercentage.floatValue());
        }
        Log.getLogWriter().info("Finished creating " + theCache + " with " + this);
        return theCache;
    }

    public Cache createCache() {
        return this.createCache(null);
    }

    public static CacheDefinition createCacheDefinition(Long hydraSpecParam, String specName) {
        CacheDefinition cacheDef = new CacheDefinition();
        cacheDef.getDefinition(hydraSpecParam, specName);
        return cacheDef;
    }

    public Boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public Integer getLockLease() {
        return this.lockLease;
    }

    public Integer getSearchTimeout() {
        return this.searchTimeout;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public void setCopyOnRead(boolean copyOnReadArg) {
        this.copyOnRead = new Boolean(copyOnReadArg);
    }

    public void setLockTimeout(int lockTimeoutArg) {
        this.lockTimeout = new Integer(lockTimeoutArg);
    }

    public void setLockLease(int lockLeaseArg) {
        this.lockLease = new Integer(lockLeaseArg);
    }

    public void setSearchTimeout(int searchTimeoutArg) {
        this.searchTimeout = new Integer(searchTimeoutArg);
    }

    public void setEvictionHeapPercentage(float pct) {
        this.evictionHeapPercentage = Float.valueOf(pct);
    }

    public void setCriticalHeapPercentage(float pct) {
        this.criticalHeapPercentage = Float.valueOf(pct);
    }
}

