/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientRegionDescription;
import hydra.ClientRegionHelper;
import hydra.DistributedConnectionMgr;
import hydra.DistributedSystemHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Set;
import util.CacheDefinition;
import util.CachePrms;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;

public class CacheUtil {
    private static final RegionAttributes DEFAULT_ATTRIBUTES = new AttributesFactory().createRegionAttributes();
    private static Cache TheCache;

    public static Cache createCache(String cacheXmlFile) {
        if (TheCache == null) {
            CacheUtil._createCache(cacheXmlFile);
        }
        return TheCache;
    }

    public static Cache createCache() {
        return CacheUtil.createCache(null);
    }

    public static void setCache(Cache c) {
        TheCache = c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void _createCache(String cacheXmlFile) {
        if (TheCache == null) {
            DistributedSystem ds = DistributedConnectionMgr.connect(cacheXmlFile);
            try {
                TheCache = CacheFactory.create((DistributedSystem)ds);
                int searchTimeout = TestConfig.tab().intAt(CachePrms.searchTimeout, -1);
                if (searchTimeout <= 0) return;
                TheCache.setSearchTimeout(searchTimeout);
                return;
            }
            catch (CacheException e) {
                String s = "Unable to create cache using: " + ds;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
        } else {
            if (cacheXmlFile == null) return;
            throw new HydraRuntimeException("Cannot honor " + cacheXmlFile + " because the cache is already open");
        }
    }

    public static Cache getCache() {
        return TheCache;
    }

    public static synchronized void closeCache() {
        if (TheCache != null) {
            TheCache.close();
            TheCache = null;
        }
    }

    public static synchronized void disconnect() {
        DistributedConnectionMgr.disconnect();
        TheCache = null;
    }

    public static Set getMembers() {
        return CacheUtil._getDM().getNormalDistributionManagerIds();
    }

    public static DistributedMember getMemberId() {
        return CacheUtil._getDM().getDistributionManagerId();
    }

    private static DM _getDM() {
        return ((GemFireCacheImpl)TheCache).getDistributedSystem().getDistributionManager();
    }

    public static boolean isAdminOnlyMember(DistributedMember mbr) {
        return ((InternalDistributedMember)mbr).getVmKind() == 12;
    }

    public static boolean isLocatorMember(DistributedMember mbr) {
        return ((InternalDistributedMember)mbr).getVmKind() == 11;
    }

    public static boolean isNormalMember(DistributedMember mbr) {
        return ((InternalDistributedMember)mbr).getVmKind() == 10;
    }

    public static boolean isLonerMember(DistributedMember mbr) {
        return ((InternalDistributedMember)mbr).getVmKind() == 13;
    }

    public static synchronized Region createRegion(String regionName) {
        return CacheUtil.createRegion(regionName, null);
    }

    public static synchronized Region createRegion(String regionName, RegionAttributes regionAttributes) {
        if (TheCache == null) {
            throw new HydraRuntimeException("The cache has not been created");
        }
        if (regionName == null) {
            throw new IllegalArgumentException("Region name is null");
        }
        try {
            if (regionAttributes == null) {
                regionAttributes = DEFAULT_ATTRIBUTES;
            }
            return TheCache.createVMRegion(regionName, regionAttributes);
        }
        catch (CacheException e) {
            throw new HydraRuntimeException("Unable to create region \"" + regionName + "\"", (Exception)((Object)e));
        }
    }

    public static synchronized Region createRegion(Region parentRegion, String regionName, RegionAttributes regionAttributes) {
        if (parentRegion == null) {
            throw new IllegalArgumentException("Parent region is null");
        }
        if (regionName == null) {
            throw new IllegalArgumentException("Region name is null");
        }
        try {
            if (regionAttributes == null) {
                return parentRegion.createSubregion(regionName, DEFAULT_ATTRIBUTES);
            }
            return parentRegion.createSubregion(regionName, regionAttributes);
        }
        catch (RegionExistsException e) {
            Region region = null;
            region = parentRegion.getSubregion(regionName);
            if (region == null) {
                throw new HydraRuntimeException("Unable to get region \"" + regionName + "\"");
            }
            if (!region.getAttributes().equals(regionAttributes)) {
                throw new HydraRuntimeException("Region \"" + regionName + "\" already exists with different attributes");
            }
            return region;
        }
    }

    public static Region createRegion(CacheDefinition cacheDef, RegionDefinition regDef, String xmlFile) {
        Region createdRegion = null;
        if (DistributedConnectionMgr.isConnected()) {
            Cache cache = cacheDef.createCache();
            createdRegion = CacheUtil.getRegion(regDef.getRegionName());
            if (createdRegion == null) {
                createdRegion = regDef.createRootRegion(cache, null, null, null, null);
            }
        } else if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile)) {
            Log.getLogWriter().info("Creating " + regDef.getRegionName() + " with " + xmlFile);
            cacheDef.createCache(xmlFile);
            createdRegion = CacheUtil.getRegion(regDef.getRegionName());
            if (createdRegion == null) {
                throw new TestException("Unexpected null region");
            }
            Log.getLogWriter().info("Finished creating " + TestHelper.regionToString(createdRegion, true) + " by using " + xmlFile);
        } else {
            createdRegion = regDef.createRootRegion(cacheDef.createCache(), null, null, null, null);
        }
        return createdRegion;
    }

    public static Region createRegion(String cacheDescriptName, String regionDescriptName, String xmlFile) {
        Region createdRegion = null;
        RegionDescription regDescript = RegionHelper.getRegionDescription(regionDescriptName);
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds != null && ds.isConnected()) {
            Cache theCache = CacheHelper.getCache();
            if (theCache == null) {
                theCache = CacheHelper.createCache(cacheDescriptName);
                createdRegion = theCache.getRegion(regDescript.getRegionName());
                if (createdRegion == null) {
                    createdRegion = RegionHelper.createRegion(regionDescriptName);
                }
            } else {
                createdRegion = RegionHelper.createRegion(regionDescriptName);
            }
        } else if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile)) {
            Log.getLogWriter().info("Creating " + regDescript.getRegionName() + " with " + xmlFile);
            Cache theCache = CacheHelper.createCacheFromXml(xmlFile);
            if (theCache == null) {
                throw new TestException("Unexpected null cache");
            }
            createdRegion = theCache.getRegion(regDescript.getRegionName());
            if (createdRegion == null) {
                throw new TestException("Unexpected null region");
            }
            Log.getLogWriter().info("Finished creating " + createdRegion.getFullPath() + " by using " + xmlFile);
        } else {
            Cache theCache = CacheHelper.createCache(cacheDescriptName);
            createdRegion = RegionHelper.createRegion(regionDescriptName);
        }
        return createdRegion;
    }

    public static Region createClientRegion(String cacheDescriptName, String regionDescriptName, String xmlFile) {
        Region createdRegion = null;
        ClientRegionDescription regDescript = ClientRegionHelper.getClientRegionDescription(regionDescriptName);
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds != null && ds.isConnected()) {
            ClientCache theCache = ClientCacheHelper.getCache();
            if (theCache == null) {
                theCache = ClientCacheHelper.createCache(cacheDescriptName);
                createdRegion = theCache.getRegion(regDescript.getRegionName());
                if (createdRegion == null) {
                    createdRegion = ClientRegionHelper.createRegion(regionDescriptName);
                }
            } else {
                createdRegion = ClientRegionHelper.createRegion(regionDescriptName);
            }
        } else if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile)) {
            Log.getLogWriter().info("Creating " + regDescript.getRegionName() + " with " + xmlFile);
            ClientCache theCache = ClientCacheHelper.createCacheFromXml(xmlFile);
            if (theCache == null) {
                throw new TestException("Unexpected null client cache");
            }
            createdRegion = theCache.getRegion(regDescript.getRegionName());
            if (createdRegion == null) {
                throw new TestException("Unexpected null region");
            }
            Log.getLogWriter().info("Finished creating " + createdRegion.getFullPath() + " by using " + xmlFile);
        } else {
            ClientCache theCache = ClientCacheHelper.createCache(cacheDescriptName);
            createdRegion = ClientRegionHelper.createRegion(regionDescriptName);
        }
        return createdRegion;
    }

    public static Region getRegion(String regionName) {
        if (TheCache == null) {
            throw new HydraRuntimeException("The cache has not been created");
        }
        if (regionName == null) {
            throw new IllegalArgumentException("Region name is null");
        }
        return TheCache.getRegion(regionName);
    }

    public static Region getRegion(Region region, String regionName) {
        if (region == null) {
            throw new IllegalArgumentException("Region is null");
        }
        if (regionName == null) {
            throw new IllegalArgumentException("Region name is null");
        }
        return region.getSubregion(regionName);
    }

    public static QueryService getQueryService() {
        if (TheCache == null) {
            throw new HydraRuntimeException("The cache has not been created");
        }
        return TheCache.getQueryService();
    }

    public static Object get(Region region, Object name) {
        if (region == null) {
            throw new IllegalArgumentException("Region is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        try {
            return region.get(name);
        }
        catch (Exception e) {
            String s = "Unable to get object \"" + region.getFullPath() + "/" + name + "\"";
            throw new HydraRuntimeException(s, e);
        }
    }

    public static void put(Region region, Object name, Object obj) {
        if (region == null) {
            throw new IllegalArgumentException("Region is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        try {
            region.put(name, obj);
        }
        catch (Exception e) {
            String s = "Unable to put object \"" + region.getFullPath() + "/" + name + "\"" + " with " + obj;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static void replace(Region region, Object name, Object obj) {
        if (region == null) {
            throw new IllegalArgumentException("Region is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        try {
            region.put(name, obj);
        }
        catch (Exception e) {
            String s = "Unable to replace object \"" + region.getFullPath() + "/" + name + "\"" + " with " + obj;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static void recoverableReplace(Region region, Object name, Object obj) {
        if (region == null) {
            throw new IllegalArgumentException("Region is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object is null");
        }
        String s = "Don't know how to implement this behavior in 3.0";
        throw new UnsupportedOperationException(s);
    }

    public static String getContentString(Region region, boolean recursive) {
        if (region == null) {
            throw new IllegalArgumentException("Region is null");
        }
        StringBuffer buf = new StringBuffer();
        Set set = region.entries(recursive);
        for (Region.Entry entry : set) {
            buf.append("[");
            buf.append(entry.getRegion().getFullPath());
            buf.append("]");
            buf.append(entry.getKey()).append("=");
            buf.append(entry.getValue()).append("\n");
        }
        return buf.toString();
    }

    public static void defineObjectAttributes(Region region, Object name) {
        try {
            region.create(name, null);
        }
        catch (CacheException e) {
            String s = "Unable to define object attributes for \"" + region.getFullPath() + "/" + name + "\"";
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    public static Set nameSet(Region region, boolean aBool) {
        if (aBool) {
            String s = "Recursive name set is not supported in 3.0";
            throw new UnsupportedOperationException(s);
        }
        return region.keys();
    }

    public static Set regionSet(Region region, boolean aBool) {
        return region.subregions(aBool);
    }

    public static RegionAttributes getRegionAttributes(Region region) {
        return region.getAttributes();
    }

    public static void invalidateRegion(Region region) {
        try {
            region.invalidateRegion();
        }
        catch (Exception e) {
            throw new HydraRuntimeException(TestHelper.getStackTrace(e));
        }
    }

    public static void destroyRegion(Region region) {
        try {
            region.destroyRegion();
        }
        catch (Exception e) {
            throw new HydraRuntimeException(TestHelper.getStackTrace(e));
        }
    }
}

