/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import management.test.cli.CommandTest;
import util.CliBB;
import util.CliHelperPrms;
import util.TestException;
import util.TestHelper;

public class CliHelper {
    protected static DistributedLockService lockService;
    protected static final String LOCK_SERVICE_NAME = "CliLockService";
    protected static final String lockObj = "cliLockObject";
    protected static final String COMMAND_KEY = "CliHelper_command";
    protected static final String HALT_KEY = "CliHelper_halt";
    protected static final String COMMAND_OUTPUT_TEXT_KEY = "CliHelper_commandOutputText";
    protected static final String PRESENTATION_STR_KEY = "CliHelper_presentationStr";
    public static final String START_NEW_CLI = "StartNewCLI";
    public static final String CONNECT_CLI = "ConnectCLI";

    public static synchronized String[] execCommand(String command, boolean haltOnCommandFailure) {
        if (CliHelperPrms.getExecuteRemote()) {
            return CliHelper.execCommandOnRemoteCli(command, haltOnCommandFailure);
        }
        return CliHelper.execCommandLocally(command, haltOnCommandFailure);
    }

    public static synchronized String[] execCommandLocally(String command, boolean haltOnCommandFailure) {
        if (command.equals(START_NEW_CLI)) {
            Log.getLogWriter().info("Directive to start a new cli instance...");
            CommandTest.testInstance.shell = null;
            CommandTest.testInstance.initShell();
            return new String[]{"", ""};
        }
        if (command.equals(CONNECT_CLI)) {
            Log.getLogWriter().info("Directive to connect cli...");
            return CommandTest.connectCLI();
        }
        return CommandTest.testInstance.execCommand(command, haltOnCommandFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String[] execCommandOnRemoteCli(String command, boolean haltOnCommandFailure) {
        if (lockService == null) {
            Log.getLogWriter().info("Creating lock service CliLockService");
            lockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service CliLockService");
        }
        try {
            lockService.lock((Object)lockObj, -1L, -1L);
            Log.getLogWriter().info("Requesting command " + command + " be executed on remote cli jvm");
            SharedMap sharedMap = CliBB.getBB().getSharedMap();
            SharedCounters sharedCounters = CliBB.getBB().getSharedCounters();
            sharedCounters.zero(CliBB.commandComplete);
            sharedMap.put(COMMAND_KEY, command);
            sharedMap.put(HALT_KEY, haltOnCommandFailure);
            sharedCounters.increment(CliBB.commandWaiting);
            TestHelper.waitForCounter(CliBB.getBB(), "commandComplete", CliBB.commandComplete, 1L, true, -1L, 250L);
            String outputText = (String)sharedMap.get(COMMAND_OUTPUT_TEXT_KEY);
            String presentationStr = (String)sharedMap.get(PRESENTATION_STR_KEY);
            String[] stringArray = new String[]{outputText, presentationStr};
            return stringArray;
        }
        finally {
            lockService.unlock((Object)lockObj);
        }
    }

    public static synchronized void HydraTask_execCommandFromBB() {
        try {
            TestHelper.waitForCounter(CliBB.getBB(), "commandWaiting", CliBB.commandWaiting, 1L, true, 30000L, 500L);
        }
        catch (TestException e) {
            return;
        }
        SharedCounters sharedCounters = CliBB.getBB().getSharedCounters();
        String command = (String)CliBB.getBB().getSharedMap().get(COMMAND_KEY);
        Boolean halt = (Boolean)CliBB.getBB().getSharedMap().get(HALT_KEY);
        Log.getLogWriter().info("Obtained command " + command + " with halt " + halt);
        String[] result = CliHelper.execCommandLocally(command, halt);
        SharedMap sharedMap = CliBB.getBB().getSharedMap();
        sharedMap.put(COMMAND_OUTPUT_TEXT_KEY, result[0]);
        sharedMap.put(PRESENTATION_STR_KEY, result[1]);
        sharedCounters.zero(CliBB.commandWaiting);
        sharedCounters.increment(CliBB.commandComplete);
    }
}

