/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import hydra.GemFirePrms;
import hydra.TestConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import util.CacheDefinition;
import util.DeclarativeGeneratorVersionHelper;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;

public class DeclarativeGenerator {
    public static void createDeclarativeXml(String xmlFileSpec, Cache aCache, boolean includeKeysValues, boolean useDTD) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(new File(xmlFileSpec)));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        CacheXmlGenerator.generate((Cache)aCache, (PrintWriter)pw, (!useDTD ? 1 : 0) != 0, (boolean)includeKeysValues);
    }

    public static void createDeclarativeXml(String xmlFileSpec, CacheDefinition cacheDef, RegionDefinition rootRegion, boolean useDTD) {
        ArrayList<RegionDefinition> aList = new ArrayList<RegionDefinition>();
        aList.add(rootRegion);
        DeclarativeGenerator.createDeclarativeXml(xmlFileSpec, cacheDef, aList, useDTD);
    }

    public static void createDeclarativeXml(String xmlFileSpec, CacheDefinition cacheDef, ArrayList rootRegions, boolean useDTD) {
        CacheCreation fakeCache = DeclarativeGenerator.createFakeCache(cacheDef);
        for (int i = 0; i < rootRegions.size(); ++i) {
            RegionDefinition regDef = (RegionDefinition)rootRegions.get(i);
            RegionAttributes attr = DeclarativeGenerator.createFakeRegionAttr(regDef, fakeCache);
            Region fakeRootRegion = null;
            String regionName = regDef.getRegionName();
            if (regionName == null) {
                throw new TestException("Cannot create a cache xml file for " + regDef + " because it does not contain \"regionName = <name>\"");
            }
            try {
                fakeRootRegion = fakeCache.createVMRegion(regionName, attr);
            }
            catch (RegionExistsException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            ArrayList subregions = regDef.getSubregions();
            for (int j = 0; j < subregions.size(); ++j) {
                RegionDefinition subRegDef = (RegionDefinition)subregions.get(j);
                DeclarativeGenerator.createFakeSubregion(subRegDef, fakeRootRegion);
            }
        }
        DeclarativeGenerator.createDeclarativeXml(xmlFileSpec, (Cache)fakeCache, false, useDTD);
    }

    private static RegionAttributes createFakeRegionAttr(RegionDefinition regDef, CacheCreation cc) {
        Boolean parReg;
        ExpirationAttributes expAttr;
        String offHeapMemorySize;
        RegionAttributesCreation attr = new RegionAttributesCreation(cc);
        if (regDef.getScope() != null) {
            attr.setScope(regDef.getScope());
        }
        if (regDef.getMirroring() != null) {
            attr.setMirrorType(regDef.getMirroring());
        }
        DeclarativeGenerator.setConcurrencyChecksEnabled(regDef, attr);
        if (regDef.getCacheListeners() != null) {
            List listenerList = regDef.getCacheListeners();
            for (int i = 0; i < listenerList.size(); ++i) {
                attr.addCacheListener((CacheListener)TestHelper.createInstance((String)listenerList.get(i)));
            }
        }
        if (regDef.getEviction() != null) {
            attr.setEvictionAttributes(regDef.getEvictionAttributes());
        }
        if (regDef.getCacheLoader() != null) {
            attr.setCacheLoader((CacheLoader)TestHelper.createInstance(regDef.getCacheLoader()));
        }
        if (regDef.getCacheWriter() != null) {
            attr.setCacheWriter((CacheWriter)TestHelper.createInstance(regDef.getCacheWriter()));
        }
        if (regDef.getConcurrencyLevel() != null) {
            attr.setConcurrencyLevel(regDef.getConcurrencyLevel().intValue());
        }
        if (regDef.getEnableOffHeapMemory() != null && regDef.getEnableOffHeapMemory().equalsIgnoreCase("ifOffHeapMemoryConfigured") && (offHeapMemorySize = TestConfig.tab().stringAt(GemFirePrms.offHeapMemorySize, null)) != null && offHeapMemorySize.charAt(0) != '0') {
            attr.setEnableOffHeapMemory(true);
        }
        if (regDef.getKeyConstraint() != null) {
            attr.setKeyConstraint(regDef.getKeyConstraint());
        }
        if (regDef.getValueConstraint() != null) {
            attr.setValueConstraint(regDef.getValueConstraint());
        }
        if (regDef.getLoadFactor() != null) {
            attr.setLoadFactor(regDef.getLoadFactor().floatValue());
        }
        if (regDef.getStatisticsEnabled() != null) {
            attr.setStatisticsEnabled(regDef.getStatisticsEnabled().booleanValue());
        }
        if (regDef.getIndexMaintenanceSynchronous() != null) {
            attr.setIndexMaintenanceSynchronous(regDef.getIndexMaintenanceSynchronous().booleanValue());
        }
        if (regDef.getPersistBackup() != null) {
            attr.setPersistBackup(regDef.getPersistBackup().booleanValue());
        }
        if (regDef.getIsSynchronous() != null) {
            attr.setDiskWriteAttributes(regDef.getDiskWriteAttributes());
        }
        if (regDef.getNumDiskDirs() != null) {
            attr.setDiskDirs(regDef.getDiskDirFileArr());
        }
        if (regDef.getMulticastEnabled() != null) {
            attr.setMulticastEnabled(regDef.getMulticastEnabled().booleanValue());
        }
        if (regDef.getDataPolicy() != null) {
            attr.setDataPolicy(regDef.getDataPolicy());
        }
        if (regDef.getSubscriptionAttributes() != null) {
            attr.setSubscriptionAttributes(regDef.getSubscriptionAttributes());
        }
        if ((expAttr = regDef.getRegionTTL()) != null) {
            attr.setRegionTimeToLive(expAttr);
        }
        if ((expAttr = regDef.getRegionIdleTimeout()) != null) {
            attr.setRegionIdleTimeout(expAttr);
        }
        if ((expAttr = regDef.getEntryTTL()) != null) {
            attr.setEntryTimeToLive(expAttr);
        }
        if ((expAttr = regDef.getEntryIdleTimeout()) != null) {
            attr.setEntryIdleTimeout(expAttr);
        }
        if ((parReg = regDef.getPartitionedRegion()) != null && parReg.booleanValue()) {
            PartitionAttributesFactory parFac = new PartitionAttributesFactory();
            expAttr = regDef.getParRegEntryTTL();
            expAttr = regDef.getParRegEntryIdleTimeout();
            if (regDef.getParRegLocalProperties() != null) {
                parFac.setLocalProperties(regDef.getParRegLocalProperties());
            }
            if (regDef.getParRegGlobalProperties() != null) {
                parFac.setGlobalProperties(regDef.getParRegGlobalProperties());
            }
            if (regDef.getParRegRedundantCopies() != null) {
                parFac.setRedundantCopies(regDef.getParRegRedundantCopies().intValue());
            }
            if (regDef.getParRegPartitionResolver() != null) {
                PartitionResolver instance = (PartitionResolver)TestHelper.createInstance(regDef.getParRegPartitionResolver());
                parFac.setPartitionResolver(instance);
            }
            if (regDef.getColocatedWith() != null) {
                parFac.setColocatedWith(regDef.getColocatedWith());
            }
            PartitionAttributes parRegAttr = parFac.create();
            attr.setPartitionAttributes(parRegAttr);
        }
        return attr;
    }

    private static CacheCreation createFakeCache(CacheDefinition cacheDef) {
        Integer anInt;
        CacheCreation fakeCache = new CacheCreation();
        Boolean aBool = cacheDef.getCopyOnRead();
        if (aBool != null) {
            fakeCache.setCopyOnRead(aBool.booleanValue());
        }
        if ((anInt = cacheDef.getLockTimeout()) != null) {
            fakeCache.setLockTimeout(anInt.intValue());
        }
        if ((anInt = cacheDef.getSearchTimeout()) != null) {
            fakeCache.setSearchTimeout(anInt.intValue());
        }
        return fakeCache;
    }

    private static Region createFakeSubregion(RegionDefinition regDef, Region fakeParent) {
        RegionAttributes attr = DeclarativeGenerator.createFakeRegionAttr(regDef, (CacheCreation)fakeParent.getCache());
        Region fakeSubRegion = null;
        String regionName = regDef.getRegionName();
        if (regionName == null) {
            throw new TestException("Cannot create a cache xml file for " + regDef + " because it does not contain \"regionName = <name>\"");
        }
        try {
            fakeSubRegion = fakeParent.createSubregion(regDef.getRegionName(), attr);
        }
        catch (RegionExistsException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        ArrayList subregions = regDef.getSubregions();
        for (int i = 0; i < subregions.size(); ++i) {
            RegionDefinition subRegDef = (RegionDefinition)subregions.get(i);
            DeclarativeGenerator.createFakeSubregion(subRegDef, fakeSubRegion);
        }
        return fakeSubRegion;
    }

    private static RegionAttributes setConcurrencyChecksEnabled(RegionDefinition regDef, RegionAttributesCreation attr) {
        attr = DeclarativeGeneratorVersionHelper.setConcurrencyChecksEnabled(regDef, attr);
        return attr;
    }
}

