/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.GsRandom;
import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public abstract class Definition
implements Serializable {
    protected String specName;
    protected Map specMap;
    protected static GsRandom RegDefRand = TestConfig.tab().getRandGen();
    protected static String SPEC_NAME_DELIM = "[\\s]*([s|S][p|P][e|E][c|C][n|N][a|A][m|M][e|E])[\\s]*=[\\s]*";
    protected static String WHITE_SPACE_DELIM = "[\\s]+";
    protected static String ATTR_DELIM = "[\\s]+|[,][\\s]+";
    protected static String SPEC_TERMINATOR = ":";
    protected String[] tokenArr;
    protected int tokenIndex = -1;

    protected abstract void initializeWithSpec(String var1);

    public abstract String toString();

    protected void getDefinition(Long hydraSpecParam, String specName) {
        this.initializeSpecMap(hydraSpecParam);
        String specStr = (String)this.specMap.get(specName);
        if (specStr == null) {
            StringBuffer errStr = new StringBuffer();
            errStr.append("Did not find specName " + specName + "; defined specNames are ");
            Iterator it = this.specMap.keySet().iterator();
            while (it.hasNext()) {
                errStr.append(" " + it.next());
            }
            throw new TestException(errStr.toString());
        }
        this.initializeWithSpec(specStr);
    }

    protected synchronized void initializeSpecMap(Long hydraSpecParam) {
        if (this.specMap != null) {
            return;
        }
        String spec = TestConfig.tab().stringAt(hydraSpecParam);
        this.specMap = new HashMap();
        Log.getLogWriter().fine("Initializing spec map...");
        String[] specArr = spec.split(SPEC_NAME_DELIM);
        Log.getLogWriter().fine("After splitting to get separate specs, specArr is length " + specArr.length);
        for (int i = 0; i < specArr.length; ++i) {
            String specStr = specArr[i];
            Log.getLogWriter().fine("sp[" + i + "] is *" + specStr + "*");
            if (specStr.length() == 0) continue;
            String[] tokensArr = specStr.split(ATTR_DELIM);
            Log.getLogWriter().fine("   After splitting to get first token, tokensArr.length is " + tokensArr.length);
            for (int j = 0; j < tokensArr.length; ++j) {
                Log.getLogWriter().fine("   tokens[" + j + "] is #" + tokensArr[j] + "#]");
            }
            String specName = tokensArr[0];
            if (specName.length() == 0) {
                throw new TestException("SpecName is empty *" + specName + "*");
            }
            if (specName.endsWith(SPEC_TERMINATOR)) {
                specName = specName.substring(0, specName.length() - 1);
            }
            this.specMap.put(specName, specStr);
        }
        Log.getLogWriter().fine("SpecMap size is " + this.specMap.size());
        for (Object key : this.specMap.keySet()) {
            Log.getLogWriter().fine("   Key: *" + key + "*, value *" + this.specMap.get(key) + "*");
        }
    }

    protected String getNextToken() {
        if (this.tokenIndex + 1 < this.tokenArr.length) {
            ++this.tokenIndex;
            String token = this.tokenArr[this.tokenIndex];
            if (token.equals("")) {
                return this.getNextToken();
            }
            Log.getLogWriter().fine("Get next token, token is " + token);
            return token;
        }
        return null;
    }

    protected String getTokenEquals() {
        String token = this.getNextToken();
        if (!token.equals("=")) {
            throw new TestException("Expected token =, but got " + token + " from " + this.tokensToString());
        }
        Log.getLogWriter().fine("Got equals token " + token);
        return token;
    }

    protected List getTokenList() {
        String token;
        Log.getLogWriter().fine("Getting token list...");
        ArrayList<String> aList = new ArrayList<String>();
        while ((token = this.getNextToken()) != null && !token.equals(SPEC_TERMINATOR)) {
            if (token.endsWith(SPEC_TERMINATOR)) {
                aList.add(token.substring(0, token.length() - 1));
                break;
            }
            aList.add(token);
        }
        if (aList.size() == 0) {
            throw new TestException("Missing attributes " + this.tokensToString());
        }
        for (int i = 0; i < aList.size(); ++i) {
            Log.getLogWriter().fine("List(" + i + ") is " + aList.get(i));
        }
        return aList;
    }

    protected String getTokenFromList() {
        List aList = this.getTokenList();
        int randInt = RegDefRand.nextInt(0, aList.size() - 1);
        return (String)aList.get(randInt);
    }

    protected Boolean getTokenBoolean() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Log.getLogWriter().fine("Chose boolean " + token);
        return new Boolean(token);
    }

    protected String getTokenString() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Log.getLogWriter().fine("Chose string " + token);
        return token;
    }

    protected Integer getTokenInteger() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Log.getLogWriter().fine("Chose integer " + token);
        return new Integer(token);
    }

    protected Long getTokenLong() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Log.getLogWriter().fine("Chose long " + token);
        return new Long(token);
    }

    protected Float getTokenFloat() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Log.getLogWriter().fine("Chose float " + token);
        return new Float(token);
    }

    protected Class getTokenClass() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        try {
            Log.getLogWriter().fine("Chose class " + token);
            return Class.forName(token);
        }
        catch (ClassNotFoundException e) {
            throw new TestException("Could not find specified class: " + token + "\n" + this.tokensToString() + TestHelper.getStackTrace(e));
        }
    }

    protected String tokensToString() {
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < this.tokenArr.length; ++i) {
            if (i == this.tokenIndex) {
                aStr.append("<<ERROR near here>>>");
            }
            aStr.append(this.tokenArr[i] + " ");
        }
        return aStr.toString();
    }
}

