/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import java.util.Arrays;
import util.TestException;

public class KeyIntervals
implements Serializable {
    public static final int NONE = 1000;
    public static final int INVALIDATE = 1001;
    public static final int LOCAL_INVALIDATE = 1002;
    public static final int DESTROY = 1003;
    public static final int LOCAL_DESTROY = 1004;
    public static final int UPDATE_EXISTING_KEY = 1005;
    public static final int GET = 1006;
    private static final int FIRST_INTERVAL = 1000;
    private static final int LAST_INTERVAL = 1006;
    private static final int NO_INTERVAL = -1;
    private int numKeys;
    private int[] firstKey = new int[7];
    private int[] lastKey = new int[7];

    public KeyIntervals(int[] includeIntervals, int numKeys) {
        this.initKeyIntervals(includeIntervals, numKeys);
    }

    public KeyIntervals(int numKeys) {
        int[] ops = new int[7];
        for (int i = 1000; i <= 1006; ++i) {
            ops[i - 1000] = i;
        }
        this.initKeyIntervals(ops, numKeys);
    }

    private void initKeyIntervals(int[] includeIntervals, int numKeys) {
        Arrays.sort(includeIntervals);
        this.numKeys = numKeys;
        int numOps = includeIntervals.length;
        int numPerInterval = numKeys / numOps;
        int numLeftOver = numKeys % numOps;
        int startKey = 1;
        for (int i = 0; i < this.firstKey.length; ++i) {
            int whichInterval = i + 1000;
            int index = Arrays.binarySearch(includeIntervals, whichInterval);
            if (index >= 0) {
                int numInInterval = numPerInterval;
                if (numLeftOver > 0) {
                    ++numInInterval;
                    --numLeftOver;
                }
                this.firstKey[i] = startKey;
                this.lastKey[i] = startKey + numInInterval - 1;
                startKey = this.lastKey[i] + 1;
                continue;
            }
            this.firstKey[i] = -1;
            this.lastKey[i] = -1;
        }
    }

    public int getFirstKey(int whichInterval) {
        if (whichInterval >= 1000 && whichInterval <= 1006) {
            int key = this.firstKey[whichInterval - 1000];
            return key;
        }
        throw new TestException("Unknown interval " + whichInterval);
    }

    public int getLastKey(int whichInterval) {
        if (whichInterval >= 1000 && whichInterval <= 1006) {
            int key = this.lastKey[whichInterval - 1000];
            return key;
        }
        throw new TestException("Unknown interval " + whichInterval);
    }

    public int getNumKeys() {
        return this.numKeys;
    }

    public int getNumKeys(int whichInterval) {
        if (whichInterval >= 1000 && whichInterval <= 1006) {
            int firstKey = this.getFirstKey(whichInterval);
            int lastKey = this.getLastKey(whichInterval);
            if (firstKey == -1) {
                return 0;
            }
            return lastKey - firstKey + 1;
        }
        throw new TestException("Unknown interval " + whichInterval);
    }

    public String intervalToString(int whichInterval) {
        switch (whichInterval) {
            case 1000: {
                return "none";
            }
            case 1001: {
                return "invalidate";
            }
            case 1002: {
                return "localInvalidate";
            }
            case 1003: {
                return "destroy";
            }
            case 1004: {
                return "localDestroy";
            }
            case 1005: {
                return "updateExistingKey";
            }
            case 1006: {
                return "get";
            }
        }
        throw new TestException("Unknown interval " + whichInterval);
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < this.firstKey.length; ++i) {
            aStr.append(this.intervalToString(1000 + i) + ", firstKey: " + this.firstKey[i] + ", lastKey: " + this.lastKey[i] + "\n");
        }
        return aStr.toString();
    }

    public boolean keyInRange(int whichInterval, long keyIndex) {
        int firstKey = this.getFirstKey(whichInterval);
        int lastKey = this.getLastKey(whichInterval);
        return keyIndex >= (long)firstKey && keyIndex <= (long)lastKey;
    }

    public int opForKeyIndex(long keyIndex) {
        if (this.keyInRange(1000, keyIndex)) {
            return 1000;
        }
        if (this.keyInRange(1001, keyIndex)) {
            return 1001;
        }
        if (this.keyInRange(1002, keyIndex)) {
            return 1002;
        }
        if (this.keyInRange(1003, keyIndex)) {
            return 1003;
        }
        if (this.keyInRange(1004, keyIndex)) {
            return 1004;
        }
        if (this.keyInRange(1005, keyIndex)) {
            return 1005;
        }
        if (this.keyInRange(1006, keyIndex)) {
            return 1006;
        }
        return -1;
    }
}

