/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import util.TestException;
import util.TestHelper;

public class MethodCoordinator {
    private boolean completed = false;
    private String className = null;
    private String methodName = null;

    public MethodCoordinator(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    public synchronized Object executeOnce(Object receiver, Object[] args) {
        if (!this.completed) {
            Class<?> aClass = null;
            try {
                aClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Method[] methodArr = aClass.getDeclaredMethods();
            Method aMethod = null;
            for (int i = 0; i < methodArr.length && !(aMethod = methodArr[i]).getName().equals(this.methodName); ++i) {
            }
            if (aMethod == null) {
                throw new TestException("Unable to find " + this.methodName + " in " + this.className);
            }
            aMethod.setAccessible(true);
            try {
                Object returnObj = aMethod.invoke(receiver, args);
                this.completed = true;
                return returnObj;
            }
            catch (InvocationTargetException e) {
                throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        return null;
    }

    public boolean methodWasExecuted() {
        return this.completed;
    }
}

