/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import util.PRObserverBB;
import util.TestException;
import util.TestHelper;

public class PRObserver
extends InternalResourceManager.ResourceObserverAdapter {
    public static final String activityListKey = "activityList_vm_";
    public static final String rebalRecovStarted = "Rebalancing/recovery started at ";
    public static final String rebalRecovFinished = "Rebalancing/recovery finished at ";
    public static final String movingBucket = "Moving bucket at ";
    public static final String movingPrimary = "Moving primary at ";
    public static final String recoveryConflated = "Recovery conflated at ";
    private static boolean recordBucketMoves = false;
    private static boolean recordPrimaryMoves = false;

    public synchronized void rebalancingOrRecoveryStarted(Region region) {
        try {
            long startTime = System.currentTimeMillis();
            this._addToActivityList(rebalRecovStarted + new Date() + " startTime=" + startTime + " for " + region.getFullPath());
            PRObserverBB.getBB().getSharedCounters().setIfSmaller(PRObserverBB.rebalRecovStartTime, new Long(startTime));
            PRObserverBB.getBB().getSharedCounters().increment(PRObserverBB.rebalRecovStartCounter);
        }
        catch (Exception e) {
            Log.getLogWriter().severe(TestHelper.getStackTrace(e));
        }
    }

    public synchronized void rebalancingOrRecoveryFinished(Region region) {
        try {
            long finishTime = System.currentTimeMillis();
            Date finishDate = new Date();
            this.addFinishToActivityList(finishDate, finishTime, region);
            PRObserverBB.getBB().getSharedCounters().setIfLarger(PRObserverBB.rebalRecovFinishTime, finishTime);
        }
        catch (Exception e) {
            Log.getLogWriter().severe(TestHelper.getStackTrace(e));
        }
    }

    public synchronized void recoveryConflated(PartitionedRegion region) {
        try {
            this._addToActivityList(recoveryConflated + new Date() + " for " + region.getFullPath());
        }
        catch (Exception e) {
            Log.getLogWriter().severe(TestHelper.getStackTrace(e));
        }
    }

    public synchronized void movingBucket(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        if (recordBucketMoves) {
            String aStr = "moving bucket with ID " + bucketId + " in " + region.getFullPath() + " from " + source + " to " + target;
            Log.getLogWriter().info("PRObserver: " + aStr);
            this._addToActivityList(movingBucket + new Date() + "; " + aStr);
        }
    }

    public synchronized void movingPrimary(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        if (recordPrimaryMoves) {
            String aStr = "moving primary for bucket with ID " + bucketId + " in " + region.getFullPath() + " from " + source + " to " + target;
            Log.getLogWriter().info("PRObserver: " + aStr);
            this._addToActivityList(movingPrimary + new Date() + "; " + aStr);
        }
    }

    public static synchronized void installObserverHook() {
        Log.getLogWriter().info("Installing PRObserver");
        InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new PRObserver());
    }

    public static synchronized void installObserverHook(boolean recordBucketMovesArg, boolean recordPrimaryMovesArg) {
        Log.getLogWriter().info("Installing PRObserver");
        InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new PRObserver());
        recordBucketMoves = recordBucketMovesArg;
        recordPrimaryMoves = recordPrimaryMovesArg;
    }

    public static synchronized void initialize() {
        Log.getLogWriter().info("Initializing PRObserverBB counters");
        PRObserverBB.getBB().getSharedCounters().zero(PRObserverBB.rebalRecovStartTime);
        PRObserverBB.getBB().getSharedCounters().zero(PRObserverBB.rebalRecovFinishTime);
        PRObserverBB.getBB().getSharedCounters().zero(PRObserverBB.approxTimerStartTime);
        PRObserverBB.getBB().getSharedCounters().zero(PRObserverBB.rebalRecovStartCounter);
        PRObserverBB.getBB().getSharedCounters().add(PRObserverBB.rebalRecovStartTime, Long.MAX_VALUE);
        PRObserverBB.getBB().getSharedCounters().add(PRObserverBB.rebalRecovFinishTime, Long.MIN_VALUE);
        PRObserverBB.getBB().getSharedCounters().add(PRObserverBB.approxTimerStartTime, Long.MAX_VALUE);
        PRObserverBB.getBB().getSharedMap().clear();
    }

    public static synchronized void initialize(int vmId) {
        Log.getLogWriter().info("PRObserver: Removing activity list for vmId " + vmId);
        String key = activityListKey + vmId;
        PRObserverBB.getBB().getSharedMap().remove(key);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean waitForRebalRecovToStart(int vmID, long millisToWait, int millisToSleep) {
        Log.getLogWriter().info("PRObserver: Waiting " + millisToWait + " ms for vm " + vmID + " to start rebalancing/recovery...");
        key = "activityList_vm_" + vmID;
        waitStartTime = System.currentTimeMillis();
        block0: while (true) {
            if ((activityList = (List)PRObserverBB.getBB().getSharedMap().get(key)) == null) {
                continue;
            }
            i = 0;
            while (true) {
                if (i < activityList.size()) ** break;
                continue block0;
                activity = (String)activityList.get(i);
                if (activity.startsWith("Rebalancing/recovery started at ")) {
                    Log.getLogWriter().info("PRObserver: Rebalancing/recovery started in vmID " + vmID + " after waiting " + (System.currentTimeMillis() - waitStartTime) + " ms: " + PRObserver.activityListToString(activityList));
                    return true;
                }
                MasterController.sleepForMs(millisToSleep);
                waitTime = System.currentTimeMillis() - waitStartTime;
                if (waitTime > millisToWait) {
                    Log.getLogWriter().info("PRObserver: Rebalancing/recovery did not start in " + millisToWait + " ms");
                    return false;
                }
                ++i;
            }
            break;
        }
    }

    public static boolean waitForAnyRebalRecovToStart(long millisToWait, int millisToSleep) {
        Log.getLogWriter().info("PRObserver: Waiting " + millisToWait + " ms for vms to start rebalancing/recovery...");
        long recovStartTime = PRObserverBB.getBB().getSharedCounters().read(PRObserverBB.rebalRecovStartTime);
        long waitStartTime = System.currentTimeMillis();
        while (recovStartTime == Long.MAX_VALUE) {
            MasterController.sleepForMs(millisToSleep);
            recovStartTime = PRObserverBB.getBB().getSharedCounters().read(PRObserverBB.rebalRecovStartTime);
            long waitTime = System.currentTimeMillis() - waitStartTime;
            if (waitTime <= millisToWait) continue;
            Log.getLogWriter().info("PRObserver: Rebalancing/recovery did not start in " + millisToWait + " ms");
            return false;
        }
        Log.getLogWriter().info("PRObserver: Rebalancing/recovery started after waiting " + (System.currentTimeMillis() - waitStartTime) + " ms");
        return true;
    }

    public static void waitForRebalRecov(Object rebalRecovVMs, int numRecovRebalActivities, int numPRsToRebalRecov, List prNames, Object noRebalRecovVMs, boolean allowRecovConflation) {
        Log.getLogWriter().info("PRObserver: Waiting for " + numRecovRebalActivities + " rebalancing/recovery activit" + (numRecovRebalActivities == 1 ? "y" : "ies") + " in vm(s) " + rebalRecovVMs + "; rebalancing/recovering " + numPRsToRebalRecov + " PR(s), " + "recovery conflation allowed: " + allowRecovConflation + ", (optional specified PR names: " + prNames + ", optional vms expecting no rebalancing/recovery: " + noRebalRecovVMs + ")");
        if (prNames != null && prNames.size() != numPRsToRebalRecov) {
            throw new TestException("Test error; prNames is " + prNames + ", but numPRsToRebalRecov is " + numPRsToRebalRecov);
        }
        PRObserver.waitForEachVMToFinish(rebalRecovVMs, numRecovRebalActivities, numPRsToRebalRecov, prNames, allowRecovConflation);
        PRObserver.verifyNoRebalRecov(noRebalRecovVMs);
        Log.getLogWriter().info("PRObserver: Done waiting for " + numRecovRebalActivities + " rebalancing/recovery activit" + (numRecovRebalActivities == 1 ? "y" : "ies") + " in vm(s) " + rebalRecovVMs + "; rebalancing/recovering " + numPRsToRebalRecov + " PRs, " + "recovery conflation allowed: " + allowRecovConflation + ", (optional specified PR names: " + prNames + ", optional vms expecting no rebalancing/recovery: " + noRebalRecovVMs + ")");
    }

    public static void waitForRecovery(long recoveryDelay, long startupRecoveryDelay, Object startupRecoveryVMs, Object departedRecoveryVMs, int numDepartedRecoveries, int numPRsToRecover, List prNames, Object noRecoveryVMs) {
        if (recoveryDelay >= 0L) {
            if (departedRecoveryVMs instanceof List && ((List)departedRecoveryVMs).size() == 0) {
                Log.getLogWriter().info("No vms to recover due to departing, not waiting");
                return;
            }
            PRObserver.waitForRebalRecov(departedRecoveryVMs, numDepartedRecoveries, numPRsToRecover, prNames, noRecoveryVMs, true);
        }
        if (startupRecoveryDelay >= 0L) {
            if (startupRecoveryVMs instanceof List && ((List)startupRecoveryVMs).size() == 0) {
                Log.getLogWriter().info("No vms to recover on startup, not waiting");
                return;
            }
            PRObserver.waitForRebalRecov(startupRecoveryVMs, 1, numPRsToRecover, prNames, noRecoveryVMs, false);
        }
    }

    public static void verifyNoRebalRecov(Object noRebalRecovVMs) {
        if (noRebalRecovVMs == null) {
            return;
        }
        ArrayList<Object> aList = new ArrayList<Object>();
        if (noRebalRecovVMs instanceof List) {
            aList.addAll((List)noRebalRecovVMs);
        } else {
            aList.add(noRebalRecovVMs);
        }
        for (int i = 0; i < aList.size(); ++i) {
            Object anObj = aList.get(i);
            int vmID = -1;
            vmID = anObj instanceof Integer ? ((Integer)anObj).intValue() : ((ClientVmInfo)anObj).getVmid().intValue();
            String key = activityListKey + vmID;
            List activityList = (List)PRObserverBB.getBB().getSharedMap().get(key);
            if (activityList != null) {
                throw new TestException("Rebalancing/recovery ran for vmID " + vmID + ", but it was not expected; recovery activities for vmID " + vmID + ": " + PRObserver.activityListToString(activityList));
            }
            Log.getLogWriter().info("Rebalancing/recovery has not run for vmID " + vmID);
        }
    }

    protected static void waitForVMToFinish(Object rebalRecovVM, int numExpectedActivities, int numPRsToRebalRecov, List prNames, boolean allowConflation) {
        int vmId = -1;
        vmId = rebalRecovVM instanceof Integer ? ((Integer)rebalRecovVM).intValue() : ((ClientVmInfo)rebalRecovVM).getVmid().intValue();
        String key = activityListKey + vmId;
        while (true) {
            List activityList;
            if (PRObserver.completedActivities(activityList = (List)PRObserverBB.getBB().getSharedMap().get(key), numExpectedActivities, allowConflation, numPRsToRebalRecov, prNames, vmId)) {
                Log.getLogWriter().info("PRObserver: Completed " + numExpectedActivities + " rebalancing/recovery activities for each of " + numPRsToRebalRecov + " PR(s) in vmId " + vmId + (prNames == null ? "" : ", PR(s) " + prNames) + ": " + PRObserver.activityListToString(activityList));
                return;
            }
            Log.getLogWriter().info("PRObserver: Waiting for " + numExpectedActivities + " rebalancing/recovery activities for each of " + numPRsToRebalRecov + " PR(s) in vmId " + vmId + (prNames == null ? "" : ", PR(s) " + prNames) + ": " + PRObserver.activityListToString(activityList));
            MasterController.sleepForMs(2000);
        }
    }

    protected static void waitForEachVMToFinish(Object rebalRecovVMs, int numExpectedActivities, int numPRsToRebalRecov, List prNames, boolean allowConflation) {
        if (rebalRecovVMs instanceof Integer || rebalRecovVMs instanceof ClientVmInfo) {
            PRObserver.waitForVMToFinish(rebalRecovVMs, numExpectedActivities, numPRsToRebalRecov, prNames, allowConflation);
        } else if (rebalRecovVMs instanceof List) {
            List vmList = (List)rebalRecovVMs;
            if (vmList.size() == 0) {
                throw new TestException("Test error: vm list is empty");
            }
            for (int i = 0; i < vmList.size(); ++i) {
                PRObserver.waitForVMToFinish(vmList.get(i), numExpectedActivities, numPRsToRebalRecov, prNames, allowConflation);
            }
        } else {
            throw new TestException("Unknown vms: " + rebalRecovVMs);
        }
    }

    protected static boolean completedActivities(List activityList, int expectedNumActivities, boolean allowConflatedActivities, int numPRs, List prNames, int vmID) {
        int i;
        if (activityList == null) {
            return false;
        }
        ArrayList<String> regNames = new ArrayList<String>();
        ArrayList<Integer> finishedCount = new ArrayList<Integer>();
        ArrayList<Integer> conflatedCount = new ArrayList<Integer>();
        for (i = 0; i < activityList.size(); ++i) {
            String activity = (String)activityList.get(i);
            String regNameFromActivity = PRObserver.getRegionNameFromActivity(activity);
            int index = regNames.indexOf(regNameFromActivity);
            if (index < 0) {
                regNames.add(regNameFromActivity);
                finishedCount.add(new Integer(0));
                conflatedCount.add(new Integer(0));
                index = regNames.size() - 1;
            }
            if (activity.startsWith(rebalRecovFinished)) {
                finishedCount.set(index, new Integer((Integer)finishedCount.get(index) + 1));
                continue;
            }
            if (!activity.startsWith(recoveryConflated)) continue;
            if (!allowConflatedActivities) {
                throw new TestException("Found unexpected conflated activity for " + PRObserver.activityListToString(activityList) + " for vm " + vmID);
            }
            conflatedCount.set(index, new Integer((Integer)conflatedCount.get(index) + 1));
        }
        if (regNames.size() > numPRs) {
            throw new TestException("Unexpected regions experienced rebalancing/recovery activities for vm " + vmID + "; expected " + expectedNumActivities + " activities for each of " + numPRs + " PR(s) with optional region names: " + prNames + ", activities found: " + PRObserver.activityListToString(activityList) + ", regions found: " + regNames);
        }
        if (prNames != null) {
            for (i = 0; i < prNames.size(); ++i) {
                if (regNames.indexOf(prNames.get(i)) >= 0) continue;
                return false;
            }
        } else if (regNames.size() < numPRs) {
            return false;
        }
        for (i = 0; i < regNames.size(); ++i) {
            int conflated;
            int finished = (Integer)finishedCount.get(i);
            int sum = finished + (conflated = ((Integer)conflatedCount.get(i)).intValue());
            if (sum > expectedNumActivities) {
                throw new TestException("Too many rebalancing/recovery activities experienced in vm " + vmID + " for region " + regNames.get(i) + "; expected " + expectedNumActivities + " activities for each of " + numPRs + " PR(s) with optional region names: " + prNames + ", activities found: " + PRObserver.activityListToString(activityList));
            }
            if (sum < expectedNumActivities) {
                return false;
            }
            if (finished != 0) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addFinishToActivityList(Date finishDate, long finishTime, Region aRegion) {
        int vmId = RemoteTestModule.getMyVmid();
        String key = activityListKey + vmId;
        List activityList = (List)PRObserverBB.getBB().getSharedMap().get(key);
        if (activityList == null) {
            throw new TestException("Got a finish callback for recovery, but no previous recovery activities found");
        }
        String lastStartActivity = null;
        for (int i = 0; i < activityList.size(); ++i) {
            String activity = (String)activityList.get(i);
            if (!activity.startsWith(rebalRecovStarted)) continue;
            lastStartActivity = activity;
        }
        if (lastStartActivity == null) {
            throw new TestException("Got a finish activity, but did not find a previous start: " + PRObserver.activityListToString(activityList));
        }
        String searchStr = "startTime=";
        int index = lastStartActivity.indexOf(searchStr);
        if (index < 0) {
            String aStr = "Test error; Could not find start time in " + lastStartActivity;
            Log.getLogWriter().info(aStr);
            throw new TestException(aStr);
        }
        int index2 = lastStartActivity.indexOf(" ", index);
        if (index2 < 0) {
            String aStr = "Test error; Could not find start time in " + lastStartActivity;
            Log.getLogWriter().info(aStr);
            throw new TestException(aStr);
        }
        String startTimeStr = lastStartActivity.substring(index + searchStr.length(), index2);
        try {
            Long startTime = Long.valueOf(startTimeStr);
            long duration = finishTime - startTime;
            this._addToActivityList(rebalRecovFinished + finishDate + " " + finishTime + " for " + aRegion.getFullPath() + " duration: " + duration + " ms");
            return;
        }
        catch (NumberFormatException e) {
            String aStr = "Test error; Could not find start time in " + startTimeStr;
            Log.getLogWriter().info(aStr);
            throw new TestException(aStr);
        }
    }

    protected void _addToActivityList(String activityStr) {
        Log.getLogWriter().info("PRObserver: " + activityStr);
        int vmId = RemoteTestModule.getMyVmid();
        String key = activityListKey + vmId;
        ArrayList<String> activityList = (ArrayList<String>)PRObserverBB.getBB().getSharedMap().get(key);
        if (activityList == null) {
            activityList = new ArrayList<String>();
        }
        activityList.add(activityStr);
        PRObserverBB.getBB().getSharedMap().put(key, activityList);
    }

    protected static String activityListToString(List activityList) {
        if (activityList == null || activityList.size() == 0) {
            return "No activities";
        }
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < activityList.size(); ++i) {
            aStr.append(activityList.get(i) + "\n");
        }
        return aStr.toString();
    }

    protected static String getRegionNameFromActivity(String activityStr) {
        String searchStr = "for /";
        int index = activityStr.indexOf(searchStr);
        if (index < 0) {
            searchStr = "in /";
            index = activityStr.indexOf(searchStr);
        }
        if (index >= 0) {
            int index2 = activityStr.indexOf(" ", index = index - 1 + searchStr.length());
            if (index2 < 0) {
                index2 = activityStr.length();
            }
            return activityStr.substring(index, index2);
        }
        throw new TestException("Could not get region name from " + activityStr);
    }
}

