/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.Log;
import hydra.TestConfig;
import util.RandomValues;
import util.RandomValuesPrms;
import util.TestException;
import util.TestHelper;

public class RandomRangeValues
extends RandomValues {
    public RandomRangeValues(Long objectType_paramKey) {
        super(objectType_paramKey);
    }

    @Override
    public Object getRandomObject() {
        int randInt = TestConfig.tab().getRandGen().nextInt(0, this.objectTypeVec.size() - 1);
        String objectType = (String)this.objectTypeVec.elementAt(randInt);
        Object anObj = this.getRandomObjectForType(objectType);
        Log.getLogWriter().fine("getRandomObject, returning " + TestHelper.toString(anObj));
        return anObj;
    }

    @Override
    public Object getRandomObjectForType(String dataTypeName) {
        Number returnObject = null;
        if (dataTypeName.equals(Integer.class.getName())) {
            returnObject = new Integer(this.getRandom_int());
        } else if (dataTypeName.equals(Long.class.getName())) {
            returnObject = new Long(this.getRandom_long());
        } else {
            throw new TestException("Test does not support: " + dataTypeName);
        }
        return returnObject;
    }

    @Override
    public int getRandom_int() {
        int randomValueRange = TestConfig.tab().intAt(RandomValuesPrms.randomValueRange);
        if (randomValueRange <= 0) {
            return TestConfig.tab().getRandGen().nextInt();
        }
        return TestConfig.tab().getRandGen().nextInt(randomValueRange);
    }

    @Override
    public long getRandom_long() {
        int randomValueRange = TestConfig.tab().intAt(RandomValuesPrms.randomValueRange);
        if (randomValueRange <= 0) {
            return TestConfig.tab().getRandGen().nextLong();
        }
        return TestConfig.tab().getRandGen().nextLong(randomValueRange);
    }
}

