/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import hydra.GemFireDescription;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.OneOf;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import memscale.OffHeapHelper;
import util.Definition;
import util.RegionDefBB;
import util.RegionDefPrms;
import util.ReliabilityPrms;
import util.TestException;
import util.TestHelper;

public class RegionDefinition
extends Definition {
    public static final String GFX_DISK_DIR_PARENT_PROP = "gfx.disk.dir.parent";
    private Scope scope = null;
    private MirrorType mirroring = null;
    private DataPolicy dataPolicy = null;
    private Boolean concurrencyChecksEnabled = null;
    private SubscriptionAttributes subscriptionAttributes = null;
    private Integer concurrencyLevel = null;
    private Integer entryIdleTimeoutSec = null;
    private ExpirationAction entryIdleTimeoutAction = null;
    private Integer entryTTLSec = null;
    private ExpirationAction entryTTLAction = null;
    private Integer regionIdleTimeoutSec = null;
    private ExpirationAction regionIdleTimeoutAction = null;
    private Integer regionTTLSec = null;
    private ExpirationAction regionTTLAction = null;
    private Class keyConstraint = null;
    private Class valueConstraint = null;
    private Float loadFactor = null;
    private Boolean statisticsEnabled = null;
    private String enableOffHeapMemory = null;
    private Boolean persistBackup = null;
    private Integer evictionLimit = null;
    private Boolean asyncConflation = null;
    private Boolean isSynchronous = null;
    private Long timeInterval = null;
    private Long bytesThreshold = null;
    private Integer numDiskDirs = null;
    private String evictionAction = null;
    private List diskDirList = null;
    private String eviction = null;
    private List cacheListeners = null;
    private String cacheLoader = null;
    private String cacheWriter = null;
    private String objectSizerClass = null;
    private Boolean indexMaintenanceSynchronous = null;
    private List requiredRoles = null;
    private LossAction lossAction = null;
    private ResumptionAction resumptionAction = null;
    private Boolean parReg = null;
    private String parReg_cacheWriter = null;
    private String parReg_partitionResolver = null;
    private String parReg_colocatedWith = null;
    private Integer parReg_entryIdleTimeoutSec = null;
    private ExpirationAction parReg_entryIdleTimeoutAction = null;
    private Integer parReg_entryTTLSec = null;
    private ExpirationAction parReg_entryTTLAction = null;
    private Properties parReg_localProperties = null;
    private Properties parReg_globalProperties = null;
    private Integer parReg_redundantCopies = null;
    private Boolean multicastEnabled = null;
    private Boolean enableWAN = null;
    private Boolean rollOplogs = null;
    private Integer maxOplogSize = null;
    private String regionName = null;
    private ArrayList subRegions = new ArrayList();
    public static final String REGION_DEF_KEY = "OneRegionPerTest";
    public static final String EVICTION_LRU_STR = "LRU";
    public static final String EVICTION_MEM_LRU_STR = "MemLRU";
    public static final String EVICTION_HEAP_STR = "Heap";
    public static final String NONE = "none";
    private Boolean useDsMulticastSetting = null;
    private static final String REGION_NAME_TOKEN = "regionName";
    private static final String SCOPE_TOKEN = "scope";
    private static final String MIRROR_TOKEN = "mirroring";
    private static final String DATA_POLICY_TOKEN = "dataPolicy";
    private static final String INTEREST_POLICY_TOKEN = "interestPolicy";
    private static final String CONCURRENCY_LEVEL_TOKEN = "concurrencyLevel";
    private static final String ENTRY_IDLE_TIMEOUT_SEC_TOKEN = "entryIdleTimeoutSec";
    private static final String ENTRY_IDLE_TIMEOUT_ACTION_TOKEN = "entryIdleTimeoutAction";
    private static final String ENTRY_TTL_SEC_TOKEN = "entryTTLSec";
    private static final String ENTRY_TTL_ACTION_TOKEN = "entryTTLAction";
    private static final String REGION_IDLE_TIMEOUT_SEC_TOKEN = "regionIdleTimeoutSec";
    private static final String REGION_IDLE_TIMEOUT_ACTION_TOKEN = "regionIdleTimeoutAction";
    private static final String REGION_TTL_SEC_TOKEN = "regionTTLSec";
    private static final String REGION_TTL_ACTION_TOKEN = "regionTTLAction";
    private static final String KEY_CONSTRAINT_TOKEN = "keyConstraint";
    private static final String VALUE_CONSTRAINT_TOKEN = "valueConstraint";
    private static final String LOAD_FACTOR_TOKEN = "loadFactor";
    private static final String STATISTICS_ENABLED_TOKEN = "statisticsEnabled";
    private static final String ENABLE_OFF_HEAP_MEMORY = "enableOffHeapMemory";
    private static final String PERSIST_BACKUP_TOKEN = "persistBackup";
    private static final String EVICTION_LIMIT_TOKEN = "evictionLimit";
    private static final String ASYNC_CONFLATION_TOKEN = "asyncConflation";
    private static final String IS_SYNCHRONOUS_TOKEN = "isSynchronous";
    private static final String TIME_INTERVAL_TOKEN = "timeInterval";
    private static final String BYTES_THRESHOLD_TOKEN = "bytesThreshold";
    private static final String NUM_DISK_FILES_TOKEN = "numDiskDirs";
    private static final String EVICTION_ACTION_TOKEN = "evictionAction";
    private static final String DISK_DIR_LIST_TOKEN = "diskDirList";
    private static final String EVICTION_TOKEN = "eviction";
    private static final String CACHE_LISTENERS_TOKEN = "cacheListeners";
    private static final String CACHE_LOADER_TOKEN = "cacheLoader";
    private static final String CACHE_WRITER_TOKEN = "cacheWriter";
    private static final String OBJECT_SIZER_CLASS_TOKEN = "objectSizerClass";
    private static final String INDEX_MAINTENANCE_SYNCHRONOUS_TOKEN = "indexMaintenanceSynchronous";
    private static final String REQUIRED_ROLES_TOKEN = "requiredRoles";
    private static final String LOSS_ACTION_TOKEN = "lossAction";
    private static final String RESUMPTION_ACTION_TOKEN = "resumptionAction";
    private static final String MULTICAST_ENABLED_TOKEN = "multicastEnabled";
    private static final String USE_DS_MULTICAST_SETTING_TOKEN = "useDsMulticastSetting";
    private static final String ENABLE_WAN_TOKEN = "enableWAN";
    private static final String CONCURRENCY_CHECKS_ENABLED_TOKEN = "concurrencyChecksEnabled";
    private static final String PARREG_TOKEN = "PartitionedRegion";
    private static final String PARREG_CACHE_WRITER_TOKEN = "ParReg_cacheWriter";
    private static final String PARREG_ROUTING_RESOLVER_TOKEN = "ParReg_routingResolver";
    private static final String PARREG_COLOCATED_WITH_TOKEN = "ParReg_colocatedWith";
    private static final String PARREG_ENTRY_IDLE_TIMEOUT_SEC_TOKEN = "ParReg_entryIdleTimeoutSec";
    private static final String PARREG_ENTRY_IDLE_TIMEOUT_ACTION_TOKEN = "ParReg_entryIdleTimeoutAction";
    private static final String PARREG_ENTRY_TTL_SEC_TOKEN = "ParReg_entryTTLSec";
    private static final String PARREG_ENTRY_TTL_ACTION_TOKEN = "ParReg_entryTTLAction";
    private static final String PARREG_LOCAL_PROPERTIES = "ParReg_localProperties";
    private static final String PARREG_GLOBAL_PROPERTIES = "ParReg_globalProperties";
    private static final String PARREG_ROUTING_RESOLVER_PROPERTIES = "ParReg_routingResolver_properties";
    private static final String PARREG_REDUNDANT_COPIES = "ParReg_redundantCopies";
    private static final String ROLL_OPLOGS_TOKEN = "rollOplogs";
    private static final String MAX_OPLOG_SIZE_TOKEN = "maxOplogSize";
    public static final String USAGE_ANY = "useAnyRegionSpec";
    public static final String USAGE_ONE = "useOneRegionSpec";
    public static final String USAGE_NONE = "none";
    public static final String USAGE_FIXED_SEQUENCE = "useFixedSequence";

    private RegionDefinition() {
    }

    private CacheLoader getCacheLoaderInstance(String className) {
        try {
            return (CacheLoader)TestHelper.createInstance(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private CacheWriter getCacheWriterInstance(String className) {
        try {
            return (CacheWriter)TestHelper.createInstance(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private PartitionResolver getPartitionResolverInstance(String className) {
        try {
            return (PartitionResolver)TestHelper.createInstance(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void getRegionDefinition() {
        String regionSpecName = null;
        Long key = RegionDefPrms.VMRegionSpecName;
        Object tmp = TestConfig.tasktab().get(key, TestConfig.tab().get(key));
        if (tmp instanceof OneOf) {
            OneOf oneof = (OneOf)tmp;
            regionSpecName = (String)oneof.next(RegDefRand);
        } else {
            regionSpecName = (String)tmp;
        }
        this.getDefinition(RegionDefPrms.regionSpecs, regionSpecName);
    }

    public static RegionDefinition createReliabilityDefinition() {
        RegionDefinition relDef = null;
        Long key = RegionDefPrms.reliabilitySpecName;
        String specName = TestConfig.tasktab().stringAt(key, TestConfig.tab().stringAt(key, null));
        if (specName != null) {
            Log.getLogWriter().info("Using membership attributes from spec: " + specName);
            relDef = new RegionDefinition();
            relDef.getDefinition(ReliabilityPrms.reliabilitySpecs, specName);
        }
        return relDef;
    }

    public void mergeReliabilityDefinition(RegionDefinition reliabilityDef) {
        if (reliabilityDef == null) {
            return;
        }
        this.requiredRoles = reliabilityDef.getRequiredRoles();
        this.lossAction = reliabilityDef.getLossAction();
        this.resumptionAction = reliabilityDef.getResumptionAction();
    }

    @Override
    protected void initializeWithSpec(String regionSpecStr) {
        String token;
        this.tokenArr = regionSpecStr.split(ATTR_DELIM);
        this.specName = token = this.getNextToken();
        token = this.getNextToken();
        while (token != null) {
            if (token.equalsIgnoreCase(REGION_NAME_TOKEN)) {
                this.getTokenEquals();
                this.regionName = this.getTokenString();
            } else if (token.equalsIgnoreCase(SCOPE_TOKEN)) {
                this.getTokenEquals();
                this.scope = this.getTokenScope();
            } else if (token.equalsIgnoreCase(MIRROR_TOKEN)) {
                this.getTokenEquals();
                this.mirroring = this.getTokenMirroring();
            } else if (token.equalsIgnoreCase(DATA_POLICY_TOKEN)) {
                this.getTokenEquals();
                this.dataPolicy = this.getTokenDataPolicy();
            } else if (token.equalsIgnoreCase(CONCURRENCY_CHECKS_ENABLED_TOKEN)) {
                this.getTokenEquals();
                this.concurrencyChecksEnabled = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(INTEREST_POLICY_TOKEN)) {
                this.getTokenEquals();
                this.subscriptionAttributes = new SubscriptionAttributes(this.getTokenInterestPolicy());
            } else if (token.equalsIgnoreCase(CONCURRENCY_LEVEL_TOKEN)) {
                this.getTokenEquals();
                this.concurrencyLevel = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(ENTRY_IDLE_TIMEOUT_SEC_TOKEN)) {
                this.getTokenEquals();
                this.entryIdleTimeoutSec = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(ENTRY_IDLE_TIMEOUT_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.entryIdleTimeoutAction = this.getTokenAction();
            } else if (token.equalsIgnoreCase(ENTRY_TTL_SEC_TOKEN)) {
                this.getTokenEquals();
                this.entryTTLSec = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(ENTRY_TTL_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.entryTTLAction = this.getTokenAction();
            } else if (token.equalsIgnoreCase(REGION_IDLE_TIMEOUT_SEC_TOKEN)) {
                this.getTokenEquals();
                this.regionIdleTimeoutSec = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(REGION_IDLE_TIMEOUT_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.regionIdleTimeoutAction = this.getTokenAction();
            } else if (token.equalsIgnoreCase(REGION_TTL_SEC_TOKEN)) {
                this.getTokenEquals();
                this.regionTTLSec = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(REGION_TTL_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.regionTTLAction = this.getTokenAction();
            } else if (token.equalsIgnoreCase(KEY_CONSTRAINT_TOKEN)) {
                this.getTokenEquals();
                this.keyConstraint = this.getTokenClass();
            } else if (token.equalsIgnoreCase(VALUE_CONSTRAINT_TOKEN)) {
                this.getTokenEquals();
                this.valueConstraint = this.getTokenClass();
            } else if (token.equalsIgnoreCase(LOAD_FACTOR_TOKEN)) {
                this.getTokenEquals();
                this.loadFactor = this.getTokenFloat();
            } else if (token.equalsIgnoreCase(STATISTICS_ENABLED_TOKEN)) {
                this.getTokenEquals();
                this.statisticsEnabled = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(ENABLE_OFF_HEAP_MEMORY)) {
                this.getTokenEquals();
                this.enableOffHeapMemory = this.getTokenString();
            } else if (token.equalsIgnoreCase(PERSIST_BACKUP_TOKEN)) {
                this.getTokenEquals();
                this.persistBackup = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(EVICTION_LIMIT_TOKEN)) {
                this.getTokenEquals();
                this.evictionLimit = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(ASYNC_CONFLATION_TOKEN)) {
                this.getTokenEquals();
                this.asyncConflation = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(IS_SYNCHRONOUS_TOKEN)) {
                this.getTokenEquals();
                this.isSynchronous = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(TIME_INTERVAL_TOKEN)) {
                this.getTokenEquals();
                this.timeInterval = this.getTokenLong();
            } else if (token.equalsIgnoreCase(BYTES_THRESHOLD_TOKEN)) {
                this.getTokenEquals();
                this.bytesThreshold = this.getTokenLong();
            } else if (token.equalsIgnoreCase(NUM_DISK_FILES_TOKEN)) {
                this.getTokenEquals();
                this.numDiskDirs = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(EVICTION_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.evictionAction = this.getTokenString();
            } else if (token.equalsIgnoreCase(DISK_DIR_LIST_TOKEN)) {
                this.getTokenEquals();
                this.diskDirList = this.getTokenList();
            } else if (token.equalsIgnoreCase(EVICTION_TOKEN)) {
                this.getTokenEquals();
                this.eviction = this.getTokenString();
            } else if (token.equalsIgnoreCase(CACHE_LISTENERS_TOKEN)) {
                this.getTokenEquals();
                this.cacheListeners = this.getTokenList();
            } else if (token.equalsIgnoreCase(CACHE_LOADER_TOKEN)) {
                this.getTokenEquals();
                this.cacheLoader = this.getTokenString();
            } else if (token.equalsIgnoreCase(CACHE_WRITER_TOKEN)) {
                this.getTokenEquals();
                this.cacheWriter = this.getTokenString();
            } else if (token.equalsIgnoreCase(OBJECT_SIZER_CLASS_TOKEN)) {
                this.getTokenEquals();
                this.objectSizerClass = this.getTokenString();
            } else if (token.equalsIgnoreCase(INDEX_MAINTENANCE_SYNCHRONOUS_TOKEN)) {
                this.getTokenEquals();
                this.indexMaintenanceSynchronous = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(REQUIRED_ROLES_TOKEN)) {
                this.getTokenEquals();
                this.requiredRoles = this.getTokenList();
            } else if (token.equalsIgnoreCase(LOSS_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.lossAction = this.getTokenLossAction();
            } else if (token.equalsIgnoreCase(RESUMPTION_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.resumptionAction = this.getTokenResumptionAction();
            } else if (token.equalsIgnoreCase(PARREG_TOKEN)) {
                this.getTokenEquals();
                this.parReg = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(PARREG_CACHE_WRITER_TOKEN)) {
                this.getTokenEquals();
                this.parReg_cacheWriter = this.getTokenString();
            } else if (token.equalsIgnoreCase(PARREG_ROUTING_RESOLVER_TOKEN)) {
                this.getTokenEquals();
                this.parReg_partitionResolver = this.getTokenString();
            } else if (token.equalsIgnoreCase(PARREG_COLOCATED_WITH_TOKEN)) {
                this.getTokenEquals();
                this.parReg_colocatedWith = this.getTokenString();
            } else if (token.equalsIgnoreCase(PARREG_ENTRY_IDLE_TIMEOUT_SEC_TOKEN)) {
                this.getTokenEquals();
                this.parReg_entryIdleTimeoutSec = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(PARREG_ENTRY_IDLE_TIMEOUT_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.parReg_entryIdleTimeoutAction = this.getTokenAction();
            } else if (token.equalsIgnoreCase(PARREG_ENTRY_TTL_SEC_TOKEN)) {
                this.getTokenEquals();
                this.parReg_entryTTLSec = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(PARREG_ENTRY_TTL_ACTION_TOKEN)) {
                this.getTokenEquals();
                this.parReg_entryTTLAction = this.getTokenAction();
            } else if (token.equalsIgnoreCase(PARREG_LOCAL_PROPERTIES)) {
                this.getTokenEquals();
                this.parReg_localProperties = this.getTokenProperties();
            } else if (token.equalsIgnoreCase(PARREG_GLOBAL_PROPERTIES)) {
                this.getTokenEquals();
                this.parReg_globalProperties = this.getTokenProperties();
            } else if (token.equalsIgnoreCase(PARREG_REDUNDANT_COPIES)) {
                this.getTokenEquals();
                this.parReg_redundantCopies = this.getTokenInteger();
            } else if (token.equalsIgnoreCase(MULTICAST_ENABLED_TOKEN)) {
                this.getTokenEquals();
                this.multicastEnabled = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(USE_DS_MULTICAST_SETTING_TOKEN)) {
                this.getTokenEquals();
                this.useDsMulticastSetting = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(ENABLE_WAN_TOKEN)) {
                this.getTokenEquals();
                this.enableWAN = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(ROLL_OPLOGS_TOKEN)) {
                this.getTokenEquals();
                this.rollOplogs = this.getTokenBoolean();
            } else if (token.equalsIgnoreCase(MAX_OPLOG_SIZE_TOKEN)) {
                this.getTokenEquals();
                this.maxOplogSize = this.getTokenInteger();
            } else {
                throw new TestException("Unknown keyword " + token);
            }
            token = this.getNextToken();
        }
        String gemfireName = System.getProperty("gemfireName");
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        Boolean mcastSettingForDs = gfd.getEnableMcast();
        if (this.useDsMulticastSetting == null) {
            this.useDsMulticastSetting = this.multicastEnabled == null ? new Boolean(true) : new Boolean(false);
        }
        if (this.useDsMulticastSetting.booleanValue()) {
            this.multicastEnabled = mcastSettingForDs;
        } else if (this.multicastEnabled == null) {
            throw new TestException("Region def must specify multicast setting for region or use multicast setting for DS");
        }
    }

    private Properties getTokenProperties() {
        String token;
        Properties props = new Properties();
        StringBuffer propStr = new StringBuffer();
        while ((token = this.getNextToken()) != null && !token.equals(SPEC_TERMINATOR)) {
            propStr.append(token);
            propStr.append(this.getTokenEquals());
            token = this.getNextToken();
            if (token.endsWith(SPEC_TERMINATOR)) {
                token = token.substring(0, token.length() - 1);
                propStr.append(token);
                break;
            }
            propStr.append(token);
            propStr.append("\n");
        }
        try {
            props.load(new ByteArrayInputStream(propStr.toString().getBytes()));
        }
        catch (IOException ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
        Log.getLogWriter().fine("Properties is " + props);
        return props;
    }

    private Scope getTokenScope() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Scope scope = null;
        try {
            scope = TestHelper.getScope(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose scope " + scope);
        return scope;
    }

    private MirrorType getTokenMirroring() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        MirrorType mt = null;
        try {
            mt = TestHelper.getMirrorType(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose mirroring " + mt);
        return mt;
    }

    private DataPolicy getTokenDataPolicy() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        DataPolicy db = null;
        try {
            db = TestHelper.getDataPolicy(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose dataPolicy " + db);
        return db;
    }

    private DataPolicy getTokenConcurrencyChecksEnabled() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        DataPolicy db = null;
        try {
            db = TestHelper.getDataPolicy(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose dataPolicy " + db);
        return db;
    }

    private InterestPolicy getTokenInterestPolicy() {
        String token = this.getTokenFromList();
        InterestPolicy ip = null;
        try {
            ip = TestHelper.getInterestPolicy(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose interestPolicy " + ip);
        return ip;
    }

    private ExpirationAction getTokenAction() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        Log.getLogWriter().fine("Chose exp action " + token);
        return TestHelper.getExpirationAction(token);
    }

    private ExpirationAttributes getExpirationAttributes(Integer time, ExpirationAction action, String expirationType) {
        ExpirationAttributes expAttr = null;
        if (time == null) {
            if (action != null) {
                throw new TestException("Unable to create region attributes: expiration action is " + action + ", but no time was specified for " + expirationType);
            }
        } else {
            expAttr = action == null ? new ExpirationAttributes(time.intValue()) : new ExpirationAttributes(time.intValue(), action);
        }
        return expAttr;
    }

    private LossAction getTokenLossAction() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        LossAction lossAction = null;
        try {
            lossAction = TestHelper.getLossAction(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose lossAction " + lossAction);
        return lossAction;
    }

    private ResumptionAction getTokenResumptionAction() {
        String token = this.getTokenFromList();
        if (token.equalsIgnoreCase("null")) {
            return null;
        }
        ResumptionAction action = null;
        try {
            action = TestHelper.getResumptionAction(token);
        }
        catch (TestException e) {
            throw new TestException(this.tokensToString() + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().fine("Chose resumptionAction " + action);
        return action;
    }

    private MembershipAttributes getMembershipAttributes() {
        MembershipAttributes reliabilityAttrs = null;
        if (this.requiredRoles != null) {
            String[] rolesArr = new String[this.requiredRoles.size()];
            int i = 0;
            Iterator it = this.requiredRoles.iterator();
            while (it.hasNext()) {
                rolesArr[i] = (String)it.next();
                ++i;
            }
            reliabilityAttrs = new MembershipAttributes(rolesArr, this.lossAction, this.resumptionAction);
        }
        return reliabilityAttrs;
    }

    private EvictionAction getEvictionActionOrDefault() {
        EvictionAction action = EvictionAction.DEFAULT_EVICTION_ACTION;
        if (this.evictionAction != null) {
            if (this.evictionAction.equalsIgnoreCase("localDestroy")) {
                action = EvictionAction.LOCAL_DESTROY;
            } else if (this.evictionAction.equalsIgnoreCase("overflowToDisk")) {
                action = EvictionAction.OVERFLOW_TO_DISK;
            } else {
                throw new TestException("Unknown eviction action " + this.evictionAction);
            }
        }
        return action;
    }

    private void deriveDiskDirList() {
        if (this.diskDirList == null) {
            this.diskDirList = new ArrayList();
            if (this.numDiskDirs == null) {
                return;
            }
            int numDirs = this.numDiskDirs;
            String gemfireName = System.getProperty("gemfireName");
            if (gemfireName == null) {
                throw new HydraConfigException("No gemfire name has been specified");
            }
            String currDir = System.getProperty("user.dir");
            for (int i = 0; i < numDirs; ++i) {
                String fname = currDir + "/DiskRegionForVmID_" + RemoteTestModule.getMyVmid() + "_dirNum_" + (i + 1);
                this.diskDirList.add(fname);
            }
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuffer aStr = new StringBuffer();
        aStr.append("RegionDefinition with name " + this.specName + "\n");
        aStr.append("   scope: " + this.scope + "\n");
        aStr.append("   mirroring: " + this.mirroring + "\n");
        aStr.append("   dataPolicy: " + this.dataPolicy + "\n");
        aStr.append("   concurrencyChecksEnabled: " + this.concurrencyChecksEnabled + "\n");
        aStr.append("   subscription: " + this.subscriptionAttributes + "\n");
        aStr.append("   concurrencyLevel: " + this.concurrencyLevel + "\n");
        aStr.append("   entryIdleTimeoutSec: " + this.entryIdleTimeoutSec + "\n");
        aStr.append("   entryIdleTimeoutAction: " + this.entryIdleTimeoutAction + "\n");
        aStr.append("   entryTTLSec: " + this.entryTTLSec + "\n");
        aStr.append("   entryTTLAction: " + this.entryTTLAction + "\n");
        aStr.append("   regionIdleTimeoutSec: " + this.regionIdleTimeoutSec + "\n");
        aStr.append("   regionIdleTimeoutAction: " + this.regionIdleTimeoutAction + "\n");
        aStr.append("   regionTTLSec: " + this.regionTTLSec + "\n");
        aStr.append("   regionTTLAction: " + this.regionTTLAction + "\n");
        if (this.keyConstraint == null) {
            aStr.append("   keyConstraint: " + this.keyConstraint + "\n");
        } else {
            aStr.append("   keyConstraint: " + this.keyConstraint.getName() + "\n");
        }
        if (this.valueConstraint == null) {
            aStr.append("   valueConstraint: " + this.valueConstraint + "\n");
        } else {
            aStr.append("   valueConstraint: " + this.valueConstraint.getName() + "\n");
        }
        aStr.append("   loadFactor: " + this.loadFactor + "\n");
        aStr.append("   statisticsEnabled: " + this.statisticsEnabled + "\n");
        aStr.append("   enableOffHeapMemory: " + this.enableOffHeapMemory + "\n");
        aStr.append("   persistBackup: " + this.persistBackup + "\n");
        aStr.append("   isSynchronous: " + this.isSynchronous + "\n");
        aStr.append("   eviction: " + this.eviction + "\n");
        aStr.append("     evictionLimit: " + this.evictionLimit + "\n");
        aStr.append("     evictionAction: " + this.evictionAction + "\n");
        aStr.append("     objectSizerClass: " + this.objectSizerClass + "\n");
        aStr.append("   asyncConflation: " + this.asyncConflation + "\n");
        aStr.append("   timeInterval: " + this.timeInterval + "\n");
        aStr.append("   bytesThreshold: " + this.bytesThreshold + "\n");
        aStr.append("   cacheLoader: " + this.cacheLoader + "\n");
        aStr.append("   cacheWriter: " + this.cacheWriter + "\n");
        aStr.append("   numDiskDirs: " + this.numDiskDirs + "\n");
        aStr.append("   indexMaintenanceSynchronous: " + this.indexMaintenanceSynchronous + "\n");
        aStr.append("   requiredRoles: " + this.requiredRoles + "\n");
        aStr.append("   lossAction: " + this.lossAction + "\n");
        aStr.append("   resumptionAction: " + this.resumptionAction + "\n");
        aStr.append("   parReg: " + this.parReg + "\n");
        aStr.append("     parReg_cacheWriter: " + this.parReg_cacheWriter + "\n");
        aStr.append("     parReg_entryIdleTimeoutSec: " + this.parReg_entryIdleTimeoutSec + "\n");
        aStr.append("     parReg_entryIdleTimeoutAction: " + this.parReg_entryIdleTimeoutAction + "\n");
        aStr.append("     parReg_entryTTLSec: " + this.parReg_entryIdleTimeoutSec + "\n");
        aStr.append("     parReg_entryTTLAction: " + this.parReg_entryIdleTimeoutAction + "\n");
        aStr.append("     parReg_localProperties: " + this.parReg_localProperties + "\n");
        aStr.append("     parReg_globalProperties: " + this.parReg_globalProperties + "\n");
        aStr.append("     parReg_redundantCopies: " + this.parReg_redundantCopies + "\n");
        aStr.append("     parReg_colocatedWith: " + this.parReg_colocatedWith + "\n");
        aStr.append("     parReg_routingResolver: " + this.parReg_partitionResolver + "\n");
        aStr.append("   multicastEnabled: " + this.multicastEnabled + "\n");
        if (this.cacheListeners == null) {
            aStr.append("   cacheListeners: " + this.cacheListeners + "\n");
        } else {
            if (this.cacheListeners.size() == 0) {
                throw new TestException("cacheListeners list is size 0");
            }
            aStr.append("   cacheListeners: " + this.cacheListeners.get(0) + "\n");
            for (i = 1; i < this.cacheListeners.size(); ++i) {
                aStr.append("                  " + this.cacheListeners.get(i) + "\n");
            }
        }
        aStr.append("   enableWAN: " + this.enableWAN + "\n");
        aStr.append("   rollOplogs: " + this.rollOplogs + "\n");
        aStr.append("   maxOplogSize: " + this.maxOplogSize + "\n");
        if (this.diskDirList != null) {
            aStr.append("   diskDirList: ");
            for (i = 0; i < this.diskDirList.size(); ++i) {
                aStr.append((String)this.diskDirList.get(i) + " ");
            }
            aStr.append("\n");
        }
        return aStr.toString();
    }

    public RegionAttributes getRegionAttributes() {
        return this.getRegionAttributes(null, null, null);
    }

    public RegionAttributes getRegionAttributes(CacheListener cacheListenerArg, CacheLoader cacheLoaderArg, CacheWriter cacheWriterArg) {
        MembershipAttributes reliabilityAttrs;
        ExpirationAttributes expAttr;
        AttributesFactory factory = new AttributesFactory();
        if (this.scope != null) {
            factory.setScope(this.scope);
        }
        if (this.mirroring != null) {
            factory.setMirrorType(this.mirroring);
        }
        if (this.dataPolicy != null) {
            factory.setDataPolicy(this.dataPolicy);
        }
        if (this.concurrencyChecksEnabled != null) {
            factory.setConcurrencyChecksEnabled(this.concurrencyChecksEnabled.booleanValue());
        }
        if (this.subscriptionAttributes != null) {
            factory.setSubscriptionAttributes(this.subscriptionAttributes);
        }
        if (this.cacheListeners != null || cacheListenerArg != null) {
            if (this.cacheListeners != null && cacheListenerArg != null) {
                throw new TestException("A cache listener was specified in the region definition as " + this.cacheListeners + ", but it was also specified as an argument to create region " + "attributes " + cacheListenerArg);
            }
            if (this.cacheListeners != null) {
                for (int i = 0; i < this.cacheListeners.size(); ++i) {
                    factory.addCacheListener((CacheListener)TestHelper.createInstance((String)this.cacheListeners.get(i)));
                }
            } else {
                factory.setCacheListener(cacheListenerArg);
            }
        }
        if (this.eviction != null) {
            EvictionAttributes evAttr = this.getEvictionAttributes();
            factory.setEvictionAttributes(evAttr);
        }
        if (this.cacheLoader != null || cacheLoaderArg != null) {
            if (this.cacheLoader != null && cacheLoaderArg != null) {
                throw new TestException("A cache Loader was specified in the region definition as " + this.cacheLoader + ", but it was also specified as an argument to create region " + "attributes " + cacheLoaderArg);
            }
            if (this.cacheLoader != null) {
                factory.setCacheLoader(this.getCacheLoaderInstance(this.cacheLoader));
            } else {
                factory.setCacheLoader(cacheLoaderArg);
            }
        }
        if (this.cacheWriter != null || cacheWriterArg != null) {
            if (this.cacheWriter != null && cacheWriterArg != null) {
                throw new TestException("A cache Writer was specified in the region definition as " + this.cacheWriter + ", but it was also specified as an argument to create region " + "attributes " + cacheWriterArg);
            }
            if (this.cacheWriter != null) {
                factory.setCacheWriter(this.getCacheWriterInstance(this.cacheWriter));
            } else {
                factory.setCacheWriter(cacheWriterArg);
            }
        }
        if (this.concurrencyLevel != null) {
            factory.setConcurrencyLevel(this.concurrencyLevel.intValue());
        }
        if (this.keyConstraint != null) {
            factory.setKeyConstraint(this.keyConstraint);
        }
        if (this.valueConstraint != null) {
            factory.setValueConstraint(this.valueConstraint);
        }
        if (this.loadFactor != null) {
            factory.setLoadFactor(this.loadFactor.floatValue());
        }
        if (this.statisticsEnabled != null) {
            factory.setStatisticsEnabled(this.statisticsEnabled.booleanValue());
        }
        if (this.enableOffHeapMemory != null && this.enableOffHeapMemory.equalsIgnoreCase("ifOffHeapMemoryConfigured") && OffHeapHelper.isOffHeapMemoryConfigured()) {
            factory.setEnableOffHeapMemory(true);
        }
        if (this.indexMaintenanceSynchronous != null) {
            factory.setIndexMaintenanceSynchronous(this.indexMaintenanceSynchronous.booleanValue());
        }
        if (this.enableWAN != null) {
            factory.setEnableWAN(this.enableWAN.booleanValue());
        }
        if (this.persistBackup != null) {
            factory.setPersistBackup(this.persistBackup.booleanValue());
        }
        if (this.asyncConflation != null) {
            factory.setEnableAsyncConflation(this.asyncConflation.booleanValue());
        }
        if (this.isSynchronous != null) {
            factory.setDiskWriteAttributes(this.getDiskWriteAttributes());
        }
        if (this.multicastEnabled != null) {
            factory.setMulticastEnabled(this.multicastEnabled.booleanValue());
        }
        if (this.numDiskDirs != null) {
            factory.setDiskDirs(this.getDiskDirFileArr());
        }
        if ((expAttr = this.getRegionTTL()) != null) {
            factory.setRegionTimeToLive(expAttr);
        }
        if ((expAttr = this.getRegionIdleTimeout()) != null) {
            factory.setRegionIdleTimeout(expAttr);
        }
        if ((expAttr = this.getEntryTTL()) != null) {
            factory.setEntryTimeToLive(expAttr);
        }
        if ((expAttr = this.getEntryIdleTimeout()) != null) {
            factory.setEntryIdleTimeout(expAttr);
        }
        if ((reliabilityAttrs = this.getMembershipAttributes()) != null) {
            factory.setMembershipAttributes(reliabilityAttrs);
        }
        PartitionAttributesFactory parFac = null;
        if (this.parReg != null) {
            if (this.parReg.booleanValue()) {
                parFac = new PartitionAttributesFactory();
                if (this.parReg_colocatedWith != null) {
                    parFac.setColocatedWith(this.parReg_colocatedWith);
                }
                if (this.parReg_partitionResolver != null) {
                    PartitionResolver instance = this.getPartitionResolverInstance(this.parReg_partitionResolver);
                    parFac.setPartitionResolver(instance);
                }
                if (this.parReg_localProperties != null) {
                    parFac.setLocalProperties(this.parReg_localProperties);
                }
                if (this.parReg_globalProperties != null) {
                    parFac.setGlobalProperties(this.parReg_globalProperties);
                }
                if (this.parReg_redundantCopies != null) {
                    parFac.setRedundantCopies(this.parReg_redundantCopies.intValue());
                }
                PartitionAttributes parAttr = parFac.create();
                factory.setPartitionAttributes(parAttr);
            } else if (this.parReg_cacheWriter != null || this.parReg_colocatedWith != null || this.parReg_partitionResolver != null || this.parReg_entryIdleTimeoutSec != null || this.parReg_entryIdleTimeoutAction != null || this.parReg_entryTTLSec != null || this.parReg_entryTTLAction != null || this.parReg_localProperties != null || this.parReg_globalProperties != null || this.parReg_redundantCopies != null) {
                throw new TestException("Some partitioned region attributes are set, but \"partitionedRegion = false\" in your RegionDefinition");
            }
        } else if (this.parReg_cacheWriter != null || this.parReg_colocatedWith != null || this.parReg_partitionResolver != null || this.parReg_entryIdleTimeoutSec != null || this.parReg_entryIdleTimeoutAction != null || this.parReg_entryTTLSec != null || this.parReg_entryTTLAction != null || this.parReg_localProperties != null || this.parReg_globalProperties != null || this.parReg_redundantCopies != null) {
            throw new TestException("Some partitioned region attributes are set; you must also set \"partitionedRegion=true\" in your RegionDefinition, but it is missing");
        }
        RegionAttributes attr = factory.createRegionAttributes();
        return attr;
    }

    public Region createRootRegion(Cache aCache, String name, CacheListener listener, CacheLoader loader, CacheWriter writer) {
        String nameToUse = null;
        if (this.regionName == null && name == null) {
            throw new TestException("A region name was not specified either in the region definition or as an argument to this call");
        }
        if (this.regionName != null && name != null && !this.regionName.equals(name)) {
            throw new TestException("A region name was specified in the region definition as " + this.regionName + ", but it was also specified as an argument to create region " + name);
        }
        nameToUse = this.regionName != null ? this.regionName : name;
        RegionAttributes attr = this.getRegionAttributes(listener, loader, writer);
        Region aRegion = null;
        try {
            Log.getLogWriter().info("Creating VM region " + nameToUse + " with " + TestHelper.regionAttributesToString(attr));
            aRegion = aCache.createVMRegion(nameToUse, attr);
        }
        catch (RegionExistsException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Finished creating " + TestHelper.regionToString(aRegion, true));
        return aRegion;
    }

    public static synchronized RegionDefinition createRegionDefinition() {
        Log.getLogWriter().info("In RegionDefinition.createRegionDefinition...");
        String regionDefUsage = TestConfig.tab().stringAt(RegionDefPrms.regionDefUsage);
        if (regionDefUsage.equalsIgnoreCase("none")) {
            return null;
        }
        if (regionDefUsage.equalsIgnoreCase(USAGE_ANY) || regionDefUsage.equalsIgnoreCase(USAGE_FIXED_SEQUENCE)) {
            if (RegDefRand == null) {
                throw new TestException("You must include an INITTASK for RegionDefinition.InitTask_initialize");
            }
            RegionDefinition regDef = new RegionDefinition();
            regDef.getRegionDefinition();
            RegionDefinition reliabilityDef = RegionDefinition.createReliabilityDefinition();
            regDef.mergeReliabilityDefinition(reliabilityDef);
            if (regionDefUsage.equalsIgnoreCase(USAGE_ANY)) {
                Log.getLogWriter().info("RegionDefinition.createRegionDefinition: Getting any region definition: " + regDef);
            } else {
                Log.getLogWriter().info("RegionDefinition.createRegionDefinition: Getting a fixed-sequence region definition: " + regDef);
            }
            return regDef;
        }
        if (regionDefUsage.equalsIgnoreCase(USAGE_ONE)) {
            RegionDefinition regDef = (RegionDefinition)RegionDefBB.getBB().getSharedMap().get(REGION_DEF_KEY);
            RegionDefinition reliabilityDef = RegionDefinition.createReliabilityDefinition();
            regDef.mergeReliabilityDefinition(reliabilityDef);
            Log.getLogWriter().info("RegionDefinition.createRegionDefinition: Getting singleton region definition " + regDef);
            if (regDef == null) {
                throw new TestException("key OneRegionPerTest in RegionDefBB has null value; you must include an INITTASK for RegionDefinition.InitTask_initialize");
            }
            return regDef;
        }
        throw new TestException("Unknown value for RegionDefPrms.regionDefUsage " + regionDefUsage);
    }

    public static RegionDefinition createRegionDefinition(Long hydraSpecParam, String specName) {
        RegionDefinition regDef = new RegionDefinition();
        regDef.getDefinition(hydraSpecParam, specName);
        return regDef;
    }

    public static Set getSpecNames(Long hydraSpecParam) {
        RegionDefinition regDef = new RegionDefinition();
        regDef.initializeSpecMap(hydraSpecParam);
        return regDef.specMap.keySet();
    }

    public static void InitTask_initialize() {
        RegionDefinition.HydraTask_initialize();
    }

    public static void HydraTask_initialize() {
        String regionDefUsage = TestConfig.tab().stringAt(RegionDefPrms.regionDefUsage);
        if (regionDefUsage.equalsIgnoreCase("none")) {
            return;
        }
        if (regionDefUsage.equalsIgnoreCase(USAGE_ONE)) {
            RegionDefinition regDef = new RegionDefinition();
            regDef.getRegionDefinition();
            RegionDefBB.getBB().getSharedMap().put(REGION_DEF_KEY, regDef);
        } else if (regionDefUsage.equalsIgnoreCase(USAGE_FIXED_SEQUENCE)) {
            long seed = TestConfig.tab().longAt(Prms.randomSeed);
            Log.getLogWriter().info("Initializing region definition random seed to " + seed);
            RegDefRand = new GsRandom(TestConfig.tab().longAt(Prms.randomSeed));
        } else {
            if (regionDefUsage.equalsIgnoreCase(USAGE_ANY)) {
                return;
            }
            throw new TestException("Unknown value for RegionDefPrms.regionDefUsage " + regionDefUsage);
        }
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public MirrorType getMirroring() {
        return this.mirroring;
    }

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public Boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.subscriptionAttributes;
    }

    public List getRequiredRoles() {
        return this.requiredRoles;
    }

    public LossAction getLossAction() {
        return this.lossAction;
    }

    public ResumptionAction getResumptionAction() {
        return this.resumptionAction;
    }

    public Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public Integer getEntryIdleTimeoutSec() {
        return this.entryIdleTimeoutSec;
    }

    public ExpirationAction getEntryIdleTimeoutAction() {
        return this.entryIdleTimeoutAction;
    }

    public Integer getEntryTTLSec() {
        return this.entryTTLSec;
    }

    public ExpirationAction getEntryTTLAction() {
        return this.entryTTLAction;
    }

    public Integer getRegionIdleTimeoutSec() {
        return this.regionIdleTimeoutSec;
    }

    public ExpirationAction getRegionIdleTimeoutAction() {
        return this.regionIdleTimeoutAction;
    }

    public Integer getRegionTTLSec() {
        return this.regionTTLSec;
    }

    public ExpirationAction getRegionTTLAction() {
        return this.regionTTLAction;
    }

    public Class getKeyConstraint() {
        return this.keyConstraint;
    }

    public Class getValueConstraint() {
        return this.valueConstraint;
    }

    public Float getLoadFactor() {
        return this.loadFactor;
    }

    public Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public String getEnableOffHeapMemory() {
        return this.enableOffHeapMemory;
    }

    public Boolean getPersistBackup() {
        return this.persistBackup;
    }

    public Integer getEvictionLimit() {
        return this.evictionLimit;
    }

    public Boolean getAsyncConflation() {
        return this.asyncConflation;
    }

    public Boolean getIsSynchronous() {
        return this.isSynchronous;
    }

    public Boolean getEnableWAN() {
        return this.enableWAN;
    }

    public Long getTimeInterval() {
        return this.timeInterval;
    }

    public Long getBytesThreshold() {
        return this.bytesThreshold;
    }

    public Integer getNumDiskDirs() {
        return this.numDiskDirs;
    }

    public String getEvictionAction() {
        return this.evictionAction;
    }

    public List getDiskDirList() {
        return this.diskDirList;
    }

    public String getEviction() {
        return this.eviction;
    }

    public List getCacheListeners() {
        return this.cacheListeners;
    }

    public String getCacheLoader() {
        return this.cacheLoader;
    }

    public String getCacheWriter() {
        return this.cacheWriter;
    }

    public String getObjectSizerClass() {
        return this.objectSizerClass;
    }

    public Boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    public Boolean getMulticastEnabled() {
        return this.multicastEnabled;
    }

    public Boolean getUseDsMulticastSetting() {
        return this.useDsMulticastSetting;
    }

    public ArrayList getSubregions() {
        return this.subRegions;
    }

    public Boolean getRollOplogs() {
        return this.rollOplogs;
    }

    public Integer getMaxOplogSize() {
        return this.maxOplogSize;
    }

    protected DiskWriteAttributes getDiskWriteAttributes() {
        DiskWriteAttributesFactory factory = new DiskWriteAttributesFactory();
        if (this.isSynchronous != null) {
            factory.setSynchronous(this.isSynchronous.booleanValue());
        }
        if (this.timeInterval != null) {
            factory.setTimeInterval(this.timeInterval.longValue());
        }
        if (this.bytesThreshold != null) {
            factory.setBytesThreshold(this.bytesThreshold.longValue());
        }
        if (this.rollOplogs != null) {
            factory.setRollOplogs(this.rollOplogs.booleanValue());
        }
        if (this.maxOplogSize != null) {
            factory.setMaxOplogSize(this.maxOplogSize.intValue());
        }
        return factory.create();
    }

    public File[] getDiskDirFileArr() {
        if (this.diskDirList == null) {
            this.deriveDiskDirList();
        }
        if (this.diskDirList != null) {
            File[] fileArr = new File[this.diskDirList.size()];
            for (int i = 0; i < this.diskDirList.size(); ++i) {
                File aDir;
                fileArr[i] = aDir = new File((String)this.diskDirList.get(i));
                aDir.mkdir();
            }
            return fileArr;
        }
        return null;
    }

    public ExpirationAttributes getRegionTTL() {
        ExpirationAttributes expAttr = this.getExpirationAttributes(this.regionTTLSec, this.regionTTLAction, "regionTTL");
        return expAttr;
    }

    public ExpirationAttributes getRegionIdleTimeout() {
        ExpirationAttributes expAttr = this.getExpirationAttributes(this.regionIdleTimeoutSec, this.regionIdleTimeoutAction, "regionIdleTimeout");
        return expAttr;
    }

    public ExpirationAttributes getEntryTTL() {
        ExpirationAttributes expAttr = this.getExpirationAttributes(this.entryTTLSec, this.entryTTLAction, "entryTTL");
        return expAttr;
    }

    public ExpirationAttributes getEntryIdleTimeout() {
        ExpirationAttributes expAttr = this.getExpirationAttributes(this.entryIdleTimeoutSec, this.entryIdleTimeoutAction, "entryIdleTimeout");
        return expAttr;
    }

    public Boolean getPartitionedRegion() {
        return this.parReg;
    }

    public String getParRegCacheWriter() {
        return this.parReg_cacheWriter;
    }

    public String getParRegPartitionResolver() {
        return this.parReg_partitionResolver;
    }

    public String getColocatedWith() {
        return this.parReg_colocatedWith;
    }

    public Integer getParRegEntryIdleTimeoutSec() {
        return this.parReg_entryIdleTimeoutSec;
    }

    public ExpirationAction getParRegEntryIdleTimeoutAction() {
        return this.parReg_entryIdleTimeoutAction;
    }

    public ExpirationAttributes getParRegEntryTTL() {
        ExpirationAttributes expAttr = this.getExpirationAttributes(this.parReg_entryTTLSec, this.parReg_entryTTLAction, "parReg_entryTTL");
        return expAttr;
    }

    public ExpirationAttributes getParRegEntryIdleTimeout() {
        ExpirationAttributes expAttr = this.getExpirationAttributes(this.parReg_entryIdleTimeoutSec, this.parReg_entryIdleTimeoutAction, "parReg_entryIdleTimeout");
        return expAttr;
    }

    public Integer getParRegEntryTTLSec() {
        return this.parReg_entryTTLSec;
    }

    public Properties getParRegLocalProperties() {
        return this.parReg_localProperties;
    }

    public Properties getParRegGlobalProperties() {
        return this.parReg_globalProperties;
    }

    public Integer getParRegRedundantCopies() {
        return this.parReg_redundantCopies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EvictionAttributes getEvictionAttributes() {
        boolean objectSizerIsSet;
        EvictionAttributes evAttr = null;
        boolean evictionLimitIsSet = this.evictionLimit != null;
        boolean evictionActionIsSet = this.evictionAction != null;
        boolean bl = objectSizerIsSet = this.objectSizerClass != null;
        if (this.eviction.equalsIgnoreCase(EVICTION_LRU_STR)) {
            if (evictionLimitIsSet && evictionActionIsSet) {
                return EvictionAttributes.createLRUEntryAttributes((int)this.evictionLimit, (EvictionAction)this.getEvictionActionOrDefault());
            }
            if (!evictionLimitIsSet && !evictionActionIsSet) {
                return EvictionAttributes.createLRUEntryAttributes();
            }
            if (!evictionLimitIsSet) throw new TestException("For eviction " + this.eviction + ", evictionLimit is " + this.evictionLimit + ", evictionAction is " + this.evictionAction + ", but valid settings are either to set " + "(1) both evictionLimit and evictionAction, (2) neither, or (3) evictionLimit only");
            if (evictionActionIsSet) throw new TestException("For eviction " + this.eviction + ", evictionLimit is " + this.evictionLimit + ", evictionAction is " + this.evictionAction + ", but valid settings are either to set " + "(1) both evictionLimit and evictionAction, (2) neither, or (3) evictionLimit only");
            return EvictionAttributes.createLRUEntryAttributes((int)this.evictionLimit);
        }
        if (this.eviction.equalsIgnoreCase(EVICTION_MEM_LRU_STR)) {
            if (evictionLimitIsSet && evictionActionIsSet && objectSizerIsSet) {
                return EvictionAttributes.createLRUMemoryAttributes((int)this.evictionLimit, (ObjectSizer)((ObjectSizer)TestHelper.createInstance(this.objectSizerClass)), (EvictionAction)this.getEvictionActionOrDefault());
            }
            if (evictionLimitIsSet && evictionActionIsSet && !objectSizerIsSet) {
                return EvictionAttributes.createLRUMemoryAttributes((int)this.evictionLimit, null, (EvictionAction)this.getEvictionActionOrDefault());
            }
            if (evictionLimitIsSet && objectSizerIsSet && !evictionActionIsSet) {
                return EvictionAttributes.createLRUMemoryAttributes((int)this.evictionLimit, (ObjectSizer)((ObjectSizer)TestHelper.createInstance(this.objectSizerClass)));
            }
            if (evictionLimitIsSet && !objectSizerIsSet && !evictionActionIsSet) {
                return EvictionAttributes.createLRUMemoryAttributes((int)this.evictionLimit);
            }
            if (evictionLimitIsSet) throw new TestException("For eviction " + this.eviction + ", evictionLimit is " + this.evictionLimit + ", evictionAction is " + this.evictionAction + ", objectSizerClass is " + this.objectSizerClass + ", but valid settings are either to set (1) all 3, (2) none, (3) evictionLimit only, " + "or (4) evictionLimit and objectSizerClass");
            if (objectSizerIsSet) throw new TestException("For eviction " + this.eviction + ", evictionLimit is " + this.evictionLimit + ", evictionAction is " + this.evictionAction + ", objectSizerClass is " + this.objectSizerClass + ", but valid settings are either to set (1) all 3, (2) none, (3) evictionLimit only, " + "or (4) evictionLimit and objectSizerClass");
            if (evictionActionIsSet) throw new TestException("For eviction " + this.eviction + ", evictionLimit is " + this.evictionLimit + ", evictionAction is " + this.evictionAction + ", objectSizerClass is " + this.objectSizerClass + ", but valid settings are either to set (1) all 3, (2) none, (3) evictionLimit only, " + "or (4) evictionLimit and objectSizerClass");
            return EvictionAttributes.createLRUMemoryAttributes();
        }
        if (!this.eviction.equalsIgnoreCase(EVICTION_HEAP_STR)) throw new TestException("Unknown eviction " + this.eviction);
        if (evictionLimitIsSet) {
            throw new TestException("With heap lru, evictionLimit cannot be set. You must use evictionHeapPercentage on cache definition.");
        }
        if (objectSizerIsSet && evictionActionIsSet) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)((ObjectSizer)TestHelper.createInstance(this.objectSizerClass)), (EvictionAction)this.getEvictionActionOrDefault());
        }
        if (!evictionActionIsSet && !evictionActionIsSet) {
            return EvictionAttributes.createLRUHeapAttributes();
        }
        if (objectSizerIsSet && !evictionActionIsSet) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)((ObjectSizer)TestHelper.createInstance(this.objectSizerClass)));
        }
        if (objectSizerIsSet) throw new TestException("For eviction " + this.eviction + ", evictionAction is " + this.evictionAction + ", objectSizer is " + this.objectSizerClass + ", but valid settings are either to set (1) both , (2) neither, or (3) objectSizerClass only, or (4) evictionAction only");
        if (!evictionActionIsSet) throw new TestException("For eviction " + this.eviction + ", evictionAction is " + this.evictionAction + ", objectSizer is " + this.objectSizerClass + ", but valid settings are either to set (1) both , (2) neither, or (3) objectSizerClass only, or (4) evictionAction only");
        return EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)this.getEvictionActionOrDefault());
    }

    public void setRegionName(String regionNameArg) {
        this.regionName = regionNameArg;
    }

    public void setScope(Scope scopeArg) {
        this.scope = scopeArg;
    }

    public void setMirroring(MirrorType mirroringArg) {
        this.mirroring = mirroringArg;
    }

    public void setDataPolicy(DataPolicy dataPolicyArg) {
        this.dataPolicy = dataPolicyArg;
    }

    public void setSubscriptionAttributes(SubscriptionAttributes subscriptionAttributesArg) {
        this.subscriptionAttributes = subscriptionAttributesArg;
    }

    public void setConcurrencyChecksEnabled(boolean concurrencyChecksEnabledArg) {
        this.concurrencyChecksEnabled = new Boolean(concurrencyChecksEnabledArg);
    }

    public void setConcurrencyChecksEnabled(Boolean concurrencyChecksEnabledArg) {
        this.concurrencyChecksEnabled = concurrencyChecksEnabledArg;
    }

    public void setRequiredRoles(List rolesArg) {
        this.requiredRoles = rolesArg;
    }

    public void setLossAction(LossAction actionArg) {
        this.lossAction = actionArg;
    }

    public void setResumptionAction(ResumptionAction actionArg) {
        this.resumptionAction = actionArg;
    }

    public void setConcurrencyLevel(int concurrencyLevelArg) {
        this.concurrencyLevel = new Integer(concurrencyLevelArg);
    }

    public void setConcurrencyLevel(Integer concurrencyLevelArg) {
        this.concurrencyLevel = concurrencyLevelArg;
    }

    public void setEntryIdleTimeoutSec(int entryIdleTimeoutSecArg) {
        this.entryIdleTimeoutSec = new Integer(entryIdleTimeoutSecArg);
    }

    public void setEntryIdleTimeoutSec(Integer entryIdleTimeoutSecArg) {
        this.entryIdleTimeoutSec = entryIdleTimeoutSecArg;
    }

    public void setEntryIdleTimeoutAction(ExpirationAction expActionArg) {
        this.entryIdleTimeoutAction = expActionArg;
    }

    public void setEntryTTLSec(int entryTTLSecArg) {
        this.entryTTLSec = new Integer(entryTTLSecArg);
    }

    public void setEntryTTLSec(Integer entryTTLSecArg) {
        this.entryTTLSec = entryTTLSecArg;
    }

    public void setEntryTTLAction(ExpirationAction expActionArg) {
        this.entryTTLAction = expActionArg;
    }

    public void setRegionIdleTimeoutSec(int regionIdleTimeoutSecArg) {
        this.regionIdleTimeoutSec = new Integer(regionIdleTimeoutSecArg);
    }

    public void setRegionIdleTimeoutSec(Integer regionIdleTimeoutSecArg) {
        this.regionIdleTimeoutSec = regionIdleTimeoutSecArg;
    }

    public void setRegionIdleTimeoutAction(ExpirationAction expActionArg) {
        this.regionIdleTimeoutAction = expActionArg;
    }

    public void setRegionTTLSec(int regionTTLSecArg) {
        this.regionTTLSec = new Integer(regionTTLSecArg);
    }

    public void setRegionTTLSec(Integer regionTTLSecArg) {
        this.regionTTLSec = regionTTLSecArg;
    }

    public void setRegionTTLAction(ExpirationAction expActionArg) {
        this.regionTTLAction = expActionArg;
    }

    public void setKeyConstraint(Class keyConstraintArg) {
        this.keyConstraint = keyConstraintArg;
    }

    public void setLoadFactor(float loadFactorArg) {
        this.loadFactor = new Float(loadFactorArg);
    }

    public void setLoadFactor(Float loadFactorArg) {
        this.loadFactor = loadFactorArg;
    }

    public void setStatisticsEnabled(boolean statisticsEnabledArg) {
        this.statisticsEnabled = new Boolean(statisticsEnabledArg);
    }

    public void setStatisticsEnabled(Boolean statisticsEnabledArg) {
        this.statisticsEnabled = statisticsEnabledArg;
    }

    public void setEnableOffHeapMemory(String enableOffHeapMemoryArg) {
        this.enableOffHeapMemory = enableOffHeapMemoryArg;
    }

    public void setPersistBackup(boolean persistBackupArg) {
        this.persistBackup = new Boolean(persistBackupArg);
    }

    public void setPersistBackup(Boolean persistBackupArg) {
        this.persistBackup = persistBackupArg;
    }

    public void setAsyncConflation(boolean asyncConflationArg) {
        this.asyncConflation = new Boolean(asyncConflationArg);
    }

    public void setAsyncConflation(Boolean asyncConflationArg) {
        this.asyncConflation = asyncConflationArg;
    }

    public void setEvictionLimit(int evictionLimitArg) {
        this.evictionLimit = new Integer(evictionLimitArg);
    }

    public void setEvictionLimit(Integer evictionLimitArg) {
        this.evictionLimit = evictionLimitArg;
    }

    public void setIsSynchronous(boolean isSynchronousArg) {
        this.isSynchronous = new Boolean(isSynchronousArg);
    }

    public void setIsSynchronous(Boolean isSynchronousArg) {
        this.isSynchronous = isSynchronousArg;
    }

    public void setTimeInterval(long timeIntervalArg) {
        this.timeInterval = new Long(timeIntervalArg);
    }

    public void setTimeInterval(Long timeIntervalArg) {
        this.timeInterval = timeIntervalArg;
    }

    public void setBytesThreshold(long bytesThresholdArg) {
        this.bytesThreshold = new Long(bytesThresholdArg);
    }

    public void setBytesThreshold(Long bytesThresholdArg) {
        this.bytesThreshold = bytesThresholdArg;
    }

    public void setNumDiskDirs(int numDiskDirsArg) {
        this.numDiskDirs = new Integer(numDiskDirsArg);
    }

    public void setNumDiskDirs(Integer numDiskDirsArg) {
        this.numDiskDirs = numDiskDirsArg;
    }

    public void setEvictionAction(String evictionActionArg) {
        this.evictionAction = evictionActionArg;
    }

    public void setDiskDirList(List aList) {
        this.diskDirList = aList;
    }

    public void setEviction(String evictionArg) {
        this.eviction = evictionArg;
    }

    public void setCacheListener(String listenerClassName) {
        this.cacheListeners = new ArrayList();
        this.cacheListeners.add(listenerClassName);
    }

    public void setCacheListeners(List cacheListenerArg) {
        this.cacheListeners = cacheListenerArg;
    }

    public void addCacheListener(String cacheListenerClassName) {
        if (this.cacheListeners == null) {
            this.cacheListeners = new ArrayList();
        }
        this.cacheListeners.add(cacheListenerClassName);
    }

    public void setCacheLoader(String cacheLoaderArg) {
        this.cacheLoader = cacheLoaderArg;
    }

    public void setCacheWriter(String cacheWriterArg) {
        this.cacheWriter = cacheWriterArg;
    }

    public void setObjectSizerClass(String sizerClass) {
        this.objectSizerClass = sizerClass;
    }

    public void setUseDsMulticastSetting(Boolean useDsMulticastSettingArg) {
        this.useDsMulticastSetting = useDsMulticastSettingArg;
    }

    public void setMulticastEnabled(Boolean multicastEnabledArg) {
        this.multicastEnabled = multicastEnabledArg;
    }

    public void setRollOplogs(Boolean rollOplogsArg) {
        this.rollOplogs = rollOplogsArg;
    }

    public void setRollOplogs(boolean rollOplogsArg) {
        this.rollOplogs = new Boolean(rollOplogsArg);
    }

    public void setMaxOplogSize(Integer maxOplogSizeArg) {
        this.maxOplogSize = maxOplogSizeArg;
    }

    public void setMaxOplogSize(int maxOplogSizeArg) {
        this.maxOplogSize = new Integer(maxOplogSizeArg);
    }

    public void setSubRegion(ArrayList regDefList) {
        if (regDefList == null) {
            throw new TestException("subregion list cannot be null");
        }
        this.subRegions = regDefList;
    }

    public void addSubRegion(RegionDefinition regDef) {
        if (regDef == null) {
            throw new TestException("Cannot add a null subregion");
        }
        this.subRegions.add(regDef);
    }

    public void setPartionedRegion(boolean aBool) {
        this.parReg = new Boolean(aBool);
    }

    public void setParRegCacheWriter(String cacheWriterArg) {
        this.parReg_cacheWriter = cacheWriterArg;
    }

    public void setParRegRoutingResolver(String routingResolverArg) {
        this.parReg_partitionResolver = routingResolverArg;
    }

    public void setParRegColocatedWith(String colocatedArg) {
        this.parReg_colocatedWith = colocatedArg;
    }

    public void setParRegEntryIdleTimeoutSec(int entryIdleTimeoutSecArg) {
        this.parReg_entryIdleTimeoutSec = new Integer(entryIdleTimeoutSecArg);
    }

    public void setParRegEntryIdleTimeoutSec(Integer entryIdleTimeoutSecArg) {
        this.parReg_entryIdleTimeoutSec = entryIdleTimeoutSecArg;
    }

    public void setParRegEntryIdleTimeoutAction(ExpirationAction expActionArg) {
        this.parReg_entryIdleTimeoutAction = expActionArg;
    }

    public void setParRegEntryTTLSec(int entryTTLSecArg) {
        this.parReg_entryTTLSec = new Integer(entryTTLSecArg);
    }

    public void setParRegEntryTTLSec(Integer entryTTLSecArg) {
        this.parReg_entryTTLSec = entryTTLSecArg;
    }

    public void setParRegEntryTTLAction(ExpirationAction expActionArg) {
        this.parReg_entryTTLAction = expActionArg;
    }

    public void setParRegLocalProperties(Properties propArg) {
        this.parReg_localProperties = propArg;
    }

    public void setParRegGlobalProperties(Properties propArg) {
        this.parReg_globalProperties = propArg;
    }

    public void setParRegRedundantCopies(int intArg) {
        this.parReg_redundantCopies = new Integer(intArg);
    }

    public void setParRegAttributes(RegionDefinition regDef) {
        regDef.parReg = this.parReg;
        regDef.parReg_cacheWriter = this.parReg_cacheWriter;
        regDef.parReg_colocatedWith = this.parReg_colocatedWith;
        regDef.parReg_partitionResolver = this.parReg_partitionResolver;
        regDef.parReg_entryIdleTimeoutSec = this.parReg_entryIdleTimeoutSec;
        regDef.parReg_entryIdleTimeoutAction = this.parReg_entryIdleTimeoutAction;
        regDef.parReg_entryTTLSec = this.parReg_entryTTLSec;
        regDef.parReg_entryTTLAction = this.parReg_entryTTLAction;
        regDef.parReg_localProperties = this.parReg_localProperties;
        regDef.parReg_globalProperties = this.parReg_globalProperties;
        regDef.parReg_redundantCopies = this.parReg_redundantCopies;
    }
}

