/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraRuntimeException;
import hydra.HydraSubthread;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import util.StopStartBB;
import util.StopStartPrms;
import util.TestException;
import util.TestHelper;
import vsphere.vijava.VMotionUtil;

public class StopStartVMs
extends Thread {
    private ClientVmInfo targetVm;
    private int stopMode;
    private boolean stop;
    private boolean start;
    private static final String NiceKillInProgress = "NiceKill_VmId_";
    private static final String VmInfoKey = "StopStartVMInfo_for_vmid_";

    public StopStartVMs(ClientVmInfo aVmId, int howToStop) {
        this.targetVm = aVmId;
        this.stopMode = howToStop;
        this.stop = true;
        this.start = true;
        this.setName("<StopStartVMs-thread to " + StopStartVMs.getAction(this.stop, this.start) + " " + aVmId + " with " + ClientVmMgr.toStopModeString(this.stopMode) + ">");
    }

    public StopStartVMs(ClientVmInfo aVmId, int howToStop, boolean doStop, boolean doStart) {
        if (!doStop && !doStart) {
            throw new TestException("You must specify at least one of stop or start, stop is " + doStop + " and start is " + doStart);
        }
        this.targetVm = aVmId;
        this.stopMode = howToStop;
        this.stop = doStop;
        this.start = doStart;
        if (doStop) {
            this.setName("<StopStartVMs-thread to " + StopStartVMs.getAction(this.stop, this.start) + " " + aVmId + " with " + ClientVmMgr.toStopModeString(this.stopMode) + ">");
        } else {
            this.setName("<StopStartVMs-thread to " + StopStartVMs.getAction(this.stop, this.start) + " " + aVmId + ">");
        }
    }

    @Override
    public void run() {
        try {
            Log.getLogWriter().info("Started " + this.getName());
            try {
                if (this.stop) {
                    ClientVmMgr.stop("Test is synchronously stopping " + this.targetVm + " with " + ClientVmMgr.toStopModeString(this.stopMode), this.stopMode, -31, this.targetVm);
                }
                VMotionUtil.doVMotion(this.targetVm);
                if (this.start) {
                    ClientVmMgr.start("Test is synchronously starting " + this.targetVm, this.targetVm);
                }
            }
            catch (ClientVmNotFoundException e) {
                Log.getLogWriter().info("Caught in thread " + this.getName() + ":" + TestHelper.getStackTrace(e));
                StopStartBB.getBB().getSharedMap().put("errorKey", TestHelper.getStackTrace(e));
            }
        }
        catch (Throwable e) {
            Log.getLogWriter().info("Caught in thread " + this.getName() + ":" + TestHelper.getStackTrace(e));
            StopStartBB.getBB().getSharedMap().put("errorKey", TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info(this.getName() + " terminating");
    }

    public static Object[] getOtherVMs(int numToTarget) {
        return StopStartVMs.getOtherVMsWithExclude(numToTarget, null);
    }

    public static Object[] getOtherVMs(int numToTarget, String clientMatchStr) {
        Log.getLogWriter().info("Choosing " + numToTarget + " vms (other than this one)");
        ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        int myVmID = RemoteTestModule.getMyVmid();
        List vmInfoList = StopStartVMs.getAllVMs();
        vmInfoList = StopStartVMs.getMatchVMs(vmInfoList, clientMatchStr);
        do {
            if (vmInfoList.size() == 0) {
                throw new TestException("Unable to find " + numToTarget + " vms to stop with client match string " + clientMatchStr + "; either a test problem or add StopStartVMs.StopStart_initTask to the test");
            }
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmInfoList.size() - 1);
            ClientVmInfo info = (ClientVmInfo)vmInfoList.get(randInt);
            if (info.getVmid() != myVmID) {
                vmList.add(info);
                String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                stopModeList.add(choice);
            }
            vmInfoList.remove(randInt);
        } while (vmList.size() < numToTarget);
        return new Object[]{vmList, stopModeList, vmInfoList};
    }

    public static Object[] getOtherVMsWithExclude(int numToTarget, String clientExcludeStr) {
        Log.getLogWriter().info("Choosing " + numToTarget + " vms (other than this one)");
        ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        int myVmID = RemoteTestModule.getMyVmid();
        List vmInfoList = StopStartVMs.getAllVMs();
        do {
            ClientVmInfo info;
            if (vmInfoList.size() == 0) {
                throw new TestException("Unable to find " + numToTarget + " vms to stop with client exclude string " + clientExcludeStr + "; either a test problem or add StopStartVMs.StopStart_initTask to the test");
            }
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmInfoList.size() - 1);
            Object anObj = vmInfoList.get(randInt);
            if (anObj instanceof ClientVmInfo && (info = (ClientVmInfo)anObj).getVmid() != myVmID && (clientExcludeStr == null || info.getClientName().indexOf(clientExcludeStr) < 0)) {
                vmList.add(info);
                String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                stopModeList.add(choice);
            }
            vmInfoList.remove(randInt);
        } while (vmList.size() < numToTarget);
        return new Object[]{vmList, stopModeList, vmInfoList};
    }

    public static Object[] getOtherVMsWithExcludeVmid(int numToTarget, String clientMatchStr, ArrayList<Integer> vmIds) {
        Log.getLogWriter().info("Choosing " + numToTarget + " vms (other than this one)");
        ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        int myVmID = RemoteTestModule.getMyVmid();
        List vmInfoList = StopStartVMs.getAllVMs();
        vmInfoList = StopStartVMs.getMatchVMs(vmInfoList, clientMatchStr);
        do {
            if (vmInfoList.size() == 0) {
                throw new TestException("Unable to find " + numToTarget + " vms to stop with client match string " + clientMatchStr + "; either a test problem or add StopStartVMs.StopStart_initTask to the test");
            }
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmInfoList.size() - 1);
            ClientVmInfo info = (ClientVmInfo)vmInfoList.get(randInt);
            boolean exclude = false;
            for (int vmId : vmIds) {
                if (info.getVmid() != vmId) continue;
                exclude = true;
            }
            if (info.getVmid() != myVmID && !exclude) {
                vmList.add(info);
                String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                stopModeList.add(choice);
            }
            vmInfoList.remove(randInt);
        } while (vmList.size() < numToTarget);
        return new Object[]{vmList, stopModeList, vmInfoList};
    }

    public static void stopStartOtherVMs(int numToTarget) {
        Log.getLogWriter().info("In stopStartVMs, attempting to stop/restart " + numToTarget + " vms (other than this one)");
        Object[] tmpArr = StopStartVMs.getOtherVMs(numToTarget);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        StopStartVMs.stopStartVMs(vmList, stopModeList);
        Log.getLogWriter().info("In stopStartVMs, done with stop/restart " + numToTarget + " vms (other than this one)");
    }

    public static void stopStartVMs(List targetVmList, List stopModeList) {
        List threadList = StopStartVMs.stopStartAsync(targetVmList, stopModeList);
        StopStartVMs.joinStopStart(targetVmList, threadList);
    }

    public static List stopStartAsync(List targetVmList, List stopModeList) {
        if (targetVmList.size() != stopModeList.size()) {
            throw new TestException("Expected targetVmList " + targetVmList + " and stopModeList " + stopModeList + " to be parallel lists of the same size, but they have different sizes");
        }
        Log.getLogWriter().info("In stopStartVMs, vms to stop: " + targetVmList + ", corresponding stop modes: " + stopModeList);
        for (int i = 0; i < stopModeList.size(); ++i) {
            String stopMode = (String)stopModeList.get(i);
            if (ClientVmMgr.toStopMode(stopMode) != -20) continue;
            StopStartBB.getBB().getSharedMap().put(NiceKillInProgress + ((ClientVmInfo)targetVmList.get(i)).getVmid(), new Boolean(true));
        }
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < targetVmList.size(); ++i) {
            ClientVmInfo targetVm = (ClientVmInfo)targetVmList.get(i);
            int stopMode = ClientVmMgr.toStopMode((String)stopModeList.get(i));
            Thread aThread = new StopStartVMs(targetVm, stopMode);
            aThread = new HydraSubthread(aThread);
            threadList.add(aThread);
            aThread.start();
        }
        return threadList;
    }

    public static List startAsync(List targetVmList) {
        Log.getLogWriter().info("In stopStartVMs, vms to start: " + targetVmList);
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < targetVmList.size(); ++i) {
            ClientVmInfo targetVm = (ClientVmInfo)targetVmList.get(i);
            Thread aThread = new StopStartVMs(targetVm, 0, false, true);
            aThread = new HydraSubthread(aThread);
            threadList.add(aThread);
            aThread.start();
        }
        return threadList;
    }

    public static void joinStopStart(List targetVmList, List threadList) {
        int i;
        Log.getLogWriter().info("Joining stop/start threads...");
        for (i = 0; i < threadList.size(); ++i) {
            HydraSubthread aThread = (HydraSubthread)threadList.get(i);
            try {
                aThread.join();
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Object err = StopStartBB.getBB().getSharedMap().get("errorKey");
            if (err == null) continue;
            throw new TestException(err.toString());
        }
        for (i = 0; i < targetVmList.size(); ++i) {
            ClientVmInfo targetVm = (ClientVmInfo)targetVmList.get(i);
            StopStartBB.getBB().getSharedMap().put(NiceKillInProgress + targetVm.getVmid(), new Boolean(false));
        }
        Log.getLogWriter().info("Done joining stop/start threads...");
    }

    public static boolean niceKillInProgress() {
        Object niceKill = StopStartBB.getBB().getSharedMap().get(NiceKillInProgress + RemoteTestModule.getMyVmid());
        boolean niceKillInProgress = niceKill != null && (Boolean)niceKill != false;
        return niceKillInProgress;
    }

    public static void StopStart_initTask() {
        int myVMid = RemoteTestModule.getMyVmid();
        ClientVmInfo myInfo = new ClientVmInfo(new Integer(myVMid), RemoteTestModule.getMyClientName(), null);
        StopStartBB.getBB().getSharedMap().put(VmInfoKey + myVMid, myInfo);
    }

    public static List getAllVMs() {
        ArrayList aList = new ArrayList();
        Map aMap = StopStartBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            Object value = aMap.get(key);
            if (!(value instanceof ClientVmInfo)) continue;
            aList.add(value);
        }
        return aList;
    }

    private static String getAction(boolean doStop, boolean doStart) {
        String actionStr = null;
        actionStr = doStop && doStart ? "stop and start" : (doStop && !doStart ? "stop" : (!doStop && doStart ? "start" : "unknown"));
        return actionStr;
    }

    public static void stopVMs(List targetVmList, List stopModeList) {
        StopStartVMs.stopStartVMs(targetVmList, stopModeList, true, false);
    }

    public static List stopVMs(int numVMsToStop) {
        Object[] anArr = StopStartVMs.getOtherVMs(numVMsToStop);
        List targetVmList = (List)anArr[0];
        List stopModeList = (List)anArr[1];
        StopStartVMs.stopStartVMs(targetVmList, stopModeList, true, false);
        return targetVmList;
    }

    public static void startVMs(List targetVmList) {
        StopStartVMs.stopStartVMs(targetVmList, null, false, true);
    }

    public static void startVMs(ClientVmInfo aVM) {
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        aList.add(aVM);
        StopStartVMs.stopStartVMs(aList, null, false, true);
    }

    private static void stopStartVMs(List targetVmList, List stopModeList, boolean doStop, boolean doStart) {
        int i;
        Log.getLogWriter().info("In stopStartVMs, vms to " + StopStartVMs.getAction(doStop, doStart) + ": " + targetVmList + ", corresponding stop modes: " + stopModeList);
        if (doStop) {
            for (int i2 = 0; i2 < stopModeList.size(); ++i2) {
                String stopMode = (String)stopModeList.get(i2);
                if (ClientVmMgr.toStopMode(stopMode) != -20) continue;
                StopStartBB.getBB().getSharedMap().put(NiceKillInProgress + ((ClientVmInfo)targetVmList.get(i2)).getVmid(), new Boolean(true));
            }
        }
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (i = 0; i < targetVmList.size(); ++i) {
            ClientVmInfo targetVm = (ClientVmInfo)targetVmList.get(i);
            int stopMode = 0;
            if (doStop) {
                stopMode = ClientVmMgr.toStopMode((String)stopModeList.get(i));
            }
            StringBuffer aStr = new StringBuffer();
            Thread aThread = new StopStartVMs(targetVm, stopMode, doStop, doStart);
            aThread = new HydraSubthread(aThread);
            threadList.add(aThread);
            aThread.start();
        }
        for (i = 0; i < threadList.size(); ++i) {
            Thread aThread = (Thread)threadList.get(i);
            try {
                aThread.join();
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        String err = (String)StopStartBB.getBB().getSharedMap().get("errorKey");
        if (err != null) {
            throw new TestException(err);
        }
        if (doStop) {
            for (int i3 = 0; i3 < targetVmList.size(); ++i3) {
                ClientVmInfo targetVm = (ClientVmInfo)targetVmList.get(i3);
                StopStartBB.getBB().getSharedMap().put(NiceKillInProgress + targetVm.getVmid(), new Boolean(false));
            }
        }
        Log.getLogWriter().info("In stopStartVMs, done with " + StopStartVMs.getAction(doStop, doStart) + ": " + targetVmList);
    }

    public static String getClientName(Integer vmID) {
        for (Object anObj : StopStartBB.getBB().getSharedMap().getMap().values()) {
            ClientVmInfo info;
            if (!(anObj instanceof ClientVmInfo) || !(info = (ClientVmInfo)anObj).getVmid().equals(vmID)) continue;
            return info.getClientName();
        }
        return null;
    }

    public static List getMatchVMs(List vmInfoList, String matchStr) {
        ArrayList<ClientVmInfo> returnList = new ArrayList<ClientVmInfo>();
        for (int i = 0; i < vmInfoList.size(); ++i) {
            ClientVmInfo info;
            Object anObj = vmInfoList.get(i);
            if (!(anObj instanceof ClientVmInfo) || (info = (ClientVmInfo)anObj).getClientName().indexOf(matchStr) < 0) continue;
            returnList.add(info);
        }
        return returnList;
    }

    public static void startVM(ClientVmInfo vm) {
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        aList.add(vm);
        StopStartVMs.startVMs(aList);
    }

    public static void stopVM(ClientVmInfo vm, String stopMode) {
        ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
        vmList.add(vm);
        ArrayList<String> stopModeList = new ArrayList<String>();
        stopModeList.add(stopMode);
        StopStartVMs.stopVMs(vmList, stopModeList);
    }

    public static Object[] getOtherVMsDivided() {
        Vector otherVmIDs = ClientVmMgr.getOtherClientVmids();
        ArrayList<ClientVmInfo> allOtherVMs = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 0; i < otherVmIDs.size(); ++i) {
            ClientVmInfo info = new ClientVmInfo((Integer)otherVmIDs.get(i));
            allOtherVMs.add(info);
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        List allOtherVMsExceptOne = allOtherVMs.subList(0, allOtherVMs.size() - 1);
        List stopModesExceptOne = stopModeList.subList(0, stopModeList.size() - 1);
        ClientVmInfo remainingVM = (ClientVmInfo)allOtherVMs.get(allOtherVMs.size() - 1);
        String remainingStopMode = (String)stopModeList.get(stopModeList.size() - 1);
        return new Object[]{allOtherVMsExceptOne, stopModesExceptOne, remainingVM, remainingStopMode, allOtherVMs, stopModeList};
    }

    public static Object[] getOtherVMsDivided(String[] excludedClientNames) {
        Vector otherVmIDs = ClientVmMgr.getOtherClientVmids();
        ArrayList<ClientVmInfo> allOtherVMs = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 0; i < otherVmIDs.size(); ++i) {
            String excludeName;
            String clientName;
            ClientVmInfo info = new ClientVmInfo((Integer)otherVmIDs.get(i));
            ClientVmInfo infoFromBB = (ClientVmInfo)StopStartBB.getBB().getSharedMap().get(VmInfoKey + otherVmIDs.get(i));
            if (infoFromBB != null) {
                info = infoFromBB;
            }
            if ((clientName = info.getClientName()) == null) {
                allOtherVMs.add(info);
                stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
                continue;
            }
            boolean inExcludedNames = false;
            int i$ = 0;
            String[] arr$ = excludedClientNames;
            int len$ = arr$.length;
            if (i$ < len$ && clientName.indexOf(excludeName = arr$[i$]) >= 0) {
                inExcludedNames = true;
            }
            if (inExcludedNames) continue;
            allOtherVMs.add(info);
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        List allOtherVMsExceptOne = allOtherVMs.subList(0, allOtherVMs.size() - 1);
        List stopModesExceptOne = stopModeList.subList(0, stopModeList.size() - 1);
        ClientVmInfo remainingVM = (ClientVmInfo)allOtherVMs.get(allOtherVMs.size() - 1);
        String remainingStopMode = (String)stopModeList.get(stopModeList.size() - 1);
        return new Object[]{allOtherVMsExceptOne, stopModesExceptOne, remainingVM, remainingStopMode, allOtherVMs, stopModeList};
    }

    public static Object[] shutDownAllMembers(AdminDistributedSystem adminDS) {
        ArrayList<String> stopModes = new ArrayList<String>();
        stopModes.add("nice_exit");
        return StopStartVMs.shutDownAllMembers(adminDS, stopModes);
    }

    public static Object[] shutDownAllMembers(AdminDistributedSystem adminDS, List<String> stopModes) {
        Set memberSet;
        if (adminDS == null) {
            throw new HydraRuntimeException("AdminDistributedSystem cannot be null");
        }
        Log.getLogWriter().info("AdminDS " + adminDS + " is shutting down all members...");
        try {
            long startTime = System.currentTimeMillis();
            memberSet = adminDS.shutDownAllMembers();
            long duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("AdminDS " + adminDS + " shut down (disconnected) the following members " + "(vms remain up): " + memberSet + "; shutDownAll duration " + duration + "ms");
        }
        catch (AdminException e1) {
            throw new TestException(TestHelper.getStackTrace(e1));
        }
        ArrayList<ClientVmInfo> allClientInfos = new ArrayList<ClientVmInfo>();
        ArrayList<ClientVmInfo> allOtherClientInfos = new ArrayList<ClientVmInfo>();
        ClientVmInfo thisClientInfo = null;
        ArrayList<String> stopModesToUse = new ArrayList<String>();
        for (DistributedMember aMember : memberSet) {
            Integer vmId = null;
            try {
                vmId = new Integer(RemoteTestModule.Master.getVmid(aMember.getHost(), aMember.getProcessId()));
            }
            catch (RemoteException e) {
                throw new HydraRuntimeException("Unable to get vmID for " + aMember + ": " + e);
            }
            ClientVmInfo infoFromBB = (ClientVmInfo)StopStartBB.getBB().getSharedMap().get(VmInfoKey + vmId);
            String clientName = null;
            if (infoFromBB != null) {
                clientName = infoFromBB.getClientName();
            }
            ClientVmInfo info = new ClientVmInfo(vmId, clientName, null);
            allClientInfos.add(info);
            if (vmId == RemoteTestModule.getMyVmid()) {
                thisClientInfo = info;
            } else {
                allOtherClientInfos.add(info);
            }
            stopModesToUse.add(stopModes.get(TestConfig.tab().getRandGen().nextInt(0, stopModes.size() - 1)));
        }
        Object[] returnArr = new Object[2];
        if (thisClientInfo == null) {
            StopStartVMs.stopVMs(allClientInfos, stopModesToUse);
            returnArr[0] = allClientInfos;
        } else {
            StopStartVMs.stopVMs(allOtherClientInfos, stopModesToUse.subList(0, stopModesToUse.size()));
            returnArr[0] = allOtherClientInfos;
        }
        returnArr[1] = memberSet;
        return returnArr;
    }
}

