/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.size.WellKnownClassSizer;
import com.gemstone.gemfire.pdx.PdxSerializable;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.CacheHelper;
import hydra.ClientDescription;
import hydra.ClientPrms;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.GemFirePrms;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import rollingupgrade.RollingUpgradePrms;
import util.CacheUtil;
import util.ExceptionVersionHelper;
import util.GenericComparator;
import util.QueryObject;
import util.TestException;
import util.TestHelperPrms;
import util.TestHelperVersionHelper;
import util.ValueHolderIF;

public class TestHelper {
    public static final int MILLIS = 0;
    public static final int NANOS = 1;
    public static final int MICROS = 2;
    public static final int SECONDS = 3;
    public static final long SEC_NANO_FACTOR = 1000000000L;
    public static final long MILLI_NANO_FACTOR = 1000000L;
    public static final long MILLI_MICRO_FACTOR = 1000L;
    public static final long MICRO_NANO_FACTOR = 1000L;
    public static final long SEC_MILLI_FACTOR = 1000L;
    public static String EVENT_ERROR_KEY = "EventErrorMessage";
    static int recursionCount = 0;

    public static String toString(Object anObj) {
        recursionCount = 0;
        int printElementsLimit = TestConfig.tab().intAt(TestHelperPrms.printElementsLimit, 0);
        int printObjectDepth = TestConfig.tab().intAt(TestHelperPrms.printObjectDepth, 0);
        StringBuffer aStr = new StringBuffer();
        TestHelper.toString(anObj, "", printElementsLimit, 0, printObjectDepth, aStr);
        return aStr.toString();
    }

    public static String toString(Object anObj, int numElements, int depth) {
        recursionCount = 0;
        StringBuffer aStr = new StringBuffer();
        TestHelper.toString(anObj, "", numElements, 0, depth, aStr);
        return aStr.toString();
    }

    private static void toString(Object anObj, String prefix, int numElements, int currentDepth, int maxDepth, StringBuffer result) {
        if (++recursionCount >= 1000) {
            result.append("...");
            return;
        }
        if (currentDepth > maxDepth) {
            return;
        }
        String tab = "";
        for (int i = 1; i <= currentDepth; ++i) {
            tab = tab + "  ";
        }
        if (result.length() > 0) {
            result.append("\n");
        }
        result.append(tab);
        result.append(prefix);
        if (anObj == null) {
            result.append("null");
            return;
        }
        Class<?> aClass = anObj.getClass();
        result.append("<");
        if (anObj instanceof Map) {
            Map aMap = (Map)anObj;
            int size = aMap.size();
            result.append(TestHelper.basicsToString(anObj, new Integer(size)));
            if (numElements > 0) {
                Iterator it = aMap.keySet().iterator();
                int count = 0;
                while (it.hasNext() && count++ < numElements) {
                    Object key = it.next();
                    TestHelper.toString(key, "Key: ", numElements, currentDepth + 1, maxDepth, result);
                    TestHelper.toString(aMap.get(key), "Value: ", numElements, currentDepth + 1, maxDepth, result);
                }
                TestHelper.addCutoffWarning(count != size && count >= numElements, tab + "  ", result, numElements);
            }
        } else if (anObj instanceof List) {
            List aList = (List)anObj;
            int size = aList.size();
            result.append(TestHelper.basicsToString(anObj, new Integer(size)));
            if (numElements > 0) {
                int count;
                for (count = 0; count < size && count < numElements; ++count) {
                    TestHelper.toString(aList.get(count), count + ": ", numElements, currentDepth + 1, maxDepth, result);
                }
                TestHelper.addCutoffWarning(count != size && count >= numElements, tab + "  ", result, numElements);
            }
        } else if (anObj instanceof Set) {
            Set aSet = (Set)anObj;
            int size = aSet.size();
            result.append(TestHelper.basicsToString(anObj, new Integer(size)));
            if (numElements > 0) {
                Iterator it = aSet.iterator();
                int count = 0;
                while (it.hasNext() && count++ < numElements) {
                    TestHelper.toString(it.next(), "", numElements, currentDepth + 1, maxDepth, result);
                }
                TestHelper.addCutoffWarning(count != size && count >= numElements, tab + "  ", result, numElements);
            }
        } else if (aClass == String.class) {
            int stringLimit = 10;
            try {
                stringLimit = TestConfig.tab().intAt(TestHelperPrms.printStringLimit, 100);
            }
            catch (HydraRuntimeException size) {
                // empty catch block
            }
            String aStr = (String)anObj;
            result.append(TestHelper.basicsToString(anObj, new Integer(aStr.length())));
            result.append(" ");
            if (aStr.length() > stringLimit) {
                result.append("\"");
                for (int i = 0; i < stringLimit; ++i) {
                    result.append(aStr.charAt(i));
                }
                result.append("...\"");
            } else {
                result.append("\"").append(aStr).append("\"");
            }
        } else if (aClass == StringBuffer.class) {
            int stringLimit = 50;
            StringBuffer aStr = (StringBuffer)anObj;
            result.append(TestHelper.basicsToString(anObj, new Integer(aStr.length()))).append(" ");
            if (aStr.length() > stringLimit) {
                result.append("\"");
                for (int i = 0; i < stringLimit; ++i) {
                    result.append(aStr.charAt(i));
                }
                result.append("...\"");
            } else {
                result.append("\"").append(aStr).append("\"");
            }
        } else if (anObj instanceof Number) {
            result.append(TestHelper.basicsToString(anObj, null));
            result.append(", value ").append(anObj);
        } else if (aClass.isArray()) {
            result.append(TestHelper.basicsToString(anObj, new Integer(Array.getLength(anObj))));
            Class<?> componentType = aClass.getComponentType();
            result.append(", componentType ").append(componentType.getName());
            if (numElements > 0) {
                int size = Array.getLength(anObj);
                int count = 0;
                for (int i = 0; i < size && count++ < numElements; ++i) {
                    TestHelper.toString(Array.get(anObj, i), "", numElements, currentDepth + 1, maxDepth, result);
                }
                TestHelper.addCutoffWarning(count != size && count >= numElements, tab + "  ", result, numElements);
            }
        } else if (aClass == Boolean.class) {
            result.append(TestHelper.basicsToString(anObj, null));
            result.append(", value ").append(anObj);
        } else if (aClass == Character.class) {
            result.append(TestHelper.basicsToString(anObj, null));
            result.append(" value (as int) " + ((Character)anObj).charValue());
        } else if (aClass == Date.class) {
            result.append(TestHelper.basicsToString(anObj, null));
            Date aDate = (Date)anObj;
            result.append(", getTime() = ").append(aDate.getTime());
            result.append(", (").append(aDate).append(")");
        } else if (anObj instanceof ValueHolderIF) {
            ValueHolderIF valueHolder = (ValueHolderIF)anObj;
            result.append(valueHolder.toString());
        } else if (anObj instanceof QueryObject) {
            result.append(TestHelper.basicsToString(anObj, null));
            result.append(" " + anObj.toString());
        } else if (anObj instanceof PdxSerializable) {
            result.append(anObj.toString());
        } else {
            result.append(TestHelper.basicsToString(anObj, null));
        }
        result.append(">");
    }

    private static void addCutoffWarning(boolean abool, String tab, StringBuffer aStr, int printElementsLimit) {
        if (abool) {
            aStr.append("\n");
            aStr.append(tab);
            aStr.append("....(not showing remaining elements due to printElementsLimit " + printElementsLimit);
        }
    }

    private static String basicsToString(Object anObj, Integer size) {
        if (anObj == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        result.append(anObj.getClass().getName());
        if (size != null) {
            result.append(" Size ").append(size);
        }
        return result.toString();
    }

    public static String getStackTrace() {
        return TestHelper.getStackTrace("Exception to get stack trace");
    }

    public static String getStackTrace(String reason) {
        try {
            throw new Exception(reason);
        }
        catch (Exception e) {
            return TestHelper.getStackTrace(e);
        }
    }

    public static Throwable findCause(Throwable aThrowable, Class type) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("aThrowable cannot be null");
        }
        while (aThrowable != null && !type.isInstance(aThrowable)) {
            aThrowable = aThrowable.getCause();
        }
        return aThrowable;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter sw = new StringWriter();
        aThrowable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String format(double adouble, int placesBeforeDecimal, int placesAfterDecimal) {
        String aStr = "" + adouble;
        int index = aStr.indexOf(".");
        if (index >= 0 && index < placesBeforeDecimal) {
            int numToAdd = placesBeforeDecimal - index;
            for (int i = 1; i <= numToAdd; ++i) {
                aStr = "0" + aStr;
            }
        }
        index = aStr.indexOf(".");
        int currPlacesAfterDecimal = aStr.length() - index - 1;
        if (currPlacesAfterDecimal >= placesAfterDecimal) {
            return aStr;
        }
        int numToAdd = placesAfterDecimal - currPlacesAfterDecimal;
        for (int i = 1; i <= numToAdd; ++i) {
            aStr = aStr + "0";
        }
        return aStr;
    }

    public static String format(long along, int places) {
        String intStr = "" + along;
        while (intStr.length() < places) {
            intStr = "0" + intStr;
        }
        return intStr;
    }

    public static String millisToString(long millis) {
        long sec = millis / 1000L;
        long min = sec / 60L;
        String aStr = millis + " ms (" + min + ":" + TestHelper.format(sec %= 60L, 2) + ":" + TestHelper.format(millis, 3) + " (min:sec:ms))";
        return aStr;
    }

    public static String nanosToString(long nanos) {
        if (nanos < 0L) {
            return "" + nanos;
        }
        long millis = nanos % 1000000000L;
        long sec = nanos / 1000000000L;
        long min = sec / 60L;
        String aStr = min + ":" + TestHelper.format(sec %= 60L, 2) + ":" + TestHelper.format(millis / 1000000L, 3) + "." + millis % 1000000L + " (min:sec:ms)";
        long checkNanos = TestHelper.stringToNanos(aStr);
        if (checkNanos != nanos) {
            throw new TestException("Original nanos: " + nanos + ", as string " + aStr + ", back to nanos " + checkNanos);
        }
        return aStr;
    }

    public static long stringToNanos(String aStr) {
        try {
            int index1 = aStr.indexOf(":");
            String minStr = aStr.substring(0, index1);
            int index2 = aStr.indexOf(":", ++index1);
            String secStr = aStr.substring(index1, index2);
            index1 = index2 + 1;
            index2 = aStr.indexOf(".", index1);
            String millisStr = aStr.substring(index1, index2);
            index1 = index2 + 1;
            index2 = aStr.indexOf(" ", index1);
            if (index2 < 0) {
                index2 = aStr.length();
            }
            String nanosStr = aStr.substring(index1, index2);
            long min = new Long(minStr);
            long sec = new Long(secStr);
            long millis = new Long(millisStr);
            long nanos = new Long(nanosStr);
            nanos = min * 60L * 1000000000L + sec * 1000000000L + millis * 1000000L + nanos;
            return nanos;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e) + "\n" + aStr);
        }
    }

    public static String unitToString(int timeUnit) {
        if (timeUnit == 0) {
            return "millis";
        }
        if (timeUnit == 1) {
            return "nanos";
        }
        if (timeUnit == 2) {
            return "micros";
        }
        if (timeUnit == 3) {
            return "seconds";
        }
        throw new TestException("Unknown time unit " + timeUnit);
    }

    public static int getPercentageOf(int percentage, int anInt) {
        if (percentage == 0) {
            return 0;
        }
        if (percentage == 100) {
            return anInt;
        }
        if (percentage < 0) {
            throw new TestException("Percentage = " + percentage + " is negative");
        }
        int returnInt = (int)((double)anInt * ((double)percentage / 100.0));
        return returnInt;
    }

    public static boolean borderCase(Long paramKey) {
        int borderCasePercentage = TestConfig.tab().intAt(paramKey);
        boolean borderCase = TestConfig.tab().getRandGen().nextInt(1, 100) <= borderCasePercentage;
        return borderCase;
    }

    public static Object getRandomKeyInMap(Map aMap) {
        if (aMap.size() == 0) {
            throw new TestException("Map is empty");
        }
        Iterator it = aMap.keySet().iterator();
        int randInt = TestConfig.tab().getRandGen().nextInt(1, aMap.size());
        Object key = null;
        for (int count = 0; count < randInt; ++count) {
            key = it.next();
        }
        return key;
    }

    public static Object getRandomElementInSet(Set aSet) {
        if (aSet.size() == 0) {
            throw new TestException("Set is empty");
        }
        TreeSet tSet = new TreeSet(new GenericComparator());
        tSet.addAll(aSet);
        Iterator it = tSet.iterator();
        int randInt = TestConfig.tab().getRandGen().nextInt(1, tSet.size());
        Object element = null;
        for (int i = 0; i < randInt; ++i) {
            element = it.next();
            boolean contains = aSet.contains(element);
            if (contains) continue;
            throw new TestException(TestHelper.toString(aSet, aSet.size(), 1) + " contains " + TestHelper.toString(element) + " but calling contains returns false");
        }
        return element;
    }

    public static ExpirationAction stringToExpirationAction(String eaStr) {
        if (eaStr.equalsIgnoreCase("DESTROY")) {
            return ExpirationAction.DESTROY;
        }
        if (eaStr.equalsIgnoreCase("INVALIDATE")) {
            return ExpirationAction.INVALIDATE;
        }
        if (eaStr.equalsIgnoreCase("LOCAL_DESTROY")) {
            return ExpirationAction.LOCAL_DESTROY;
        }
        if (eaStr.equalsIgnoreCase("LOCAL_INVALIDATE")) {
            return ExpirationAction.LOCAL_INVALIDATE;
        }
        throw new TestException("Unknown expiration action " + eaStr);
    }

    public static void sleepForever() {
        try {
            Log.getLogWriter().info("Calling Thread.currentThread().sleep(9223372036854775807)...");
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void waitForCounterSum(Blackboard BB2, String counterName1, String counterName2, long requiredCounterSum, boolean exact, long waitLimitMS) {
        boolean done;
        long startTime;
        SharedCounters counters = BB2.getSharedCounters();
        long lastLogTime = startTime = System.currentTimeMillis();
        long logIntervalMillis = 5000L;
        int whichCounter1 = BB2.getSharedCounter(counterName1);
        int whichCounter2 = BB2.getSharedCounter(counterName2);
        long currCounter1 = counters.read(whichCounter1);
        long currCounter2 = counters.read(whichCounter2);
        long currSum = currCounter1 + currCounter2;
        Log.getLogWriter().info("Waiting for " + BB2.getClass().getName() + "." + counterName1 + " (current value: " + counters.read(whichCounter1) + ") and " + BB2.getClass().getName() + "." + counterName2 + " (current value: " + counters.read(whichCounter2) + ") to have sum " + requiredCounterSum + "; exact=" + exact + "; current counter sum is " + currSum);
        boolean bl = exact ? currSum == requiredCounterSum : (done = currSum >= requiredCounterSum);
        while (!done) {
            if (System.currentTimeMillis() - lastLogTime >= logIntervalMillis) {
                lastLogTime = System.currentTimeMillis();
                currCounter1 = counters.read(whichCounter1);
                currCounter2 = counters.read(whichCounter2);
                currSum = currCounter1 + currCounter2;
                Log.getLogWriter().info("Waiting for " + BB2.getClass().getName() + "." + counterName1 + " (current value: " + counters.read(whichCounter1) + ") and " + BB2.getClass().getName() + "." + counterName2 + " (current value: " + counters.read(whichCounter2) + ") to have sum " + requiredCounterSum + "; exact=" + exact + "; current counter sum is " + currSum);
            }
            if (waitLimitMS >= 0L && System.currentTimeMillis() - startTime >= waitLimitMS) {
                BB2.printSharedCounters();
                throw new TestException("After waiting for " + (System.currentTimeMillis() - startTime) + " millis, " + BB2.getClass().getName() + "." + counterName1 + " (current value: " + currCounter1 + ") and " + BB2.getClass().getName() + "." + counterName2 + " (current value: " + currCounter2 + ") have sum " + currSum + ", but expected it to be " + requiredCounterSum);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new TestException(e.toString());
            }
            currCounter1 = counters.read(whichCounter1);
            currCounter2 = counters.read(whichCounter2);
            currSum = currCounter1 + currCounter2;
            done = exact ? currSum == requiredCounterSum : currSum >= requiredCounterSum;
        }
        Log.getLogWriter().info("Finished waiting for " + BB2.getClass().getName() + "." + counterName1 + " (current value: " + counters.read(whichCounter1) + ") and " + BB2.getClass().getName() + "." + counterName2 + " (current value: " + counters.read(whichCounter2) + ") to have sum " + requiredCounterSum + "; exact=" + exact + "; current counter sum is " + currSum);
    }

    public static void waitForCounter(Blackboard BB2, String counterName, int whichCounter, long requiredCounterValue, boolean exact, long waitLimitMS, long sleepMS) {
        boolean done;
        long startTime;
        SharedCounters counters = BB2.getSharedCounters();
        long lastLogTime = startTime = System.currentTimeMillis();
        long logIntervalMillis = 5000L;
        Log.getLogWriter().info("Waiting for " + BB2.getClass().getName() + "." + counterName + " to have value " + requiredCounterValue + "; exact=" + exact + "; current counter value is " + counters.read(whichCounter));
        boolean bl = exact ? counters.read(whichCounter) == requiredCounterValue : (done = counters.read(whichCounter) >= requiredCounterValue);
        while (!done) {
            if (System.currentTimeMillis() - lastLogTime >= logIntervalMillis) {
                lastLogTime = System.currentTimeMillis();
                Log.getLogWriter().info("Waiting for " + counterName + " to reach " + requiredCounterValue + "; current counter value is " + counters.read(whichCounter));
            }
            if (waitLimitMS >= 0L && System.currentTimeMillis() - startTime >= waitLimitMS) {
                BB2.printSharedCounters();
                throw new TestException("After waiting for " + (System.currentTimeMillis() - startTime) + " millis, " + BB2.getClass().getName() + "." + counterName + " has value of " + counters.read(whichCounter) + ", but expected it to become " + requiredCounterValue);
            }
            try {
                Thread.sleep(sleepMS);
            }
            catch (InterruptedException e) {
                throw new TestException(e.toString());
            }
            done = exact ? counters.read(whichCounter) == requiredCounterValue : counters.read(whichCounter) >= requiredCounterValue;
        }
        Log.getLogWriter().info("Finished waiting for " + counterName + " to have value " + requiredCounterValue + "; exact=" + exact + "; current counter value is " + counters.read(whichCounter));
    }

    public static void waitForCounter(Blackboard BB2, String counterName, int whichCounter, long requiredCounterValue, boolean exact, long waitLimitMS) {
        TestHelper.waitForCounter(BB2, counterName, whichCounter, requiredCounterValue, exact, waitLimitMS, 100L);
    }

    public static String waitForContainsKey(Region aRegion, Object key, boolean expected, long timeoutMS, boolean logProgress) {
        long startTime;
        StringBuffer logStr = new StringBuffer();
        String aStr = "Waiting for " + TestHelper.regionToString(aRegion, false) + ".containsKey(" + key + ") to become " + expected;
        logStr.append(new Date() + ": " + aStr + "\n");
        if (logProgress) {
            Log.getLogWriter().info(aStr);
        }
        logStr.append(aStr);
        long lastLogTime = startTime = System.currentTimeMillis();
        long logIntervalMS = 15000L;
        while (true) {
            boolean containsKey;
            if ((containsKey = aRegion.containsKey(key)) == expected) {
                aStr = TestHelper.regionToString(aRegion, false) + ".containsKey(" + key + ") has expected value " + containsKey;
                logStr.append(new Date() + ": " + aStr + "\n");
                if (logProgress) {
                    Log.getLogWriter().info(aStr);
                }
                return logStr.toString();
            }
            long currentWaitTime = System.currentTimeMillis() - startTime;
            if (currentWaitTime >= timeoutMS) {
                throw new TestException("After waiting " + currentWaitTime + " millis, " + TestHelper.regionToString(aRegion, false) + ".containsKey(" + key + ") is " + containsKey + "; expected it to become " + expected + "\nLog of wait progress: " + logStr);
            }
            if (System.currentTimeMillis() - lastLogTime >= logIntervalMS) {
                aStr = "Waiting for " + TestHelper.regionToString(aRegion, false) + ".containsKey(" + key + ") to become " + expected + "...";
                logStr.append(new Date() + ": " + aStr + "\n");
                if (logProgress) {
                    Log.getLogWriter().info(aStr);
                }
                lastLogTime = System.currentTimeMillis();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                throw new TestException("Interrupted after waiting " + currentWaitTime + " millis for " + TestHelper.regionToString(aRegion, false) + ".containsKey(" + key + ") to become " + expected);
            }
        }
    }

    public static String waitForContainsValueForKey(Region aRegion, Object key, boolean expected, long timeoutMS, boolean logProgress) {
        long startTime;
        StringBuffer logStr = new StringBuffer();
        String aStr = "Waiting for " + TestHelper.regionToString(aRegion, false) + ".containsValueForKey(" + key + ") to become " + expected;
        logStr.append(new Date() + aStr + "\n");
        if (logProgress) {
            Log.getLogWriter().info(aStr);
        }
        long lastLogTime = startTime = System.currentTimeMillis();
        long logIntervalMS = 15000L;
        while (true) {
            boolean containsValueForKey;
            if ((containsValueForKey = aRegion.containsValueForKey(key)) == expected) {
                aStr = TestHelper.regionToString(aRegion, false) + ".containsValueForKey(" + key + ") has expected value " + containsValueForKey;
                logStr.append(new Date() + ": " + aStr + "\n");
                if (logProgress) {
                    Log.getLogWriter().info(aStr);
                }
                return logStr.toString();
            }
            long currentWaitTime = System.currentTimeMillis() - startTime;
            if (currentWaitTime >= timeoutMS) {
                throw new TestException("After waiting " + currentWaitTime + " millis, " + TestHelper.regionToString(aRegion, false) + ".containsValueForKey(" + key + ") is " + containsValueForKey + "; expected it to become " + expected + "\nLog of wait progress: " + logStr);
            }
            if (System.currentTimeMillis() - lastLogTime >= logIntervalMS) {
                aStr = "Waiting for " + TestHelper.regionToString(aRegion, false) + ".containsValueForKey(" + key + ") to become " + expected + "...";
                logStr.append(new Date() + ": " + aStr + "\n");
                if (logProgress) {
                    Log.getLogWriter().info(aStr);
                }
                lastLogTime = System.currentTimeMillis();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                throw new TestException("Interrupted after waiting " + currentWaitTime + " millis for " + TestHelper.regionToString(aRegion, false) + ".containsValueForKey(" + key + ") to become " + expected);
            }
        }
    }

    public static void waitForObjectValue(Region aRegion, Object key, Object expectedObjectValue, long timeoutMS) {
        long startTime;
        Log.getLogWriter().info("Waiting for " + TestHelper.regionToString(aRegion, false) + ".get(" + key + ") to have a value of " + TestHelper.toString(expectedObjectValue));
        long lastLogTime = startTime = System.currentTimeMillis();
        long logIntervalMS = 15000L;
        while (true) {
            long currentWaitTime;
            Object value;
            if ((value = CacheUtil.get(aRegion, key)) == null) {
                if (expectedObjectValue == null) {
                    Log.getLogWriter().info(TestHelper.regionToString(aRegion, false) + ".get(" + key + ") has expected value " + value);
                    return;
                }
            } else if (value.equals(expectedObjectValue)) {
                Log.getLogWriter().info(TestHelper.regionToString(aRegion, false) + ".get(" + key + ") has expected value " + value);
                return;
            }
            if ((currentWaitTime = System.currentTimeMillis() - startTime) >= timeoutMS) {
                throw new TestException("After waiting " + currentWaitTime + " millis, " + TestHelper.regionToString(aRegion, false) + ".get(" + key + ") is " + TestHelper.toString(value) + "; expected it to be " + TestHelper.toString(expectedObjectValue));
            }
            if (System.currentTimeMillis() - lastLogTime >= logIntervalMS) {
                Log.getLogWriter().info("Waiting for " + TestHelper.regionToString(aRegion, false) + ".get(" + key + ") to have a value of " + TestHelper.toString(expectedObjectValue));
                lastLogTime = System.currentTimeMillis();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                throw new TestException("Interrupted after waiting " + currentWaitTime + " millis for " + TestHelper.regionToString(aRegion, false) + ".get(" + key + ") to have a value of " + TestHelper.toString(expectedObjectValue));
            }
        }
    }

    public static String getGemFireName() {
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        GemFireDescription gfd = cd.getGemFireDescription();
        return gfd.getName();
    }

    public static String regionToString(Region aRegion, boolean showAttributes) {
        StringBuffer aStr = new StringBuffer();
        aStr.append(aRegion.getFullPath());
        try {
            if (aRegion.getAttributes().getPartitionAttributes() != null) {
                aStr.append(" (PartitionedRegion)");
            }
            if (showAttributes) {
                return aStr.toString() + " with attributes " + TestHelper.regionAttributesToString(aRegion.getAttributes());
            }
            return aStr.toString();
        }
        catch (RegionDestroyedException e) {
            boolean destroyed = aRegion.isDestroyed();
            if (destroyed) {
                return aRegion.getFullPath() + ": attributes for region not available because region was destroyed";
            }
            throw new TestException("Got " + (Object)((Object)e) + " but region is destroyed is " + destroyed);
        }
        catch (CacheRuntimeException e) {
            ExceptionVersionHelper.checkCancelException(e);
            return aRegion.getFullPath() + ": attributes for region not available because cache was closed";
        }
    }

    public static String regionsToString(Region aRegion, boolean showAttributes) {
        StringBuffer aStr = new StringBuffer();
        aStr.append(TestHelper.regionToString(aRegion, showAttributes) + " with subregions ");
        Set regionSet = null;
        try {
            regionSet = aRegion.subregions(true);
        }
        catch (RegionDestroyedException e) {
            boolean isDestroyed = aRegion.isDestroyed();
            if (aRegion.isDestroyed()) {
                return "<" + aRegion.getFullPath() + " destroyed>";
            }
            throw new TestException("Getting subregions of region [" + aStr + "...] got " + e.toString() + ", but isDestroyed is " + isDestroyed);
        }
        Iterator it = regionSet.iterator();
        if (!it.hasNext()) {
            aStr.append("NONE");
            return aStr.toString();
        }
        aStr.append("\n");
        TreeSet<String> aSet = new TreeSet<String>();
        while (it.hasNext()) {
            aSet.add("   " + TestHelper.regionToString((Region)it.next(), showAttributes) + "\n");
        }
        int count = 0;
        it = aSet.iterator();
        while (it.hasNext()) {
            aStr.append(it.next());
            ++count;
        }
        aStr.append("Total: " + count + " regions");
        return aStr.toString();
    }

    public static String regionAttributesToString(RegionAttributes attr) {
        MembershipAttributes ratts;
        SubscriptionAttributes subAttr;
        StringBuffer aStr = new StringBuffer();
        aStr.append(attr + "\n");
        aStr.append("   cacheListeners: \n");
        CacheListener[] listeners = attr.getCacheListeners();
        for (int i = 0; i < listeners.length; ++i) {
            aStr.append("      " + listeners[i] + "\n");
        }
        aStr.append("   cacheLoader: " + attr.getCacheLoader() + "\n");
        aStr.append("   cacheWriter: " + attr.getCacheWriter() + "\n");
        aStr.append("   enableOffHeapMemory: " + attr.getEnableOffHeapMemory() + "\n");
        aStr.append("   entryIdleTimeout: " + attr.getEntryIdleTimeout() + "\n");
        aStr.append("   entryTimeToLive: " + attr.getEntryTimeToLive() + "\n");
        aStr.append("   evictionAttributes: " + attr.getEvictionAttributes() + "\n");
        aStr.append("   initialCapacity: " + attr.getInitialCapacity() + "\n");
        aStr.append("   keyConstraint: " + attr.getKeyConstraint() + "\n");
        aStr.append("   loadFactor: " + attr.getLoadFactor() + "\n");
        aStr.append("   enableOffHeapMemory: " + attr.getEnableOffHeapMemory() + "\n");
        aStr.append("   dataPolicy: " + attr.getDataPolicy() + "\n");
        String concurrencyChecksEnabled = TestHelper.getConcurrencyChecksEnabled(attr);
        if (concurrencyChecksEnabled != null) {
            aStr.append(concurrencyChecksEnabled);
        }
        if ((subAttr = attr.getSubscriptionAttributes()) == null) {
            aStr.append("   SubscriptionAttributes (interestPolicy): " + subAttr + "\n");
        } else {
            aStr.append("   interestPolicy: " + subAttr.getInterestPolicy() + "\n");
        }
        aStr.append("   regionIdleTimeout: " + attr.getRegionIdleTimeout() + "\n");
        aStr.append("   regionTimeToLive: " + attr.getRegionTimeToLive() + "\n");
        aStr.append("   scope: " + attr.getScope() + "\n");
        aStr.append("   enableAsyncConflation: " + attr.getEnableAsyncConflation() + "\n");
        aStr.append("   enableSubscriptionConflation: " + attr.getEnableSubscriptionConflation() + "\n");
        aStr.append("   enableWAN: " + attr.getEnableWAN() + "\n");
        aStr.append("   statisticsEnabled: " + attr.getStatisticsEnabled() + "\n");
        PartitionAttributes parAttr = attr.getPartitionAttributes();
        if (parAttr == null) {
            aStr.append("   PartitionAttributes: " + parAttr + "\n");
        } else {
            aStr.append("   PartitionAttributes:\n");
            aStr.append("      redundantCopies: " + parAttr.getRedundantCopies() + "\n");
            aStr.append("      localProperties: " + parAttr.getLocalProperties() + "\n");
            aStr.append("      globalProperties: " + parAttr.getGlobalProperties() + "\n");
            aStr.append("      partitonResolver: " + parAttr.getPartitionResolver() + "\n");
            aStr.append("      colocatedWith: " + parAttr.getColocatedWith() + "\n");
            aStr.append("      recoveryDelay: " + parAttr.getRecoveryDelay() + "\n");
            aStr.append("      startupRecoveryDelay: " + parAttr.getStartupRecoveryDelay() + "\n");
        }
        aStr.append("   multicastEnabled: " + attr.getMulticastEnabled() + "\n");
        aStr.append("   persistBackup: " + attr.getPersistBackup() + "\n");
        if (attr.getDiskWriteAttributes() != null) {
            aStr.append("   DiskWriteAttributes.isSynchronous: " + attr.getDiskWriteAttributes().isSynchronous() + "\n");
            aStr.append("   DiskWriteAttributes.timeInterval: " + attr.getDiskWriteAttributes().getTimeInterval() + "\n");
            aStr.append("   DiskWriteAttributes.bytesThreshold: " + attr.getDiskWriteAttributes().getBytesThreshold() + "\n");
            aStr.append("   diskFiles: ");
            File[] fileArr = attr.getDiskDirs();
            for (int i = 0; i < fileArr.length; ++i) {
                aStr.append(fileArr[i].getAbsolutePath() + " ");
            }
            aStr.append("\n");
        }
        if ((ratts = attr.getMembershipAttributes()) != null) {
            aStr.append("   membershipAttributes: " + ratts + "\n");
        }
        return aStr.toString();
    }

    public static String getConcurrencyChecksEnabled(RegionAttributes attrs) {
        return TestHelperVersionHelper.getConcurrencyChecksEnabled(attrs);
    }

    public static LossAction getLossAction(String lossAction) {
        if (lossAction.equalsIgnoreCase("fullAccess")) {
            return LossAction.FULL_ACCESS;
        }
        if (lossAction.equalsIgnoreCase("limitedAccess")) {
            return LossAction.LIMITED_ACCESS;
        }
        if (lossAction.equalsIgnoreCase("noAccess")) {
            return LossAction.NO_ACCESS;
        }
        if (lossAction.equalsIgnoreCase("reconnect")) {
            return LossAction.RECONNECT;
        }
        throw new TestException("Unknown lossAction " + lossAction);
    }

    public static ResumptionAction getResumptionAction(String resumptionAction) {
        if (resumptionAction.equalsIgnoreCase("none")) {
            return ResumptionAction.NONE;
        }
        if (resumptionAction.equalsIgnoreCase("reinitialize")) {
            return ResumptionAction.REINITIALIZE;
        }
        throw new TestException("Unknown reliabilityAction " + resumptionAction);
    }

    public static ExpirationAction getExpirationAction(String action) {
        if (action.equalsIgnoreCase("destroy")) {
            return ExpirationAction.DESTROY;
        }
        if (action.equalsIgnoreCase("local_destroy") || action.equalsIgnoreCase("localDestroy")) {
            return ExpirationAction.LOCAL_DESTROY;
        }
        if (action.equalsIgnoreCase("invalidate")) {
            return ExpirationAction.INVALIDATE;
        }
        if (action.equalsIgnoreCase("local_invalidate") || action.equalsIgnoreCase("localInvalidate")) {
            return ExpirationAction.LOCAL_INVALIDATE;
        }
        throw new TestException("Unknown action " + action);
    }

    public static InterestResultPolicy getResultPolicy(String policy) {
        if (policy.equalsIgnoreCase("keys")) {
            return InterestResultPolicy.KEYS;
        }
        if (policy.equalsIgnoreCase("keys_values") || policy.equalsIgnoreCase("keysValues")) {
            return InterestResultPolicy.KEYS_VALUES;
        }
        if (policy.equalsIgnoreCase("none")) {
            return InterestResultPolicy.NONE;
        }
        throw new TestException("Unknown result policy " + policy);
    }

    public static MirrorType getMirrorType(String attribute) {
        if (attribute.equalsIgnoreCase("keys")) {
            return MirrorType.KEYS;
        }
        if (attribute.equalsIgnoreCase("keys_values") || attribute.equalsIgnoreCase("keysValues")) {
            return MirrorType.KEYS_VALUES;
        }
        if (attribute.equalsIgnoreCase("none")) {
            return MirrorType.NONE;
        }
        throw new TestException("Unknown mirroring attribute " + attribute);
    }

    public static DataPolicy getDataPolicy(String attribute) {
        if (attribute.equalsIgnoreCase("normal")) {
            return DataPolicy.NORMAL;
        }
        if (attribute.equalsIgnoreCase("preloaded")) {
            return DataPolicy.PRELOADED;
        }
        if (attribute.equalsIgnoreCase("empty")) {
            return DataPolicy.EMPTY;
        }
        if (attribute.equalsIgnoreCase("replicate")) {
            return DataPolicy.REPLICATE;
        }
        if (attribute.equalsIgnoreCase("persistent_replicate") || attribute.equalsIgnoreCase("persistentReplicate")) {
            return DataPolicy.PERSISTENT_REPLICATE;
        }
        if (attribute.equalsIgnoreCase("persistentPartition")) {
            return DataPolicy.PERSISTENT_PARTITION;
        }
        throw new TestException("Unknown dataPolicy attribute " + attribute);
    }

    public static InterestPolicy getInterestPolicy(String attribute) {
        if (attribute.equalsIgnoreCase("all")) {
            return InterestPolicy.ALL;
        }
        if (attribute.equalsIgnoreCase("cache_content") || attribute.equalsIgnoreCase("cacheContent")) {
            return InterestPolicy.CACHE_CONTENT;
        }
        throw new TestException("Unknown interestPolicy attribute " + attribute);
    }

    public static InterestResultPolicy getInterestResultPolicy(String attribute) {
        if (attribute.equalsIgnoreCase("none")) {
            return InterestResultPolicy.NONE;
        }
        if (attribute.equalsIgnoreCase("keys")) {
            return InterestResultPolicy.KEYS;
        }
        if (attribute.equalsIgnoreCase("keys_values") || attribute.equalsIgnoreCase("keysValues")) {
            return InterestResultPolicy.KEYS_VALUES;
        }
        throw new TestException("Unknown interestResultPolicy attribute " + attribute);
    }

    public static Scope getScope(String attribute) {
        if (attribute.equalsIgnoreCase("distributed_ack") || attribute.equalsIgnoreCase("distributedAck") || attribute.equalsIgnoreCase("ack")) {
            return Scope.DISTRIBUTED_ACK;
        }
        if (attribute.equalsIgnoreCase("distributed_no_ack") || attribute.equalsIgnoreCase("distributedNoAck") || attribute.equalsIgnoreCase("noAck")) {
            return Scope.DISTRIBUTED_NO_ACK;
        }
        if (attribute.equalsIgnoreCase("local")) {
            return Scope.LOCAL;
        }
        if (attribute.equalsIgnoreCase("global")) {
            return Scope.GLOBAL;
        }
        throw new TestException("Unknown scope attribute \"" + attribute + "\"");
    }

    public static int getTotalNumKeys(Region aRegion) {
        int numKeys = 0;
        Set regionSet = aRegion.subregions(true);
        Iterator it = regionSet.iterator();
        while (it.hasNext()) {
            numKeys += ((Region)it.next()).keys().size();
        }
        return numKeys;
    }

    public static Set getAllKeys(Region aRegion) {
        HashSet keySet = new HashSet();
        Set regionSet = aRegion.subregions(true);
        for (Region thisRegion : regionSet) {
            keySet.addAll(thisRegion.keys());
        }
        return keySet;
    }

    public static void checkForEventError(Blackboard bb) {
        SharedMap aMap = bb.getSharedMap();
        Object anObj = aMap.get(EVENT_ERROR_KEY);
        if (anObj != null) {
            throw new TestException(anObj.toString());
        }
    }

    public static double getNumLRUEvictions() {
        String spec = "* LRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static double getNumMemLRUEvictions() {
        String spec = "*bridge* MemLRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static double getNumHeapLRUEvictions() {
        String spec = "* HeapLRUStatistics * lruEvictions filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double totalEvictions = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            totalEvictions += stat.getMax();
        }
        return totalEvictions;
    }

    public static double getNumLoadsCompleted() {
        String spec = "*bridge* CachePerfStats cachePerfStats loadsCompleted filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double loadsCompleted = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            loadsCompleted += stat.getMax();
        }
        return loadsCompleted;
    }

    public static double getNumCQsCreated() {
        String spec = "*edge* CqServiceStats * numCQsCreated filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double numCqs = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            numCqs += stat.getMax();
        }
        return numCqs;
    }

    public static int getNumVMs() {
        int numVMs = 0;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        if (gemFireNamesVec.size() == numVMsVec.size()) {
            for (int i = 0; i < numVMsVec.size(); ++i) {
                numVMs += new Integer((String)numVMsVec.elementAt(i)).intValue();
            }
        } else {
            numVMs = new Integer((String)numVMsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        return numVMs;
    }

    public static int getNumThreads() {
        int numThreads = 0;
        boolean numLocatorThreads = false;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        HydraVector vmThreadsVec = TestConfig.tab().vecAt(ClientPrms.vmThreads);
        if (gemFireNamesVec.size() > 1 || numVMsVec.size() > 1 || vmThreadsVec.size() > 1) {
            int gemFireSize = gemFireNamesVec.size();
            int numVMsSize = numVMsVec.size();
            int vmThreadsSize = vmThreadsVec.size();
            int maxSize = Math.max(Math.max(gemFireSize, numVMsSize), vmThreadsSize);
            for (int i = 0; i < maxSize; ++i) {
                String gfName;
                int numVMsForThisGF = 0;
                int numThreadsPerVM = 0;
                numVMsForThisGF = i < numVMsSize ? new Integer((String)numVMsVec.elementAt(i)).intValue() : new Integer((String)numVMsVec.elementAt(numVMsSize - 1)).intValue();
                numThreadsPerVM = i < vmThreadsSize ? new Integer((String)vmThreadsVec.elementAt(i)).intValue() : new Integer((String)vmThreadsVec.elementAt(numVMsSize - 1)).intValue();
                numThreads += numVMsForThisGF * numThreadsPerVM;
                if (!TestConfig.tab().booleanAt(RollingUpgradePrms.excludeLocatorThreadsFromTotalThreads, false) || !(gfName = (String)gemFireNamesVec.elementAt(i)).startsWith("locator")) continue;
                numThreads -= numVMsForThisGF * numThreadsPerVM;
            }
        } else {
            numThreads = new Integer((String)numVMsVec.elementAt(0)) * new Integer((String)vmThreadsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        return numThreads;
    }

    public static int getSizeInBytes(Object anObj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(anObj);
            byte[] byteArray = baos.toByteArray();
            return byteArray.length;
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static int getStat_getRecoveriesInProgress(String diskStoreName) {
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics[] diskStoreStats = statFactory.findStatisticsByTextId(diskStoreName);
        while (diskStoreStats.length == 0) {
            diskStoreStats = statFactory.findStatisticsByTextId(diskStoreName);
        }
        int diskRecoveryInProgress = diskStoreStats[0].getInt("recoveriesInProgress");
        return diskRecoveryInProgress;
    }

    public static int getStat_getInitialImagesInProgress(String regionName) {
        String regionStatName = "RegionStats-" + regionName;
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics[] regionStats = statFactory.findStatisticsByTextId(regionStatName);
        while (regionStats.length == 0) {
            regionStats = statFactory.findStatisticsByTextId(regionStatName);
        }
        int giisInProgress = regionStats[0].getInt("getInitialImagesInProgress");
        return giisInProgress;
    }

    public static int getStat_getInitialImagesCompleted(String regionName) {
        String regionStatName = "RegionStats-" + regionName;
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics[] regionStats = statFactory.findStatisticsByTextId(regionStatName);
        while (regionStats.length == 0) {
            regionStats = statFactory.findStatisticsByTextId(regionStatName);
        }
        int giisCompleted = regionStats[0].getInt("getInitialImagesCompleted");
        return giisCompleted;
    }

    public static int getStat_deltaGetInitialImagesCompleted(String regionName) {
        String regionStatName = "RegionStats-" + regionName;
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics[] regionStats = statFactory.findStatisticsByTextId(regionStatName);
        while (regionStats.length == 0) {
            regionStats = statFactory.findStatisticsByTextId(regionStatName);
        }
        int deltaGiisCompleted = regionStats[0].getInt("deltaGetInitialImagesCompleted");
        Log.getLogWriter().info("getStat_deltaGetInitialImagesCompleted() returns " + deltaGiisCompleted);
        return deltaGiisCompleted;
    }

    public static long getStat_getInitialImageTime(String regionName) {
        String regionStatName = "RegionStats-" + regionName;
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics[] regionStats = statFactory.findStatisticsByTextId(regionStatName);
        while (regionStats.length == 0) {
            regionStats = statFactory.findStatisticsByTextId(regionStatName);
        }
        long giiTime = regionStats[0].getLong("getInitialImageTime");
        return giiTime;
    }

    public static Object createInstance(String className) {
        try {
            return TestHelper.createInstance(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static Object createInstance(Class aClass) {
        try {
            Object anObj = aClass.newInstance();
            return anObj;
        }
        catch (InstantiationException anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
        catch (IllegalAccessException anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
        catch (Exception anExcept) {
            throw new TestException(TestHelper.getStackTrace(anExcept));
        }
    }

    public static int calculateStringSize(String aStr) {
        return WellKnownClassSizer.sizeof((Object)aStr);
    }

    public static Throwable getLastCausedBy(Throwable e) {
        Throwable cause = e;
        while (cause != null) {
            Throwable nextCause = cause.getCause();
            if (nextCause == null) {
                return cause;
            }
            cause = nextCause;
        }
        return cause;
    }

    public static void logRegionHierarchy() {
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    public static String regionHierarchyToString() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return "Unable to log regions, this member does not have a cache";
        }
        Set roots = theCache.rootRegions();
        StringBuffer aStr = new StringBuffer();
        int totalNumRegions = 0;
        for (Region aRegion : roots) {
            aStr.append(TestHelper.getRegionStr(aRegion));
            ++totalNumRegions;
            Object[] tmp = TestHelper.subregionsToString(aRegion, 1);
            aStr.append(tmp[0]);
            totalNumRegions += ((Integer)tmp[1]).intValue();
        }
        return "Region hierarchy with " + totalNumRegions + " regions\n" + aStr.toString();
    }

    private static String getRegionStr(Region aRegion) {
        StringBuffer aStr = new StringBuffer();
        aStr.append(aRegion.getFullPath() + "  (size " + aRegion.size() + " dataPolicy " + aRegion.getAttributes().getDataPolicy() + " eviction " + aRegion.getAttributes().getEvictionAttributes());
        PartitionAttributes prAttr = aRegion.getAttributes().getPartitionAttributes();
        if (prAttr != null) {
            aStr.append(" localMaxMemory=" + aRegion.getAttributes().getPartitionAttributes().getLocalMaxMemory());
            aStr.append(" redundantCopies=" + aRegion.getAttributes().getPartitionAttributes().getRedundantCopies());
            if (prAttr.getColocatedWith() != null) {
                aStr.append(" colocatedWith=" + prAttr.getColocatedWith());
            }
        }
        RecoveryTestVersionHelper.logDiskStore(aRegion, aStr);
        aStr.append(")\n");
        return aStr.toString();
    }

    private static Object[] subregionsToString(Region region, int level) {
        Set subregionSet = region.subregions(false);
        StringBuffer aStr = new StringBuffer();
        int numRegions = subregionSet.size();
        for (Region reg : subregionSet) {
            for (int i = 1; i <= level; ++i) {
                aStr.append("  ");
            }
            aStr.append(TestHelper.getRegionStr(reg));
            Object[] tmp = TestHelper.subregionsToString(reg, level + 1);
            aStr.append(tmp[0]);
            numRegions += ((Integer)tmp[1]).intValue();
        }
        return new Object[]{aStr.toString(), numRegions};
    }
}

