/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.Log;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.TestException;
import util.TestHelper;

public class TxEventCountersBB
extends Blackboard {
    static String BB_NAME = "TxEventCounters_Blackboard";
    static String BB_TYPE = "RMI";
    private static TxEventCountersBB bbInstance = null;
    public static int numCreateTxEvents_isDist;
    public static int numCreateTxEvents_isNotDist;
    public static int numCreateTxEvents_isExp;
    public static int numCreateTxEvents_isNotExp;
    public static int numCreateTxEvents_isRemote;
    public static int numCreateTxEvents_isNotRemote;
    public static int numCreateTxEvents_isLoad;
    public static int numCreateTxEvents_isNotLoad;
    public static int numCreateTxEvents_isLocalLoad;
    public static int numCreateTxEvents_isNotLocalLoad;
    public static int numCreateTxEvents_isNetLoad;
    public static int numCreateTxEvents_isNotNetLoad;
    public static int numCreateTxEvents_isNetSearch;
    public static int numCreateTxEvents_isNotNetSearch;
    public static int numDestroyTxEvents_isDist;
    public static int numDestroyTxEvents_isNotDist;
    public static int numDestroyTxEvents_isExp;
    public static int numDestroyTxEvents_isNotExp;
    public static int numDestroyTxEvents_isRemote;
    public static int numDestroyTxEvents_isNotRemote;
    public static int numDestroyTxEvents_isLoad;
    public static int numDestroyTxEvents_isNotLoad;
    public static int numDestroyTxEvents_isLocalLoad;
    public static int numDestroyTxEvents_isNotLocalLoad;
    public static int numDestroyTxEvents_isNetLoad;
    public static int numDestroyTxEvents_isNotNetLoad;
    public static int numDestroyTxEvents_isNetSearch;
    public static int numDestroyTxEvents_isNotNetSearch;
    public static int numInvalidateTxEvents_isDist;
    public static int numInvalidateTxEvents_isNotDist;
    public static int numInvalidateTxEvents_isExp;
    public static int numInvalidateTxEvents_isNotExp;
    public static int numInvalidateTxEvents_isRemote;
    public static int numInvalidateTxEvents_isNotRemote;
    public static int numInvalidateTxEvents_isLoad;
    public static int numInvalidateTxEvents_isNotLoad;
    public static int numInvalidateTxEvents_isLocalLoad;
    public static int numInvalidateTxEvents_isNotLocalLoad;
    public static int numInvalidateTxEvents_isNetLoad;
    public static int numInvalidateTxEvents_isNotNetLoad;
    public static int numInvalidateTxEvents_isNetSearch;
    public static int numInvalidateTxEvents_isNotNetSearch;
    public static int numUpdateTxEvents_isDist;
    public static int numUpdateTxEvents_isNotDist;
    public static int numUpdateTxEvents_isExp;
    public static int numUpdateTxEvents_isNotExp;
    public static int numUpdateTxEvents_isRemote;
    public static int numUpdateTxEvents_isNotRemote;
    public static int numUpdateTxEvents_isLoad;
    public static int numUpdateTxEvents_isNotLoad;
    public static int numUpdateTxEvents_isLocalLoad;
    public static int numUpdateTxEvents_isNotLocalLoad;
    public static int numUpdateTxEvents_isNetLoad;
    public static int numUpdateTxEvents_isNotNetLoad;
    public static int numUpdateTxEvents_isNetSearch;
    public static int numUpdateTxEvents_isNotNetSearch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TxEventCountersBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<TxEventCountersBB> clazz = TxEventCountersBB.class;
        synchronized (TxEventCountersBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new TxEventCountersBB(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public TxEventCountersBB() {
    }

    public TxEventCountersBB(String name, String type) {
        super(name, type, TxEventCountersBB.class);
    }

    public static void incrementEntryTxEventCntrs(String eventName, boolean isDistributed, boolean isExpiration, boolean isRemote, boolean isLoad, boolean isLocalLoad, boolean isNetLoad, boolean isNetSearch) {
        TxEventCountersBB bb = TxEventCountersBB.getBB();
        SharedCounters sc = bb.getSharedCounters();
        String counterName = "num" + eventName + "TxEvents_" + (isDistributed ? "isDist" : "isNotDist");
        sc.increment(bb.getSharedCounter(counterName));
        counterName = "num" + eventName + "TxEvents_" + (isExpiration ? "isExp" : "isNotExp");
        sc.increment(bb.getSharedCounter(counterName));
        counterName = "num" + eventName + "TxEvents_" + (isRemote ? "isRemote" : "isNotRemote");
        sc.increment(bb.getSharedCounter(counterName));
        counterName = "num" + eventName + "TxEvents_" + (isLoad ? "isLoad" : "isNotLoad");
        sc.increment(bb.getSharedCounter(counterName));
        counterName = "num" + eventName + "TxEvents_" + (isLocalLoad ? "isLocalLoad" : "isNotLocalLoad");
        sc.increment(bb.getSharedCounter(counterName));
        counterName = "num" + eventName + "TxEvents_" + (isNetLoad ? "isNetLoad" : "isNotNetLoad");
        sc.increment(bb.getSharedCounter(counterName));
        counterName = "num" + eventName + "TxEvents_" + (isNetSearch ? "isNetSearch" : "isNotNetSearch");
        sc.increment(bb.getSharedCounter(counterName));
    }

    public void checkEventCounters(ArrayList expectedValues) {
        Log.getLogWriter().info("Checking " + expectedValues.size() + " tx event counters in " + this.getClass().getName());
        TxEventCountersBB BB2 = TxEventCountersBB.getBB();
        SharedCounters counters = BB2.getSharedCounters();
        String[] counterNames = BB2.getCounterNames();
        for (int i = 0; i < expectedValues.size(); ++i) {
            ExpCounterValue expValue = (ExpCounterValue)expectedValues.get(i);
            if (expValue.getCounterName1() != null && expValue.getCounterName2() != null) {
                try {
                    TestHelper.waitForCounterSum(BB2, expValue.getCounterName1(), expValue.getCounterName2(), expValue.getExpectedValue(), true, 60000L);
                    continue;
                }
                catch (TestException e) {
                    BB2.printSharedCounters();
                    throw e;
                }
            }
            boolean exact = expValue.getExact();
            try {
                TestHelper.waitForCounter(BB2, expValue.getCounterName1(), BB2.getSharedCounter(expValue.getCounterName1()), expValue.getExpectedValue(), exact, 60000L);
                continue;
            }
            catch (TestException e) {
                BB2.printSharedCounters();
                throw e;
            }
        }
        Log.getLogWriter().info(BB2.getClass().getName() + ", all counters are OK");
    }

    public void checkTxEventCounters(long[] expectedValues) {
        Log.getLogWriter().info("Checking tx event counters in " + this.getClass().getName());
        TxEventCountersBB BB2 = TxEventCountersBB.getBB();
        String[] counterNames = BB2.getCounterNames();
        if (counterNames.length != expectedValues.length) {
            int i;
            StringBuffer aStr = new StringBuffer();
            for (i = 0; i < counterNames.length; ++i) {
                aStr.append("   counterNames[" + i + "] is " + counterNames[i] + "\n");
            }
            for (i = 0; i < expectedValues.length; ++i) {
                aStr.append("   expectedValues[" + i + "] is " + expectedValues[i] + "\n");
            }
            Log.getLogWriter().info(aStr.toString());
            throw new TestException("Expected length of expectedValues " + expectedValues.length + " to be = length of counterNames " + counterNames.length);
        }
        SharedCounters counters = BB2.getSharedCounters();
        for (int i = 0; i < expectedValues.length; ++i) {
            if (expectedValues[i] < 0L) continue;
            try {
                TestHelper.waitForCounter(BB2, counterNames[i], BB2.getSharedCounter(counterNames[i]), expectedValues[i], true, 60000L);
                continue;
            }
            catch (TestException e) {
                BB2.printSharedCounters();
                throw e;
            }
        }
        Log.getLogWriter().info(BB2.getClass().getName() + ", all counters are OK");
    }

    public static void checkCreateUpdate(long expectedIsDist, long expectedIsNotDist, long expectedIsExp, long expectedIsNotExp, long expectedIsRemote, long expectedIsNotRemote) {
        EventCountersBB BB2 = EventCountersBB.getBB();
        SharedCounters counters = EventCountersBB.getBB().getSharedCounters();
        long isDist = counters.read(numCreateTxEvents_isDist) + counters.read(numUpdateTxEvents_isDist);
        long isNotDist = counters.read(numCreateTxEvents_isNotDist) + counters.read(numUpdateTxEvents_isNotDist);
        long isExp = counters.read(numCreateTxEvents_isExp) + counters.read(numUpdateTxEvents_isExp);
        long isNotExp = counters.read(numCreateTxEvents_isNotExp) + counters.read(numUpdateTxEvents_isNotExp);
        long isRemote = counters.read(numCreateTxEvents_isRemote) + counters.read(numUpdateTxEvents_isRemote);
        long isNotRemote = counters.read(numCreateTxEvents_isNotRemote) + counters.read(numUpdateTxEvents_isNotRemote);
        if (isDist != expectedIsDist) {
            BB2.print();
            throw new TestException("Expected create/update sum of isDist to be " + expectedIsDist + ", but it is " + isDist);
        }
        if (isNotDist != expectedIsNotDist) {
            BB2.print();
            throw new TestException("Expected create/update sum of isNotDist to be " + expectedIsNotDist + ", but it is " + isNotDist);
        }
        if (isExp != expectedIsExp) {
            BB2.print();
            throw new TestException("Expected create/update sum of isExp to be " + expectedIsExp + ", but it is " + isExp);
        }
        if (isNotExp != expectedIsNotExp) {
            BB2.print();
            throw new TestException("Expected create/update sum of isNotExp to be " + expectedIsNotExp + ", but it is " + isNotExp);
        }
        if (isRemote != expectedIsRemote) {
            BB2.print();
            throw new TestException("Expected create/update sum of isRemote to be " + expectedIsRemote + ", but it is " + isRemote);
        }
        if (isNotRemote != expectedIsNotRemote) {
            BB2.print();
            throw new TestException("Expected create/update sum of isNotRemote to be " + expectedIsNotRemote + ", but it is " + isNotRemote);
        }
        Log.getLogWriter().info("EventCountersBB, create/update counters are OK");
    }

    public void zeroAllCounters() {
        SharedCounters sc = this.getSharedCounters();
        sc.zero(numCreateTxEvents_isDist);
        sc.zero(numCreateTxEvents_isNotDist);
        sc.zero(numCreateTxEvents_isExp);
        sc.zero(numCreateTxEvents_isNotExp);
        sc.zero(numCreateTxEvents_isRemote);
        sc.zero(numCreateTxEvents_isNotRemote);
        sc.zero(numCreateTxEvents_isLoad);
        sc.zero(numCreateTxEvents_isNotLoad);
        sc.zero(numCreateTxEvents_isLocalLoad);
        sc.zero(numCreateTxEvents_isNotLocalLoad);
        sc.zero(numCreateTxEvents_isNetLoad);
        sc.zero(numCreateTxEvents_isNotNetLoad);
        sc.zero(numCreateTxEvents_isNetSearch);
        sc.zero(numCreateTxEvents_isNotNetSearch);
        sc.zero(numDestroyTxEvents_isDist);
        sc.zero(numDestroyTxEvents_isNotDist);
        sc.zero(numDestroyTxEvents_isExp);
        sc.zero(numDestroyTxEvents_isNotExp);
        sc.zero(numDestroyTxEvents_isRemote);
        sc.zero(numDestroyTxEvents_isNotRemote);
        sc.zero(numDestroyTxEvents_isLoad);
        sc.zero(numDestroyTxEvents_isNotLoad);
        sc.zero(numDestroyTxEvents_isLocalLoad);
        sc.zero(numDestroyTxEvents_isNotLocalLoad);
        sc.zero(numDestroyTxEvents_isNetLoad);
        sc.zero(numDestroyTxEvents_isNotNetLoad);
        sc.zero(numDestroyTxEvents_isNetSearch);
        sc.zero(numDestroyTxEvents_isNotNetSearch);
        sc.zero(numInvalidateTxEvents_isDist);
        sc.zero(numInvalidateTxEvents_isNotDist);
        sc.zero(numInvalidateTxEvents_isExp);
        sc.zero(numInvalidateTxEvents_isNotExp);
        sc.zero(numInvalidateTxEvents_isRemote);
        sc.zero(numInvalidateTxEvents_isNotRemote);
        sc.zero(numInvalidateTxEvents_isLoad);
        sc.zero(numInvalidateTxEvents_isNotLoad);
        sc.zero(numInvalidateTxEvents_isLocalLoad);
        sc.zero(numInvalidateTxEvents_isNotLocalLoad);
        sc.zero(numInvalidateTxEvents_isNetLoad);
        sc.zero(numInvalidateTxEvents_isNotNetLoad);
        sc.zero(numInvalidateTxEvents_isNetSearch);
        sc.zero(numInvalidateTxEvents_isNotNetSearch);
        sc.zero(numUpdateTxEvents_isDist);
        sc.zero(numUpdateTxEvents_isNotDist);
        sc.zero(numUpdateTxEvents_isExp);
        sc.zero(numUpdateTxEvents_isNotExp);
        sc.zero(numUpdateTxEvents_isRemote);
        sc.zero(numUpdateTxEvents_isNotRemote);
        sc.zero(numUpdateTxEvents_isLoad);
        sc.zero(numUpdateTxEvents_isNotLoad);
        sc.zero(numUpdateTxEvents_isLocalLoad);
        sc.zero(numUpdateTxEvents_isNotLocalLoad);
        sc.zero(numUpdateTxEvents_isNetLoad);
        sc.zero(numUpdateTxEvents_isNotNetLoad);
        sc.zero(numUpdateTxEvents_isNetSearch);
        sc.zero(numUpdateTxEvents_isNotNetSearch);
    }
}

