/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import hydra.CacheHelper;
import hydra.Log;
import java.util.concurrent.TimeUnit;
import tx.TxBB;
import util.TestException;
import util.TestHelper;

public class TxHelper {
    static CacheTransactionManager tm = CacheHelper.getCache().getCacheTransactionManager();

    public static void setTransactionManager() {
        tm = CacheHelper.getCache().getCacheTransactionManager();
    }

    public static void begin() {
        Log.getLogWriter().info("BEGINNING TX");
        tm.begin();
        TxBB.getBB().getSharedCounters().increment(TxBB.TX_IN_PROGRESS);
        Log.getLogWriter().info("Began transaction with id " + tm.getTransactionId());
    }

    public static void commit() throws TransactionException {
        Log.getLogWriter().info("COMMITTING TX");
        TxBB.getBB().getSharedCounters().decrement(TxBB.TX_IN_PROGRESS);
        TransactionId txid = tm.getTransactionId();
        Log.getLogWriter().info("Committing transaction with id " + txid.toString());
        try {
            tm.commit();
            Log.getLogWriter().info("Committed transaction with id " + txid.toString());
        }
        catch (ConflictException e) {
            TxHelper.checkCommitConflictException(e);
            throw e;
        }
    }

    public static void commitExpectSuccess() {
        Log.getLogWriter().info("In commitExpectSuccess");
        TxBB.getBB().getSharedCounters().decrement(TxBB.TX_IN_PROGRESS);
        TransactionId txid = tm.getTransactionId();
        try {
            tm.commit();
            Log.getLogWriter().info("Successful commit for transaction with id " + txid.toString());
        }
        catch (ConflictException e) {
            TxHelper.checkCommitConflictException(e);
            throw new TestException("Expected successful commit for transaction with id " + txid.toString() + ", but got " + TestHelper.getStackTrace(e));
        }
    }

    public static void commitExpectFailure() {
        Log.getLogWriter().info("In commitExpectFailure");
        TxBB.getBB().getSharedCounters().decrement(TxBB.TX_IN_PROGRESS);
        TransactionId txid = tm.getTransactionId();
        try {
            tm.commit();
            throw new TestException("Expected failed commit, but got success for transaction with id " + tm.getTransactionId());
        }
        catch (ConflictException e) {
            TxHelper.checkCommitConflictException(e);
            Log.getLogWriter().info("Transaction with id " + txid.toString() + " failed as expected");
            return;
        }
    }

    public static boolean exists() {
        return tm.exists();
    }

    public static boolean exists(TransactionId txId) {
        return tm.exists(txId);
    }

    public static TransactionId getTransactionId() {
        return tm.getTransactionId();
    }

    public static void rollback() {
        Log.getLogWriter().info("ROLLBACK TX");
        TxBB.getBB().getSharedCounters().decrement(TxBB.TX_IN_PROGRESS);
        TransactionId txid = tm.getTransactionId();
        Log.getLogWriter().info("Rolling back transaction with id " + txid.toString());
        tm.rollback();
        Log.getLogWriter().info("Rolled back transaction with id " + txid.toString());
    }

    public static TransactionId suspend() {
        TXId txId = ((TXManagerImpl)tm).suspend();
        Log.getLogWriter().info("SUSPENDED TX: " + txId);
        return txId;
    }

    public static TXStateInterface internalSuspend() {
        TXStateInterface txContext = ((TXManagerImpl)tm).internalSuspend();
        if (txContext != null) {
            Log.getLogWriter().fine("SUSPENDED TX: " + txContext.toString());
        }
        return txContext;
    }

    public static boolean isSuspended(TransactionId txId) {
        return ((TXManagerImpl)tm).isSuspended(txId);
    }

    public static void resume(TransactionId txId) {
        Log.getLogWriter().info("RESUMING TX: " + txId);
        ((TXManagerImpl)tm).resume(txId);
    }

    public static boolean tryResume(TransactionId txId, long wait, TimeUnit timeUnit) {
        Log.getLogWriter().fine("Trying RESUME with wait (" + wait + "): " + txId);
        return ((TXManagerImpl)tm).tryResume(txId, wait, timeUnit);
    }

    public static void internalResume(TXStateInterface txContext) {
        if (txContext != null) {
            Log.getLogWriter().fine("RESUMING TX: " + txContext.toString());
        }
        ((TXManagerImpl)tm).resume(txContext);
    }

    public static TXStateInterface getTxState() {
        return ((TXManagerImpl)tm).getTXState();
    }

    public static void checkCommitConflictException(ConflictException ex) {
        String errStr = ex.toString();
        if (errStr.indexOf("REMOVED") >= 0 || errStr.indexOf("INVALID") >= 0 || errStr.indexOf("Deserializ") >= 0) {
            throw new TestException("Test got " + errStr + ", but this error text " + "might contain GemFire internal values\n" + TestHelper.getStackTrace(ex));
        }
    }
}

