/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.DataSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import util.BaseValueHolder;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class VHDataSerializable
extends BaseValueHolder
implements DataSerializable {
    public VHDataSerializable(Object anObj, RandomValues randomValues) {
        super(anObj, randomValues);
        this.myVersion = "util.VHDataSerializable";
    }

    public VHDataSerializable(RandomValues randomValues) {
        super(randomValues);
        this.myVersion = "util.VHDataSerializable";
    }

    public VHDataSerializable(String nameFactoryName, RandomValues randomValues) {
        super(nameFactoryName, randomValues);
        this.myVersion = "util.VHDataSerializable";
    }

    public VHDataSerializable(Object anObj, RandomValues randomValues, Integer initModVal) {
        super(anObj, randomValues, initModVal);
        this.myVersion = "util.VHDataSerializable";
    }

    public VHDataSerializable(String nameFactoryName, RandomValues randomValues, Integer initModVal) {
        super(nameFactoryName, randomValues, initModVal);
        this.myVersion = "util.VHDataSerializable";
    }

    public VHDataSerializable() {
        this.myVersion = "util.VHDataSerializable";
    }

    public void toData(DataOutput out) throws IOException {
        VHDataSerializable.myToData(this, out);
    }

    public static void myToData(BaseValueHolder vh, DataOutput out) throws IOException {
        out.writeUTF(vh.myVersion);
        VHDataSerializable.writeObject(out, vh.myValue);
        VHDataSerializable.writeObject(out, vh.extraObject);
        if (vh.modVal == null) {
            out.writeUTF("null");
        } else {
            out.writeUTF(vh.modVal.toString());
        }
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        VHDataSerializable.myFromData(this, in);
    }

    public static void myFromData(BaseValueHolder vh, DataInput in) throws IOException {
        vh.myVersion = in.readUTF();
        vh.myValue = VHDataSerializable.readObject(in);
        vh.extraObject = VHDataSerializable.readObject(in);
        String aStr = in.readUTF();
        vh.modVal = aStr.equals("null") ? null : Integer.valueOf(aStr);
    }

    protected static byte[] toBytes(Object anObj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(anObj);
            byte[] byteArr = bos.toByteArray();
            out.close();
            bos.close();
            return byteArr;
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private static void writeObject(DataOutput out, Object anObj) {
        byte[] byteArr = VHDataSerializable.toBytes(anObj);
        try {
            out.writeInt(byteArr.length);
            out.write(byteArr);
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private static Object readObject(DataInput in) {
        try {
            int length = in.readInt();
            byte[] byteArr = new byte[length];
            in.readFully(byteArr);
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArr);
            ObjectInputStream objIn = new ObjectInputStream(bis);
            Object anObj = objIn.readObject();
            bis.close();
            objIn.close();
            return anObj;
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }
}

