/*
 * Decompiled with CFR 0.152.
 */
package versioning;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.ArrayDeque;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import versioning.ConflictedOpsBB;

public class ConflictedOpsListener
extends SilenceListener
implements CacheListener,
Declarable {
    static Object lastNewValue = null;
    static int numEvents = 0;
    protected String myVmId = null;
    protected String myClientName = null;
    protected Executor serialExecutor = Executors.newSingleThreadExecutor();

    public ConflictedOpsListener() {
        this.myVmId = "vm_" + RemoteTestModule.getMyVmid();
        this.myClientName = RemoteTestModule.getMyClientName();
    }

    public Object getLastNewValue() {
        return lastNewValue;
    }

    public void setLastNewValue(Object v) {
        lastNewValue = v;
    }

    public int getNumEvents() {
        return numEvents;
    }

    public void setNumEvents(int n) {
        numEvents = n;
    }

    @Override
    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
    }

    @Override
    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
    }

    @Override
    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
    }

    @Override
    public void afterUpdate(final EntryEvent event) {
        Object key = event.getKey();
        final Object value = event.getNewValue();
        Region aRegion = event.getRegion();
        this.serialExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ConflictedOpsListener.this.logCall("afterUpdate", (CacheEvent)event);
                if (ConflictedOpsBB.getInstance().getSharedCounters().read(ConflictedOpsBB.processEvents) > 0L) {
                    ConflictedOpsListener.this.setLastNewValue(value);
                    ++numEvents;
                }
            }
        });
        if (((EntryEventImpl)event).isConcurrencyConflict()) {
            this.throwException("ConflictedOpsListener processed CacheEvent with isConcurrencyConflict = true in " + this.myVmId + "_" + this.myClientName);
        }
    }

    @Override
    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    @Override
    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    @Override
    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    @Override
    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    @Override
    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    @Override
    public void close() {
        this.logCall("close", null);
    }

    protected void throwException(String errStr) {
        SharedMap aMap = ConflictedOpsBB.getInstance().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    @Override
    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    class SerialExecutor
    implements Executor {
        final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
        final Executor executor;
        Runnable active;

        SerialExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.tasks.offer(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.active == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.active = this.tasks.poll();
            if (this.active != null) {
                this.executor.execute(this.active);
            }
        }
    }
}

