/*
 * Decompiled with CFR 0.152.
 */
package versioning;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.Set;
import util.NameFactory;
import util.RandomValues;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;
import versioning.ConflictedOpsBB;
import versioning.ConflictedOpsListener;
import versioning.ConflictedOpsPrms;

public class ConflictedOpsTest {
    static ConflictedOpsTest testInstance;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int PUT_IF_ABSENT_OPERATION = 9;
    protected static final int REMOVE_OPERATION = 10;
    protected static final int REPLACE_OPERATION = 11;
    protected static final String REGION_NAME = "testRegion";
    protected ConflictedOpsListener myEventListener;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    protected int totalNumThreadsInTest;
    protected RandomValues randomValues = new RandomValues();
    protected Region aRegion;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected int concurrentLeaderTid;
    protected int myTid;
    protected int myVmId;
    protected int secondsToRun;
    protected volatile long taskStartTime;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    public static int EQUAL;
    public static int EQUIVALENT;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static void HydraTask_startGatewayHubTask() {
        testInstance.startGatewayHub(ConfigPrms.getGatewayConfig());
    }

    protected void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    protected void createGatewayHub(String gatewayHubConfig) {
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ConflictedOpsTest();
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            testInstance.createRegion();
            testInstance.createGatewayHub();
            testInstance.initializeInstance();
        }
    }

    protected void initializeInstance() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = TestConfig.tab().intAt(ConflictedOpsPrms.numOpsPerTask, Integer.MAX_VALUE);
        this.upperThreshold = TestConfig.tab().intAt(ConflictedOpsPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(ConflictedOpsPrms.lowerThreshold, -1);
        this.secondsToRun = TestConfig.tab().intAt(ConflictedOpsPrms.secondsToRun, 1800);
        this.concurrentLeaderTid = -1;
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", " + "minTaskGranularityMS " + this.minTaskGranularityMS + ", " + "numOpsPerTask " + this.numOpsPerTask + ", " + "secondsToRun " + this.secondsToRun + ", " + "upperThreshold " + this.upperThreshold + ", " + "lowerThreshold " + this.lowerThreshold);
    }

    public static void HydraTask_loadRegion() {
        long startTime = System.currentTimeMillis();
        long lastLogTime = System.currentTimeMillis();
        do {
            Object key = testInstance.getNewKey();
            ValueHolder anObj = testInstance.getValueForKey(key);
            ConflictedOpsTest.testInstance.aRegion.put(key, (Object)anObj);
            long counter = NameFactory.getCounterForName(key);
            if (counter >= (long)ConflictedOpsTest.testInstance.upperThreshold) {
                String s = "NameFactory nameCounter has reached " + counter;
                throw new StopSchedulingTaskOnClientOrder(s);
            }
            if (System.currentTimeMillis() - lastLogTime < 10000L) continue;
            Log.getLogWriter().info("Current nameCounter is " + counter);
            lastLogTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < ConflictedOpsTest.testInstance.minTaskGranularityMS);
    }

    public static void HydraTask_conflictedOpsTest() {
        testInstance.conflictedOpsTest();
    }

    protected void conflictedOpsTest() {
        Object key;
        this.totalNumThreadsInTest = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        this.myTid = RemoteTestModule.getCurrentThread().getThreadId();
        this.myVmId = RemoteTestModule.getMyVmid();
        long numWaiting = ConflictedOpsBB.getInstance().getSharedCounters().incrementAndRead(ConflictedOpsBB.ReadyToBegin);
        if (numWaiting == 1L) {
            ConflictedOpsTest.logExecutionNumber();
        }
        TestHelper.waitForCounter(ConflictedOpsBB.getInstance(), "ConflictedOpsBB.ReadyToBegin", ConflictedOpsBB.ReadyToBegin, this.totalNumThreadsInTest, true, -1L, 1000L);
        this.checkForLastIteration();
        boolean leader = false;
        boolean bl = leader = ConflictedOpsBB.getInstance().getSharedCounters().incrementAndRead(ConflictedOpsBB.ConcurrentLeader) == 1L;
        if (leader) {
            ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.WaitForSelectedKey);
            ConflictedOpsBB.getInstance().getSharedCounters().increment(ConflictedOpsBB.processEvents);
            this.concurrentLeaderTid = RemoteTestModule.getCurrentThread().getThreadId();
            Log.getLogWriter().info("In conflictedOpsTest, concurrentLeaderTid is vm_" + this.myVmId + " thr_" + this.concurrentLeaderTid);
            key = this.getExistingKey(this.aRegion);
            ConflictedOpsBB.getInstance().getSharedMap().put("SelectedKey", key);
            ConflictedOpsBB.getInstance().getSharedCounters().increment(ConflictedOpsBB.WaitForSelectedKey);
        } else {
            TestHelper.waitForCounter(ConflictedOpsBB.getInstance(), "ConflictedOpsBB.WaitForSelectedKey", ConflictedOpsBB.WaitForSelectedKey, 1L, true, -1L, 500L);
        }
        Log.getLogWriter().info("Zeroing ShapshotWritten");
        ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.SnapshotWritten);
        ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.ReadyToVerify);
        key = ConflictedOpsBB.getInstance().getSharedMap().get("SelectedKey");
        ValueHolder value = this.getValueForKey(key, this.myTid);
        String callback = "vm_" + this.myVmId + "_thr_" + this.myTid;
        this.aRegion.put(key, (Object)value, (Object)callback);
        Log.getLogWriter().info("Zeroing FinishedVerify");
        ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.FinishedVerify);
        ConflictedOpsBB.getInstance().getSharedCounters().increment(ConflictedOpsBB.Pausing);
        TestHelper.waitForCounter(ConflictedOpsBB.getInstance(), "ConflictedOpsBB.Pausing", ConflictedOpsBB.Pausing, this.totalNumThreadsInTest, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing ReadyToBegin");
        ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.ReadyToBegin);
        ConflictedOpsBB.getInstance().getSharedCounters().increment(ConflictedOpsBB.ReadyToVerify);
        TestHelper.waitForCounter(ConflictedOpsBB.getInstance(), "ConflictedOpsBB.ReadyToVerify", ConflictedOpsBB.ReadyToVerify, this.totalNumThreadsInTest, true, -1L, 1000L);
        SilenceListener.waitForSilence(30L, 1000L);
        this.conflictedOpsVerify();
        ConflictedOpsBB.getInstance().getSharedCounters().increment(ConflictedOpsBB.FinishedVerify);
        TestHelper.waitForCounter(ConflictedOpsBB.getInstance(), "ConflictedOpsBB.FinishedVerify", ConflictedOpsBB.FinishedVerify, this.totalNumThreadsInTest, true, -1L, 1000L);
        Log.getLogWriter().info("Zeroing ConcurrentLeader, Pausing");
        ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.ConcurrentLeader);
        ConflictedOpsBB.getInstance().getSharedCounters().zero(ConflictedOpsBB.Pausing);
        this.concurrentLeaderTid = -1;
        this.myEventListener.setLastNewValue(null);
        this.myEventListener.setNumEvents(0);
        long counter = ConflictedOpsBB.getInstance().getSharedCounters().read(ConflictedOpsBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + ConflictedOpsBB.getInstance().getSharedCounters().read(ConflictedOpsBB.ExecutionNumber));
        }
    }

    protected void doEntryOperations(Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        do {
            int whichOp = this.getOperation(ConflictedOpsPrms.entryOperations);
            int size = aRegion.keys().size();
            Log.getLogWriter().info("Selecting operation, region size is " + size);
            if (size >= this.upperThreshold) {
                whichOp = this.getOperation(ConflictedOpsPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getOperation(ConflictedOpsPrms.lowerThresholdOperations);
            }
            switch (whichOp) {
                case 1: {
                    this.addEntry(aRegion);
                    break;
                }
                case 3: {
                    this.invalidateEntry(aRegion, false);
                    break;
                }
                case 2: {
                    this.destroyEntry(aRegion, false);
                    break;
                }
                case 6: {
                    this.updateEntry(aRegion);
                    break;
                }
                case 7: {
                    this.getKey(aRegion);
                    break;
                }
                case 8: {
                    this.getNewKey(aRegion);
                    break;
                }
                case 5: {
                    this.invalidateEntry(aRegion, true);
                    break;
                }
                case 4: {
                    this.destroyEntry(aRegion, true);
                    break;
                }
                case 9: {
                    this.putIfAbsent(aRegion);
                    break;
                }
                case 10: {
                    this.remove(aRegion);
                    break;
                }
                case 11: {
                    this.replace(aRegion);
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
    }

    protected Object addEntry(Region aRegion) {
        Object key = this.getNewKey();
        ValueHolder anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.keys().size();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                try {
                    Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                    aRegion.create(key, (Object)anObj, (Object)callback);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (CacheWriterException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (EntryExistsException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            } else {
                try {
                    Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                    aRegion.create(key, (Object)anObj);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (CacheWriterException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (EntryExistsException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            try {
                aRegion.put(key, (Object)anObj, (Object)callback);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("addEntry: done putting key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            try {
                aRegion.put(key, (Object)anObj);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
        return key;
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        int beforeSize = aRegion.keys().size();
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: No keys in region");
            return;
        }
        boolean containsKey = aRegion.containsKey(key);
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        Log.getLogWriter().info("containsKey for " + key + ": " + containsKey);
        Log.getLogWriter().info("containsValueForKey for " + key + ": " + containsValueForKey);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aRegion.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    aRegion.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            if (e instanceof BridgeWriterException) {
                if (e.toString().indexOf(EntryNotFoundException.class.getName()) >= 0) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                    return;
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    protected Object putIfAbsent(Region aRegion) {
        Object key = this.getNewKey();
        ValueHolder anObj = this.getValueForKey(key);
        int beforeSize = aRegion.keys().size();
        try {
            Log.getLogWriter().info("putIfAbsent: creating key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            Object retVal = aRegion.putIfAbsent(key, (Object)anObj);
            Log.getLogWriter().info("putIfAbsent: done creating key " + key);
            if (retVal != null) {
                Log.getLogWriter().info("putIfAbsent for key " + key + " expected successful operation (with return value of null), but entry already exists with value " + retVal);
                throw new TestException(TestHelper.getStackTrace());
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return key;
    }

    protected void replace(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("replace: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        ValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        Log.getLogWriter().info("Replacing key " + key);
        Object retVal = aRegion.replace(key, (Object)anObj);
        Log.getLogWriter().info("Done with call to replace " + key + " with return value " + retVal);
    }

    protected void remove(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("remove: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        try {
            Log.getLogWriter().info("remove: removing key " + key);
            aRegion.remove(key, aRegion.get(key));
            Log.getLogWriter().info("remove: done removing key " + key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("updateEntry: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        ValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            try {
                aRegion.put(key, (Object)anObj, (Object)callback);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Done with call to put (update)");
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            try {
                aRegion.put(key, (Object)anObj);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Done with call to put (update)");
        }
    }

    protected void getKey(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            this.getNewKey(aRegion);
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.keys().size();
        boolean beforeContainsValueForKey = aRegion.containsValueForKey(key);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
                Object anObj = aRegion.get(key, (Object)callback);
                Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
            } else {
                Log.getLogWriter().info("getKey: getting key " + key);
                Object anObj = aRegion.get(key);
                Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.keys().size();
        boolean beforeContainsValueForKey = aRegion.containsValueForKey(key);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
                Object anObj = aRegion.get(key, (Object)callback);
                Log.getLogWriter().info("getNewKey: getting value for key " + key + ": " + TestHelper.toString(anObj));
            } else {
                Log.getLogWriter().info("getNewKey: getting key " + key);
                Object anObj = aRegion.get(key);
                Log.getLogWriter().info("getNewKey: got value for key " + key + ": " + TestHelper.toString(anObj));
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void checkForLastIteration() {
        if (this.taskStartTime == 0L) {
            this.taskStartTime = System.currentTimeMillis();
            Log.getLogWriter().info("Initialized taskStartTime to " + this.taskStartTime);
        }
        if (System.currentTimeMillis() - this.taskStartTime >= (long)(this.secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            ConflictedOpsBB.getInstance().getSharedCounters().increment(ConflictedOpsBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + this.secondsToRun + " seconds; time remaining is " + (System.currentTimeMillis() - this.taskStartTime) / 1000L + " seconds");
        }
    }

    protected ValueHolder getValueForKey(Object key, Integer modVal) {
        return new ValueHolder((Object)((String)key), this.randomValues, modVal);
    }

    protected ValueHolder getValueForKey(Object key) {
        return new ValueHolder((String)key, this.randomValues);
    }

    protected Object getNewKey() {
        return NameFactory.getNextPositiveObjectName();
    }

    protected Object getRecentKey(Region aRegion, int recentHistory) {
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            return null;
        }
        long keyIndex = TestConfig.tab().getRandGen().nextLong(Math.max(maxNames - (long)recentHistory, 1L), maxNames);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        return key;
    }

    protected ValueHolder getUpdateObject(Region aRegion, String key) {
        try {
            Object anObj = aRegion.get((Object)key);
            if (anObj != null && !(anObj instanceof ValueHolder)) {
                throw new TestException("Getting key " + key + " returned " + TestHelper.toString(anObj) + ", but an instance of ValueHolder was expected");
            }
            ValueHolder vh = (ValueHolder)anObj;
            ValueHolder newObj = vh == null ? new ValueHolder(key, this.randomValues) : (ValueHolder)vh.getAlternateValueHolder(this.randomValues);
            return newObj;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static void logExecutionNumber() {
        long exeNum = ConflictedOpsBB.getInstance().getSharedCounters().incrementAndRead(ConflictedOpsBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putIfAbsent")) {
            op = 9;
        } else if (operation.equals("remove")) {
            op = 10;
        } else if (operation.equals("replace")) {
            op = 11;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void verifySelectedKeyValue(Object key) {
        ValueHolder expectedValue = (ValueHolder)ConflictedOpsBB.getInstance().getSharedMap().get("ExpectedValue");
        StringBuffer aStr = new StringBuffer();
        try {
            ConflictedOpsTest.verifyContainsKey(this.aRegion, key, true);
        }
        catch (TestException e) {
            aStr.append(e.getMessage() + "\n");
        }
        boolean containsValueForKey = this.aRegion.containsValueForKey(key);
        try {
            ConflictedOpsTest.verifyContainsValueForKey(this.aRegion, key, expectedValue != null);
        }
        catch (TestException e) {
            aStr.append(e.getMessage());
        }
        if (containsValueForKey) {
            try {
                ValueHolder actualValue = (ValueHolder)this.aRegion.get(key);
                ConflictedOpsTest.verifyMyValue(key, expectedValue, actualValue, EQUAL);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            if (aStr.length() == 0) {
                Log.getLogWriter().info("Done (successfully) verifying value of selected key " + key + ":" + expectedValue.toString());
            } else {
                Log.getLogWriter().info("Validation of local cache value against concurrentLeader's cache value failed: " + aStr.toString());
            }
            try {
                int numEvents = this.myEventListener.getNumEvents();
                if (numEvents > TestHelper.getNumThreads()) {
                    throw new TestException("numEvents in this vm (" + numEvents + ") for last operation > numThreadsInTest (" + TestHelper.getNumThreads() + ").  Suspect that we handled an elided event");
                }
                Log.getLogWriter().info("This vm processed " + numEvents + " events for this operation");
                ValueHolder lastNewValueFromMyListener = (ValueHolder)this.myEventListener.getLastNewValue();
                if (lastNewValueFromMyListener != null) {
                    ConflictedOpsTest.verifyMyValue(key, expectedValue, lastNewValueFromMyListener, EQUAL);
                }
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        if (aStr.length() == 0) {
            Log.getLogWriter().info("Done (successfully) verifying value last update in this vm for key " + key + ":" + expectedValue.toString());
        } else {
            Log.getLogWriter().info("Validation of newValue in last update (fired in this vm) against concurrentLeader's cache value failed: " + aStr.toString());
        }
        try {
            TestHelper.checkForEventError(ConflictedOpsBB.getInstance());
        }
        catch (TestException e) {
            aStr.append("Listener threw Exception:" + e);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    protected void conflictedOpsVerify() {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        Object key = ConflictedOpsBB.getInstance().getSharedMap().get("SelectedKey");
        Log.getLogWriter().info("In conflictedOpsVerify, with myTid " + myTid + ", concurrentLeaderTid is " + this.concurrentLeaderTid);
        if (myTid == this.concurrentLeaderTid) {
            Log.getLogWriter().info("This thread is the concurrentLeader, providing the selected key and expected final value after this op");
            ValueHolder value = null;
            try {
                value = (ValueHolder)this.aRegion.get(key);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            ConflictedOpsBB.getInstance().getSharedMap().put("ExpectedValue", value);
            Log.getLogWriter().info("Done posting expected value" + value);
            long snapshotWritten = ConflictedOpsBB.getInstance().getSharedCounters().incrementAndRead(ConflictedOpsBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        } else {
            TestHelper.waitForCounter(ConflictedOpsBB.getInstance(), "ConflictedOpsBB.SnapshotWritten", ConflictedOpsBB.SnapshotWritten, 1L, true, -1L, 2000L);
        }
        this.verifySelectedKeyValue(key);
    }

    protected static void verifySize(Region aRegion, int expectedSize) {
        int size = aRegion.keys().size();
        if (size != expectedSize) {
            throw new TestException("Expected size of " + aRegion.getFullPath() + " to be " + expectedSize + ", but it is " + size + ", keys are: " + aRegion.keys());
        }
    }

    protected Object getExistingKey(Region aRegion) {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            return null;
        }
        Iterator it = aSet.iterator();
        Object key = null;
        if (it.hasNext()) {
            key = it.next();
            return key;
        }
        return null;
    }

    protected static void verifyContainsKey(Region aRegion, Object key, boolean expected) {
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsKey);
        }
    }

    protected static void verifyContainsValueForKey(Region aRegion, Object key, boolean expected) {
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        if (containsValueForKey != expected) {
            throw new TestException("Expected containsValueForKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsValueForKey);
        }
    }

    protected static void verifyMyValue(Object key, ValueHolder expectedValue, ValueHolder valueToCheck, int compareStrategy) {
        if (valueToCheck == null) {
            if (expectedValue != null) {
                throw new TestException("For key " + key + ", expected myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
            }
        } else if (valueToCheck instanceof ValueHolder) {
            if (compareStrategy == EQUAL ? !expectedValue.equals(valueToCheck) : compareStrategy == EQUIVALENT && !expectedValue.toString().equals(valueToCheck.toString())) {
                throw new TestException("For key " + key + ", expected ValueHolder to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
            }
        } else {
            throw new TestException("Expected value for key " + key + " to be an instance of ValueHolder, but it is " + TestHelper.toString(valueToCheck));
        }
    }

    protected void createRegion() {
        this.aRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        Log.getLogWriter().info("After creating region, region size is " + this.aRegion.keys().size());
        CacheListener[] listeners = this.aRegion.getAttributes().getCacheListeners();
        this.myEventListener = (ConflictedOpsListener)listeners[0];
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        }
        if (this.aRegion.getAttributes().getPoolName() != null) {
            this.aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("registered interest in ALL_KEYS for testRegion");
        }
    }

    static {
        EQUAL = 1;
        EQUIVALENT = 2;
    }
}

