/*
 * Decompiled with CFR 0.152.
 */
package versioning;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import util.NameFactory;
import util.RandomValues;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;
import versioning.VersionBB;
import versioning.VersionPrms;

public class VersioningTest {
    static VersioningTest testInstance;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int PUT_IF_ABSENT_OPERATION = 9;
    protected static final int REMOVE_OPERATION = 10;
    protected static final int REPLACE_OPERATION = 11;
    protected static final String REGION_NAME = "testRegion";
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    protected boolean isSerialExecution;
    protected int totalNumThreadsInTest;
    protected RandomValues randomValues = new RandomValues();
    protected Region aRegion;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected int concurrentLeaderTid;
    protected int secondsToRun;
    protected volatile long taskStartTime;
    protected Map regionSnapshot;
    protected Set destroyedKeys;
    protected boolean useOwnKeys;
    public HydraThreadLocal ownKeysIndex = new HydraThreadLocal();
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    public static int EQUAL;
    public static int EQUIVALENT;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static void HydraTask_startGatewayHubTask() {
        testInstance.startGatewayHub(ConfigPrms.getGatewayConfig());
    }

    protected void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    protected void createGatewayHub(String gatewayHubConfig) {
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new VersioningTest();
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            testInstance.createRegion();
            testInstance.createGatewayHub();
            testInstance.initializeInstance();
        }
        VersioningTest.testInstance.ownKeysIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    protected void initializeInstance() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = TestConfig.tab().intAt(VersionPrms.numOpsPerTask, Integer.MAX_VALUE);
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        this.upperThreshold = TestConfig.tab().intAt(VersionPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(VersionPrms.lowerThreshold, -1);
        this.secondsToRun = TestConfig.tab().intAt(VersionPrms.secondsToRun, 1800);
        this.useOwnKeys = TestConfig.tab().booleanAt(VersionPrms.useOwnKeys);
        this.concurrentLeaderTid = -1;
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", " + "minTaskGranularityMS " + this.minTaskGranularityMS + ", " + "numOpsPerTask " + this.numOpsPerTask + ", " + "useOwnKeys " + this.useOwnKeys + ", " + "secondsToRun " + this.secondsToRun + ", " + "isSerialExecution " + this.isSerialExecution + ", " + "upperThreshold " + this.upperThreshold + ", " + "lowerThreshold " + this.lowerThreshold);
        this.regionSnapshot = new HashMap();
        this.destroyedKeys = new HashSet();
    }

    public static void HydraTask_doConcOpsAndVerify() {
        testInstance.doConcOpsAndVerify();
    }

    protected void doConcOpsAndVerify() {
        this.totalNumThreadsInTest = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long numWaiting = VersionBB.getInstance().getSharedCounters().incrementAndRead(VersionBB.ReadyToBegin);
        if (numWaiting == 1L) {
            VersioningTest.logExecutionNumber();
        }
        TestHelper.waitForCounter(VersionBB.getInstance(), "VersionBB.ReadyToBegin", VersionBB.ReadyToBegin, this.totalNumThreadsInTest, true, -1L, 1000L);
        this.checkForLastIteration();
        boolean leader = false;
        if (!this.aRegion.isEmpty()) {
            boolean bl = leader = VersionBB.getInstance().getSharedCounters().incrementAndRead(VersionBB.ConcurrentLeader) == 1L;
        }
        if (leader) {
            this.concurrentLeaderTid = RemoteTestModule.getCurrentThread().getThreadId();
        }
        Log.getLogWriter().info("In doConcOpsAndVerify, concurrentLeaderTid is " + this.concurrentLeaderTid);
        Log.getLogWriter().info("Zeroing ShapshotWritten");
        VersionBB.getInstance().getSharedCounters().zero(VersionBB.SnapshotWritten);
        VersionBB.getInstance().getSharedCounters().zero(VersionBB.ReadyToVerify);
        this.doEntryOperations(this.aRegion);
        Log.getLogWriter().info("Zeroing FinishedVerify");
        VersionBB.getInstance().getSharedCounters().zero(VersionBB.FinishedVerify);
        VersionBB.getInstance().getSharedCounters().increment(VersionBB.Pausing);
        TestHelper.waitForCounter(VersionBB.getInstance(), "VersionBB.Pausing", VersionBB.Pausing, this.totalNumThreadsInTest, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing ReadyToBegin, ConcurrentLeader");
        VersionBB.getInstance().getSharedCounters().zero(VersionBB.ReadyToBegin);
        VersionBB.getInstance().getSharedCounters().zero(VersionBB.ConcurrentLeader);
        VersionBB.getInstance().getSharedCounters().increment(VersionBB.ReadyToVerify);
        TestHelper.waitForCounter(VersionBB.getInstance(), "VersionBB.ReadyToVerify", VersionBB.ReadyToVerify, this.totalNumThreadsInTest, true, -1L, 1000L);
        SilenceListener.waitForSilence(30L, 1000L);
        this.concVerify();
        VersionBB.getInstance().getSharedCounters().increment(VersionBB.FinishedVerify);
        TestHelper.waitForCounter(VersionBB.getInstance(), "VersionBB.FinishedVerify", VersionBB.FinishedVerify, this.totalNumThreadsInTest, true, -1L, 1000L);
        Log.getLogWriter().info("Zeroing concurrentLeaderTid, Pausing");
        this.concurrentLeaderTid = -1;
        VersionBB.getInstance().getSharedCounters().zero(VersionBB.Pausing);
        long counter = VersionBB.getInstance().getSharedCounters().read(VersionBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + VersionBB.getInstance().getSharedCounters().read(VersionBB.ExecutionNumber));
        }
    }

    protected void doEntryOperations(Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        do {
            int whichOp = this.getOperation(VersionPrms.entryOperations);
            if (aRegion.getAttributes().getDataPolicy().withStorage()) {
                int size = aRegion.keys().size();
                Log.getLogWriter().info("Selecting operation, region size is " + size);
                if (size >= this.upperThreshold) {
                    whichOp = this.getOperation(VersionPrms.upperThresholdOperations);
                } else if (size <= this.lowerThreshold) {
                    whichOp = this.getOperation(VersionPrms.lowerThresholdOperations);
                }
            } else {
                whichOp = 7;
            }
            switch (whichOp) {
                case 1: {
                    this.addEntry(aRegion);
                    break;
                }
                case 3: {
                    this.invalidateEntry(aRegion, false);
                    break;
                }
                case 2: {
                    this.destroyEntry(aRegion, false);
                    break;
                }
                case 6: {
                    this.updateEntry(aRegion);
                    break;
                }
                case 7: {
                    this.getKey(aRegion);
                    break;
                }
                case 8: {
                    this.getNewKey(aRegion);
                    break;
                }
                case 5: {
                    this.invalidateEntry(aRegion, true);
                    break;
                }
                case 4: {
                    this.destroyEntry(aRegion, true);
                    break;
                }
                case 9: {
                    this.putIfAbsent(aRegion);
                    break;
                }
                case 10: {
                    this.remove(aRegion);
                    break;
                }
                case 11: {
                    this.replace(aRegion);
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
    }

    protected Object addEntry(Region aRegion) {
        Object key = this.getNewKey();
        ValueHolder anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.keys().size();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                try {
                    Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                    aRegion.create(key, (Object)anObj, (Object)callback);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (CacheWriterException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (EntryExistsException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            } else {
                try {
                    Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                    aRegion.create(key, (Object)anObj);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (CacheWriterException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (EntryExistsException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            try {
                aRegion.put(key, (Object)anObj, (Object)callback);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("addEntry: done putting key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            try {
                aRegion.put(key, (Object)anObj);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, true);
            VersioningTest.verifySize(aRegion, beforeSize + 1);
            this.regionSnapshot.put(key, anObj.myValue);
            this.destroyedKeys.remove(key);
        }
        return key;
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        int beforeSize = aRegion.keys().size();
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: No keys in region");
            return;
        }
        boolean containsKey = aRegion.containsKey(key);
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        Log.getLogWriter().info("containsKey for " + key + ": " + containsKey);
        Log.getLogWriter().info("containsValueForKey for " + key + ": " + containsValueForKey);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aRegion.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    aRegion.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, false);
            VersioningTest.verifySize(aRegion, beforeSize);
            if (!isLocalInvalidate) {
                this.regionSnapshot.put(key, null);
                this.destroyedKeys.remove(key);
            }
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            if (this.isSerialExecution || this.useOwnKeys) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (e instanceof BridgeWriterException) {
                if (e.toString().indexOf(EntryNotFoundException.class.getName()) >= 0) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                    return;
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution || this.useOwnKeys) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, false);
            VersioningTest.verifyContainsValueForKey(aRegion, key, false);
            VersioningTest.verifySize(aRegion, beforeSize - 1);
            if (!isLocalDestroy) {
                this.regionSnapshot.remove(key);
                this.destroyedKeys.add(key);
            }
        }
    }

    protected Object putIfAbsent(Region aRegion) {
        Object key = this.getNewKey();
        ValueHolder anObj = this.getValueForKey(key);
        int beforeSize = aRegion.keys().size();
        try {
            Log.getLogWriter().info("putIfAbsent: creating key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            Object retVal = aRegion.putIfAbsent(key, (Object)anObj);
            Log.getLogWriter().info("putIfAbsent: done creating key " + key);
            if (retVal != null) {
                Log.getLogWriter().info("putIfAbsent for key " + key + " expected successful operation (with return value of null), but entry already exists with value " + retVal);
                throw new TestException(TestHelper.getStackTrace());
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, true);
            VersioningTest.verifySize(aRegion, beforeSize + 1);
            this.regionSnapshot.put(key, anObj.myValue);
            this.destroyedKeys.remove(key);
        }
        return key;
    }

    protected void replace(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("replace: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        ValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        Log.getLogWriter().info("Replacing key " + key);
        Object retVal = aRegion.replace(key, (Object)anObj);
        Log.getLogWriter().info("Done with call to replace " + key + " with return value " + retVal);
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, true);
            VersioningTest.verifySize(aRegion, beforeSize);
            this.regionSnapshot.put(key, anObj.myValue);
            this.destroyedKeys.remove(key);
        }
    }

    protected void remove(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("remove: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        try {
            Log.getLogWriter().info("remove: removing key " + key);
            aRegion.remove(key, aRegion.get(key));
            Log.getLogWriter().info("remove: done removing key " + key);
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution || this.useOwnKeys) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, false);
            VersioningTest.verifyContainsValueForKey(aRegion, key, false);
            VersioningTest.verifySize(aRegion, beforeSize - 1);
            this.regionSnapshot.remove(key);
            this.destroyedKeys.add(key);
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("updateEntry: No keys in region");
            return;
        }
        int beforeSize = aRegion.keys().size();
        ValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            try {
                aRegion.put(key, (Object)anObj, (Object)callback);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Done with call to put (update)");
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            try {
                aRegion.put(key, (Object)anObj);
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Done with call to put (update)");
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, true);
            VersioningTest.verifySize(aRegion, beforeSize);
            this.regionSnapshot.put(key, anObj.myValue);
            this.destroyedKeys.remove(key);
        }
    }

    protected void getKey(Region aRegion) {
        Object anObj;
        Object key = this.getExistingKey(aRegion);
        boolean hasStorage = aRegion.getAttributes().getDataPolicy().withStorage();
        if (!hasStorage) {
            while (key == null) {
                long lastKey = NameFactory.getPositiveNameCounter();
                key = this.getRecentKey(aRegion, (int)lastKey);
            }
        }
        if (key == null) {
            this.getNewKey(aRegion);
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.keys().size();
        boolean beforeContainsValueForKey = aRegion.containsValueForKey(key);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
                anObj = aRegion.get(key, (Object)callback);
                Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
            } else {
                Log.getLogWriter().info("getKey: getting key " + key);
                anObj = aRegion.get(key);
                Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, anObj != null);
            Object expectedValue = this.regionSnapshot.get(key);
            VersioningTest.verifyMyValue(aRegion, key, expectedValue, anObj, EQUAL);
            if (anObj == null) {
                this.regionSnapshot.put(key, null);
            } else {
                this.regionSnapshot.put(key, ((ValueHolder)anObj).myValue);
            }
            this.destroyedKeys.remove(key);
        }
    }

    protected void getNewKey(Region aRegion) {
        Object anObj;
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.keys().size();
        boolean beforeContainsValueForKey = aRegion.containsValueForKey(key);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
                anObj = aRegion.get(key, (Object)callback);
                Log.getLogWriter().info("getNewKey: getting value for key " + key + ": " + TestHelper.toString(anObj));
            } else {
                Log.getLogWriter().info("getNewKey: getting key " + key);
                anObj = aRegion.get(key);
                Log.getLogWriter().info("getNewKey: got value for key " + key + ": " + TestHelper.toString(anObj));
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isSerialExecution) {
            VersioningTest.verifyContainsKey(aRegion, key, true);
            VersioningTest.verifyContainsValueForKey(aRegion, key, false);
            if (anObj != null) {
                throw new TestException("Expected null to be returned from get of new key " + key + ", but " + TestHelper.toString(anObj) + " was returned");
            }
            this.regionSnapshot.put(key, null);
            this.destroyedKeys.remove(key);
        }
    }

    protected void checkForLastIteration() {
        if (this.taskStartTime == 0L) {
            this.taskStartTime = System.currentTimeMillis();
            Log.getLogWriter().info("Initialized taskStartTime to " + this.taskStartTime);
        }
        if (System.currentTimeMillis() - this.taskStartTime >= (long)(this.secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            VersionBB.getInstance().getSharedCounters().increment(VersionBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + this.secondsToRun + " seconds; time remaining is " + (System.currentTimeMillis() - this.taskStartTime) / 1000L + " seconds");
        }
    }

    protected ValueHolder getValueForKey(Object key) {
        return new ValueHolder((String)key, this.randomValues);
    }

    protected Object getNewKey() {
        if (this.useOwnKeys) {
            int anInt = (Integer)this.ownKeysIndex.get();
            this.ownKeysIndex.set(new Integer(anInt += this.totalNumThreadsInTest));
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    protected Object getRecentKey(Region aRegion, int recentHistory) {
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            return null;
        }
        long keyIndex = TestConfig.tab().getRandGen().nextLong(Math.max(maxNames - (long)recentHistory, 1L), maxNames);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        return key;
    }

    protected ValueHolder getUpdateObject(Region aRegion, String key) {
        try {
            Object anObj = aRegion.get((Object)key);
            if (anObj != null && !(anObj instanceof ValueHolder)) {
                throw new TestException("Getting key " + key + " returned " + TestHelper.toString(anObj) + ", but an instance of ValueHolder was expected");
            }
            ValueHolder vh = (ValueHolder)anObj;
            ValueHolder newObj = vh == null ? new ValueHolder(key, this.randomValues) : (ValueHolder)vh.getAlternateValueHolder(this.randomValues);
            return newObj;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static void logExecutionNumber() {
        long exeNum = VersionBB.getInstance().getSharedCounters().incrementAndRead(VersionBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putIfAbsent")) {
            op = 9;
        } else if (operation.equals("remove")) {
            op = 10;
        } else if (operation.equals("replace")) {
            op = 11;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void verifyFromSnapshot() {
        int regionSize;
        if (this.aRegion.isEmpty()) {
            return;
        }
        StringBuffer aStr = new StringBuffer();
        this.regionSnapshot = (Map)VersionBB.getInstance().getSharedMap().get("RegionSnapshot");
        this.destroyedKeys = (Set)VersionBB.getInstance().getSharedMap().get("DestroyedKeys");
        int snapshotSize = this.regionSnapshot.size();
        if (snapshotSize != (regionSize = this.aRegion.keys().size())) {
            aStr.append("Expected region " + this.aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n entries = " + this.aRegion.keySet());
        }
        Log.getLogWriter().info("Verifying from snapshot containing " + snapshotSize + " entries...");
        for (Map.Entry entry : this.regionSnapshot.entrySet()) {
            Object key = entry.getKey();
            ValueAndVersion valueAndTag = (ValueAndVersion)entry.getValue();
            Object expectedValue = valueAndTag.value;
            Object versionTag = valueAndTag.version;
            VersionTag myVersion = ((LocalRegion)this.aRegion).getVersionTag(key);
            try {
                VersioningTest.verifyContainsKey(this.aRegion, key, true);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = this.aRegion.containsValueForKey(key);
            try {
                VersioningTest.verifyContainsValueForKey(this.aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + " my version = " + myVersion + " snapshot version = " + versionTag + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = this.aRegion.get(key);
                VersioningTest.verifyMyValue(this.aRegion, key, expectedValue, actualValue, EQUAL);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + " my version = " + myVersion + " snapshot version = " + versionTag + "\n");
            }
        }
        for (Map.Entry key : this.destroyedKeys) {
            try {
                VersioningTest.verifyContainsKey(this.aRegion, key, false);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + " version = " + ((LocalRegion)this.aRegion).getVersionTag(key));
            }
        }
        Set snapshotKeys = this.regionSnapshot.keySet();
        HashSet regionKeys = new HashSet(this.aRegion.keys());
        regionKeys.removeAll(snapshotKeys);
        if (regionKeys.size() != 0) {
            aStr.append("\nFound the following unexpected keys in " + this.aRegion.getFullPath() + ": " + regionKeys + "\n");
            for (Object key : regionKeys) {
                aStr.append("\n  key " + key + " version = " + ((LocalRegion)this.aRegion).getVersionTag(key));
            }
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying from snapshot containing " + snapshotSize + " entries...");
    }

    protected void concVerify() {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        Log.getLogWriter().info("In concVerify, with myTid " + myTid + ", concurrentLeaderTid is " + this.concurrentLeaderTid);
        if (myTid == this.concurrentLeaderTid) {
            this.regionSnapshot = new HashMap();
            this.destroyedKeys = new HashSet();
            Log.getLogWriter().info("This thread is the concurrentLeader, creating region snapshot...");
            Set keySet = this.aRegion.keys();
            Iterator it = keySet.iterator();
            if (!it.hasNext()) {
                throw new TestException("Unexpected region size " + this.aRegion.keys().size());
            }
            while (it.hasNext()) {
                try {
                    Object key = it.next();
                    Object value = this.aRegion.get(key);
                    VersionTag tag = ((LocalRegion)this.aRegion).getVersionTag(key);
                    if (value instanceof ValueHolder) {
                        this.regionSnapshot.put(key, new ValueAndVersion(((ValueHolder)value).myValue, tag));
                        continue;
                    }
                    this.regionSnapshot.put(key, new ValueAndVersion(value, tag));
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (CacheLoaderException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            Log.getLogWriter().info("Done creating region snapshot with " + this.regionSnapshot.size() + " entries; snapshot is " + this.regionSnapshot);
            VersionBB.getInstance().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
            Log.getLogWriter().info("Done creating destroyed keys with " + this.destroyedKeys.size() + " keys");
            VersionBB.getInstance().getSharedMap().put("DestroyedKeys", this.destroyedKeys);
            long snapshotWritten = VersionBB.getInstance().getSharedCounters().incrementAndRead(VersionBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        } else {
            TestHelper.waitForCounter(VersionBB.getInstance(), "VersionBB.SnapshotWritten", VersionBB.SnapshotWritten, 1L, true, -1L, 2000L);
            this.verifyFromSnapshot();
        }
    }

    protected static void verifySize(Region aRegion, int expectedSize) {
        int size = aRegion.keys().size();
        if (size != expectedSize) {
            throw new TestException("Expected size of " + aRegion.getFullPath() + " to be " + expectedSize + ", but it is " + size + ", keys are: " + aRegion.keys());
        }
    }

    protected Object getExistingKey(Region aRegion) {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            return null;
        }
        Iterator it = aSet.iterator();
        Object key = null;
        while (it.hasNext()) {
            key = it.next();
            if (this.useOwnKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)this.totalNumThreadsInTest != (long)myTid) continue;
                return key;
            }
            return key;
        }
        return null;
    }

    protected static void verifyContainsKey(Region aRegion, Object key, boolean expected) {
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsKey);
        }
    }

    protected static void verifyContainsValueForKey(Region aRegion, Object key, boolean expected) {
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        if (containsValueForKey != expected) {
            throw new TestException("Expected containsValueForKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsValueForKey);
        }
    }

    protected static void verifyMyValue(Region aRegion, Object key, Object expectedValue, Object valueToCheck, int compareStrategy) {
        if (valueToCheck == null) {
            if (expectedValue != null) {
                throw new TestException("For key " + key + ", expected myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
            }
        } else if (valueToCheck instanceof ValueHolder) {
            ValueHolder actualVH = (ValueHolder)valueToCheck;
            if (compareStrategy == EQUAL) {
                if (!actualVH.myValue.equals(expectedValue)) {
                    throw new TestException("For key " + key + ", expected ValueHolder.myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
                }
            } else if (compareStrategy == EQUIVALENT && !actualVH.myValue.toString().equals(expectedValue.toString())) {
                throw new TestException("For key " + key + ", expected ValueHolder.myValue to be " + expectedValue + ", but it is " + actualVH.myValue);
            }
        } else {
            throw new TestException("Expected value for key " + key + " to be an instance of ValueHolder, but it is " + TestHelper.toString(valueToCheck));
        }
    }

    protected static synchronized void closeAndOpenRegion() {
        if (!VersioningTest.testInstance.aRegion.isDestroyed()) {
            Log.getLogWriter().info("Closing region " + VersioningTest.testInstance.aRegion.getFullPath() + " with " + VersioningTest.testInstance.aRegion.keys().size() + " entries");
            VersioningTest.testInstance.aRegion.close();
            testInstance.createRegion();
        } else {
            Log.getLogWriter().info("Not closing region; it has been closed by another thread");
        }
    }

    protected void createRegion() {
        this.aRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        Log.getLogWriter().info("After creating region, region size is " + this.aRegion.keys().size());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        }
        if (this.aRegion.getAttributes().getPoolName() != null) {
            this.aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("registered interest in ALL_KEYS for testRegion");
        }
    }

    static {
        EQUAL = 1;
        EQUIVALENT = 2;
    }

    public static class ValueAndVersion
    implements Serializable {
        public Object value;
        public Object version;

        public ValueAndVersion() {
        }

        public ValueAndVersion(Object value, Object version) {
            this.value = value;
            this.version = version;
        }

        public String toString() {
            return "(value=" + this.value + ", " + this.version + ")";
        }
    }
}

