/*
 * Decompiled with CFR 0.152.
 */
package versioning.newWan;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.util.GatewayConflictHelper;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.cache.util.TimestampedEntryEvent;
import hydra.Log;
import newWan.WANOperationsClientBB;

public class WANConflictResolver
implements GatewayConflictResolver {
    LogWriter log = Log.getLogWriter();
    WANOperationsClientBB bb = WANOperationsClientBB.getBB();

    public void onEvent(TimestampedEntryEvent event, GatewayConflictHelper helper) {
        this.bb.getSharedCounters().increment(WANOperationsClientBB.WanEventResolved);
        this.log.info("WANConflictResolver: existing timestamp=" + event.getOldTimestamp() + " existing value=" + event.getOldValue() + "\n proposed timestamp=" + event.getNewTimestamp() + " proposed value=" + event.getNewValue());
        if (event.getOldTimestamp() > event.getNewTimestamp()) {
            this.log.info("New event is older, disallow the event " + event);
            helper.disallowEvent();
        }
        if (event.getOldTimestamp() == event.getNewTimestamp() && event.getOldDistributedSystemID() > event.getNewDistributedSystemID()) {
            this.log.info("Both event has same timestamp, but new event's ds id small. Thus dissallow the event " + event);
            helper.disallowEvent();
        }
    }
}

