/*
 * Decompiled with CFR 0.152.
 */
package versioning.newWan;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ConfigPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.List;
import java.util.Set;
import newWan.WANOperationsClient;
import newWan.WANOperationsClientBB;
import newWan.WANOperationsClientPrms;
import newWan.WANTest;
import util.PRObserver;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class WanConflictResolverTest
extends WANTest {
    public static WanConflictResolverTest testInstance;
    public static Boolean singleThreadPerVMValidation;
    String ENTRY_OPS_PREFIX = "EntryOps: ";
    int waitSec = TestConfig.tasktab().intAt(WANOperationsClientPrms.waitForSilenceListenerSec, TestConfig.tab().intAt(WANOperationsClientPrms.waitForSilenceListenerSec, 30));

    protected void initialize() {
        opsClient = new WANOperationsClient();
        PRObserver.installObserverHook();
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            regionDescriptNames.add(regionDescriptName);
        }
        WanConflictResolverTest.testInstance.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
    }

    public static synchronized void HydraTask_initServerTask() {
        if (testInstance == null) {
            testInstance = new WanConflictResolverTest();
            testInstance.initialize();
            testInstance.initPeerCache();
            testInstance.initGatewaySender();
            testInstance.initDatastoreRegion();
            testInstance.initGatewayReceiver();
            testInstance.startGatewaySender();
            String bridgeConfig = ConfigPrms.getBridgeConfig();
            if (bridgeConfig != null) {
                BridgeHelper.startBridgeServer(bridgeConfig);
            }
        }
    }

    public static synchronized void HydraTask_initEdgeTask() {
        if (testInstance == null) {
            testInstance = new WanConflictResolverTest();
            testInstance.initialize();
            WanConflictResolverTest.testInstance.isBridgeClient = true;
            testInstance.initEdgeClientCache();
        }
    }

    public static void HydraTask_doOpsKillAndValidateHA() {
        testInstance.doOpsKillAndValidateHA();
    }

    public static void HydraTask_doOpsAndValidateHA() {
        testInstance.doOpsAndValidateHA();
    }

    public static void HydraTask_verifyResolvedEvent() {
        testInstance.verifyResolvedEvents();
    }

    public void doOpsKillAndValidateHA() {
        SharedCounters sc = WANOperationsClientBB.getBB().getSharedCounters();
        int numThreadsForTask = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long cycleCounter = sc.incrementAndRead(WANOperationsClientBB.NumCycle);
        long entryCount = sc.incrementAndRead(WANOperationsClientBB.NumStartedDoingOps);
        logger.info(this.ENTRY_OPS_PREFIX + "Started as leader with entryCount=" + entryCount + " for cycleCounter=" + cycleCounter + ", waiting for others to enter.");
        sc.setIfLarger(WANOperationsClientBB.IsReady, 1L);
        TestHelper.waitForCounter(WANOperationsClientBB.getBB(), "WANOperationsClientBB.NumStartedDoingOps", WANOperationsClientBB.NumStartedDoingOps, numThreadsForTask, true, 500000L);
        logger.info(this.ENTRY_OPS_PREFIX + "All threads have entered in current execution cycle cycleCounter=" + cycleCounter);
        sc.zero(WANOperationsClientBB.IsReady);
        WANOperationsClientBB.getBB().getSharedCounters().zero(WANOperationsClientBB.InvokeEntryOperation);
        Log.getLogWriter().info(this.ENTRY_OPS_PREFIX + "Waiting for Silence Listener for " + this.waitSec + " seconds ...");
        SilenceListener.waitForSilence(this.waitSec, 5000L);
        opsClient.writeRegionSnapshotToBB();
        Log.getLogWriter().info(this.ENTRY_OPS_PREFIX + "Done writing snapshot to BB, cycleCounter=" + cycleCounter);
        sc.setIfLarger(WANOperationsClientBB.InvokeValidation, 1L);
        this.validateEntryOperationFromBBSnapshot();
        long validate = sc.incrementAndRead(WANOperationsClientBB.NumDoneValidation);
        Log.getLogWriter().info(this.ENTRY_OPS_PREFIX + "Done validating snapshot, validateCounter=" + validate + " cycleCounter=" + cycleCounter);
        MasterController.sleepForMs(700);
        TestHelper.waitForCounter(WANOperationsClientBB.getBB(), "WANOperationsClientBB.NumDoneValidation", WANOperationsClientBB.NumDoneValidation, numThreadsForTask, true, 500000L);
        Log.getLogWriter().info(this.ENTRY_OPS_PREFIX + "Done everyone validating the snapshot, cycleCounter=" + cycleCounter);
        WANOperationsClientBB.getBB().getSharedCounters().zero(WANOperationsClientBB.InvokeValidation);
        WANOperationsClientBB.getBB().getSharedCounters().setIfLarger(WANOperationsClientBB.InvokeEntryOperation, 1L);
        Log.getLogWriter().info(this.ENTRY_OPS_PREFIX + "Enabling entry operations, cycleCounter=" + cycleCounter);
        if (WANOperationsClientPrms.enableFailover()) {
            int numVMsToStop = TestConfig.tasktab().intAt(StopStartPrms.numVMsToStop, TestConfig.tab().intAt(StopStartPrms.numVMsToStop));
            if (numVMsToStop <= 0) {
                throw new TestException("doOpsKillAndValidateHA: Not doing anything as number of vm requested to kill is " + numVMsToStop);
            }
            String clientName = WANOperationsClientPrms.getClientNamePrefixForHA();
            if (clientName == null) {
                throw new TestException("newWan.WANOperationsClientPrms-clientNamePrefixForHA can not be null : " + clientName);
            }
            PRObserver.initialize();
            logger.info(this.ENTRY_OPS_PREFIX + "doOpsKillAndValidateHA: Looking for " + numVMsToStop + " vm with client name " + clientName);
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, clientName);
            List vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            List otherVms = (List)tmpArr[2];
            List threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
            this.doEntryOperationAllRegions();
            long numDoneOps = sc.incrementAndRead(WANOperationsClientBB.NumFinishedDoingOps);
            logger.info(this.ENTRY_OPS_PREFIX + "Done entry operation, counter is " + numDoneOps + " in current cycle, cycleCounter=" + cycleCounter);
            for (String stopMode : stopModeList) {
                if (ClientVmMgr.toStopMode(stopMode) != -20) continue;
                sc.increment(WANOperationsClientBB.NumFinishedDoingOps);
            }
            StopStartVMs.joinStopStart(vmList, threads);
            logger.info(this.ENTRY_OPS_PREFIX + "doOpsKillAndValidateHA: done restarting " + vmList);
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                RegionDescription rd;
                DataPolicy policy;
                String regionDescriptName = (String)regionDescriptNames.get(j);
                if (regionDescriptName.startsWith("client") || regionDescriptName.startsWith("accessor") || !(policy = (rd = RegionHelper.getRegionDescription(regionDescriptName)).getDataPolicy()).equals(DataPolicy.PARTITION) && !policy.equals(DataPolicy.PERSISTENT_PARTITION)) continue;
                this.waitForRecovery(vmList, otherVms);
                break;
            }
        } else {
            this.doEntryOperationAllRegions();
            long numDoneOps = sc.incrementAndRead(WANOperationsClientBB.NumFinishedDoingOps);
            logger.info(this.ENTRY_OPS_PREFIX + "Done entry operation, counter is " + numDoneOps + " in current cycle, cycleCounter=" + cycleCounter);
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 600000L;
        boolean doOpsFinishied = false;
        while (!doOpsFinishied) {
            long time;
            block10: {
                try {
                    TestHelper.waitForCounter(WANOperationsClientBB.getBB(), "WANOperationsClientBB.NumFinishedDoingOps", WANOperationsClientBB.NumFinishedDoingOps, numThreadsForTask, false, 30000L);
                    doOpsFinishied = true;
                }
                catch (TestException te) {
                    Boolean isStopEvent = (Boolean)WANOperationsClientBB.getBB().getSharedMap().get(WANOperationsClientBB.IS_TASK_SCHEDULING_STOPPED);
                    if (isStopEvent == null || !isStopEvent.booleanValue()) break block10;
                    doOpsFinishied = true;
                }
            }
            if ((time = System.currentTimeMillis()) < endTime) continue;
            long numfinished = sc.read(WANOperationsClientBB.NumFinishedDoingOps);
            throw new TestException("After waiting for 600000 millis, newWan.WANOperationsClientBB.WANOperationsClientBB.NumFinishedDoingOps has value of " + numfinished + ", but expected it to become " + numThreadsForTask);
        }
        logger.info(this.ENTRY_OPS_PREFIX + "Finished current cycle. Zeroing NumFinishedDoingOps and NumStartedDoingOps. cycleCounter=" + cycleCounter);
        opsClient.checkForTermicationCondition();
        sc.zero(WANOperationsClientBB.NumFinishedDoingOps);
        sc.zero(WANOperationsClientBB.NumStartedDoingOps);
        sc.zero(WANOperationsClientBB.NumDoneValidation);
    }

    public void doOpsAndValidateHA() {
        SharedCounters sc = WANOperationsClientBB.getBB().getSharedCounters();
        long isready = sc.read(WANOperationsClientBB.IsReady);
        if (isready == 0L) {
            logger.info("returning from doOpsAndValidateHA as WANOperationsClientBB.IsReady=0");
            return;
        }
        long cycleCounter = sc.read(WANOperationsClientBB.NumCycle);
        long entryCount = sc.incrementAndRead(WANOperationsClientBB.NumStartedDoingOps);
        logger.info(this.ENTRY_OPS_PREFIX + "Entering with entryCount=" + entryCount + " for cycleCounter=" + cycleCounter);
        TestHelper.waitForCounter(WANOperationsClientBB.getBB(), "WANOperationsClientBB.InvokeValidation", WANOperationsClientBB.InvokeValidation, 1L, true, 600000L, 200L);
        this.validateEntryOperationFromBBSnapshot();
        long validate = sc.incrementAndRead(WANOperationsClientBB.NumDoneValidation);
        Log.getLogWriter().info(this.ENTRY_OPS_PREFIX + "Done validation, counter is " + validate + " in current cycle, cycleCounter=" + cycleCounter);
        TestHelper.waitForCounter(WANOperationsClientBB.getBB(), "WANOperationsClientBB.InvokeEntryOperation", WANOperationsClientBB.InvokeEntryOperation, 1L, true, 500000L);
        this.doEntryOperationAllRegions();
        long numDoneOps = sc.incrementAndRead(WANOperationsClientBB.NumFinishedDoingOps);
        logger.info(this.ENTRY_OPS_PREFIX + "Done entry operation, counter is " + numDoneOps + " in current cycle, cycleCounter=" + cycleCounter);
    }

    public void verifyResolvedEvents() {
        if (WANOperationsClientPrms.getTaskTerminationMethod() == 1) {
            int expectedEventResolved = WANOperationsClientPrms.getTaskTerminatorThreshold();
            long eventResolved = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.WanEventResolved);
            if (eventResolved < (long)expectedEventResolved) {
                throw new TestException("Wan event resolved are " + eventResolved + ", does not reached to expected " + expectedEventResolved);
            }
        }
    }

    protected void validateEntryOperationFromBBSnapshot() {
        if (singleThreadPerVMValidation.booleanValue()) {
            singleThreadPerVMValidation = false;
            Log.getLogWriter().info("validateEntryOperationFromBBSnapshot: Validation started");
            Region aRegion2 = null;
            Set rootRegions = CacheHelper.getCache().rootRegions();
            for (Region aRegion2 : rootRegions) {
                opsClient.verifyRegionContents(aRegion2, opsClient.getBBSnapshot(aRegion2));
            }
            Log.getLogWriter().info("validateDoEntryOperation: Validation complete");
            singleThreadPerVMValidation = true;
        }
    }

    static {
        singleThreadPerVMValidation = new Boolean(true);
    }
}

