/*
 * Decompiled with CFR 0.152.
 */
package vsphere.vijava;

import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionWriterException;
import hydra.Log;
import tx.TxBB;
import tx.TxWriter;
import vsphere.vijava.VIJavaUtil;

public class TxVMotionWriter
extends TxWriter {
    @Override
    public void beforeCommit(TransactionEvent event) throws TransactionWriterException {
        super.beforeCommit(event);
        Boolean bool = (Boolean)TxBB.getBB().getSharedMap().get("vMotionTriggerred");
        if (bool == null || !bool.booleanValue()) {
            try {
                TxBB.getBB().getSharedMap().put("vMotionTriggerred", Boolean.TRUE);
                TxBB.getBB().getSharedMap().put("vMotionTriggerredTime", System.currentTimeMillis());
                Log.getLogWriter().info("Migrating a VM in beforeCommit()");
                VIJavaUtil.doMigrateVM();
            }
            catch (Exception e) {
                Log.getLogWriter().info("Failed migrating a VM in beforeCommit()", (Throwable)e);
            }
        } else {
            long lastTrigger = (Long)TxBB.getBB().getSharedMap().get("vMotionTriggerredTime");
            if (System.currentTimeMillis() - lastTrigger > 300000L) {
                try {
                    TxBB.getBB().getSharedMap().put("vMotionTriggerredTime", System.currentTimeMillis());
                    Log.getLogWriter().info("Migrating a VM in beforeCommit()");
                    VIJavaUtil.doMigrateVM();
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Failed migrating a VM in beforeCommit()", (Throwable)e);
                }
            }
        }
    }
}

