/*
 * Decompiled with CFR 0.152.
 */
package vsphere.vijava;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import parReg.ParRegBB;
import parReg.execute.FunctionServiceTest;
import util.CachePrms;
import util.KeyIntervals;
import util.PRObserver;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import vsphere.vijava.VMotionRegionOperationsFunction;

public class VMotionFunctionServiceTest
extends FunctionServiceTest {
    private static int maxRegions;

    public static synchronized void HydraTask_dataStoreVMInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            isBridgeConfiguration = false;
            testInstance = new VMotionFunctionServiceTest();
            isBridgeClient = false;
            testInstance.initialize("dataStore");
            ((FunctionServiceTest)testInstance).registerFunctions();
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
        }
    }

    public static synchronized void HydraTask_accessorVMInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            isBridgeConfiguration = true;
            testInstance = new VMotionFunctionServiceTest();
            isBridgeClient = false;
            testInstance.initialize();
            ((FunctionServiceTest)testInstance).registerFunctions();
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration && !TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile, false)) {
                BridgeHelper.startBridgeServer("bridge");
                Log.getLogWriter().info("started bridge server on accessor.");
            }
        }
    }

    public static synchronized void HydraTask_HA_clientVMInitialize() {
        if (testInstance == null) {
            isBridgeConfiguration = true;
            isBridgeClient = true;
            testInstance = new VMotionFunctionServiceTest();
            testInstance.initialize();
            ((FunctionServiceTest)testInstance).registerFunctions();
        }
    }

    @Override
    public void initialize() {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            if (regionDescriptName.startsWith("bridge")) {
                bridgeRegionDescriptNames.add(regionDescriptName);
                continue;
            }
            if (regionDescriptName.startsWith("dataStore")) continue;
            regionDescriptNames.add(regionDescriptName);
        }
        if (isBridgeConfiguration && bridgeRegionDescriptNames.size() != regionDescriptNames.size()) {
            throw new TestException("Error in test configuration; need equal number of region descriptions for bridge servers and bridge clients");
        }
        Log.getLogWriter().info("bridgeRegionDescriptNames is " + bridgeRegionDescriptNames);
        Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
        maxRegions = regionDescriptNames.size();
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile, false)) {
            this.createRegionsWithXml();
        } else {
            theCache = CacheHelper.createCache("cache1");
            this.createRegions();
        }
        TestHelper.logRegionHierarchy();
    }

    @Override
    public void initialize(String regionDescription) {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            if (!regionDescriptName.startsWith("dataStore") || !regionDescription.startsWith("dataStore")) continue;
            regionDescriptNames.add(regionDescriptName);
        }
        Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
        maxRegions = regionDescriptNames.size();
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
        if (TestConfig.tab().booleanAt(CachePrms.useDeclarativeXmlFile, false)) {
            this.createRegionsWithXml();
        } else {
            theCache = CacheHelper.createCache("cache1");
            this.createRegions();
        }
    }

    @Override
    public synchronized void queryFunction(Region aRegion, Object key) {
        Execution dataSet;
        VMotionRegionOperationsFunction queryFunction = new VMotionRegionOperationsFunction();
        if (aRegion instanceof PartitionedRegion) {
            Log.getLogWriter().info("Inside p2p function execution");
            dataSet = FunctionService.onRegion((Region)aRegion);
        } else {
            Log.getLogWriter().info("Inside client server function execution");
            dataSet = FunctionService.onRegion((Region)aRegion);
        }
        HashSet<Object> keySet = new HashSet<Object>();
        keySet.add(key);
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add("query");
        aList.add(RemoteTestModule.getCurrentThread().getThreadId());
        Log.getLogWriter().info("Going to do query execute");
        ResultCollector drc = dataSet.withFilter(keySet).withArgs(aList).execute(queryFunction.getId());
        drc.getResult();
    }
}

