/*
 * Decompiled with CFR 0.152.
 */
package vsphere.vijava;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.Log;
import java.util.ArrayList;
import vsphere.vijava.VIJavaUtil;

public class VMotionPRObserver
extends InternalResourceManager.ResourceObserverAdapter {
    private static int numTimesBucketMoved = 0;
    private static int numTimesVMotionTriggerred = 0;
    private static ArrayList<Thread> threads = new ArrayList();

    public synchronized void movingBucket(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        if (++numTimesBucketMoved == 1) {
            Log.getLogWriter().info("Triggerring vMotion from movePrimary()");
            final String vmName = target.getHost().substring(0, target.getHost().indexOf("."));
            Thread task = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        VIJavaUtil.migrateVMToTargetHost(vmName);
                        ++numTimesVMotionTriggerred;
                    }
                    catch (Exception e) {
                        Log.getLogWriter().warning("Error while migrating vm during PR rebalancing", (Throwable)e);
                    }
                }
            });
            threads.add(task);
            task.start();
        }
    }

    public synchronized void movingPrimary(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        if (++numTimesBucketMoved == 1) {
            Log.getLogWriter().info("Triggerring vMotion from movingPrimary()");
            final String vmName = target.getHost().substring(0, target.getHost().indexOf("."));
            Thread task = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        VIJavaUtil.migrateVMToTargetHost(vmName);
                        ++numTimesVMotionTriggerred;
                    }
                    catch (Exception e) {
                        Log.getLogWriter().warning("Error while migrating vm during PR rebalancing", (Throwable)e);
                    }
                }
            });
            threads.add(task);
            task.start();
        }
    }

    public synchronized void rebalancingOrRecoveryFinished(Region region) {
        VMotionPRObserver.waitForAllVMotionThreadsToComplete();
        Log.getLogWriter().info("Done waiting for vMotion thread to join.");
    }

    public static void waitForAllVMotionThreadsToComplete() {
        try {
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                thread.join(200000L);
            }
            threads.clear();
        }
        catch (InterruptedException ie) {
            Log.getLogWriter().warning("Error while waiting for thread to complete vMotion", (Throwable)ie);
        }
    }
}

