/*
 * Decompiled with CFR 0.152.
 */
package wan;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import cq.CQUtil;
import cq.CQUtilBB;
import diskReg.DiskRegUtil;
import durableClients.DurableClientsBB;
import getInitialImage.InitImagePrms;
import hct.BBoard;
import hct.HctPrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.DistributedSystemHelper;
import hydra.EdgeHelper;
import hydra.GatewayHubHelper;
import hydra.GsRandom;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import objects.ObjectHelper;
import objects.PSTObject;
import pdx.PdxTest;
import security.SecurityClientsPrms;
import util.BaseValueHolder;
import util.NameFactory;
import util.RandomValues;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import wan.CacheClientPrms;
import wan.CacheServerPrms;
import wan.WANBlackboard;
import wan.WANClientVersionHelper;
import wan.ml.GemFireQuoteFeeder;
import wan.ml.GemFireTradeBurstFeeder;
import wan.ml.GemFireTradeFeeder;
import wan.ml.MLPrms;

public class WANClient {
    protected static final String REGION_NAME = NameFactory.REGION_NAME_PREFIX + "GlobalVillage";
    protected static final String TRADES_REGION_NAME = NameFactory.REGION_NAME_PREFIX + "TRADES";
    protected static final String QUOTES_REGION_NAME = NameFactory.REGION_NAME_PREFIX + "QUOTES";
    protected static final int ITERATIONS = CacheClientPrms.getIterations();
    public static boolean serverAlive = true;
    static ConfigHashtable conftab = TestConfig.tab();
    static LogWriter logger = Log.getLogWriter();
    static GsRandom rand = new GsRandom();
    static RandomValues rv = new RandomValues();
    static boolean validPrefix = false;
    static boolean invalidPrefix = false;
    static ArrayList keyList = new ArrayList();
    public static long lastEventReceivedTime = 0L;
    protected static boolean killing = false;
    protected static Lock workLock = new Lock();

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static void initPeerCacheTask() {
        String cacheConfig = TestConfig.tasktab().stringAt(CacheClientPrms.cacheConfig, conftab.stringAt(CacheClientPrms.cacheConfig, null));
        String regionConfig = TestConfig.tasktab().stringAt(CacheClientPrms.regionConfig, conftab.stringAt(CacheClientPrms.regionConfig, null));
        WANClient client = new WANClient();
        client.createCache(cacheConfig);
        client.createRegion(REGION_NAME, regionConfig);
        client.createGatewayHub();
        WANClient.initPdxDiskStore();
    }

    public static void initSecurityPeerCacheTask() {
        boolean expectedFail = SecurityClientsPrms.isExpectedException();
        try {
            String cacheConfig = TestConfig.tasktab().stringAt(CacheClientPrms.cacheConfig, conftab.stringAt(CacheClientPrms.cacheConfig, null));
            String regionConfig = TestConfig.tasktab().stringAt(CacheClientPrms.regionConfig, conftab.stringAt(CacheClientPrms.regionConfig, null));
            WANClient client = new WANClient();
            client.createCache(cacheConfig);
            client.createRegion(REGION_NAME, regionConfig);
            if (expectedFail) {
                throw new TestException("Expected this to throw AuthFailException");
            }
        }
        catch (AuthenticationFailedException e) {
            if (expectedFail) {
                Log.getLogWriter().info("Got expected AuthenticationFailedException: " + e.getMessage());
            }
            throw new TestException("AuthenticationFailedException while openCacheTask :" + e.getMessage());
        }
        catch (Exception e) {
            throw new TestException("Exception while openCacheTask :" + e.getMessage());
        }
    }

    public static void initServerCacheTask() {
        String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, conftab.stringAt(CacheServerPrms.cacheConfig, null));
        String regionConfig = TestConfig.tasktab().stringAt(CacheServerPrms.regionConfig, conftab.stringAt(CacheServerPrms.regionConfig, null));
        String bridgeConfig = TestConfig.tasktab().stringAt(CacheServerPrms.bridgeConfig, conftab.stringAt(CacheServerPrms.bridgeConfig, null));
        WANClient client = new WANClient();
        client.createCache(cacheConfig);
        client.createRegion(REGION_NAME, regionConfig);
        WANClient.initPdxDiskStore();
        client.startBridgeServer(bridgeConfig);
        client.createGatewayHub();
    }

    public static void initSecurityServerCacheTask() {
        boolean expectedFail = SecurityClientsPrms.isExpectedException();
        try {
            String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, conftab.stringAt(CacheServerPrms.cacheConfig, null));
            String regionConfig = TestConfig.tasktab().stringAt(CacheServerPrms.regionConfig, conftab.stringAt(CacheServerPrms.regionConfig, null));
            String bridgeConfig = TestConfig.tasktab().stringAt(CacheServerPrms.bridgeConfig, conftab.stringAt(CacheServerPrms.bridgeConfig, null));
            WANClient client = new WANClient();
            client.createCache(cacheConfig);
            client.createRegion(REGION_NAME, regionConfig);
            client.startBridgeServer(bridgeConfig);
            if (expectedFail) {
                throw new TestException("Expected this to throw AuthFailException");
            }
        }
        catch (AuthenticationFailedException e) {
            if (expectedFail) {
                Log.getLogWriter().info("Got expected AuthenticationFailedException: " + e.getMessage());
            }
            throw new TestException("AuthenticationFailedException while openCacheTask :" + e.getMessage());
        }
        catch (Exception e) {
            throw new TestException("Exception while openCacheTask :" + e.getMessage());
        }
    }

    public static void initMLServerCacheTask() {
        String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, conftab.stringAt(CacheServerPrms.cacheConfig, null));
        String regionConfig = TestConfig.tasktab().stringAt(CacheServerPrms.regionConfig, conftab.stringAt(CacheServerPrms.regionConfig, null));
        String bridgeConfig = TestConfig.tasktab().stringAt(CacheServerPrms.bridgeConfig, conftab.stringAt(CacheServerPrms.bridgeConfig, null));
        WANClient client = new WANClient();
        client.createCache(cacheConfig);
        client.createRegion(TRADES_REGION_NAME, regionConfig);
        client.createRegion(QUOTES_REGION_NAME, regionConfig);
        client.startBridgeServer(bridgeConfig);
        client.createGatewayHub();
    }

    public static void startGatewayHubTask() {
        String gatewayConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayConfig, conftab.stringAt(CacheServerPrms.gatewayConfig, null));
        WANClient client = new WANClient();
        client.startGatewayHub(gatewayConfig);
        client.startQueueMonitor();
    }

    public static void createAndStartGatewayHubTask() {
        boolean expectedFail = SecurityClientsPrms.isExpectedException();
        Log.getLogWriter().info("isExpectedException " + expectedFail);
        try {
            String gatewayConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayConfig, conftab.stringAt(CacheServerPrms.gatewayConfig, null));
            WANClient client = new WANClient();
            client.createGatewayHub();
            MasterController.sleepForMs(30000);
            client.startGatewayHub(gatewayConfig);
            client.startQueueMonitor();
            if (expectedFail) {
                throw new TestException("Expected this to throw AuthFailException");
            }
        }
        catch (AuthenticationFailedException e) {
            if (expectedFail) {
                Log.getLogWriter().info("Got expected AuthenticationFailedException: " + e.getMessage());
            }
            throw new TestException("AuthenticationFailedException while openCacheTask :" + e.getMessage());
        }
    }

    public static void initEdgeClientCacheTask() {
        String cacheConfig = conftab.stringAt(CacheClientPrms.cacheConfig);
        String regionConfig = conftab.stringAt(CacheClientPrms.regionConfig);
        WANClient client = new WANClient();
        Cache cache = client.createCache(cacheConfig);
        Region region = client.createRegion(REGION_NAME, regionConfig);
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
            if (!DurableClientsBB.getBB().getSharedMap().containsKey(VmDurableId)) {
                HashMap map = new HashMap();
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            }
            cache.readyForEvents();
        }
        PoolImpl mybw = ClientHelper.getPool(region);
        ServerLocation primaryEndpoint = mybw.getPrimary();
        Log.getLogWriter().info("The primary server endpoint is " + primaryEndpoint);
        client.registerInterest(region);
    }

    public static void initCQClientTask() {
        String cacheConfig = conftab.stringAt(CacheClientPrms.cacheConfig);
        String regionConfig = conftab.stringAt(CacheClientPrms.regionConfig);
        WANClient client = new WANClient();
        client.createCache(cacheConfig);
        Region region = client.createRegion(REGION_NAME, regionConfig);
        CQUtil.initialize();
        CQUtil.initializeCQService();
        CQUtil.registerCQ(region);
    }

    public static void initMLEdgeClientCacheTask() {
        String cacheConfig = conftab.stringAt(CacheClientPrms.cacheConfig);
        String regionConfig = conftab.stringAt(CacheClientPrms.regionConfig);
        WANClient client = new WANClient();
        client.createCache(cacheConfig);
        Region tradesRegion = client.createRegion(TRADES_REGION_NAME, regionConfig);
        client.registerInterest(tradesRegion);
        Region quotesRegion = client.createRegion(QUOTES_REGION_NAME, regionConfig);
        client.registerInterest(quotesRegion);
    }

    protected Cache createCache(String cacheConfig) {
        return CacheHelper.createCache(cacheConfig);
    }

    protected Region createRegion(String regionName, String regionConfig) {
        return RegionHelper.createRegion(regionName, regionConfig);
    }

    private void registerInterest(Region region) {
        InterestResultPolicy interestPolicy = CacheClientPrms.getInterestPolicy();
        LocalRegion localRegion = (LocalRegion)region;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            Log.getLogWriter().info("Doing durable register interest");
            localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy, true);
        } else {
            localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy);
        }
        Log.getLogWriter().info("Initialized region " + region + "\nRegistered interest in ALL_KEYS with InterestResultPolicy = " + interestPolicy);
    }

    protected CacheServer startBridgeServer(String bridgeConfig) {
        return BridgeHelper.startBridgeServer(bridgeConfig);
    }

    protected void startQueueMonitor() {
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        String key = "EVENT_QUEUE_SIZE: for vm_" + RemoteTestModule.getMyVmid();
        Log.getLogWriter().info("Started event queue monitor with key: " + key);
        SharedMap bb = WANBlackboard.getInstance().getSharedMap();
        Thread queueMonitor = new Thread(new Runnable((StatisticsFactory)statFactory, bb, key){
            final /* synthetic */ StatisticsFactory val$statFactory;
            final /* synthetic */ SharedMap val$bb;
            final /* synthetic */ String val$key;
            {
                this.val$statFactory = statisticsFactory;
                this.val$bb = sharedMap;
                this.val$key = string;
            }

            @Override
            public void run() {
                Statistics[] gStats = this.val$statFactory.findStatisticsByType(this.val$statFactory.findType("GatewayStatistics"));
                boolean running = true;
                long lastQSize = -1L;
                while (serverAlive) {
                    SystemFailure.checkFailure();
                    long qSize = 0L;
                    for (int i = 0; i < gStats.length; ++i) {
                        long gQSize = gStats[i].getInt(GatewayStats.getEventQueueSizeId());
                        qSize += gQSize;
                    }
                    try {
                        this.val$bb.put(this.val$key, new Long(qSize));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!serverAlive) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            protected void finalize() throws Throwable {
                Object o = this.val$bb.remove(this.val$key);
                logger.severe("REMOVING BBKEY2[" + this.val$key + "] value was:" + o);
                super.finalize();
            }
        }, "Gateway Queue Monitor");
        queueMonitor.setDaemon(true);
        queueMonitor.start();
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayHubConfig, conftab.stringAt(CacheServerPrms.gatewayHubConfig, null));
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    protected void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    public static void putTask() {
        PdxTest.initClassLoader();
        WANClient.startNoKillZone();
        WANClient client = new WANClient();
        client.put();
        WANClient.endNoKillZone();
    }

    private void put() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        int tid = RemoteTestModule.getCurrentThread().getThreadGroupId();
        Integer key = new Integer(tid);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        String objectType = CacheClientPrms.getObjectType();
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            Object value = null;
            if (objectType == null) {
                value = new Integer(i);
            } else if (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder")) {
                value = PdxTest.getVersionedValueHolder(objectType, new Integer(i), rv);
            } else {
                throw new TestException("Unknown objectType: " + objectType);
            }
            WANClientVersionHelper.updateEntry(region, key, value);
        }
        WANBlackboard.getInstance().getSharedCounters().setIfLarger(WANBlackboard.MaxKeys, tid + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSequentialKeysUsingPutAllTask() throws Exception {
        try {
            WANClient.startNoKillZone();
            Region region = RegionHelper.getRegion(REGION_NAME);
            int batchSize = CacheClientPrms.getBatchSize();
            for (int i = 0; i < batchSize; i += WANClient.createSequentialKeyUsingPutAll(region)) {
            }
        }
        finally {
            WANClient.endNoKillZone();
        }
    }

    private static int createSequentialKeyUsingPutAll(Region region) throws Exception {
        int numEntries = CacheClientPrms.getNumEntries();
        int mapSize = CacheClientPrms.getNumPutAllEntries();
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("PutAll with map size of " + mapSize);
        }
        long ec = -1L;
        SharedCounters sc = WANBlackboard.getInstance().getSharedCounters();
        int wanSite = EdgeHelper.toWanSite(RemoteTestModule.getMyClientName());
        switch (wanSite) {
            case 1: {
                ec = sc.add(WANBlackboard.currentEntry1, mapSize);
                break;
            }
            case 2: {
                ec = sc.add(WANBlackboard.currentEntry2, mapSize);
                break;
            }
            case 3: {
                ec = sc.add(WANBlackboard.currentEntry3, mapSize);
                break;
            }
            case 4: {
                ec = sc.add(WANBlackboard.currentEntry4, mapSize);
                break;
            }
            case 5: {
                ec = sc.add(WANBlackboard.currentEntry5, mapSize);
                break;
            }
            case 6: {
                ec = sc.add(WANBlackboard.currentEntry6, mapSize);
                break;
            }
            default: {
                String s = "Too many WAN sites: " + wanSite;
                throw new UnsupportedOperationException(s);
            }
        }
        int entryCounter = (int)ec;
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        String objectType = CacheClientPrms.getObjectType();
        for (int i = entryCounter - mapSize + 1; i <= entryCounter; ++i) {
            if (i > numEntries) {
                String s = "Created at least " + numEntries + " entries";
                throw new StopSchedulingTaskOnClientOrder(s);
            }
            Object val = null;
            val = objectType == null ? Integer.valueOf(i) : ObjectHelper.createObject(objectType, i);
            String key = String.valueOf(i);
            aMap.put(key, val);
        }
        region.putAll(aMap);
        return aMap.size();
    }

    public static void putSequentialKeysWithDrainTask() throws Exception {
        WANClient.putSequentialKeysTask();
        WANClient.waitForQueuesToDrain();
    }

    public static void putSequentialKeysTask() throws Exception {
        WANClient client = new WANClient();
        WANClientVersionHelper.putSequentialKeysTask(client);
    }

    public static void putSequentialKeyUsingPutAll(Region region, int sleepMs) throws Exception {
        int minMapSize = 1;
        int maxMapSize = 5;
        boolean useTransactions = InitImagePrms.useTransactions();
        if (useTransactions) {
            maxMapSize = 1;
        }
        int mapSize = rand.nextInt(maxMapSize - minMapSize) + minMapSize;
        Log.getLogWriter().info("PutAll with the map size of " + mapSize);
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        long entryCounter = WANBlackboard.getInstance().getSharedCounters().add(WANBlackboard.currentEntry, mapSize);
        String objectType = CacheClientPrms.getObjectType();
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            for (long j = entryCounter - (long)mapSize + 1L; j <= entryCounter; ++j) {
                String key = "" + j;
                if (objectType != null && (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder"))) {
                    BaseValueHolder vh = PdxTest.getVersionedValueHolder(objectType, new Integer(i), rv);
                    aMap.put(key, vh);
                    continue;
                }
                aMap.put(key, new Integer(i));
            }
            region.putAll(aMap);
        }
    }

    public static void putSequentialKeysTaskForValid() throws Exception {
        WANClient.startNoKillZone();
        Region region = RegionHelper.getRegion(REGION_NAME);
        String key = "valid_" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_valid);
        Log.getLogWriter().info("The vm will be operating on the key : " + key);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            WANClientVersionHelper.updateEntry(region, key, new Integer(i));
        }
        WANClient.endNoKillZone();
    }

    public static void putSequentialKeysTaskForInValid() throws Exception {
        WANClient.startNoKillZone();
        Region region = RegionHelper.getRegion(REGION_NAME);
        String key = "invalid_" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_invalid);
        Log.getLogWriter().info("The vm will be operating on the key : " + key);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            WANClientVersionHelper.updateEntry(region, key, new Integer(i));
        }
        WANClient.endNoKillZone();
    }

    public static void putSequentialKeysTaskForReader() throws Exception {
        WANClient.startNoKillZone();
        Region region = RegionHelper.getRegion(REGION_NAME);
        String key = "reader_" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_reader);
        Log.getLogWriter().info("The vm will be operating on the key : " + key);
        keyList.add(key);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            WANClientVersionHelper.updateEntry(region, key, new Integer(i));
        }
        WANClient.endNoKillZone();
    }

    public static void putSequentialKeysTaskForWriter() throws Exception {
        WANClient.startNoKillZone();
        Region region = RegionHelper.getRegion(REGION_NAME);
        String key = "writer_" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_writer);
        Log.getLogWriter().info("The vm will be operating on the key : " + key);
        keyList.add(key);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            WANClientVersionHelper.updateEntry(region, key, new Integer(i));
        }
        WANClient.endNoKillZone();
    }

    private static BridgeHelper.Endpoint getEndpoint(ServerLocation location) {
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        InetSocketAddress ia = null;
        for (BridgeHelper.Endpoint next : endpoints) {
            if (next.getPort() != location.getPort()) continue;
            if (next.getHost().equals(location.getHostName())) {
                return next;
            }
            try {
                ia = new InetSocketAddress(location.getHostName(), location.getPort());
                if (!ia.getAddress().getHostAddress().equals(next.getAddress())) continue;
                return next;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void clientPutSequentialKeysTask() throws Exception {
        Region region = RegionHelper.getRegion(REGION_NAME);
        PoolImpl mybw = ClientHelper.getPool(region);
        ServerLocation primary = mybw.getPrimary();
        if (primary == null) {
            throw new InternalGemFireException("Primary is null" + primary);
        }
        BridgeHelper.Endpoint primaryEndpoint = WANClient.getEndpoint(primary);
        if (primaryEndpoint == null) {
            throw new InternalGemFireException("Unable to find endpoint for primary " + primary);
        }
        Log.getLogWriter().info("Primary name is " + primaryEndpoint.getName());
        if (primaryEndpoint.getName().indexOf("_validbridge_") != -1) {
            WANClient.putSequentialKeysTaskForValid();
        } else if (primaryEndpoint.getName().indexOf("_invalidbridge_") != -1) {
            WANClient.putSequentialKeysTaskForInValid();
        }
    }

    public static void putSequentialKeysWithBytesTask() throws Exception {
        WANClient.startNoKillZone();
        Region region = RegionHelper.getRegion(REGION_NAME);
        String key = "" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            WANClientVersionHelper.updateEntry(region, key, new byte[i]);
        }
        WANClient.endNoKillZone();
    }

    public static void populateRegionTask() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        int numEntries = CacheClientPrms.getNumEntries();
        for (int i = 0; i < numEntries; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                region.put((Object)key, (Object)new Long(NameFactory.getCounterForName(key)));
                continue;
            }
            region.putIfAbsent((Object)key, (Object)new Long(NameFactory.getCounterForName(key)));
        }
        Log.getLogWriter().info("populated cache with " + NameFactory.getPositiveNameCounter() + " keys");
        MasterController.sleepForMs(60000);
    }

    public static void destroyRandomEntriesTask() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        Set aSet = region.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("destroyRandomEntryTask: No keys in region");
            return;
        }
        int numEntries = CacheClientPrms.getNumEntries();
        for (int i = 0; i < numEntries; ++i) {
            aSet = region.keys();
            if (aSet.size() == 0) {
                Log.getLogWriter().info("destroyRandomEntriesTask: No keys remain to destroy");
                return;
            }
            Object[] keyList = aSet.toArray();
            int index = rand.nextInt(aSet.size() - 1);
            Log.getLogWriter().info("Number of keys in region = " + aSet.size());
            try {
                Object key = keyList[index];
                Log.getLogWriter().info("Destroying key " + key + " from region " + region.getName());
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    region.destroy(key);
                } else {
                    boolean removed = region.remove(key, region.get(key));
                    if (!removed) {
                        region.destroy(key);
                    }
                }
                Log.getLogWriter().info("Done destroying key " + key + " from region " + region.getName());
                continue;
            }
            catch (Exception e) {
                throw new TestException("destroyRandomEntryTask throws " + e + " " + TestHelper.getStackTrace(e));
            }
        }
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        MasterController.sleepForMs(sleepMs);
    }

    public static void updateEntries() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        Set aSet = region.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("updateEntries: No keys in region");
            return;
        }
        Object[] keyList = aSet.toArray();
        int index = rand.nextInt(aSet.size() - 1);
        Log.getLogWriter().info("Number of keys in region = " + aSet.size());
        try {
            Object key = keyList[index];
            Log.getLogWriter().info("Updating " + key + " in region " + region.getName());
            Long val = (Long)region.get(key);
            WANClientVersionHelper.updateEntry(region, key, new Long(val.intValue() + 1));
            Log.getLogWriter().info("Done updating key " + key + " in region " + region.getName());
        }
        catch (Exception e) {
            throw new TestException("updateEntries throws " + e + " " + TestHelper.getStackTrace(e));
        }
    }

    public static void tradeFeederTask() {
        int tradeStartId;
        int tid = RemoteTestModule.getCurrentThread().getThreadGroupId();
        int tradesToProcess = MLPrms.getTradesToProcess();
        int tradeFileStartLine = tradeStartId = tradesToProcess * tid + 1;
        int tradeFileEndLine = (tid + 1) * tradesToProcess;
        System.out.println("Starting trade feeder");
        System.out.println("tradesToProcess: " + MLPrms.getTradesToProcess());
        System.out.println("tradeStartId: " + tradeStartId);
        System.out.println("tradeFileStartLine: " + tradeFileStartLine);
        System.out.println("tradeFileEndLine: " + tradeFileEndLine);
        String tradeStartIdStr = String.valueOf(tradeStartId);
        String tradeFileStartLineStr = String.valueOf(tradeFileStartLine);
        String tradeFileEndLineStr = String.valueOf(tradeFileEndLine);
        String tradesPerSecondStr = String.valueOf(MLPrms.getTradesPerSecond());
        String tradeFile = MLPrms.getTradesDataFile();
        GemFireTradeFeeder.main(new String[]{tradeStartIdStr, tradeFileStartLineStr, tradeFileEndLineStr, tradesPerSecondStr, tradeFile});
    }

    public static void tradeBurstFeederTask() {
        int tradeStartId;
        int tradeFeeders = 5;
        int tradesToProcess = MLPrms.getTradesToProcess();
        int tradeFileStartLine = tradeStartId = tradesToProcess * tradeFeeders + 1;
        int tradeFileEndLine = tradeStartId + 5000;
        System.out.println("Starting trade burst feeder");
        System.out.println("tradesToProcess: " + MLPrms.getTradesToProcess());
        System.out.println("tradeStartId: " + tradeStartId);
        System.out.println("tradeFileStartLine: " + tradeFileStartLine);
        System.out.println("tradeFileEndLine: " + tradeFileEndLine);
        String tradeStartIdStr = String.valueOf(tradeStartId);
        String tradeFileStartLineStr = String.valueOf(tradeFileStartLine);
        String tradeFileEndLineStr = String.valueOf(tradeFileEndLine);
        String burstTradesPerSecondStr = String.valueOf(MLPrms.getBurstTradesPerSecond());
        String burstSleepIntervalStr = String.valueOf(MLPrms.getBurstSleepInterval());
        String burstTimeStr = String.valueOf(MLPrms.getBurstTime());
        String tradeFile = MLPrms.getTradesDataFile();
        GemFireTradeBurstFeeder.main(new String[]{tradeStartIdStr, tradeFileStartLineStr, tradeFileEndLineStr, burstTradesPerSecondStr, tradeFile, burstSleepIntervalStr, burstTimeStr});
    }

    public static void quoteFeederTask() {
        String quotesToProcessStr = String.valueOf(MLPrms.getQuotesToProcess());
        String quotesPerSecondStr = String.valueOf(MLPrms.getQuotesPerSecond());
        String quoteFile = MLPrms.getQuotesDataFile();
        GemFireQuoteFeeder.main(new String[]{quotesToProcessStr, quotesPerSecondStr, quoteFile});
    }

    public static void printMLTask() {
        MasterController.sleepForMs(5000);
        WANClient client = new WANClient();
        client.print(TRADES_REGION_NAME);
        client.print(QUOTES_REGION_NAME);
    }

    public static void printTask() {
        PdxTest.initClassLoader();
        MasterController.sleepForMs(5000);
        WANClient client = new WANClient();
        client.print(REGION_NAME);
    }

    protected void print(String regionName) {
        long size = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.MaxKeys);
        StringBuffer buffer = new StringBuffer();
        Region region = RegionHelper.getRegion(regionName);
        buffer.append("Contents of region");
        buffer.append(region.getFullPath());
        buffer.append(":");
        int i = 0;
        while ((long)i < size) {
            Integer key = new Integer(i);
            Object val = DiskRegUtil.getValueInVM(region, key);
            if (region.getAttributes().getPartitionAttributes() != null) {
                val = region.get((Object)key);
            }
            if (val != null) {
                buffer.append("\n\tENTRY ");
                buffer.append(key);
                buffer.append(":");
                buffer.append(val);
            }
            ++i;
        }
        Log.getLogWriter().info(buffer.toString());
    }

    public static void printSequentialKeysTask() throws Exception {
        PdxTest.initClassLoader();
        long size = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.MaxKeys);
        Region region = RegionHelper.getRegion(REGION_NAME);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Contents of region");
        buffer.append(region.getFullPath());
        buffer.append(":");
        Set keys = region.keys();
        for (Object key : keys) {
            Object val = DiskRegUtil.getValueInVM(region, key);
            if (val == null) continue;
            buffer.append("\n\tENTRY ");
            buffer.append(key);
            buffer.append(":");
            buffer.append(val);
        }
        Log.getLogWriter().info(buffer.toString());
    }

    public static void printKeyListTask() {
        Iterator Itr2 = keyList.iterator();
        while (Itr2.hasNext()) {
            Log.getLogWriter().info((String)Itr2.next());
        }
    }

    public static void validateTask() throws Exception {
        PdxTest.initClassLoader();
        WANClient client = new WANClient();
        int minutesToWait = 5;
        for (int i = 1; i <= minutesToWait; ++i) {
            try {
                Thread.interrupted();
                MasterController.sleepForMs(60000);
                client.validate(REGION_NAME);
                return;
            }
            catch (TestException e) {
                if (e.getMessage().startsWith("Wrong value")) {
                    if (i == minutesToWait) {
                        throw e;
                    }
                } else {
                    throw e;
                }
                logger.info("Giving gateway queues more time to drain: " + e.getMessage());
                continue;
            }
        }
    }

    public static void validateMLTask() throws Exception {
        WANClient client = new WANClient();
        client.validate(TRADES_REGION_NAME);
        client.validate(QUOTES_REGION_NAME);
    }

    public static synchronized void closeEdgeClientCacheTask() {
        Region region;
        Cache cache = CacheHelper.getCache();
        if (cache != null && (region = RegionHelper.getRegion(REGION_NAME)) != null) {
            Set keySet = region.keys();
            int numEntries = keySet.size();
            Log.getLogWriter().info("Client's region " + REGION_NAME + " contains " + numEntries + " entries");
            if (region.getAttributes().getPartitionAttributes() == null) {
                CacheHelper.closeCache();
            }
        }
    }

    public static void HydraCloseTask_regionSizeToBB() {
        String clientName = System.getProperty("clientName");
        Cache cache = CacheHelper.getCache();
        if (cache != null) {
            Region region = RegionHelper.getRegion(REGION_NAME);
            Set myKeys = region.keys();
            Log.getLogWriter().info("Region " + region.getName() + " contains " + myKeys.size() + " entries");
            String mapKey = clientName + "_" + WANBlackboard.REGION_SIZE;
            WANBlackboard.getInstance().getSharedMap().put(mapKey, new Integer(myKeys.size()));
            CacheHelper.closeCache();
        }
    }

    public static void HydraEndTask_regionSizesEqual() {
        Integer targetRegionSize = null;
        HydraVector clientsToCompare = TestConfig.tab().vecAt(CacheClientPrms.clientsToCompare);
        for (int i = 0; i < clientsToCompare.size(); ++i) {
            String clientName = (String)clientsToCompare.elementAt(i);
            String mapKey = clientName + "_" + WANBlackboard.REGION_SIZE;
            Integer regionSize = (Integer)WANBlackboard.getInstance().getSharedMap().get(mapKey);
            Log.getLogWriter().info("RegionSize for " + clientName + " = " + regionSize);
            if (i == 0) {
                targetRegionSize = regionSize;
                continue;
            }
            if (regionSize.equals(targetRegionSize)) continue;
            throw new TestException("Expected regionSize " + targetRegionSize + " but " + clientName + " has a region size of " + regionSize);
        }
    }

    public static void updateBBandCloseServerCacheTask() throws Exception {
        if (CacheHelper.getCache() == null) {
            return;
        }
        long serverNumber = WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.bridgeCloserNumber);
        Log.getLogWriter().info("BridgeCloserNumber " + serverNumber + ": Updating BB and Closing server cache");
        Region region = RegionHelper.getRegion(REGION_NAME);
        Set myKeys = region.keys();
        ArrayList aList = new ArrayList(myKeys);
        Log.getLogWriter().info("Region " + region.getName() + " contains " + myKeys.size() + " entries");
        SharedMap map = WANBlackboard.getInstance().getSharedMap();
        SharedCounters sc = WANBlackboard.getInstance().getSharedCounters();
        if (serverNumber == 1L) {
            map.put(WANBlackboard.REGION_SIZE, new Integer(myKeys.size()));
            map.put(WANBlackboard.KEY_LIST, aList);
            sc.increment(WANBlackboard.keyListReady);
        } else {
            while (sc.read(WANBlackboard.keyListReady) != 1L) {
                MasterController.sleepForMs(250);
            }
            Integer expectedRegionSize = (Integer)map.get(WANBlackboard.REGION_SIZE);
            if (myKeys.size() != expectedRegionSize.intValue()) {
                List expectedKeySet = (List)map.get(WANBlackboard.KEY_LIST);
                throw new TestException("Expected " + expectedRegionSize + " keys, but found " + myKeys.size() + " entries");
            }
            List expectedKeys = (List)map.get(WANBlackboard.KEY_LIST);
            if (!myKeys.containsAll(expectedKeys)) {
                for (Object key : myKeys) {
                    if (expectedKeys.contains(key)) continue;
                    Log.getLogWriter().info("myKeys = " + myKeys.toString());
                    Log.getLogWriter().info("expectedKeys = " + expectedKeys.toString());
                    throw new TestException("This VM's region contains the key " + key + " but it was not in the keyList from server publishing to the BB");
                }
            }
            if (!expectedKeys.containsAll(myKeys)) {
                for (Object key : expectedKeys) {
                    if (myKeys.contains(key)) continue;
                    Log.getLogWriter().info("myKeys = " + myKeys.toString());
                    Log.getLogWriter().info("expectedKeys = " + expectedKeys.toString());
                    throw new TestException("The server publishing to the BB has key " + key + " but it was not in the keyList for this VM's region");
                }
            }
        }
        WANBlackboard.getInstance().printSharedMap();
        WANClient client = new WANClient();
        client.print(REGION_NAME);
        client.closeCache();
    }

    public static void closePeerCacheTask() throws Exception {
        WANClient.closeEdgeClientCacheTask();
    }

    public static void closePeerCacheRandomKeysTask() throws Exception {
        WANClient client = new WANClient();
        client.closeCache();
    }

    public static void closeServerCacheTask() throws Exception {
        Log.getLogWriter().info("Closing server cache");
        WANClient client = new WANClient();
        client.print(REGION_NAME);
        client.validate(REGION_NAME);
        client.closeCache();
    }

    public static void closeMLServerCacheTask() throws Exception {
        MasterController.sleepForMs(30000);
        Log.getLogWriter().info("Closing server cache");
        WANClient client = new WANClient();
        client.print(TRADES_REGION_NAME);
        client.print(QUOTES_REGION_NAME);
        client.validate(TRADES_REGION_NAME);
        client.validate(QUOTES_REGION_NAME);
        client.closeCache();
    }

    public static void closeServerCacheRandomKeysTask() throws Exception {
        WANClient.printSequentialKeysTask();
        Log.getLogWriter().info("Closing server cache");
        WANClient.validateSequentialKeysTask();
        WANClient client = new WANClient();
        client.closeCache();
    }

    private void validate(String regionName) throws CacheException {
        long size = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.MaxKeys);
        Log.getLogWriter().info("Validating cache, maxKeys = " + size);
        Region region = RegionHelper.getRegion(regionName);
        if (region == null) {
            throw new TestException("Region " + regionName + " is null, perhaps cache is closed");
        }
        int i = 0;
        while ((long)i < size) {
            Integer key = new Integer(i);
            Object val = region.get((Object)key);
            if (val == null) {
                String s = "No value in cache at " + key;
                throw new TestException(s);
            }
            if (val instanceof Integer) {
                int ival = (Integer)val;
                if (ival != ITERATIONS) {
                    String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + ival;
                    throw new TestException(s);
                }
            } else if (val instanceof BaseValueHolder || val instanceof PdxInstance) {
                val = PdxTest.toValueHolder(val);
                BaseValueHolder vh = (BaseValueHolder)val;
                int ival = (Integer)vh.myValue;
                if (ival != ITERATIONS) {
                    String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + ival;
                    throw new TestException(s);
                }
                try {
                    vh.verifyMyFields(((Integer)vh.myValue).intValue());
                }
                catch (TestException e) {
                    throw new TestException("While checking key " + key + ": " + e.getMessage());
                }
            } else {
                String s = "Wrong type in cache at " + key + ", expected Integer " + "but got " + val + " of type " + val.getClass().getName();
                throw new TestException(s);
            }
            ++i;
        }
        Log.getLogWriter().info("Validated cache");
    }

    public static void validateValidSequentialKeysTask() throws Exception {
        validPrefix = true;
        invalidPrefix = false;
        WANClient.validateSequentialKeysTask();
    }

    public static void validateInvalidSequentialKeysTask() throws Exception {
        validPrefix = false;
        invalidPrefix = true;
        WANClient.validateSequentialKeysTask();
    }

    public static void clientValidateSequentialKeysTask() throws Exception {
        Region region = RegionHelper.getRegion(REGION_NAME);
        PoolImpl mybw = ClientHelper.getPool(region);
        ServerLocation primary = mybw.getPrimary();
        if (primary == null) {
            throw new InternalGemFireException("Primary is null" + primary);
        }
        BridgeHelper.Endpoint primaryEndpoint = WANClient.getEndpoint(primary);
        if (primaryEndpoint == null) {
            throw new InternalGemFireException("Unable to find endpoint for primary " + primary);
        }
        Log.getLogWriter().info("Primary name is " + primaryEndpoint.getName());
        if (primaryEndpoint.getName().indexOf("_validbridge_") != -1) {
            WANClient.validateValidSequentialKeysTask();
        } else if (primaryEndpoint.getName().indexOf("_invalidbridge_") != -1) {
            WANClient.validateInvalidSequentialKeysTask();
        }
    }

    public static void validateSequentialKeysTask() throws Exception {
        PdxTest.initClassLoader();
        int minWaitSec = 30;
        Log.getLogWriter().info("Validating cache after sleeping " + minWaitSec + " seconds");
        MasterController.sleepForMs(minWaitSec * 1000);
        WANClient.waitForQueuesToDrain();
        if (RegionHelper.getRegion(REGION_NAME).getAttributes().getPoolName() != null) {
            SilenceListener.waitForSilence(30L, 1000L);
        }
        long size = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.MaxKeys);
        Region region = RegionHelper.getRegion(REGION_NAME);
        Set keys = region.keys();
        long requiredSize = 0L;
        String keyPrefix = "";
        if (!validPrefix && !invalidPrefix) {
            requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry);
            keyPrefix = "";
            logger.info("SUPPOSED TO HAVE:" + requiredSize + " DOES HAVE:" + keys.size());
        } else if (validPrefix && !invalidPrefix) {
            requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_valid);
            keyPrefix = "valid_";
            logger.info("SUPPOSED TO HAVE:" + requiredSize + " DOES HAVE:" + keys.size());
            WANClient.checkInvalidKeys(keyPrefix);
        } else if (!validPrefix && invalidPrefix) {
            requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_invalid);
            keyPrefix = "invalid_";
            WANClient.checkInvalidKeys(keyPrefix);
        }
        Log.getLogWriter().info("Prefix is " + keyPrefix);
        if (keyPrefix != "invalid_") {
            Log.getLogWriter().info("Entering the validation loop ");
            Iterator kI = keys.iterator();
            int i = 1;
            while ((long)i < requiredSize) {
                String key = keyPrefix + i;
                Object val = region.get((Object)key);
                if (val == null) {
                    String s = "No value in cache at " + key;
                    throw new TestException(s);
                }
                if (val instanceof Integer) {
                    int ival = (Integer)val;
                    if (ival != ITERATIONS) {
                        String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + ival;
                        throw new TestException(s);
                    }
                } else if (val instanceof BaseValueHolder || val instanceof PdxInstance) {
                    val = PdxTest.toValueHolder(val);
                    BaseValueHolder vh = (BaseValueHolder)val;
                    int ival = (Integer)vh.myValue;
                    if (ival != ITERATIONS) {
                        String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + ival;
                        throw new TestException(s);
                    }
                    try {
                        vh.verifyMyFields(((Integer)vh.myValue).intValue());
                    }
                    catch (TestException e) {
                        throw new TestException("While checking key " + key + ": " + e.getMessage());
                    }
                } else if (val instanceof byte[]) {
                    if (((byte[])val).length != ITERATIONS) {
                        String s = "Wrong value in cache at " + key + ", expected byte[] of length " + ITERATIONS + " but got length " + ((byte[])val).length;
                        throw new TestException(s);
                    }
                } else if (val instanceof PSTObject) {
                    if (((PSTObject)val).getIndex() != ITERATIONS) {
                        String s = "Wrong value in cache at " + key + ", expected PSTObject with index " + ITERATIONS + " but got index " + ((PSTObject)val).getIndex();
                        throw new TestException(s);
                    }
                } else {
                    String s = "Wrong type in cache at " + key + ", expected Integer " + "but got " + val + " of type " + val.getClass().getName();
                    throw new TestException(s);
                }
                ++i;
            }
        }
        Log.getLogWriter().info("Validated cache");
    }

    public static void validateSequentialKeysCQTask() throws Exception {
        long numOnErrorInvocations;
        long numCQDestroyEvents;
        long numCQInvalidateEvents;
        int minWaitSec = 30;
        Log.getLogWriter().info("Validating cache after sleeping " + minWaitSec + " seconds");
        MasterController.sleepForMs(minWaitSec * 1000);
        long numCqs = (long)TestHelper.getNumCQsCreated();
        WANClient.waitForQueuesToDrain();
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry);
        StringBuffer errMsg = new StringBuffer();
        long numCQCreateEvents = sc.read(CQUtilBB.NUM_CREATE);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_CREATE", CQUtilBB.NUM_CREATE, requiredSize * numCqs, true, 300000L);
        long numCQUpdateEvents = sc.read(CQUtilBB.NUM_UPDATE);
        try {
            TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_UPDATE", CQUtilBB.NUM_UPDATE, (long)(ITERATIONS - 1) * (requiredSize * numCqs), true, 180000L);
        }
        catch (TestException e) {
            errMsg.append(e.toString() + "\n");
        }
        SharedMap aMap = CQUtilBB.getBB().getSharedMap();
        String exceptionStr = (String)aMap.get(TestHelper.EVENT_ERROR_KEY);
        if (exceptionStr != null) {
            errMsg.append("\nFirst Exception encountered by listener: \n");
            errMsg.append("\t" + exceptionStr + "\n");
            long missing = sc.read(CQUtilBB.MISSING_UPDATES);
            long late = sc.read(CQUtilBB.LATE_UPDATES);
            errMsg.append("\tTotal count of missingUpdates = " + missing + "\n");
            errMsg.append("\tTotal count of late (OutOfOrder) Updates = " + late + "\n");
        }
        if ((numCQInvalidateEvents = sc.read(CQUtilBB.NUM_INVALIDATE)) != 0L) {
            errMsg.append("Expected 0 CQ Invalidate Events, but found " + numCQInvalidateEvents + "\n");
        }
        if ((numCQDestroyEvents = sc.read(CQUtilBB.NUM_DESTROY)) != 0L) {
            errMsg.append("Expected 0 CQ Destroy Events, but found " + numCQDestroyEvents + "\n");
        }
        if ((numOnErrorInvocations = sc.read(CQUtilBB.NUM_ERRORS)) != 0L) {
            errMsg.append("Expected 0 onError() invocations, but found " + numOnErrorInvocations + "\n");
        }
        if (errMsg.length() > 0) {
            String errHdr = "Failures found while verifying CQEvents\n";
            throw new TestException(errHdr + errMsg.toString() + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("Successfully validated CQEvents in client");
        StringBuffer aStr = new StringBuffer("CQEvent Summary\n");
        aStr.append("   numCQCreateEvents = " + numCQCreateEvents + "\n");
        aStr.append("   numCQUpdateEvents = " + numCQUpdateEvents + "\n");
        aStr.append("   numCQDestroyEvents = " + numCQDestroyEvents + "\n");
        aStr.append("   numCQInvalidateEvents = " + numCQInvalidateEvents + "\n");
        aStr.append("   numOnErrorInvocations = " + numOnErrorInvocations + "\n");
        Log.getLogWriter().info(aStr.toString());
        SelectResults results = CQUtil.getCQResults();
        logger.info("SelectResults SUPPOSED TO HAVE:" + requiredSize + " DOES HAVE:" + results.size() + " numCqs = " + numCqs);
        if ((long)results.size() != requiredSize) {
            throw new TestException("Expected SelectResults to be size " + requiredSize + " but found " + results.size() + " elements");
        }
        for (Object val : results) {
            if (val == null) {
                String s = "Unexpected value " + val + " in SelectResults";
                throw new TestException(s);
            }
            if (val instanceof Integer) {
                int ival = (Integer)val;
                if (ival == ITERATIONS) continue;
                String s = "Wrong value in SelectResults, expected " + ITERATIONS + " but got " + ival;
                throw new TestException(s);
            }
            if (val instanceof byte[]) {
                if (((byte[])val).length == ITERATIONS) continue;
                String s = "Wrong value in SelectResults, expected byte[] of length " + ITERATIONS + " but got length " + ((byte[])val).length;
                throw new TestException(s);
            }
            String s = "Wrong type in SelectResults, expected Integer but got " + val + " of type " + val.getClass().getName();
            throw new TestException(s);
        }
        Log.getLogWriter().info("Successful validation of SelectResults (" + results.size() + "): " + results.toString());
    }

    public static void waitForQueuesToDrain() {
        SharedMap bb = WANBlackboard.getInstance().getSharedMap();
        long startTime = System.currentTimeMillis();
        long maxWait = CacheClientPrms.getSecToWaitForQueue();
        long entriesLeft = 0L;
        while (System.currentTimeMillis() - startTime < maxWait * 1000L) {
            Set keySet = bb.getMap().keySet();
            Iterator kIt = keySet.iterator();
            boolean pass = true;
            while (kIt.hasNext()) {
                String k = (String)kIt.next();
                if (!k.startsWith("EVENT_QUEUE")) continue;
                logger.info("Checking event queue key: " + k);
                Long value = (Long)bb.get(k);
                if (value <= 0L) continue;
                pass = false;
                entriesLeft = value;
                logger.warning("STILL WAITING CUZ QUEUE HAS " + value + " entries in it. [" + k + "]=" + value);
                break;
            }
            if (pass) {
                entriesLeft = 0L;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (entriesLeft > 0L) {
            throw new TestException("TIMED OUT waiting for queue to drain. EntriesLeft:" + entriesLeft);
        }
        logger.info("QUEUES ARE DRAINED");
    }

    protected void closeCache() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        PartitionAttributes prAttrs = null;
        if (region != null) {
            prAttrs = region.getAttributes().getPartitionAttributes();
        }
        if (prAttrs == null) {
            CacheHelper.closeCache();
        }
    }

    public static synchronized void killServer() throws ClientVmNotFoundException {
        String server = CacheClientPrms.getBridgeKillTarget();
        if (server == null) {
            throw new TestException("killServer requires bridgeKillTarget (server) to be specified in conf file");
        }
        BridgeHelper.Endpoint endpoint = WANClient.getBridgeEndpoint(server);
        WANClient.killComponent("cacheserver", endpoint);
    }

    public static void killClient() {
        try {
            MasterController.sleepForMs(1000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static synchronized void restartServer() throws ClientVmNotFoundException {
        String server = CacheClientPrms.getBridgeKillTarget();
        if (server == null) {
            throw new TestException("restartServer requires bridgeKillTarget (server) to be specified in conf file");
        }
        BridgeHelper.Endpoint endpoint = WANClient.getBridgeEndpoint(server);
        WANClient.restartComponent("cacheserver", endpoint);
    }

    public static synchronized void recycleServer() throws ClientVmNotFoundException {
        String server = CacheClientPrms.getBridgeKillTarget();
        if (server == null) {
            throw new TestException("recycleServer requires bridgeKillTarget (server) to be specified in conf file");
        }
        int restartWaitSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        BridgeHelper.Endpoint endpoint = WANClient.getBridgeEndpoint(server);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        ClientVmMgr.stop("recycleServer: " + endpoint, -21, -31, target);
        MasterController.sleepForMs(restartWaitSec * 1000);
        ClientVmMgr.start("recycleServer: " + endpoint, target);
    }

    public static synchronized void killGatewayHub() throws ClientVmNotFoundException {
        BBoard bb = BBoard.getInstance();
        long killInterval = conftab.longAt(HctPrms.killInterval);
        long now = System.currentTimeMillis();
        Long lastKill = (Long)bb.getSharedMap().get("lastKillTime");
        long diff = 0L;
        if (lastKill != null) {
            diff = now - lastKill;
            if (diff < killInterval) {
                logger.info("No kill executed. " + (killInterval - diff) + "ms remaining before next kill.");
                return;
            }
        } else {
            int sleepMs = CacheClientPrms.getSleepSec() * 1000;
            logger.info("Sleeping for " + sleepMs + "ms");
            MasterController.sleepForMs(sleepMs);
            bb.getSharedMap().put("lastKillTime", new Long(now));
        }
        WANClient.startKillZone();
        int restartWaitSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        String reason = "Killing self, restarting after " + restartWaitSec + " seconds";
        ClientVmMgr.stop(reason, -21, restartWaitSec * 1000);
    }

    public static void waitForEvents() {
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        logger.info("Sleeping for " + sleepMs + "ms");
        MasterController.sleepForMs(sleepMs);
    }

    private static void killComponent(String comp, BridgeHelper.Endpoint endpoint) throws ClientVmNotFoundException {
        if (comp.equals("cacheserver")) {
            ClientVmInfo target = new ClientVmInfo(endpoint);
            ClientVmMgr.stop("Killing cache server", -21, -31, target);
            return;
        }
        logger.info("ERROR in killComponent - unknown argument: " + comp);
        throw new HydraRuntimeException("error in killComponent");
    }

    public static void restartComponent(String comp, BridgeHelper.Endpoint endpoint) throws ClientVmNotFoundException {
        if (comp.equals("cacheserver")) {
            ClientVmInfo target = new ClientVmInfo(endpoint);
            ClientVmMgr.start("Restarting cache server", target);
            return;
        }
        logger.info("ERROR in restartComponent - unknown argument: " + comp);
        throw new HydraRuntimeException("error in restartComponent");
    }

    public static void notifyFarEnd() {
        long val = WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.nearEndReady);
        if (val != 1L) {
            throw new HydraRuntimeException("Unintended use");
        }
    }

    public static void notifyNearEnd() {
        long val = WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.farEndReady);
        if (val != 1L) {
            throw new HydraRuntimeException("Unintended use");
        }
    }

    public static void waitForFarEnd() {
        SharedCounters counters = WANBlackboard.getInstance().getSharedCounters();
        do {
            MasterController.sleepForMs(1000);
        } while (counters.read(WANBlackboard.farEndReady) != 1L);
        long val = counters.decrementAndRead(WANBlackboard.farEndReady);
        if (val != 0L) {
            throw new HydraRuntimeException("Unintended use");
        }
    }

    public static void waitForListenerSilence() {
        Log.getLogWriter().info("Waiting for 50 seconds ...");
        MasterController.sleepForMs(50000);
        long currentTime = System.currentTimeMillis();
        long timeElapsedSinceLastEvent = currentTime - lastEventReceivedTime;
        if (timeElapsedSinceLastEvent > 50000L) {
            throw new StopSchedulingTaskOnClientOrder("Stopping the task schedule as the listener was silent for last 50 secs");
        }
        Log.getLogWriter().info("Task to be rescheduled as listner is still not silent!");
    }

    public static void mentionReferenceInBlackboard() {
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Log.getLogWriter().info("Reference vm is : " + VmDurableId);
        DurableClientsBB.getBB().getSharedMap().put("REFERENCE VM:", VmDurableId);
    }

    public static void validateEventsReceived() {
        DurableClientsBB.getBB().printSharedMap();
        String ReferenceVm = (String)DurableClientsBB.getBB().getSharedMap().get("REFERENCE VM:");
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap currentVmMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
        HashMap referenceMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(ReferenceVm);
        if (currentVmMap.isEmpty()) {
            throw new TestException(" The map of threads is empty for the Vm " + VmDurableId);
        }
        if (referenceMap.isEmpty()) {
            throw new TestException(" The map of threads is empty for the Reference Vm " + ReferenceVm);
        }
        Iterator iterator = referenceMap.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        Object value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            HashMap referenceThreadMap = value;
            Iterator iterator1 = referenceThreadMap.entrySet().iterator();
            Map.Entry entry1 = null;
            Object key1 = null;
            Object value1 = null;
            while (iterator1.hasNext()) {
                entry1 = iterator1.next();
                key1 = entry1.getKey();
                value1 = entry1.getValue();
                if (!((String)key1).startsWith("EVENT SR. No : ")) continue;
                if (currentVmMap.get(key) == null) {
                    throw new TestException("Map is null");
                }
                if (((HashMap)currentVmMap.get(key)).get(key1) == null) {
                    throw new TestException("Event not received by the client for the key " + key + " for the event no " + key1);
                }
                if (value1.equals(((HashMap)currentVmMap.get(key)).get(key1))) continue;
                throw new TestException(" For the key " + key + " the event no " + key1 + " has different events");
            }
        }
    }

    public static void checkInvalidKeys(String validKey) {
        Region region = RegionHelper.getRegion(REGION_NAME);
        Set keys = region.keySet();
        for (String key : keys) {
            if (!key.startsWith(validKey)) {
                throw new TestException("Invalid key found in the cache " + key);
            }
            Log.getLogWriter().info("Found valid key " + key);
        }
    }

    public static void validateWriterWanSiteEntriesTask() {
        Log.getLogWriter().info("Sleeping for some time ..");
        MasterController.sleepForMs(100000);
        Region region = RegionHelper.getRegion(REGION_NAME);
        if (region.isEmpty()) {
            throw new TestException(" Region has no entries to validate ");
        }
        WANClient.checkInvalidKeys("writer_");
        long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_writer);
        WANClient.checkKeyRegionEntries("writer_", requiredSize);
    }

    public static void validateReaderWanSiteEntriesTask() {
        Log.getLogWriter().info("Sleeping for some time ..");
        MasterController.sleepForMs(100000);
        Region region = RegionHelper.getRegion(REGION_NAME);
        if (region.isEmpty()) {
            throw new TestException(" Region has no entries to validate ");
        }
        long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_writer);
        WANClient.checkKeyRegionEntries("writer_", requiredSize);
        Iterator iterator = region.entrySet(false).iterator();
        Region.Entry entry = null;
        Object key = null;
        Object value = null;
        while (iterator.hasNext()) {
            entry = (Region.Entry)iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (!((String)key).startsWith("reader_")) continue;
            if (!keyList.contains(key)) {
                throw new TestException("Found reader key that is not present in the keyList");
            }
            if ((Integer)value == ITERATIONS) continue;
            String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + (Integer)value;
            throw new TestException(s);
        }
    }

    protected static void checkKeyRegionEntries(String keyPrefix, long expectedsize) {
        Region region = RegionHelper.getRegion(REGION_NAME);
        Log.getLogWriter().info("Key prefix is " + keyPrefix + " Expected size is " + expectedsize);
        int i = 1;
        while ((long)i <= expectedsize) {
            String key = keyPrefix + i;
            Object val = region.get((Object)key);
            if (val == null) {
                String s = "No value in cache at " + key;
                throw new TestException(s);
            }
            if ((Integer)val != ITERATIONS) {
                Log.getLogWriter().info("Key is :" + key + " Value found in region is " + (Integer)val);
                String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + (Integer)val;
                throw new TestException(s);
            }
            Log.getLogWriter().info("Key is :" + key + " Value found in region is " + (Integer)val);
            ++i;
        }
    }

    public static void readerDestroyAllKeysTask() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        Iterator iterator = region.entrySet(false).iterator();
        Region.Entry entry = null;
        Object key = null;
        while (iterator.hasNext()) {
            entry = (Region.Entry)iterator.next();
            key = entry.getKey();
            try {
                region.destroy(key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Entry Not found.");
            }
        }
        if (!region.isEmpty()) {
            throw new TestException("Region is supposed to be empty but that is not the case");
        }
        Log.getLogWriter().info("Completed the destroy operation for all the keys in the region");
    }

    public static void writerDestroyCreatedKeysTask() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        Iterator iterator = keyList.iterator();
        String key = null;
        while (iterator.hasNext()) {
            try {
                key = (String)iterator.next();
                Log.getLogWriter().info("Destroying key :" + key + " which is present in the keyList");
                region.destroy((Object)key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Entry Not found.");
            }
            catch (EntryDestroyedException e) {
                Log.getLogWriter().info("Entry Already destroyed.");
            }
        }
    }

    public static void checkWriterRegionContentsEmpty() {
        Region region = RegionHelper.getRegion(REGION_NAME);
        if (!region.isEmpty()) {
            throw new TestException("Region content supposed to be empty but it is having size of " + region.size());
        }
        Log.getLogWriter().info("Region is empty as expected");
    }

    public static void waitForNearEnd() {
        SharedCounters counters = WANBlackboard.getInstance().getSharedCounters();
        do {
            MasterController.sleepForMs(1000);
        } while (counters.read(WANBlackboard.nearEndReady) != 1L);
        long val = counters.decrementAndRead(WANBlackboard.nearEndReady);
        if (val != 0L) {
            throw new HydraRuntimeException("Unintended use");
        }
    }

    private static BridgeHelper.Endpoint getBridgeEndpoint(String name) {
        for (BridgeHelper.Endpoint endpoint : BridgeHelper.getEndpoints()) {
            if (!endpoint.getName().equals(name)) continue;
            return endpoint;
        }
        throw new HydraRuntimeException(name + " not found in bridge endpoints");
    }

    protected static void startKillZone() {
        killing = true;
        workLock.waitForLock();
    }

    protected static void startNoKillZone() {
        workLock.lock();
        if (killing) {
            workLock.unlock();
            logger.info("Going into permanent sleep to await kill");
            MasterController.sleepForMs(Integer.MAX_VALUE);
        }
    }

    protected static void endNoKillZone() {
        workLock.unlock();
    }

    protected static void initPdxDiskStore() {
        WANClientVersionHelper.initPdxDiskStore();
    }

    public static class Lock {
        int state = 0;

        public synchronized void lock() {
            ++this.state;
        }

        public synchronized void unlock() {
            --this.state;
        }

        public void waitForLock() {
            while (this.state != 0) {
                MasterController.sleepForMs(2000);
            }
            return;
        }
    }
}

